/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.core.ast;

import java.util.Set;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.GivenType;
import org.eventb.core.ast.ITypeVisitor;
import org.eventb.core.ast.Type;

public class ProductType
extends Type {
    private final Type left;
    private final Type right;

    protected ProductType(FormulaFactory ff, Type left, Type right) {
        super(ff, left.isSolved() && right.isSolved());
        this.left = left;
        this.right = right;
        this.ensureSameFactory(this.left, this.right);
    }

    @Override
    protected void addGivenTypes(Set<GivenType> set) {
        this.left.addGivenTypes(set);
        this.right.addGivenTypes(set);
    }

    @Override
    protected Expression buildExpression(FormulaFactory factory) {
        Expression leftExpr = this.left.toExpression();
        Expression rightExpr = this.right.toExpression();
        return factory.makeBinaryExpression(214, leftExpr, rightExpr, null);
    }

    @Override
    protected void buildString(StringBuilder buffer) {
        this.left.buildString(buffer);
        buffer.append('\u00d7');
        boolean rightNeedsParen = this.right instanceof ProductType;
        if (rightNeedsParen) {
            buffer.append('(');
        }
        this.right.buildString(buffer);
        if (rightNeedsParen) {
            buffer.append(')');
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProductType)) {
            return false;
        }
        ProductType other = (ProductType)o;
        return this.left.equals(other.left) && this.right.equals(other.right);
    }

    public Type getLeft() {
        return this.left;
    }

    public Type getRight() {
        return this.right;
    }

    @Override
    public int hashCode() {
        return this.left.hashCode() * 17 + this.right.hashCode();
    }

    @Override
    public void accept(ITypeVisitor visitor) {
        visitor.visit(this);
    }
}

