/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.core.ast;

import java.util.Set;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.ITypeVisitor;
import org.eventb.core.ast.Type;
import org.eventb.internal.core.ast.FormulaChecks;

public class GivenType
extends Type {
    private String name;

    protected GivenType(FormulaFactory ff, String name) {
        super(ff, true);
        FormulaChecks.ensureValidIdentifierName(name, ff);
        this.name = name;
    }

    protected GivenType(FormulaFactory ff, FreeIdentifier freeIdent) {
        super(ff, true, freeIdent);
        FormulaChecks.ensureValidGivenType(freeIdent);
        this.name = freeIdent.getName();
    }

    @Override
    protected void addGivenTypes(Set<GivenType> set) {
        set.add(this);
    }

    @Override
    protected Expression buildExpression(FormulaFactory factory) {
        return factory.makeFreeIdentifier(this.name, null, factory.makePowerSetType(this));
    }

    @Override
    protected void buildString(StringBuilder buffer) {
        buffer.append(this.name);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GivenType)) {
            return false;
        }
        GivenType other = (GivenType)o;
        return this.name.equals(other.name);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public FreeIdentifier toExpression() {
        return (FreeIdentifier)super.toExpression();
    }

    @Override
    public void accept(ITypeVisitor visitor) {
        visitor.visit(this);
    }
}

