/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.core.ast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eventb.core.ast.AssociativeHelper;
import org.eventb.core.ast.BoundIdentDecl;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.ExtensionHelper;
import org.eventb.core.ast.Formula;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.IPosition;
import org.eventb.core.ast.ISimpleVisitor;
import org.eventb.core.ast.IVisitor;
import org.eventb.core.ast.Predicate;
import org.eventb.core.ast.SingleRewriter;
import org.eventb.core.ast.SourceLocation;
import org.eventb.core.ast.extension.IExtendedFormula;
import org.eventb.core.ast.extension.IExtensionKind;
import org.eventb.core.ast.extension.IOperatorProperties;
import org.eventb.core.ast.extension.IPredicateExtension;
import org.eventb.internal.core.ast.FindingAccumulator;
import org.eventb.internal.core.ast.ITypeCheckingRewriter;
import org.eventb.internal.core.ast.IdentListMerger;
import org.eventb.internal.core.ast.IntStack;
import org.eventb.internal.core.ast.LegibilityResult;
import org.eventb.internal.core.ast.extension.ArityCoverage;
import org.eventb.internal.core.ast.extension.IToStringMediator;
import org.eventb.internal.core.ast.extension.KindMediator;
import org.eventb.internal.core.ast.extension.OperatorCoverage;
import org.eventb.internal.core.ast.extension.TypeCheckMediator;
import org.eventb.internal.core.parser.ExtendedGrammar;
import org.eventb.internal.core.parser.GenParser;
import org.eventb.internal.core.parser.IOperatorInfo;
import org.eventb.internal.core.parser.IParserPrinter;
import org.eventb.internal.core.parser.IPropertyParserInfo;
import org.eventb.internal.core.parser.SubParsers;
import org.eventb.internal.core.typecheck.TypeCheckResult;
import org.eventb.internal.core.typecheck.TypeUnifier;

public class ExtendedPredicate
extends Predicate
implements IExtendedFormula {
    private final Expression[] childExpressions;
    private final Predicate[] childPredicates;
    private final IPredicateExtension extension;

    public static void init(ExtendedGrammar grammar) {
        try {
            for (ExtendedPredicateParsers parserInfo : ExtendedPredicateParsers.values()) {
                grammar.addParser(parserInfo);
            }
        }
        catch (GenParser.OverrideException e) {
            e.printStackTrace();
        }
    }

    protected ExtendedPredicate(int tag, Expression[] expressions, Predicate[] predicates, SourceLocation location, FormulaFactory ff, IPredicateExtension extension) {
        super(tag, ff, location, ExtendedPredicate.combineHashCodes(expressions, predicates));
        this.childExpressions = expressions;
        this.childPredicates = predicates;
        this.extension = extension;
        this.checkPreconditions();
        this.ensureSameFactory(this.childExpressions);
        this.ensureSameFactory(this.childPredicates);
        this.setPredicateVariableCache(this.getChildren());
        this.synthesizeType();
    }

    private void checkPreconditions() {
        IExtensionKind kind = this.extension.getKind();
        assert (kind.getProperties().getFormulaType() == IOperatorProperties.FormulaType.PREDICATE);
        if (!kind.checkPreconditions(this.childExpressions, this.childPredicates)) {
            throw new IllegalArgumentException("Incorrect kind of children");
        }
    }

    @Override
    protected void synthesizeType() {
        Formula[] children = this.getChildren();
        IdentListMerger freeIdentMerger = ExtendedPredicate.mergeFreeIdentifiers((Formula[])children);
        this.freeIdents = freeIdentMerger.getFreeMergedArray();
        IdentListMerger boundIdentMerger = ExtendedPredicate.mergeBoundIdentifiers((Formula[])children);
        this.boundIdents = boundIdentMerger.getBoundMergedArray();
        if (freeIdentMerger.containsError() || boundIdentMerger.containsError()) {
            return;
        }
        for (Formula child : children) {
            if (child.isTypeChecked()) continue;
            return;
        }
        this.typeChecked = true;
    }

    @Override
    public Expression[] getChildExpressions() {
        return (Expression[])this.childExpressions.clone();
    }

    @Override
    public Predicate[] getChildPredicates() {
        return (Predicate[])this.childPredicates.clone();
    }

    @Override
    public IPredicateExtension getExtension() {
        return this.extension;
    }

    private Formula<?>[] getChildren() {
        return ExtensionHelper.concat(this.childExpressions, this.childPredicates);
    }

    @Override
    protected boolean equalsInternal(Formula<?> formula) {
        ExtendedPredicate other = (ExtendedPredicate)formula;
        return Arrays.equals(this.childExpressions, other.childExpressions) && Arrays.equals(this.childPredicates, other.childPredicates);
    }

    @Override
    protected void typeCheck(TypeCheckResult result, BoundIdentDecl[] quantifiedIdentifiers) {
        for (Formula<?> child : this.getChildren()) {
            child.typeCheck(result, quantifiedIdentifiers);
        }
        this.extension.typeCheck(this, new TypeCheckMediator(result, this, false));
    }

    @Override
    protected void solveChildrenTypes(TypeUnifier unifier) {
        ExtensionHelper.solveTypes(unifier, this.childExpressions, this.childPredicates);
    }

    @Override
    protected void toString(IToStringMediator mediator) {
        IParserPrinter<Formula<?>> parser;
        IParserPrinter<Formula<?>> extParser = parser = ExtensionHelper.makeParserPrinter(this, this.extension, mediator);
        extParser.toString(mediator, this);
    }

    @Override
    protected int getKind(KindMediator mediator) {
        return mediator.getKind(this.extension.getSyntaxSymbol());
    }

    @Override
    protected String getSyntaxTree(String[] boundNames, String tabs) {
        return AssociativeHelper.getSyntaxTreeHelper(boundNames, tabs, this.getChildren(), this.extension.getSyntaxSymbol(), "", this.getClass().getSimpleName());
    }

    @Override
    protected void isLegible(LegibilityResult result) {
        ExtensionHelper.isLegible((Formula[])this.childExpressions, (Formula[])this.childPredicates, (LegibilityResult)result);
    }

    @Override
    protected void collectFreeIdentifiers(LinkedHashSet<FreeIdentifier> freeIdentSet) {
        ExtensionHelper.collectFreeIdentifiers(freeIdentSet, this.childExpressions, this.childPredicates);
    }

    @Override
    protected void collectNamesAbove(Set<String> names, String[] boundNames, int offset) {
        ExtensionHelper.collectNamesAbove(names, boundNames, offset, this.childExpressions, this.childPredicates);
    }

    @Override
    public boolean accept(IVisitor visitor) {
        int i;
        boolean goOn = visitor.enterExtendedPredicate(this);
        for (i = 0; goOn && i < this.childExpressions.length; ++i) {
            if (i != 0) {
                goOn = visitor.continueExtendedPredicate(this);
            }
            if (!goOn) continue;
            goOn = this.childExpressions[i].accept(visitor);
        }
        for (i = 0; goOn && i < this.childPredicates.length; ++i) {
            goOn = visitor.continueExtendedPredicate(this);
            if (!goOn) continue;
            goOn = this.childPredicates[i].accept(visitor);
        }
        return visitor.exitExtendedPredicate(this);
    }

    @Override
    public void accept(ISimpleVisitor visitor) {
        visitor.visitExtendedPredicate(this);
    }

    @Override
    protected Predicate rewrite(ITypeCheckingRewriter rewriter) {
        Predicate[] newChildPreds;
        Expression[] newChildExprs;
        boolean flatten = rewriter.autoFlatteningMode() && this.extension.getKind().getProperties().isAssociative();
        ArrayList<Expression> newChildExpressions = new ArrayList<Expression>(this.childExpressions.length);
        boolean changed = false;
        for (Expression child : this.childExpressions) {
            Expression newChild = (Expression)child.rewrite(rewriter);
            newChildExpressions.add(newChild);
            changed |= newChild != child;
        }
        ArrayList<Predicate> newChildPredicates = new ArrayList<Predicate>(this.childPredicates.length + 11);
        for (Predicate child : this.childPredicates) {
            Predicate newChild = (Predicate)child.rewrite(rewriter);
            if (flatten && this.getTag() == newChild.getTag()) {
                Predicate[] grandChildren = ((ExtendedPredicate)newChild).childPredicates;
                newChildPredicates.addAll(Arrays.asList(grandChildren));
                changed = true;
                continue;
            }
            newChildPredicates.add(newChild);
            changed |= newChild != child;
        }
        if (!changed) {
            newChildExprs = this.childExpressions;
            newChildPreds = this.childPredicates;
        } else {
            newChildExprs = newChildExpressions.toArray(new Expression[newChildExpressions.size()]);
            newChildPreds = newChildPredicates.toArray(new Predicate[newChildPredicates.size()]);
        }
        return rewriter.rewrite(this, changed, newChildExprs, newChildPreds);
    }

    @Override
    protected final <F> void inspect(FindingAccumulator<F> acc) {
        acc.inspect(this);
        ExtensionHelper.inspectChildren(acc, this.childExpressions, this.childPredicates);
    }

    @Override
    public Formula<?> getChild(int index) {
        this.checkChildIndex(index);
        return ExtensionHelper.getChild(this.childExpressions, this.childPredicates, index);
    }

    @Override
    public int getChildCount() {
        return ExtensionHelper.getChildCount(this.childExpressions, this.childPredicates);
    }

    @Override
    protected IPosition getDescendantPos(SourceLocation sloc, IntStack indexes) {
        return ExtensionHelper.getDescendantPos((Formula[])this.childExpressions, (Formula[])this.childPredicates, (SourceLocation)sloc, (IntStack)indexes);
    }

    @Override
    protected Predicate rewriteChild(int index, SingleRewriter rewriter) {
        FormulaFactory factory = this.getFactory();
        if (index < 0 || this.childExpressions.length + this.childPredicates.length <= index) {
            throw new IllegalArgumentException("Position is outside the formula");
        }
        if (index < this.childExpressions.length) {
            Expression[] newChildExpressions = (Expression[])this.childExpressions.clone();
            newChildExpressions[index] = rewriter.rewrite(this.childExpressions[index]);
            return factory.makeExtendedPredicate(this.extension, newChildExpressions, (Predicate[])this.childPredicates.clone(), this.getSourceLocation());
        }
        Predicate[] newChildPredicates = (Predicate[])this.childPredicates.clone();
        newChildPredicates[index -= this.childExpressions.length] = rewriter.rewrite(this.childPredicates[index]);
        return factory.makeExtendedPredicate(this.extension, (Expression[])this.childExpressions.clone(), newChildPredicates, this.getSourceLocation());
    }

    @Override
    public boolean isWDStrict() {
        return this.extension.conjoinChildrenWD();
    }

    private static enum ExtendedPredicateParsers implements IPropertyParserInfo<ExtendedPredicate>
    {
        PARENTHESIZED_PREDICATE(IOperatorProperties.Notation.PREFIX, IOperatorProperties.FormulaType.PREDICATE, ArityCoverage.ANY, ArityCoverage.ANY, ArityCoverage.ONE_OR_MORE, false){

            @Override
            public IParserPrinter<ExtendedPredicate> makeParser(int kind, int tag) {
                return new SubParsers.ExtendedPredParen(kind, tag);
            }
        };

        private final OperatorCoverage operProps;

        private ExtendedPredicateParsers(IOperatorProperties.Notation notation, IOperatorProperties.FormulaType formulaType, ArityCoverage exprArity, ArityCoverage predArity, ArityCoverage globalArity, boolean isAssociative) {
            this.operProps = new OperatorCoverage(notation, formulaType, exprArity, predArity, globalArity, isAssociative);
        }

        protected abstract IParserPrinter<ExtendedPredicate> makeParser(int var1, int var2);

        @Override
        public OperatorCoverage getOperatorCoverage() {
            return this.operProps;
        }

        @Override
        public IOperatorInfo<ExtendedPredicate> makeOpInfo(final String image, final int tag, final String opId, final String groupId) {
            return new IOperatorInfo<ExtendedPredicate>(){

                @Override
                public IParserPrinter<ExtendedPredicate> makeParser(int kind) {
                    return ExtendedPredicateParsers.this.makeParser(kind, tag);
                }

                @Override
                public boolean isSpaced() {
                    return false;
                }

                @Override
                public String getImage() {
                    return image;
                }

                @Override
                public String getId() {
                    return opId;
                }

                @Override
                public String getGroupId() {
                    return groupId;
                }
            };
        }
    }
}

