/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.core.ast;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eventb.core.ast.BoundIdentDecl;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.Formula;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.IPosition;
import org.eventb.core.ast.ISimpleVisitor;
import org.eventb.core.ast.IVisitor;
import org.eventb.core.ast.PowerSetType;
import org.eventb.core.ast.ProductType;
import org.eventb.core.ast.SingleRewriter;
import org.eventb.core.ast.SourceLocation;
import org.eventb.core.ast.Type;
import org.eventb.core.ast.extension.StandardGroup;
import org.eventb.internal.core.ast.FindingAccumulator;
import org.eventb.internal.core.ast.FormulaChecks;
import org.eventb.internal.core.ast.GivenTypeHelper;
import org.eventb.internal.core.ast.ITypeCheckingRewriter;
import org.eventb.internal.core.ast.IntStack;
import org.eventb.internal.core.ast.LegibilityResult;
import org.eventb.internal.core.ast.Position;
import org.eventb.internal.core.ast.extension.IToStringMediator;
import org.eventb.internal.core.ast.extension.KindMediator;
import org.eventb.internal.core.parser.BMath;
import org.eventb.internal.core.parser.GenParser;
import org.eventb.internal.core.parser.IOperatorInfo;
import org.eventb.internal.core.parser.IParserPrinter;
import org.eventb.internal.core.parser.SubParsers;
import org.eventb.internal.core.typecheck.TypeCheckResult;
import org.eventb.internal.core.typecheck.TypeUnifier;
import org.eventb.internal.core.typecheck.TypeVariable;

public class AtomicExpression
extends Expression {
    private static final int FIRST_TAG = 401;
    public static final int TAGS_LENGTH = Operators.values().length;
    private static final String INTEGER_ID = "Integer";
    private static final String NATURAL_ID = "Natural";
    private static final String NATURAL1_ID = "Natural1";
    private static final String BOOL_ID = "Bool Type";
    private static final String TRUE_ID = "True";
    private static final String FALSE_ID = "False";
    private static final String EMPTYSET_ID = "Empty Set";
    private static final String KPRED_ID = "Predecessor";
    private static final String KSUCC_ID = "Successor";
    private static final String KPRJ1_GEN_ID = "Projection 1";
    private static final String KPRJ2_GEN_ID = "Projection 2";
    private static final String KID_GEN_ID = "Identity";

    public static void initV1(BMath grammar) {
        try {
            grammar.addOperator(Operators.OP_INTEGER);
            grammar.addOperator(Operators.OP_NATURAL);
            grammar.addOperator(Operators.OP_NATURAL1);
            grammar.addOperator(Operators.OP_BOOL);
            grammar.addOperator(Operators.OP_TRUE);
            grammar.addOperator(Operators.OP_FALSE);
            grammar.addOperator(Operators.OP_EMPTYSET);
            grammar.addOperator(Operators.OP_KPRED);
            grammar.addOperator(Operators.OP_KSUCC);
        }
        catch (GenParser.OverrideException e) {
            e.printStackTrace();
        }
    }

    public static void initV2(BMath grammar) {
        try {
            AtomicExpression.initV1(grammar);
            grammar.addOperator(Operators.OP_KPRJ1_GEN);
            grammar.addOperator(Operators.OP_KPRJ2_GEN);
            grammar.addOperator(Operators.OP_KID_GEN);
        }
        catch (GenParser.OverrideException e) {
            e.printStackTrace();
        }
    }

    protected AtomicExpression(int tag, SourceLocation location, Type type, FormulaFactory ff) {
        super(tag, ff, location, 0);
        FormulaChecks.ensureTagInRange(tag, 401, TAGS_LENGTH);
        this.ensureSameFactory(type);
        this.setPredicateVariableCache(new Formula[0]);
        this.synthesizeType(type);
        FormulaChecks.ensureHasType(this, type);
    }

    @Override
    protected void synthesizeType(Type givenType) {
        Type resultType;
        this.freeIdents = NO_FREE_IDENT;
        this.boundIdents = NO_BOUND_IDENT;
        FormulaFactory ff = this.getFactory();
        switch (this.getTag()) {
            case 401: 
            case 402: 
            case 403: {
                resultType = ff.makePowerSetType(ff.makeIntegerType());
                break;
            }
            case 404: {
                resultType = ff.makePowerSetType(ff.makeBooleanType());
                break;
            }
            case 405: 
            case 406: {
                resultType = ff.makeBooleanType();
                break;
            }
            case 407: {
                if (!this.isEmptySetType(givenType)) {
                    return;
                }
                resultType = givenType;
                break;
            }
            case 408: 
            case 409: {
                resultType = ff.makeRelationalType(ff.makeIntegerType(), ff.makeIntegerType());
                break;
            }
            case 410: {
                if (!AtomicExpression.isPrjType(givenType, true)) {
                    return;
                }
                resultType = givenType;
                break;
            }
            case 411: {
                if (!AtomicExpression.isPrjType(givenType, false)) {
                    return;
                }
                resultType = givenType;
                break;
            }
            case 412: {
                if (!AtomicExpression.isIdType(givenType)) {
                    return;
                }
                resultType = givenType;
                break;
            }
            default: {
                assert (false);
                return;
            }
        }
        if (resultType != null) {
            this.freeIdents = GivenTypeHelper.getGivenTypeIdentifiers(resultType);
            this.setFinalType(resultType, givenType);
        }
    }

    private boolean isEmptySetType(Type proposedType) {
        return proposedType instanceof PowerSetType;
    }

    private static boolean isPrjType(Type proposedType, boolean left) {
        if (proposedType == null) {
            return false;
        }
        Type source = proposedType.getSource();
        Type target = proposedType.getTarget();
        if (!(source instanceof ProductType)) {
            return false;
        }
        ProductType pSource = (ProductType)source;
        Type child = left ? pSource.getLeft() : pSource.getRight();
        return child.equals(target);
    }

    private static boolean isIdType(Type proposedType) {
        if (proposedType == null) {
            return false;
        }
        Type source = proposedType.getSource();
        Type target = proposedType.getTarget();
        return source != null && source.equals(target);
    }

    @Override
    protected void isLegible(LegibilityResult result) {
    }

    @Override
    boolean equalsInternalExpr(Expression expr) {
        return true;
    }

    @Override
    protected void typeCheck(TypeCheckResult result, BoundIdentDecl[] quantifiedIdentifiers) {
        Type resultType;
        switch (this.getTag()) {
            case 401: 
            case 402: 
            case 403: {
                resultType = result.makePowerSetType(result.makeIntegerType());
                break;
            }
            case 404: {
                resultType = result.makePowerSetType(result.makeBooleanType());
                break;
            }
            case 405: 
            case 406: {
                resultType = result.makeBooleanType();
                break;
            }
            case 407: {
                TypeVariable alpha = result.newFreshVariable(this.getSourceLocation());
                resultType = result.makePowerSetType(alpha);
                break;
            }
            case 408: 
            case 409: {
                resultType = result.makeRelationalType(result.makeIntegerType(), result.makeIntegerType());
                break;
            }
            case 410: {
                TypeVariable alpha = result.newFreshVariable(this.getSourceLocation());
                TypeVariable beta = result.newFreshVariable(this.getSourceLocation());
                ProductType srcType = result.makeProductType(alpha, beta);
                resultType = result.makeRelationalType(srcType, alpha);
                break;
            }
            case 411: {
                TypeVariable alpha = result.newFreshVariable(this.getSourceLocation());
                TypeVariable beta = result.newFreshVariable(this.getSourceLocation());
                ProductType srcType = result.makeProductType(alpha, beta);
                resultType = result.makeRelationalType(srcType, beta);
                break;
            }
            case 412: {
                TypeVariable alpha = result.newFreshVariable(this.getSourceLocation());
                resultType = result.makeRelationalType(alpha, alpha);
                break;
            }
            default: {
                assert (false);
                return;
            }
        }
        this.setTemporaryType(resultType, result);
        result.analyzeExpression(this);
    }

    @Override
    protected void solveChildrenTypes(TypeUnifier unifier) {
    }

    @Override
    protected void toString(IToStringMediator mediator) {
        Operators operator = this.getOperator();
        int kind = mediator.getKind();
        operator.makeParser(kind).toString(mediator, this);
    }

    @Override
    protected int getKind(KindMediator mediator) {
        return mediator.getKind(this.getOperatorImage());
    }

    private String getOperatorImage() {
        return this.getOperator().getImage();
    }

    private Operators getOperator() {
        return Operators.values()[this.getTag() - 401];
    }

    @Override
    protected String getSyntaxTree(String[] boundNames, String tabs) {
        String typeName = this.getType() != null ? " [type: " + this.getType().toString() + "]" : "";
        return tabs + this.getClass().getSimpleName() + " [" + this.getOperatorImage() + "]" + typeName + "\n";
    }

    @Override
    protected void collectFreeIdentifiers(LinkedHashSet<FreeIdentifier> freeIdentSet) {
    }

    @Override
    protected void collectNamesAbove(Set<String> names, String[] boundNames, int offset) {
    }

    @Override
    public boolean accept(IVisitor visitor) {
        switch (this.getTag()) {
            case 401: {
                return visitor.visitINTEGER(this);
            }
            case 402: {
                return visitor.visitNATURAL(this);
            }
            case 403: {
                return visitor.visitNATURAL1(this);
            }
            case 404: {
                return visitor.visitBOOL(this);
            }
            case 405: {
                return visitor.visitTRUE(this);
            }
            case 406: {
                return visitor.visitFALSE(this);
            }
            case 407: {
                return visitor.visitEMPTYSET(this);
            }
            case 408: {
                return visitor.visitKPRED(this);
            }
            case 409: {
                return visitor.visitKSUCC(this);
            }
            case 410: {
                return visitor.visitKPRJ1_GEN(this);
            }
            case 411: {
                return visitor.visitKPRJ2_GEN(this);
            }
            case 412: {
                return visitor.visitKID_GEN(this);
            }
        }
        return true;
    }

    @Override
    public void accept(ISimpleVisitor visitor) {
        visitor.visitAtomicExpression(this);
    }

    @Override
    protected Expression rewrite(ITypeCheckingRewriter rewriter) {
        return rewriter.rewrite(this);
    }

    @Override
    public boolean isATypeExpression() {
        int tag = this.getTag();
        return tag == 401 || tag == 404;
    }

    @Override
    public Type toType() {
        FormulaFactory factory = this.getFactory();
        switch (this.getTag()) {
            case 401: {
                return factory.makeIntegerType();
            }
            case 404: {
                return factory.makeBooleanType();
            }
        }
        return super.toType();
    }

    @Override
    protected final <F> void inspect(FindingAccumulator<F> acc) {
        acc.inspect(this);
        if (acc.childrenSkipped()) {
            return;
        }
    }

    @Override
    public Formula<?> getChild(int index) {
        throw AtomicExpression.invalidIndex(index);
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    protected IPosition getDescendantPos(SourceLocation sloc, IntStack indexes) {
        return new Position(indexes);
    }

    @Override
    protected Expression rewriteChild(int index, SingleRewriter rewriter) {
        throw new IllegalArgumentException("Position is outside the formula");
    }

    @Override
    public boolean isWDStrict() {
        return true;
    }

    private static enum Operators implements IOperatorInfo<AtomicExpression>
    {
        OP_INTEGER("\u2124", "Integer", StandardGroup.ATOMIC_EXPR, 401),
        OP_NATURAL("\u2115", "Natural", StandardGroup.ATOMIC_EXPR, 402),
        OP_NATURAL1("\u21151", "Natural1", StandardGroup.ATOMIC_EXPR, 403),
        OP_BOOL("BOOL", "Bool Type", StandardGroup.ATOMIC_EXPR, 404),
        OP_TRUE("TRUE", "True", StandardGroup.ATOMIC_EXPR, 405),
        OP_FALSE("FALSE", "False", StandardGroup.ATOMIC_EXPR, 406),
        OP_EMPTYSET("\u2205", "Empty Set", StandardGroup.ATOMIC_EXPR, 407),
        OP_KPRED("pred", "Predecessor", StandardGroup.ATOMIC_EXPR, 408),
        OP_KSUCC("succ", "Successor", StandardGroup.ATOMIC_EXPR, 409),
        OP_KPRJ1_GEN("prj1", "Projection 1", StandardGroup.ATOMIC_EXPR, 410),
        OP_KPRJ2_GEN("prj2", "Projection 2", StandardGroup.ATOMIC_EXPR, 411),
        OP_KID_GEN("id", "Identity", StandardGroup.ATOMIC_EXPR, 412);

        private final String image;
        private final String id;
        private final String groupId;
        private final int tag;

        private Operators(String image, String id, StandardGroup group, int tag) {
            this.image = image;
            this.id = id;
            this.groupId = group.getId();
            this.tag = tag;
        }

        @Override
        public String getImage() {
            return this.image;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getGroupId() {
            return this.groupId;
        }

        @Override
        public IParserPrinter<AtomicExpression> makeParser(int kind) {
            return new SubParsers.AtomicExpressionParser(kind, this.tag);
        }

        @Override
        public boolean isSpaced() {
            return false;
        }
    }
}

