/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.IOException;
import java.io.Serializable;
import tlc2.tool.distributed.InternRMI;
import tlc2.util.FP64;
import util.BufferedDataInputStream;
import util.BufferedDataOutputStream;
import util.InternTable;

public final class UniqueString
implements Serializable {
    public static InternTable internTbl = null;
    private String s;
    private int tok;
    private int loc = -1;
    private static int varCount;

    public static void initialize() {
        internTbl = new InternTable(1024);
        varCount = 0;
    }

    protected UniqueString(String str, int tok) {
        this.s = str;
        this.tok = tok;
    }

    private UniqueString(String str, int tok, int loc) {
        this(str, tok);
        this.loc = loc;
    }

    public static void setVariableCount(int varCount) {
        UniqueString.varCount = varCount;
    }

    public int getVarLoc() {
        return this.loc < varCount ? this.loc : -1;
    }

    public int getDefnLoc() {
        return this.loc < varCount ? -1 : this.loc;
    }

    public void setLoc(int loc) {
        this.loc = loc;
    }

    public int getTok() {
        return this.tok;
    }

    public UniqueString concat(UniqueString uniqueString) {
        return UniqueString.uniqueStringOf(this.toString() + uniqueString.toString());
    }

    public String toString() {
        return this.s;
    }

    public int hashCode() {
        return this.s.hashCode();
    }

    public int length() {
        return this.s.length();
    }

    public int compareTo(UniqueString uniqueString) {
        return this.tok - uniqueString.tok;
    }

    public boolean equals(UniqueString t) {
        return this.tok == t.tok;
    }

    public boolean equals(String t) {
        return this.s.equals(t);
    }

    public long fingerPrint(long fp) {
        return FP64.Extend(fp, this.tok);
    }

    public static UniqueString uniqueStringOf(String str) {
        return internTbl.put(str);
    }

    public static UniqueString uidToUniqueString(int tok) {
        return internTbl.get(tok);
    }

    public final void write(BufferedDataOutputStream dos) throws IOException {
        dos.writeInt(this.tok);
        dos.writeInt(this.getVarLoc());
        dos.writeInt(this.s.length());
        dos.writeString(this.s);
    }

    public static UniqueString read(BufferedDataInputStream dis) throws IOException {
        int tok1 = dis.readInt();
        int loc1 = dis.readInt();
        int slen = dis.readInt();
        String str = dis.readString(slen);
        return new UniqueString(str, tok1, loc1);
    }

    public static void setSource(InternRMI source) {
        internTbl.setSource(source);
    }

    static {
        UniqueString.initialize();
    }
}

