/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value;

import tlc2.TLCGlobals;
import tlc2.value.Enumerable;
import tlc2.value.FcnRcdValue;
import tlc2.value.MVPerm;
import tlc2.value.ModelValue;
import tlc2.value.SetEnumValue;
import tlc2.value.Value;
import tlc2.value.ValueEnumeration;
import tlc2.value.ValueExcept;
import tlc2.value.ValueVec;
import util.Assert;

public class SetOfFcnsValue
extends Value
implements Enumerable {
    public Value domain;
    public Value range;
    protected SetEnumValue fcnSet;

    public SetOfFcnsValue(Value domain, Value range) {
        this.domain = domain;
        this.range = range;
        this.fcnSet = null;
    }

    @Override
    public final byte getKind() {
        return 13;
    }

    @Override
    public final int compareTo(Object obj) {
        this.convertAndCache();
        return this.fcnSet.compareTo(obj);
    }

    public final boolean equals(Object obj) {
        if (obj instanceof SetOfFcnsValue) {
            SetOfFcnsValue fcns = (SetOfFcnsValue)obj;
            return this.domain.equals(fcns.domain) && this.range.equals(fcns.range);
        }
        this.convertAndCache();
        return this.fcnSet.equals(obj);
    }

    @Override
    public final boolean member(Value elem) {
        FcnRcdValue fcn = FcnRcdValue.convert(elem);
        if (fcn == null) {
            if (elem instanceof ModelValue) {
                return ((ModelValue)elem).modelValueMember(this);
            }
            Assert.fail("Attempted to check if \n" + elem + "\nwhich is not a TLC function" + " value, is in the set of functions:\n" + SetOfFcnsValue.ppr(this.toString()));
        }
        if (fcn.intv == null) {
            fcn.normalize();
            SetEnumValue fdom = new SetEnumValue(fcn.domain, true);
            if (this.domain.equals(fdom)) {
                for (int i = 0; i < fcn.values.length; ++i) {
                    if (this.range.member(fcn.values[i])) continue;
                    return false;
                }
                return true;
            }
        } else if (fcn.intv.equals(this.domain)) {
            for (int i = 0; i < fcn.values.length; ++i) {
                if (this.range.member(fcn.values[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public final boolean isFinite() {
        return this.domain.isFinite() && this.range.isFinite();
    }

    @Override
    public final Value takeExcept(ValueExcept ex) {
        if (ex.idx < ex.path.length) {
            Assert.fail("Attempted to apply EXCEPT to the set of functions:\n" + SetOfFcnsValue.ppr(this.toString()));
        }
        return ex.value;
    }

    @Override
    public final Value takeExcept(ValueExcept[] exs) {
        if (exs.length != 0) {
            Assert.fail("Attempted to apply EXCEPT to the set of functions:\n" + SetOfFcnsValue.ppr(this.toString()));
        }
        return this;
    }

    @Override
    public final int size() {
        int dsz = this.domain.size();
        int rsz = this.range.size();
        long sz = 1L;
        for (int i = 0; i < dsz; ++i) {
            if ((sz *= (long)rsz) >= Integer.MIN_VALUE && sz <= Integer.MAX_VALUE) continue;
            Assert.fail("Overflow when computing the number of elements in:\n" + SetOfFcnsValue.ppr(this.toString()));
        }
        return (int)sz;
    }

    @Override
    public final boolean isNormalized() {
        if (this.fcnSet == null || this.fcnSet == DummyEnum) {
            return this.domain.isNormalized() && this.range.isNormalized();
        }
        return this.fcnSet.isNormalized();
    }

    @Override
    public final void normalize() {
        if (this.fcnSet == null || this.fcnSet == DummyEnum) {
            this.domain.normalize();
            this.range.normalize();
        } else {
            this.fcnSet.normalize();
        }
    }

    @Override
    public final boolean isDefined() {
        return this.domain.isDefined() && this.range.isDefined();
    }

    @Override
    public final Value deepCopy() {
        return this;
    }

    @Override
    public final boolean assignable(Value val) {
        return this.equals(val);
    }

    @Override
    public final long fingerPrint(long fp) {
        this.convertAndCache();
        return this.fcnSet.fingerPrint(fp);
    }

    @Override
    public final Value permute(MVPerm perm) {
        this.convertAndCache();
        return this.fcnSet.permute(perm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void convertAndCache() {
        if (this.fcnSet == null) {
            this.fcnSet = SetEnumValue.convert(this);
        } else if (this.fcnSet == DummyEnum) {
            SetEnumValue val = null;
            SetOfFcnsValue setOfFcnsValue = this;
            synchronized (setOfFcnsValue) {
                if (this.fcnSet == DummyEnum) {
                    val = SetEnumValue.convert(this);
                    val.deepNormalize();
                }
            }
            setOfFcnsValue = this;
            synchronized (setOfFcnsValue) {
                if (this.fcnSet == DummyEnum) {
                    this.fcnSet = val;
                }
            }
        }
    }

    @Override
    public final StringBuffer toString(StringBuffer sb, int offset) {
        boolean unlazy = expand;
        try {
            if (unlazy) {
                int dsz = this.domain.size();
                int rsz = this.range.size();
                long sz = 1L;
                for (int i = 0; i < dsz; ++i) {
                    if ((sz *= (long)rsz) >= Integer.MIN_VALUE && sz <= Integer.MAX_VALUE) continue;
                    unlazy = false;
                    break;
                }
                unlazy = sz < (long)TLCGlobals.enumBound;
            }
        }
        catch (Throwable e) {
            unlazy = false;
        }
        if (unlazy) {
            SetEnumValue val = SetEnumValue.convert(this);
            return ((Value)val).toString(sb, offset);
        }
        sb.append("[");
        this.domain.toString(sb, offset);
        sb.append(" -> ");
        this.range.toString(sb, offset);
        sb.append("]");
        return sb;
    }

    @Override
    public final ValueEnumeration elements() {
        if (this.fcnSet == null || this.fcnSet == DummyEnum) {
            return new Enumerator();
        }
        return this.fcnSet.elements();
    }

    final class Enumerator
    implements ValueEnumeration {
        private Value[] dom;
        private ValueEnumeration[] enums;
        private Value[] currentElems;
        private boolean isDone = false;

        public Enumerator() {
            SetEnumValue domSet = SetEnumValue.convert(SetOfFcnsValue.this.domain);
            if (domSet == null) {
                Assert.fail("Attempted to enumerate a set of the form [D -> R],but the domain D:\n" + Value.ppr(SetOfFcnsValue.this.domain.toString()) + "\ncannot be enumerated.");
            }
            domSet.normalize();
            ValueVec elems = domSet.elems;
            int sz = elems.size();
            if (SetOfFcnsValue.this.range instanceof Enumerable) {
                this.dom = new Value[sz];
                this.enums = new ValueEnumeration[sz];
                this.currentElems = new Value[sz];
                for (int i = 0; i < sz; ++i) {
                    this.dom[i] = elems.elementAt(i);
                    this.enums[i] = ((Enumerable)((Object)SetOfFcnsValue.this.range)).elements();
                    this.currentElems[i] = this.enums[i].nextElement();
                    if (this.currentElems[i] != null) continue;
                    this.enums = null;
                    this.isDone = true;
                    break;
                }
            } else {
                Assert.fail("Attempted to enumerate a set of the form [D -> R],but the range R:\n" + Value.ppr(SetOfFcnsValue.this.range.toString()) + "\ncannot be enumerated.");
            }
        }

        @Override
        public final void reset() {
            if (this.enums != null) {
                for (int i = 0; i < this.enums.length; ++i) {
                    this.enums[i].reset();
                    this.currentElems[i] = this.enums[i].nextElement();
                }
                this.isDone = false;
            }
        }

        @Override
        public final Value nextElement() {
            if (this.isDone) {
                return null;
            }
            Value[] elems = new Value[this.currentElems.length];
            if (elems.length == 0) {
                this.isDone = true;
            } else {
                int i;
                for (i = 0; i < elems.length; ++i) {
                    elems[i] = this.currentElems[i];
                }
                for (i = elems.length - 1; i >= 0; --i) {
                    this.currentElems[i] = this.enums[i].nextElement();
                    if (this.currentElems[i] != null) break;
                    if (i == 0) {
                        this.isDone = true;
                        break;
                    }
                    this.enums[i].reset();
                    this.currentElems[i] = this.enums[i].nextElement();
                }
            }
            return new FcnRcdValue(this.dom, elems, true);
        }
    }
}

