/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util;

import java.io.IOException;
import java.io.Serializable;
import tlc2.util.BufferedRandomAccessFile;

public class BitVector
implements Serializable {
    private static final long serialVersionUID = 901734230891583097L;
    private long[] word;

    public BitVector() {
        this.word = null;
    }

    public BitVector(int initCapacity) {
        int len = initCapacity == 0 ? 0 : (initCapacity - 1) / 64 + 1;
        this.word = new long[len];
    }

    public BitVector(int initCapacity, boolean initValue) {
        int len = initCapacity == 0 ? 0 : (initCapacity - 1) / 64 + 1;
        this.word = new long[len];
        if (initValue) {
            this.set(0, len);
        }
    }

    public BitVector(BitVector bv) {
        int len = bv.word.length;
        this.word = new long[len];
        System.arraycopy(bv.word, 0, this.word, 0, len);
    }

    public boolean equals(Object o) {
        if (!(o instanceof BitVector)) {
            return false;
        }
        BitVector other = (BitVector)o;
        int minLen = Math.min(this.word.length, other.word.length);
        for (int i = 0; i < minLen; ++i) {
            if (this.word[i] == other.word[i]) continue;
            return false;
        }
        if (this.word.length != other.word.length) {
            int maxLen = Math.max(this.word.length, other.word.length);
            long[] tail = maxLen == this.word.length ? this.word : other.word;
            for (int i = minLen; i < maxLen; ++i) {
                if (tail[i] == 0L) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int res = 0;
        for (int i = 0; i < this.word.length; ++i) {
            long w = this.word[i];
            if (w == 0L) continue;
            res ^= (int)(w & 0xFFFFL);
            res ^= (int)(w >>> 32);
        }
        return res;
    }

    public void clear() {
        for (int i = 0; i < this.word.length; ++i) {
            this.word[i] = 0L;
        }
    }

    public boolean get(int i) {
        int wd = i / 64;
        if (wd >= this.word.length) {
            return false;
        }
        int bit = i % 64;
        return (this.word[wd] & 1L << bit) != 0L;
    }

    public void set(int i) {
        int wd = i / 64;
        if (wd >= this.word.length) {
            this.grow(wd);
        }
        int bit = i % 64;
        int n = wd;
        this.word[n] = this.word[n] | 1L << bit;
    }

    public void set(int lo, int hi) {
        int lwd = lo / 64;
        int hwd = hi / 64;
        if (hwd >= this.word.length) {
            this.grow(hwd);
        }
        int lbit = lo % 64;
        int hbit = hi % 64;
        if (lwd < hwd) {
            for (int i = lwd + 1; i < hwd; ++i) {
                this.word[i] = -1L;
            }
            this.word[lwd] = -1L << lbit;
            this.word[hwd] = -1L >>> 63 - hbit;
        } else if (lo <= hi) {
            this.word[lwd] = -1L << lbit & -1L >>> 63 - hbit;
        }
    }

    public int trueCnt() {
        int res = 0;
        for (int i = 0; i < this.word.length * 64; ++i) {
            int wd = i / 64;
            int bit = i % 64;
            if ((this.word[wd] & 1L << bit) == 0L) continue;
            ++res;
        }
        return res;
    }

    public void reset(int i) {
        int wd = i / 64;
        if (wd >= this.word.length) {
            this.grow(wd);
        }
        int bit = i % 64;
        int n = wd;
        this.word[n] = this.word[n] & (1L << bit ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void set(int i, boolean val) {
        int wd = i / 64;
        if (wd >= this.word.length) {
            this.grow(wd);
        }
        int bit = i % 64;
        if (val) {
            int n = wd;
            this.word[n] = this.word[n] | 1L << bit;
        } else {
            int n = wd;
            this.word[n] = this.word[n] & (1L << bit ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public void write(BufferedRandomAccessFile raf) throws IOException {
        int len = this.word.length;
        raf.writeNat(len);
        for (int i = 0; i < len; ++i) {
            raf.writeLong(this.word[i]);
        }
    }

    public void read(BufferedRandomAccessFile raf) throws IOException {
        int len = raf.readNat();
        this.word = new long[len];
        for (int i = 0; i < len; ++i) {
            this.word[i] = raf.readLong();
        }
    }

    private void grow(int wd) {
        int newLen = Math.max(this.word.length, wd + 1);
        long[] tmp = new long[newLen];
        System.arraycopy(this.word, 0, tmp, 0, this.word.length);
        this.word = tmp;
    }

    public static class Iter {
        long[] word;
        int wd;
        int bit;
        long mask;

        public Iter() {
        }

        public Iter(BitVector bv) {
            this.init(bv);
        }

        public void init(BitVector bv) {
            this.word = bv.word;
            this.wd = 0;
            this.bit = 0;
            this.mask = 1L;
        }

        public int next() {
            while (this.wd < this.word.length) {
                long w = this.word[this.wd];
                while (this.bit < 64) {
                    if ((w & this.mask) != 0L) {
                        int res = this.wd * 64 + this.bit;
                        ++this.bit;
                        if (this.bit < 64) {
                            this.mask <<= 1;
                        } else {
                            ++this.wd;
                            this.bit = 0;
                            this.mask = 1L;
                        }
                        return res;
                    }
                    ++this.bit;
                    this.mask <<= 1;
                }
                this.bit = 0;
                this.mask = 1L;
                ++this.wd;
            }
            return -1;
        }
    }
}

