/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.liveness;

import tlc2.tool.TLCState;
import tlc2.tool.Tool;
import tlc2.tool.liveness.LNNeg;
import tlc2.tool.liveness.LNState;
import tlc2.tool.liveness.LiveExprNode;
import tlc2.tool.liveness.TBPar;
import tlc2.util.SetOfLong;
import tlc2.util.Vect;

public class TBGraphNode {
    private final TBPar par;
    public final Vect nexts;
    public int index;
    private final LiveExprNode[] statePreds;
    public static TBGraphNode dummyNode = new TBGraphNode();

    private TBGraphNode() {
        this.par = null;
        this.nexts = null;
        this.index = -1;
        this.statePreds = null;
    }

    public TBGraphNode(TBPar par) {
        int i;
        this.par = par;
        this.index = 0;
        this.nexts = new Vect();
        TBPar preds = new TBPar(par.size());
        for (i = 0; i < par.size(); ++i) {
            LiveExprNode body;
            LiveExprNode ln = par.exprAt(i);
            if (ln instanceof LNState) {
                preds.addElement(ln);
                continue;
            }
            if (!(ln instanceof LNNeg) || !((body = ((LNNeg)ln).getBody()) instanceof LNState)) continue;
            preds.addElement(ln);
        }
        this.statePreds = new LiveExprNode[preds.size()];
        for (i = 0; i < preds.size(); ++i) {
            this.statePreds[i] = preds.exprAt(i);
        }
    }

    public final TBPar getPar() {
        return this.par;
    }

    public int nextSize() {
        return this.nexts.size();
    }

    public TBGraphNode nextAt(int i) {
        return (TBGraphNode)this.nexts.elementAt(i);
    }

    public final boolean hasLink(TBGraphNode target) {
        int sz = this.nexts.size();
        for (int i = 0; i < sz; ++i) {
            if (this.nexts.elementAt(i) != target) continue;
            return true;
        }
        return false;
    }

    public boolean isConsistent(TLCState state, Tool tool) {
        for (int j = 0; j < this.statePreds.length; ++j) {
            if (this.statePreds[j].eval(tool, state, null)) continue;
            return false;
        }
        return true;
    }

    public final String toString() {
        StringBuffer buf = new StringBuffer();
        SetOfLong visited = new SetOfLong(16);
        this.toString(buf, visited);
        return buf.toString();
    }

    private final void toString(StringBuffer buf, SetOfLong visited) {
        if (!visited.put(this.index)) {
            int i;
            buf.append(this.par.toString());
            for (i = 0; i < this.nexts.size(); ++i) {
                buf.append(this.nextAt((int)i).index + " ");
            }
            buf.append("\n");
            for (i = 0; i < this.nexts.size(); ++i) {
                this.nextAt(i).toString(buf, visited);
            }
        }
    }

    public String toDotViz() {
        String label = "\"Id: " + this.index + "\n" + this.par.toDotViz() + "\"";
        StringBuffer buf = new StringBuffer(this.nextSize());
        buf.append(this.index + " [label=" + label + "]\n");
        for (int i = 0; i < this.nextSize(); ++i) {
            TBGraphNode successor = this.nextAt(i);
            buf.append(this.index + " -> " + successor.index);
            buf.append("\n");
        }
        return buf.toString();
    }
}

