/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import tlc2.output.MP;
import tlc2.tool.AbstractChecker;
import tlc2.tool.IWorker;
import tlc2.tool.ModelChecker;
import tlc2.tool.TLCState;
import tlc2.tool.queue.IStateQueue;
import tlc2.util.IdThread;
import tlc2.util.ObjLongTable;
import tlc2.value.Value;

public class Worker
extends IdThread
implements IWorker {
    private ModelChecker tlc;
    private IStateQueue squeue;
    private ObjLongTable astCounts;
    private Value[] localValues;

    public Worker(int id, AbstractChecker tlc) {
        super(id);
        this.setName("TLC Worker " + id);
        this.tlc = (ModelChecker)tlc;
        this.squeue = this.tlc.theStateQueue;
        this.astCounts = new ObjLongTable(10);
        this.localValues = new Value[4];
        this.setName("TLCWorkerThread-" + String.format("%03d", id));
    }

    @Override
    public final ObjLongTable getCounts() {
        return this.astCounts;
    }

    public Value getLocalValue(int idx) {
        if (idx < this.localValues.length) {
            return this.localValues[idx];
        }
        return null;
    }

    public void setLocalValue(int idx, Value val) {
        if (idx >= this.localValues.length) {
            Value[] vals = new Value[idx + 1];
            System.arraycopy(this.localValues, 0, vals, 0, this.localValues.length);
            this.localValues = vals;
        }
        this.localValues[idx] = val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        TLCState curState = null;
        try {
            do {
                if ((curState = this.squeue.sDequeue()) != null) continue;
                ModelChecker modelChecker = this.tlc;
                synchronized (modelChecker) {
                    this.tlc.setDone();
                    this.tlc.notify();
                }
                this.squeue.finishAll();
                return;
            } while (!this.tlc.doNext(curState, this.astCounts));
            return;
        }
        catch (Throwable e) {
            ModelChecker modelChecker = this.tlc;
            synchronized (modelChecker) {
                if (this.tlc.setErrState(curState, null, true)) {
                    MP.printError(1000, e);
                }
                this.squeue.finishAll();
                this.tlc.notify();
            }
            return;
        }
    }
}

