/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import tla2sany.modanalyzer.SpecObj;
import tla2sany.semantic.ExprNode;
import tlc2.TLCGlobals;
import tlc2.output.MP;
import tlc2.output.OutputCollector;
import tlc2.tool.AbstractChecker;
import tlc2.tool.EvalException;
import tlc2.tool.StateVec;
import tlc2.tool.TLCState;
import tlc2.tool.TLCStateMutSource;
import tlc2.tool.TLCTrace;
import tlc2.tool.Worker;
import tlc2.tool.fp.FPSet;
import tlc2.tool.fp.FPSetConfiguration;
import tlc2.tool.fp.FPSetFactory;
import tlc2.tool.liveness.LiveCheck;
import tlc2.tool.queue.DiskStateQueue;
import tlc2.tool.queue.IStateQueue;
import tlc2.util.IdThread;
import tlc2.util.LongVec;
import tlc2.util.ObjLongTable;
import tlc2.util.statistics.BucketStatistics;
import tlc2.value.Value;
import util.DebugPrinter;
import util.FileUtil;
import util.FilenameToStream;
import util.UniqueString;

public class ModelChecker
extends AbstractChecker {
    private static final boolean VETO_CLEANUP = Boolean.getBoolean(ModelChecker.class.getName() + ".vetoCleanup");
    public FPSet theFPSet;
    public IStateQueue theStateQueue = new DiskStateQueue(this.metadir);
    public TLCTrace trace;
    protected Worker[] workers;
    public long distinctStatesPerMinute;
    public long statesPerMinute = 0L;
    protected long oldNumOfGenStates;
    protected long oldFPSetSize = 0L;

    public ModelChecker(String specFile, String configFile, String dumpFile, boolean deadlock, String fromChkpt, FilenameToStream resolver, SpecObj specObj, FPSetConfiguration fpSetConfig) throws EvalException, IOException {
        super(specFile, configFile, dumpFile, deadlock, fromChkpt, true, resolver, specObj);
        this.theFPSet = FPSetFactory.getFPSet(fpSetConfig);
        this.theFPSet.init(TLCGlobals.getNumWorkers(), this.metadir, specFile);
        this.trace = new TLCTrace(this.metadir, specFile, this.tool);
        this.workers = new Worker[TLCGlobals.getNumWorkers()];
        for (int i = 0; i < this.workers.length; ++i) {
            this.workers[i] = new Worker(i, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modelCheck() throws Exception {
        this.report("entering modelCheck()");
        long startTime = System.currentTimeMillis();
        boolean recovered = this.recover();
        if (!recovered) {
            if (!this.checkAssumptions()) {
                return;
            }
            try {
                this.report("doInit(false)");
                MP.printMessage(2189);
                if (!this.doInit(false)) {
                    this.report("exiting, because init failed");
                    return;
                }
            }
            catch (Throwable e) {
                this.report("exception in init");
                this.report(e);
                String msg = e.getMessage();
                if (e instanceof StackOverflowError) {
                    msg = "This was a Java StackOverflowError. It was probably the result\nof an incorrect recursive function definition that caused TLC to enter\nan infinite loop when trying to compute the function or its application\nto an element in its putative domain.";
                }
                if (msg == null) {
                    msg = e.toString();
                }
                if (this.errState != null) {
                    MP.printError(2102, new String[]{msg, this.errState.toString()});
                } else {
                    MP.printError(1000, msg);
                }
                this.tool.setCallStack();
                try {
                    this.numOfGenStates = new AtomicLong(0L);
                    this.doInit(true);
                }
                catch (Throwable e1) {
                    MP.printError(2103, this.tool.getCallStack().toString());
                }
                this.printSummary(false, startTime);
                this.cleanup(false);
                this.report("exiting, because init failed with exception");
                return;
            }
            if (this.numOfGenStates.get() == this.theFPSet.size()) {
                String plural = this.numOfGenStates.get() == 1L ? "" : "s";
                MP.printMessage(2190, new String[]{String.valueOf(this.numOfGenStates), plural});
            } else {
                MP.printMessage(2190, new String[]{String.valueOf(this.numOfGenStates), String.valueOf(this.theFPSet.size())});
            }
        }
        this.report("init processed");
        if (this.actions.length == 0) {
            ModelChecker.reportSuccess(this.theFPSet, this.numOfGenStates.get());
            this.printSummary(true, startTime);
            this.cleanup(true);
            this.report("exiting with actions.length == 0");
            return;
        }
        boolean success = false;
        try {
            this.report("running TLC");
            success = this.runTLC(Integer.MAX_VALUE);
            if (!success) {
                this.report("TLC terminated with error");
                return;
            }
            if (this.errState == null) {
                if (this.checkLiveness) {
                    MP.printMessage(2192, new String[]{"complete", Long.toString(this.theFPSet.size())});
                    this.report("checking liveness");
                    success = this.liveCheck.finalCheck();
                    this.report("liveness check complete");
                    if (!success) {
                        this.report("exiting error status on liveness check");
                        return;
                    }
                }
                success = true;
                ModelChecker.reportSuccess(this.theFPSet, this.numOfGenStates.get());
            } else if (this.keepCallStack) {
                this.tool.setCallStack();
                try {
                    this.doNext(this.predErrState, new ObjLongTable(10));
                }
                catch (Throwable e) {
                    MP.printError(2103, this.tool.getCallStack().toString());
                }
            }
        }
        catch (Exception e) {
            this.report("TLC terminated with error");
            success = false;
            MP.printError(1000, e);
        }
        finally {
            this.printSummary(success, startTime);
            if (this.checkLiveness && LIVENESS_STATS) {
                System.gc();
                MP.printStats(this.liveCheck.calculateInDegreeDiskGraphs(new BucketStatistics("Histogram vertex in-degree", LiveCheck.class.getPackage().getName(), "DiskGraphsInDegree")), this.liveCheck.getOutDegreeStatistics());
            }
            this.cleanup(success);
        }
        this.report("exiting modelCheck()");
    }

    public boolean checkAssumptions() {
        ExprNode[] assumps = this.tool.getAssumptions();
        boolean[] isAxiom = this.tool.getAssumptionIsAxiom();
        boolean assumptionsAreTRUE = true;
        for (int i = 0; i < assumps.length; ++i) {
            try {
                if (isAxiom[i] || this.tool.isValid(assumps[i])) continue;
                OutputCollector.addViolatedAssumption(assumps[i]);
                MP.printError(2104, assumps[i].toString());
                assumptionsAreTRUE = false;
                continue;
            }
            catch (Exception e) {
                OutputCollector.addViolatedAssumption(assumps[i]);
                MP.printError(2105, new String[]{assumps[i].toString(), e.getMessage()});
                assumptionsAreTRUE = false;
            }
        }
        return assumptionsAreTRUE;
    }

    @Override
    public final boolean doInit(boolean ignoreCancel) throws Throwable {
        if (!ignoreCancel && this.cancellationFlag) {
            return false;
        }
        TLCState curState = null;
        try {
            StateVec theInitStates = this.tool.getInitStates();
            this.numOfGenStates.set(theInitStates.size());
            for (int i = 0; i < theInitStates.size(); ++i) {
                int j;
                long fp;
                curState = theInitStates.elementAt(i);
                if (!this.tool.isGoodState(curState)) {
                    MP.printError(2102, curState.toString());
                    return false;
                }
                boolean inModel = this.tool.isInModel(curState);
                boolean seen = false;
                if (inModel && !(seen = this.theFPSet.put(fp = curState.fingerPrint()))) {
                    if (this.allStateWriter != null) {
                        this.allStateWriter.writeState(curState);
                    }
                    curState.uid = this.trace.writeState(fp);
                    this.theStateQueue.enqueue(curState);
                    if (this.checkLiveness) {
                        this.liveCheck.addInitState(curState, fp);
                    }
                }
                OutputCollector.setInitialState(curState);
                if (seen) continue;
                for (j = 0; j < this.invariants.length; ++j) {
                    if (this.tool.isValid(this.invariants[j], curState)) continue;
                    MP.printError(2107, new String[]{this.tool.getInvNames()[j].toString(), curState.toString()});
                    if (TLCGlobals.continuation) continue;
                    return false;
                }
                for (j = 0; j < this.impliedInits.length; ++j) {
                    if (this.tool.isValid(this.impliedInits[j], curState)) continue;
                    MP.printError(2108, new String[]{this.tool.getImpliedInitNames()[j], curState.toString()});
                    return false;
                }
            }
        }
        catch (Throwable e) {
            if (e instanceof OutOfMemoryError) {
                MP.printError(1002);
                return false;
            }
            this.errState = curState;
            throw e;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean doNext(TLCState curState, ObjLongTable counts) throws Throwable {
        if (this.cancellationFlag) {
            return false;
        }
        boolean deadLocked = true;
        TLCState succState = null;
        StateVec liveNextStates = null;
        LongVec liveNextFPs = null;
        if (this.checkLiveness) {
            liveNextStates = new StateVec(2);
            liveNextFPs = new LongVec(2);
        }
        try {
            int k = 0;
            for (int i = 0; i < this.actions.length; ++i) {
                if (this.cancellationFlag) {
                    return false;
                }
                StateVec nextStates = this.tool.getNextStates(this.actions[i], curState);
                int sz = nextStates.size();
                this.incNumOfGenStates(sz);
                deadLocked = deadLocked && sz == 0;
                for (int j = 0; j < sz; ++j) {
                    ModelChecker modelChecker;
                    int len;
                    succState = nextStates.elementAt(j);
                    if (!this.tool.isGoodState(succState)) {
                        if (this.setErrState(curState, succState, false)) {
                            MP.printError(2109);
                            this.trace.printTrace(curState, succState);
                            this.theStateQueue.finishAll();
                            ModelChecker modelChecker2 = this;
                            synchronized (modelChecker2) {
                                this.notify();
                            }
                        }
                        return true;
                    }
                    if (TLCGlobals.coverageInterval >= 0) {
                        ((TLCStateMutSource)succState).addCounts(counts);
                    }
                    boolean inModel = this.tool.isInModel(succState) && this.tool.isInActions(curState, succState);
                    boolean seen = false;
                    if (inModel) {
                        long fp = succState.fingerPrint();
                        seen = this.theFPSet.put(fp);
                        if (!seen) {
                            long loc;
                            if (this.allStateWriter != null) {
                                this.allStateWriter.writeState(succState);
                            }
                            succState.uid = loc = this.trace.writeState(curState, fp);
                            this.theStateQueue.sEnqueue(succState);
                        }
                        if (this.checkLiveness) {
                            liveNextStates.addElement(succState);
                            liveNextFPs.addElement(fp);
                        }
                    }
                    if (!seen) {
                        try {
                            len = this.invariants.length;
                            for (k = 0; k < len; ++k) {
                                if (this.cancellationFlag) {
                                    return false;
                                }
                                if (this.tool.isValid(this.invariants[k], succState)) continue;
                                modelChecker = this;
                                synchronized (modelChecker) {
                                    if (TLCGlobals.continuation) {
                                        MP.printError(2110, this.tool.getInvNames()[k]);
                                        this.trace.printTrace(curState, succState);
                                        break;
                                    }
                                    if (this.setErrState(curState, succState, false)) {
                                        MP.printError(2110, this.tool.getInvNames()[k]);
                                        this.trace.printTrace(curState, succState);
                                        this.theStateQueue.finishAll();
                                        this.notify();
                                    }
                                    return true;
                                }
                            }
                            if (k < len) {
                                continue;
                            }
                        }
                        catch (Exception e) {
                            if (this.setErrState(curState, succState, true)) {
                                MP.printError(2111, new String[]{this.tool.getInvNames()[k], e.getMessage() == null ? e.toString() : e.getMessage()});
                                this.trace.printTrace(curState, succState);
                                this.theStateQueue.finishAll();
                                this.notify();
                            }
                            throw e;
                        }
                    }
                    try {
                        len = this.impliedActions.length;
                        for (k = 0; k < len; ++k) {
                            if (this.cancellationFlag) {
                                return false;
                            }
                            if (this.tool.isValid(this.impliedActions[k], curState, succState)) continue;
                            modelChecker = this;
                            synchronized (modelChecker) {
                                if (TLCGlobals.continuation) {
                                    MP.printError(2112, this.tool.getImpliedActNames()[k]);
                                    this.trace.printTrace(curState, succState);
                                    break;
                                }
                                if (this.setErrState(curState, succState, false)) {
                                    MP.printError(2112, this.tool.getImpliedActNames()[k]);
                                    this.trace.printTrace(curState, succState);
                                    this.theStateQueue.finishAll();
                                    this.notify();
                                }
                                return true;
                            }
                        }
                        if (k >= len) continue;
                    }
                    catch (Exception e) {
                        if (this.setErrState(curState, succState, true)) {
                            MP.printError(2113, new String[]{this.tool.getImpliedActNames()[k], e.getMessage() == null ? e.toString() : e.getMessage()});
                            this.trace.printTrace(curState, succState);
                            this.theStateQueue.finishAll();
                            this.notify();
                        }
                        throw e;
                    }
                }
                succState = null;
            }
            if (deadLocked && this.checkDeadlock) {
                ModelChecker i = this;
                synchronized (i) {
                    if (this.setErrState(curState, null, false)) {
                        MP.printError(2114);
                        this.trace.printTrace(curState, null);
                        this.theStateQueue.finishAll();
                        this.notify();
                    }
                }
                return true;
            }
            if (this.checkLiveness) {
                long curStateFP = curState.fingerPrint();
                liveNextStates.addElement(curState);
                liveNextFPs.addElement(curStateFP);
                this.liveCheck.addNextState(curState, curStateFP, liveNextStates, liveNextFPs);
            }
            return false;
        }
        catch (Throwable e) {
            boolean keep = e instanceof StackOverflowError || e instanceof OutOfMemoryError;
            ModelChecker modelChecker = this;
            synchronized (modelChecker) {
                if (this.setErrState(curState, succState, !keep)) {
                    if (e instanceof StackOverflowError) {
                        MP.printError(1005, e);
                    } else if (e instanceof OutOfMemoryError) {
                        MP.printError(1001, e);
                    } else if (e.getMessage() != null) {
                        MP.printError(1000, e);
                    }
                    this.trace.printTrace(curState, succState);
                    this.theStateQueue.finishAll();
                    this.notify();
                }
            }
            throw e;
        }
    }

    @Override
    public final boolean doPeriodicWork() throws Exception {
        if (this.theStateQueue.suspendAll()) {
            if (this.checkLiveness && !this.liveCheck.check(false)) {
                return false;
            }
            if (TLCGlobals.doCheckPoint()) {
                MP.printMessage(2195, this.metadir);
                this.theStateQueue.beginChkpt();
                this.trace.beginChkpt();
                this.theFPSet.beginChkpt();
                this.theStateQueue.resumeAll();
                UniqueString.internTbl.beginChkpt(this.metadir);
                if (this.checkLiveness) {
                    this.liveCheck.beginChkpt();
                }
                this.theStateQueue.commitChkpt();
                this.trace.commitChkpt();
                this.theFPSet.commitChkpt();
                UniqueString.internTbl.commitChkpt(this.metadir);
                if (this.checkLiveness) {
                    this.liveCheck.commitChkpt();
                }
                MP.printMessage(2196);
            } else {
                this.theStateQueue.resumeAll();
            }
        }
        return true;
    }

    public final boolean recover() throws IOException {
        boolean recovered = false;
        if (this.fromChkpt != null) {
            MP.printMessage(2197, this.fromChkpt);
            this.trace.recover();
            this.theStateQueue.recover();
            this.theFPSet.recover();
            if (this.checkLiveness) {
                this.liveCheck.recover();
            }
            MP.printMessage(2198, new String[]{String.valueOf(this.theFPSet.size()), String.valueOf(this.theStateQueue.size())});
            recovered = true;
            this.numOfGenStates.set(this.theFPSet.size());
        }
        return recovered;
    }

    private final void cleanup(boolean success) throws IOException {
        this.theFPSet.close();
        this.trace.close();
        if (this.checkLiveness) {
            this.liveCheck.close();
        }
        if (this.allStateWriter != null) {
            this.allStateWriter.close();
        }
        if (!VETO_CLEANUP) {
            FileUtil.deleteDir(this.metadir, success);
        }
    }

    public final void printSummary(boolean success, long startTime) throws IOException {
        super.reportCoverage(this.workers);
        if (TLCGlobals.tool) {
            this.printProgresStats(startTime);
        }
        MP.printMessage(2199, new String[]{String.valueOf(this.numOfGenStates), String.valueOf(this.theFPSet.size()), String.valueOf(this.theStateQueue.size())});
        if (success) {
            MP.printMessage(2194, String.valueOf(this.trace.getLevelForReporting()));
        }
    }

    private final void printProgresStats(long startTime) throws IOException {
        double factor;
        long fpSetSize = this.theFPSet.size();
        if (startTime < 0L) {
            factor = 1.0;
        } else {
            this.oldNumOfGenStates = 0L;
            this.oldFPSetSize = 0L;
            factor = (double)(System.currentTimeMillis() - startTime) / 60000.0;
        }
        long l = this.numOfGenStates.get();
        this.statesPerMinute = (long)((double)(l - this.oldNumOfGenStates) / factor);
        this.oldNumOfGenStates = l;
        this.distinctStatesPerMinute = (long)((double)(fpSetSize - this.oldFPSetSize) / factor);
        this.oldFPSetSize = fpSetSize;
        MP.printMessage(2200, new String[]{String.valueOf(this.trace.getLevelForReporting()), String.valueOf(this.numOfGenStates), String.valueOf(fpSetSize), String.valueOf(this.theStateQueue.size()), String.valueOf(this.statesPerMinute), String.valueOf(this.distinctStatesPerMinute)});
    }

    public static final void reportSuccess(FPSet anFpSet, long numOfGenStates) throws IOException {
        long fpSetSize = anFpSet.size();
        double actualProb = anFpSet.checkFPs();
        ModelChecker.reportSuccess(fpSetSize, actualProb, numOfGenStates);
    }

    public static final void reportSuccess(long numOfDistinctStates, double actualProb, long numOfGenStates) throws IOException {
        double optimisticProb = (double)numOfDistinctStates * ((double)(numOfGenStates - numOfDistinctStates) / Math.pow(2.0, 64.0));
        String optimisticProbStr = "val = " + ModelChecker.ProbabilityToString(optimisticProb, 2);
        String actualProbStr = "val = " + ModelChecker.ProbabilityToString(actualProb, 2);
        MP.printMessage(2193, new String[]{optimisticProbStr, actualProbStr});
    }

    private static final String ProbabilityToString(double val, int significantDigits) {
        int next;
        if (val == 0.0) {
            return "0.0";
        }
        String valString = Double.toString(val);
        int valStringLen = valString.length();
        String result = "";
        int significantDigitsFound = 0;
        for (next = 0; next < valStringLen && valString.charAt(next) == '0'; ++next) {
        }
        while (next < valStringLen && Character.isDigit(valString.charAt(next))) {
            result = result + valString.charAt(next);
            ++significantDigitsFound;
            ++next;
        }
        if (next == valStringLen) {
            return result;
        }
        if (valString.charAt(next) != '.') {
            return valString;
        }
        if (significantDigitsFound >= significantDigits) {
            ++next;
            while (next < valStringLen && Character.isDigit(valString.charAt(next))) {
                ++next;
            }
        } else {
            ++next;
            result = result + ".";
            if (significantDigitsFound == 0) {
                while (next < valStringLen && valString.charAt(next) == '0') {
                    ++next;
                    result = result + "0";
                }
            }
            while (next < valStringLen && Character.isDigit(valString.charAt(next)) && significantDigitsFound < significantDigits) {
                result = result + valString.charAt(next);
                ++next;
                ++significantDigitsFound;
            }
            if (next < valStringLen && Character.isDigit(valString.charAt(next)) && Character.digit(valString.charAt(next), 10) >= 5) {
                int prev = result.length() - 1;
                boolean done = false;
                while (!done) {
                    if (prev < 0) {
                        result = "1" + result;
                        done = true;
                    } else {
                        char prevChar = result.charAt(prev);
                        String front = result.substring(0, prev);
                        String back = result.substring(prev + 1);
                        if (Character.isDigit(prevChar)) {
                            if (prevChar == '9') {
                                result = front + '0' + back;
                            } else {
                                result = front + Character.forDigit(Character.digit(prevChar, 10) + 1, 10) + back;
                                done = true;
                            }
                        }
                    }
                    --prev;
                }
            }
            while (next < valStringLen && Character.isDigit(valString.charAt(next))) {
                ++next;
            }
        }
        if (next >= valStringLen) {
            return result;
        }
        if (valString.charAt(next) == 'E') {
            ++next;
            result = result + "E";
            while (next < valStringLen) {
                result = result + valString.charAt(next);
                ++next;
            }
            return result;
        }
        return valString;
    }

    public final void setAllValues(int idx, Value val) {
        for (int i = 0; i < this.workers.length; ++i) {
            this.workers[i].setLocalValue(idx, val);
        }
    }

    public final Value getValue(int i, int idx) {
        return this.workers[i].getLocalValue(idx);
    }

    @Override
    protected IdThread[] startWorkers(AbstractChecker checker, int checkIndex) {
        for (int i = 0; i < this.workers.length; ++i) {
            this.workers[i].start();
        }
        return this.workers;
    }

    @Override
    protected void runTLCPreLoop() {
    }

    @Override
    protected void runTLCContinueDoing(int count, int depth) throws Exception {
        int level = this.trace.getLevel();
        this.printProgresStats(-1L);
        if (level > depth) {
            this.theStateQueue.finishAll();
            this.done = true;
        } else {
            if (count == 0) {
                super.reportCoverage(this.workers);
            }
            this.wait(60000L);
        }
    }

    private void report(Throwable e) {
        DebugPrinter.print(e);
    }

    public long getStatesGenerated() {
        return this.numOfGenStates.get();
    }
}

