/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import java.util.Hashtable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import tla2sany.explorer.ExploreNode;
import tla2sany.parser.SyntaxTreeNode;
import tla2sany.semantic.ASTConstants;
import tla2sany.semantic.Errors;
import tla2sany.semantic.LevelConstants;
import tla2sany.st.Location;
import tla2sany.st.TreeNode;
import tla2sany.xml.SymbolContext;
import tla2sany.xml.XMLExportable;
import util.ToolIO;

public abstract class SemanticNode
implements ASTConstants,
ExploreNode,
LevelConstants,
Comparable,
XMLExportable {
    private static final Object[] EmptyArr = new Object[0];
    private static int uid = 0;
    protected static Errors errors;
    public int myUID = uid++;
    public TreeNode stn;
    private Object[] tools;
    private int kind;

    public SemanticNode(int kind, TreeNode stn) {
        this.kind = kind;
        this.stn = stn;
        this.tools = EmptyArr;
    }

    public static void setError(Errors errs) {
        errors = errs;
    }

    public static String levelToString(int level) {
        switch (level) {
            case 0: {
                return level + " (Constant)";
            }
            case 1: {
                return level + " (Variable)";
            }
            case 2: {
                return level + " (Action)";
            }
            case 3: {
                return level + " (Temporal)";
            }
        }
        return level + " (Illegal)";
    }

    public final int getUid() {
        return this.myUID;
    }

    public final Object getToolObject(int toolId) {
        if (this.tools.length <= toolId) {
            return null;
        }
        return this.tools[toolId];
    }

    public final void setToolObject(int toolId, Object obj) {
        if (this.tools.length <= toolId) {
            Object[] newTools = new Object[toolId + 1];
            System.arraycopy(this.tools, 0, newTools, 0, this.tools.length);
            this.tools = newTools;
        }
        this.tools[toolId] = obj;
        ToolIO.registerSemanticNode(this, toolId);
    }

    public final int getKind() {
        return this.kind;
    }

    public final void setKind(int k) {
        this.kind = k;
    }

    public final TreeNode getTreeNode() {
        return this.stn;
    }

    public String[] getPreComments() {
        return ((SyntaxTreeNode)this.stn).getAttachedComments();
    }

    public String getPreCommentsAsString() {
        return SyntaxTreeNode.PreCommentToString(this.getPreComments());
    }

    public SemanticNode[] getChildren() {
        return null;
    }

    @Override
    public void walkGraph(Hashtable semNodesTable) {
        Integer uid = new Integer(this.myUID);
        if (semNodesTable.get(uid) != null) {
            return;
        }
        semNodesTable.put(new Integer(this.myUID), this);
    }

    @Override
    public String toString(int depth) {
        if (depth <= 0) {
            return "";
        }
        return "  uid: " + this.myUID + "  kind: " + (this.kind == -1 ? "<none>" : kinds[this.kind]) + this.getPreCommentsAsString();
    }

    public final Location getLocation() {
        return this.stn.getLocation();
    }

    public int compareTo(Object s) {
        Location loc1 = this.stn.getLocation();
        Location loc2 = ((SemanticNode)s).stn.getLocation();
        if (loc1.beginLine() < loc2.beginLine()) {
            return -1;
        }
        if (loc1.beginLine() > loc2.beginLine()) {
            return 1;
        }
        if (loc1.beginColumn() == loc2.beginColumn()) {
            return 0;
        }
        return loc1.beginColumn() < loc2.beginColumn() ? -1 : 1;
    }

    public final void toString(StringBuffer sb, String padding) {
        sb.append(this.getLocation());
    }

    public String toString() {
        return this.getLocation().toString();
    }

    protected Element getSemanticElement(Document doc, SymbolContext context) {
        throw new UnsupportedOperationException("xml export is not yet supported for: " + this.getClass() + " with toString: " + this.toString(100));
    }

    protected Element getLocationElement(Document doc) {
        Location loc = this.getLocation();
        Element e = doc.createElement("location");
        Element ecol = doc.createElement("column");
        Element eline = doc.createElement("line");
        Element fname = doc.createElement("filename");
        Element bl = doc.createElement("begin");
        Element el = doc.createElement("end");
        Element bc = doc.createElement("begin");
        Element ec = doc.createElement("end");
        bc.appendChild(doc.createTextNode(Integer.toString(loc.beginColumn())));
        ec.appendChild(doc.createTextNode(Integer.toString(loc.endColumn())));
        bl.appendChild(doc.createTextNode(Integer.toString(loc.beginLine())));
        el.appendChild(doc.createTextNode(Integer.toString(loc.endLine())));
        fname.appendChild(doc.createTextNode(this.stn.getFilename()));
        ecol.appendChild(bc);
        ecol.appendChild(ec);
        eline.appendChild(bl);
        eline.appendChild(el);
        e.appendChild(ecol);
        e.appendChild(eline);
        e.appendChild(fname);
        return e;
    }

    protected Element appendElement(Document doc, String el, Element e2) {
        Element e = doc.createElement(el);
        e.appendChild(e2);
        return e;
    }

    protected Element appendText(Document doc, String el, String txt) {
        Element e = doc.createElement(el);
        Text n = doc.createTextNode(txt);
        e.appendChild(n);
        return e;
    }

    @Override
    public Element export(Document doc, SymbolContext context) {
        try {
            Element e = this.getSemanticElement(doc, context);
            try {
                Element loc = this.getLocationElement(doc);
                e.insertBefore(loc, e.getFirstChild());
            }
            catch (UnsupportedOperationException uoe) {
                uoe.printStackTrace();
                throw uoe;
            }
            catch (RuntimeException ee) {
                // empty catch block
            }
            return e;
        }
        catch (RuntimeException ee) {
            System.err.println("failed for node.toString(): " + this.toString() + "\n with error ");
            ee.printStackTrace();
            throw ee;
        }
    }
}

