/*
 * Decompiled with CFR 0.152.
 */
package pcal;

import java.util.Vector;
import pcal.AST;
import pcal.PcalDebug;
import pcal.TLAExpr;
import pcal.exception.PcalSymTabException;

public class PcalSymTab {
    public Vector symtab = new Vector();
    public Vector procs;
    public Vector processes;
    public Vector disambiguateReport = new Vector();
    public String errorReport = "";
    public String iPC = null;
    public static final int num_vtypes = 7;
    public static final int GLOBAL = 0;
    public static final int LABEL = 1;
    public static final int PROCEDURE = 2;
    public static final int PROCESS = 3;
    public static final int PROCESSVAR = 4;
    public static final int PROCEDUREVAR = 5;
    public static final int PARAMETER = 6;
    private static String[] typePrefix = new String[]{"", "", "", "", "", "", ""};
    public static String[] vtypeName = new String[]{"Global variable", "Label", "Procedure", "Process", "Process variable", "Procedure variable", "Parameter"};

    public PcalSymTab(AST ast) throws PcalSymTabException {
        this.procs = new Vector();
        this.processes = new Vector();
        this.InsertSym(0, "pc", "", "", 0, 0);
        this.ExtractSym(ast, "");
        if (this.errorReport.length() > 0) {
            throw new PcalSymTabException(this.errorReport);
        }
    }

    public boolean InsertSym(int type, String id, String context, String cType, int line, int col) {
        if (type == 5 || type == 4 || type == 6) {
            int i = this.FindSym(0, id, "");
            if (i < this.symtab.size()) {
                return false;
            }
            i = this.FindSym(id, context);
            if (i < this.symtab.size()) {
                return false;
            }
        } else {
            int i = this.FindSym(type, id, context);
            if (i < this.symtab.size()) {
                return false;
            }
        }
        SymTabEntry se = new SymTabEntry(type, id, context, cType, line, col);
        this.symtab.addElement(se);
        return true;
    }

    public boolean InsertProc(AST.Procedure proc) {
        int i = this.FindProc(proc.name);
        if (i < this.procs.size()) {
            return false;
        }
        ProcedureEntry pe = new ProcedureEntry(proc);
        this.procs.addElement(pe);
        return true;
    }

    public boolean InsertProcess(AST.Process p) {
        int i = this.FindProcess(p.name);
        if (i < this.processes.size()) {
            return false;
        }
        ProcessEntry pe = new ProcessEntry(p);
        this.processes.addElement(pe);
        return true;
    }

    public int FindSym(int type, String id, String context) {
        int i;
        for (i = 0; i < this.symtab.size(); ++i) {
            SymTabEntry se = (SymTabEntry)this.symtab.elementAt(i);
            if (!se.id.equals(id) || !se.context.equals(context) || se.type != type) continue;
            return i;
        }
        return i;
    }

    public int FindSym(String id, String context) {
        int i;
        for (i = 0; i < this.symtab.size(); ++i) {
            SymTabEntry se = (SymTabEntry)this.symtab.elementAt(i);
            if (!se.id.equals(id) || !se.context.equals(context)) continue;
            return i;
        }
        return i;
    }

    public int FindProc(String id) {
        int i;
        for (i = 0; i < this.procs.size(); ++i) {
            ProcedureEntry pe = (ProcedureEntry)this.procs.elementAt(i);
            if (!pe.name.equals(id)) continue;
            return i;
        }
        return i;
    }

    public int FindProcess(String id) {
        int i;
        for (i = 0; i < this.processes.size(); ++i) {
            ProcessEntry pe = (ProcessEntry)this.processes.elementAt(i);
            if (!pe.name.equals(id)) continue;
            return i;
        }
        return i;
    }

    public String UseThis(int type, String id, String context) {
        int i = this.FindSym(type, id, context);
        if (i == this.symtab.size()) {
            return id;
        }
        return ((SymTabEntry)this.symtab.elementAt((int)i)).useThis;
    }

    public String UseThisLab(String id, String context) {
        return this.UseThis(1, id, context);
    }

    public String UseThisVar(String id, String context) {
        SymTabEntry se = null;
        int i = this.FindSym(id, context);
        if (i == this.symtab.size()) {
            return id;
        }
        se = (SymTabEntry)this.symtab.elementAt(i);
        if (se.type == 0 || se.type == 4 || se.type == 5 || se.type == 6) {
            return se.useThis;
        }
        i = this.FindSym(id, "");
        if (se.type == 0) {
            return se.useThis;
        }
        return id;
    }

    public String UseThis(String id, String context) {
        int i;
        for (i = 0; i < this.symtab.size(); ++i) {
            SymTabEntry se = (SymTabEntry)this.symtab.elementAt(i);
            if (se.id.equals(id) && se.context.equals(context) && (se.type == 0 || se.type == 4 || se.type == 5 || se.type == 6)) break;
        }
        if (i == this.symtab.size()) {
            return id;
        }
        return ((SymTabEntry)this.symtab.elementAt((int)i)).useThis;
    }

    private boolean Ambiguous(String id) {
        boolean found = false;
        for (int i = 0; i < this.symtab.size(); ++i) {
            SymTabEntry se = (SymTabEntry)this.symtab.elementAt(i);
            if (!se.useThis.equals(id)) continue;
            if (!found) {
                found = true;
                continue;
            }
            return true;
        }
        return false;
    }

    public void Disambiguate() {
        for (int vtype = 0; vtype <= 7; ++vtype) {
            for (int i = 0; i < this.symtab.size(); ++i) {
                SymTabEntry se = (SymTabEntry)this.symtab.elementAt(i);
                if (se.type != vtype) continue;
                se.useThis = typePrefix[vtype] + se.id;
                int suffixLength = 0;
                while (vtype > 0 && this.Ambiguous(se.useThis)) {
                    if (++suffixLength == 1) {
                        se.useThis = se.useThis + "_";
                        continue;
                    }
                    if (suffixLength > se.context.length() + 1) {
                        se.useThis = se.useThis + vtype;
                        continue;
                    }
                    se.useThis = se.useThis + se.context.charAt(suffixLength - 2);
                }
                if (se.id.equals(se.useThis)) continue;
                this.disambiguateReport.addElement("\\* " + vtypeName[se.type] + " " + se.id + (se.context.length() == 0 ? "" : " of " + se.cType + " " + se.context) + " at line " + se.line + " col " + se.col + " changed to " + se.useThis);
            }
        }
    }

    public String toString() {
        String result = "[";
        for (int i = 0; i < this.symtab.size(); ++i) {
            SymTabEntry se = (SymTabEntry)this.symtab.elementAt(i);
            if (i > 0) {
                result = result + ", ";
            }
            result = result + vtypeName[se.type] + " " + se.context + ':' + se.id + " line " + se.line + " col " + se.col + " (" + se.useThis + ")";
        }
        return result + "]";
    }

    private void ExtractSym(AST ast, String context) {
        if (ast.getClass().equals(AST.UniprocessObj.getClass())) {
            this.ExtractUniprocess((AST.Uniprocess)ast, context);
        } else if (ast.getClass().equals(AST.MultiprocessObj.getClass())) {
            this.ExtractMultiprocess((AST.Multiprocess)ast, context);
        } else {
            PcalDebug.ReportBug("Unexpected AST type.");
        }
    }

    private void ExtractStmt(AST ast, String context, String cType) {
        if (ast.getClass().equals(AST.WhileObj.getClass())) {
            this.ExtractWhile((AST.While)ast, context, cType);
        } else if (ast.getClass().equals(AST.AssignObj.getClass())) {
            this.ExtractAssign((AST.Assign)ast, context, cType);
        } else if (ast.getClass().equals(AST.IfObj.getClass())) {
            this.ExtractIf((AST.If)ast, context, cType);
        } else if (ast.getClass().equals(AST.WithObj.getClass())) {
            this.ExtractWith((AST.With)ast, context, cType);
        } else if (ast.getClass().equals(AST.WhenObj.getClass())) {
            this.ExtractWhen((AST.When)ast, context, cType);
        } else if (ast.getClass().equals(AST.PrintSObj.getClass())) {
            this.ExtractPrintS((AST.PrintS)ast, context, cType);
        } else if (ast.getClass().equals(AST.AssertObj.getClass())) {
            this.ExtractAssert((AST.Assert)ast, context, cType);
        } else if (ast.getClass().equals(AST.SkipObj.getClass())) {
            this.ExtractSkip((AST.Skip)ast, context, cType);
        } else if (ast.getClass().equals(AST.LabelIfObj.getClass())) {
            this.ExtractLabelIf((AST.LabelIf)ast, context, cType);
        } else if (ast.getClass().equals(AST.CallObj.getClass())) {
            this.ExtractCall((AST.Call)ast, context, cType);
        } else if (ast.getClass().equals(AST.ReturnObj.getClass())) {
            this.ExtractReturn((AST.Return)ast, context, cType);
        } else if (ast.getClass().equals(AST.CallReturnObj.getClass())) {
            this.ExtractCallReturn((AST.CallReturn)ast, context, cType);
        } else if (ast.getClass().equals(AST.GotoObj.getClass())) {
            this.ExtractGoto((AST.Goto)ast, context, cType);
        } else if (ast.getClass().equals(AST.EitherObj.getClass())) {
            this.ExtractEither((AST.Either)ast, context, cType);
        } else if (ast.getClass().equals(AST.LabelEitherObj.getClass())) {
            this.ExtractLabelEither((AST.LabelEither)ast, context, cType);
        } else {
            PcalDebug.ReportBug("Unexpected AST type " + ast.toString());
        }
    }

    private void ExtractUniprocess(AST.Uniprocess ast, String context) {
        int i;
        if (ast.prcds.size() > 0) {
            this.InsertSym(0, "stack", "", "", 0, 0);
        }
        for (i = 0; i < ast.decls.size(); ++i) {
            this.ExtractVarDecl((AST.VarDecl)ast.decls.elementAt(i), "");
        }
        for (i = 0; i < ast.prcds.size(); ++i) {
            this.ExtractProcedure((AST.Procedure)ast.prcds.elementAt(i), "");
        }
        if (ast.body.size() > 0) {
            AST.LabeledStmt ls = (AST.LabeledStmt)ast.body.elementAt(0);
            this.iPC = ls.label;
        }
        for (int i2 = 0; i2 < ast.body.size(); ++i2) {
            this.ExtractLabeledStmt((AST.LabeledStmt)ast.body.elementAt(i2), "", "");
        }
    }

    private void ExtractMultiprocess(AST.Multiprocess ast, String context) {
        int i;
        if (ast.prcds.size() > 0) {
            this.InsertSym(0, "stack", "", "", 0, 0);
        }
        for (i = 0; i < ast.decls.size(); ++i) {
            this.ExtractVarDecl((AST.VarDecl)ast.decls.elementAt(i), "");
        }
        for (i = 0; i < ast.prcds.size(); ++i) {
            this.ExtractProcedure((AST.Procedure)ast.prcds.elementAt(i), "");
        }
        for (i = 0; i < ast.procs.size(); ++i) {
            this.ExtractProcess((AST.Process)ast.procs.elementAt(i), "");
        }
    }

    private void ExtractProcedure(AST.Procedure ast, String context) {
        int i;
        if (!this.InsertProc(ast)) {
            this.errorReport = this.errorReport + "\nProcedure " + ast.name + " redefined at line " + ast.line + ", column " + ast.col;
        }
        boolean b = this.InsertSym(2, ast.name, context, "procedure", ast.line, ast.col);
        for (i = 0; i < ast.decls.size(); ++i) {
            this.ExtractPVarDecl((AST.PVarDecl)ast.decls.elementAt(i), ast.name);
        }
        for (i = 0; i < ast.params.size(); ++i) {
            this.ExtractParamDecl((AST.PVarDecl)ast.params.elementAt(i), ast.name);
        }
        for (i = 0; i < ast.body.size(); ++i) {
            this.ExtractLabeledStmt((AST.LabeledStmt)ast.body.elementAt(i), ast.name, "procedure");
        }
    }

    private void ExtractProcess(AST.Process ast, String context) {
        int i;
        if (!this.InsertProcess(ast)) {
            this.errorReport = this.errorReport + "\nProcess " + ast.name + " redefined at line " + ast.line + ", column " + ast.col;
        }
        boolean b = this.InsertSym(3, ast.name, context, "process", ast.line, ast.col);
        for (i = 0; i < ast.decls.size(); ++i) {
            this.ExtractVarDecl((AST.VarDecl)ast.decls.elementAt(i), ast.name);
        }
        for (i = 0; i < ast.body.size(); ++i) {
            this.ExtractLabeledStmt((AST.LabeledStmt)ast.body.elementAt(i), ast.name, "process");
        }
    }

    private void ExtractVarDecl(AST.VarDecl ast, String context) {
        int vtype;
        int n = vtype = context == "" ? 0 : 4;
        if (!this.InsertSym(vtype, ast.var, context, "process", ast.line, ast.col)) {
            this.errorReport = this.errorReport + "\n" + vtypeName[vtype] + " " + ast.var + " redefined at line " + ast.line + ", column " + ast.col;
        }
    }

    private void ExtractPVarDecl(AST.PVarDecl ast, String context) {
        if (!this.InsertSym(5, ast.var, context, "procedure", ast.line, ast.col)) {
            this.errorReport = this.errorReport + "\nProcedure variable " + ast.var + " redefined at line " + ast.line + ", column " + ast.col;
        }
    }

    private void ExtractParamDecl(AST.PVarDecl ast, String context) {
        if (!this.InsertSym(6, ast.var, context, "procedure", ast.line, ast.col)) {
            this.errorReport = this.errorReport + "\nParameter " + ast.var + " redefined at line " + ast.line + ", column " + ast.col;
        }
    }

    private void ExtractLabeledStmt(AST.LabeledStmt ast, String context, String cType) {
        if (!this.InsertSym(1, ast.label, context, cType, ast.line, ast.col)) {
            this.errorReport = this.errorReport + "\nLabel " + ast.label + " redefined at line " + ast.line + ", column " + ast.col;
        }
        for (int i = 0; i < ast.stmts.size(); ++i) {
            this.ExtractStmt((AST)ast.stmts.elementAt(i), context, cType);
        }
    }

    private void ExtractWhile(AST.While ast, String context, String cType) {
        int i;
        for (i = 0; i < ast.unlabDo.size(); ++i) {
            this.ExtractStmt((AST)ast.unlabDo.elementAt(i), context, cType);
        }
        for (i = 0; i < ast.labDo.size(); ++i) {
            this.ExtractLabeledStmt((AST.LabeledStmt)ast.labDo.elementAt(i), context, cType);
        }
    }

    private void ExtractAssign(AST.Assign ast, String context, String cType) {
    }

    private void ExtractIf(AST.If ast, String context, String cType) {
        int i;
        for (i = 0; i < ast.Then.size(); ++i) {
            this.ExtractStmt((AST)ast.Then.elementAt(i), context, cType);
        }
        for (i = 0; i < ast.Else.size(); ++i) {
            this.ExtractStmt((AST)ast.Else.elementAt(i), context, cType);
        }
    }

    private void ExtractWith(AST.With ast, String context, String cType) {
        for (int i = 0; i < ast.Do.size(); ++i) {
            this.ExtractStmt((AST)ast.Do.elementAt(i), context, cType);
        }
    }

    private void ExtractWhen(AST.When ast, String context, String cType) {
    }

    private void ExtractPrintS(AST.PrintS ast, String context, String cType) {
    }

    private void ExtractAssert(AST.Assert ast, String context, String cType) {
    }

    private void ExtractSkip(AST.Skip ast, String context, String cType) {
    }

    private void ExtractLabelIf(AST.LabelIf ast, String context, String cType) {
        int i;
        for (i = 0; i < ast.unlabThen.size(); ++i) {
            this.ExtractStmt((AST)ast.unlabThen.elementAt(i), context, cType);
        }
        for (i = 0; i < ast.labThen.size(); ++i) {
            this.ExtractLabeledStmt((AST.LabeledStmt)ast.labThen.elementAt(i), context, cType);
        }
        for (i = 0; i < ast.unlabElse.size(); ++i) {
            this.ExtractStmt((AST)ast.unlabElse.elementAt(i), context, cType);
        }
        for (i = 0; i < ast.labElse.size(); ++i) {
            this.ExtractLabeledStmt((AST.LabeledStmt)ast.labElse.elementAt(i), context, cType);
        }
    }

    private void ExtractCall(AST.Call ast, String context, String cType) {
    }

    private void ExtractReturn(AST.Return ast, String context, String cType) {
    }

    private void ExtractCallReturn(AST.CallReturn ast, String context, String cType) {
    }

    private void ExtractGoto(AST.Goto ast, String context, String cType) {
    }

    private void ExtractEither(AST.Either ast, String context, String cType) {
        for (int i = 0; i < ast.ors.size(); ++i) {
            Vector orClause = (Vector)ast.ors.elementAt(i);
            for (int j = 0; j < orClause.size(); ++j) {
                this.ExtractStmt((AST)orClause.elementAt(j), context, cType);
            }
        }
    }

    private void ExtractLabelEither(AST.LabelEither ast, String context, String cType) {
        for (int i = 0; i < ast.clauses.size(); ++i) {
            int j;
            AST.Clause orClause = (AST.Clause)ast.clauses.elementAt(i);
            for (j = 0; j < orClause.unlabOr.size(); ++j) {
                this.ExtractStmt((AST)orClause.unlabOr.elementAt(j), context, cType);
            }
            for (j = 0; j < orClause.labOr.size(); ++j) {
                this.ExtractLabeledStmt((AST.LabeledStmt)orClause.labOr.elementAt(j), context, cType);
            }
        }
    }

    public void CheckForDefaultInitValue() throws PcalSymTabException {
        String errors = "";
        for (int i = 0; i < this.symtab.size(); ++i) {
            SymTabEntry se = (SymTabEntry)this.symtab.elementAt(i);
            if (!se.id.equals("defaultInitValue")) continue;
            errors = errors.equals("") ? "Cannot use `defaultInitValue' as " : errors + " or ";
            errors = errors + vtypeName[se.type] + " name";
        }
        if (!errors.equals("")) {
            throw new PcalSymTabException(errors);
        }
    }

    public class ProcessEntry {
        public String name;
        public boolean isEq;
        public TLAExpr id;
        public Vector decls;
        public String iPC;
        public AST.Process ast;

        public ProcessEntry(AST.Process p) {
            this.name = p.name;
            this.isEq = p.isEq;
            this.id = p.id;
            this.decls = p.decls;
            this.ast = p;
            if (p.body.size() == 0) {
                this.iPC = null;
            } else {
                AST.LabeledStmt ls = (AST.LabeledStmt)p.body.elementAt(0);
                this.iPC = ls.label;
            }
        }
    }

    public class ProcedureEntry {
        public String name;
        public Vector params;
        public Vector decls;
        public String iPC;
        public AST.Procedure ast;

        public ProcedureEntry(AST.Procedure p) {
            this.name = p.name;
            this.params = p.params;
            this.decls = p.decls;
            this.ast = p;
            if (p.body.size() == 0) {
                this.iPC = null;
            } else {
                AST.LabeledStmt ls = (AST.LabeledStmt)p.body.elementAt(0);
                this.iPC = ls.label;
            }
        }
    }

    public class SymTabEntry {
        public int type;
        public String id;
        public String context;
        public String cType;
        public int line;
        public int col;
        public String useThis;

        public SymTabEntry(int type, String id, String context, String cType, int line, int col) {
            this.type = type;
            this.id = id;
            this.context = context;
            this.cType = cType;
            this.line = line;
            this.col = col;
            this.useThis = id;
        }

        public String toString() {
            return "[id: " + this.id + ", usethis: " + this.useThis + ", line: " + this.line + ", col:" + this.col + ", type: " + this.type + ", context: " + this.context + "]";
        }
    }
}

