/*
 * Decompiled with CFR 0.152.
 */
package pcal;

import java.util.Enumeration;
import java.util.Hashtable;
import tla2tex.Misc;
import tla2tex.Symbol;

public final class PcalBuiltInSymbols {
    private static Hashtable builtInHashTable = new Hashtable(200);
    private static Hashtable prefixHashTable = new Hashtable(700);
    private static Hashtable stringCharTable = new Hashtable(100);
    private static String nullString = "";

    public static void Initialize() {
        PcalBuiltInSymbols.buildHashTable();
        PcalBuiltInSymbols.buildPrefixHashTable();
        PcalBuiltInSymbols.buildStringCharTable();
    }

    public static boolean IsBuiltInSymbol(String str) {
        return null != PcalBuiltInSymbols.GetBuiltInSymbol(str);
    }

    public static Symbol GetBuiltInSymbol(String str) {
        return (Symbol)builtInHashTable.get(str);
    }

    public static boolean IsBuiltInPrefix(String str) {
        return prefixHashTable.containsKey(str);
    }

    public static boolean IsStringChar(char ch) {
        return stringCharTable.containsKey("" + ch);
    }

    private static void buildStringCharTable() {
        String legalChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ ~!@#$%^&*()_-+={}[]|:;<,>.?/`'0123456789";
        for (int n = 0; n < legalChars.length(); ++n) {
            stringCharTable.put("" + legalChars.charAt(n), nullString);
        }
    }

    private static void add(String tla, String tex, int stype, int atype) {
        builtInHashTable.put(tla, new Symbol(tla, tex, stype, atype));
    }

    private static void buildHashTable() {
        PcalBuiltInSymbols.add("_", "\\_", 7, 0);
        PcalBuiltInSymbols.add("ASSUME", "{\\ASSUME}", 7, 0);
        PcalBuiltInSymbols.add("ASSUMPTION", "{\\ASSUMPTION}", 7, 0);
        PcalBuiltInSymbols.add("AXIOM", "{\\AXIOM}", 7, 0);
        PcalBuiltInSymbols.add("BOOLEAN", "{\\BOOLEAN}", 7, 0);
        PcalBuiltInSymbols.add("CASE", "{\\CASE}", 7, 0);
        PcalBuiltInSymbols.add("CONSTANT", "{\\CONSTANT}", 7, 0);
        PcalBuiltInSymbols.add("CONSTANTS", "{\\CONSTANTS}", 7, 0);
        PcalBuiltInSymbols.add("EXCEPT", "{\\EXCEPT}", 7, 0);
        PcalBuiltInSymbols.add("EXTENDS", "{\\EXTENDS}", 7, 0);
        PcalBuiltInSymbols.add("FALSE", "{\\FALSE}", 7, 0);
        PcalBuiltInSymbols.add("IF", "{\\IF}", 7, 0);
        PcalBuiltInSymbols.add("INSTANCE", "{\\INSTANCE}", 7, 0);
        PcalBuiltInSymbols.add("LOCAL", "{\\LOCAL}", 7, 0);
        PcalBuiltInSymbols.add("MODULE", "{\\MODULE}", 7, 0);
        PcalBuiltInSymbols.add("OTHER", "{\\OTHER}", 7, 0);
        PcalBuiltInSymbols.add("STRING", "{\\STRING}", 7, 0);
        PcalBuiltInSymbols.add("THEOREM", "{\\THEOREM}", 7, 0);
        PcalBuiltInSymbols.add("TRUE", "{\\TRUE}", 7, 0);
        PcalBuiltInSymbols.add("VARIABLE", "{\\VARIABLE}", 7, 0);
        PcalBuiltInSymbols.add("VARIABLES", "{\\VARIABLES}", 7, 0);
        PcalBuiltInSymbols.add("WITH", "{\\WITH}", 7, 0);
        PcalBuiltInSymbols.add("WF_", "{\\WF}", 6, 0);
        PcalBuiltInSymbols.add("SF_", "{\\SF}", 6, 0);
        PcalBuiltInSymbols.add(">>_", "{\\rangle}", 5, 0);
        PcalBuiltInSymbols.add("]_", "]", 5, 0);
        PcalBuiltInSymbols.add("(", "(", 4, 0);
        PcalBuiltInSymbols.add("[", "[", 4, 0);
        PcalBuiltInSymbols.add("{", "\\{", 4, 0);
        PcalBuiltInSymbols.add("<<", "{\\langle}", 4, 0);
        PcalBuiltInSymbols.add(")", ")", 5, 0);
        PcalBuiltInSymbols.add("}", "\\}", 5, 0);
        PcalBuiltInSymbols.add("]", "]", 5, 0);
        PcalBuiltInSymbols.add(">>", "{\\rangle}", 5, 0);
        PcalBuiltInSymbols.add("\\A", "\\A\\,", 2, 0);
        PcalBuiltInSymbols.add("\\forall", "\\forall\\,", 2, 0);
        PcalBuiltInSymbols.add("\\E", "\\E\\,", 2, 0);
        PcalBuiltInSymbols.add("\\exists", "\\exists\\,", 2, 0);
        PcalBuiltInSymbols.add("\\AA", "{\\AA}", 2, 0);
        PcalBuiltInSymbols.add("\\EE", "{\\EE}", 2, 0);
        PcalBuiltInSymbols.add("~", "{\\lnot}", 2, 0);
        PcalBuiltInSymbols.add("\\lnot", "{\\lnot}", 2, 0);
        PcalBuiltInSymbols.add("\\neg", "{\\neg}", 2, 0);
        PcalBuiltInSymbols.add("<>", "{\\Diamond}", 2, 0);
        PcalBuiltInSymbols.add("CHOOSE", "{\\CHOOSE}", 2, 0);
        PcalBuiltInSymbols.add("ENABLED", "{\\ENABLED}", 2, 0);
        PcalBuiltInSymbols.add("UNCHANGED", "{\\UNCHANGED}", 2, 0);
        PcalBuiltInSymbols.add("SUBSET", "{\\SUBSET}", 2, 0);
        PcalBuiltInSymbols.add("UNION", "{\\UNION}", 2, 0);
        PcalBuiltInSymbols.add("DOMAIN", "{\\DOMAIN}", 2, 0);
        PcalBuiltInSymbols.add("'", "\\.{'}", 3, 0);
        PcalBuiltInSymbols.add("^+", "\\.{\\mbox{}^+}", 3, 0);
        PcalBuiltInSymbols.add("^*", "\\.{\\mbox{}^*}", 3, 0);
        PcalBuiltInSymbols.add("^#", "\\.{\\mbox{}^{\\#}}", 3, 0);
        PcalBuiltInSymbols.add("=>", "\\.{\\implies}", 1, 1);
        PcalBuiltInSymbols.add("\\cdot", "\\.{\\cdot}", 1, 2);
        PcalBuiltInSymbols.add("<=>", "\\.{\\equiv}", 1, 3);
        PcalBuiltInSymbols.add("\\equiv", "\\.{\\equiv}", 1, 4);
        PcalBuiltInSymbols.add("~>", "\\.{\\leadsto}", 1, 5);
        PcalBuiltInSymbols.add("-+->", "\\.{\\whileop}", 1, 6);
        PcalBuiltInSymbols.add("\\subseteq", "\\.{\\subseteq}", 1, 7);
        PcalBuiltInSymbols.add("\\subset", "\\.{\\subset}", 1, 7);
        PcalBuiltInSymbols.add("\\supset", "\\.{\\supset}", 1, 7);
        PcalBuiltInSymbols.add("\\supseteq", "\\.{\\supseteq}", 1, 7);
        PcalBuiltInSymbols.add("\\ll", "\\.{\\ll}", 1, 8);
        PcalBuiltInSymbols.add("\\gg", "\\.{\\gg}", 1, 8);
        PcalBuiltInSymbols.add("\\", "\\.{\\,\\backslash\\,}", 1, 9);
        PcalBuiltInSymbols.add("\\cap", "\\.{\\cap}", 1, 10);
        PcalBuiltInSymbols.add("\\intersect", "\\.{\\cap}", 1, 11);
        PcalBuiltInSymbols.add("\\cup", "\\.{\\cup}", 1, 12);
        PcalBuiltInSymbols.add("\\union", "\\.{\\cup}", 1, 13);
        PcalBuiltInSymbols.add("/\\", "\\.{\\land}", 1, 14);
        PcalBuiltInSymbols.add("\\/", "\\.{\\lor}", 1, 15);
        PcalBuiltInSymbols.add("\\land", "\\.{\\land}", 1, 16);
        PcalBuiltInSymbols.add("\\lor", "\\.{\\lor}", 1, 17);
        PcalBuiltInSymbols.add("\\X", "\\.{\\times}", 1, 18);
        PcalBuiltInSymbols.add("-", "\\.{-}", 1, 19);
        PcalBuiltInSymbols.add("+", "\\.{+}", 1, 19);
        PcalBuiltInSymbols.add("*", "\\.{*}", 1, 20);
        PcalBuiltInSymbols.add("/", "\\.{/}", 1, 21);
        PcalBuiltInSymbols.add("^", "\\.{\\ct}", 1, 22);
        PcalBuiltInSymbols.add("|", "\\.{\\,|\\,}", 1, 23);
        PcalBuiltInSymbols.add("||", "\\.{\\,||\\,}", 1, 24);
        PcalBuiltInSymbols.add("&", "\\.{\\,\\&\\,}", 1, 25);
        PcalBuiltInSymbols.add("&&", "\\.{\\,\\&\\&\\,}", 1, 26);
        PcalBuiltInSymbols.add("++", "\\.{\\pp}", 1, 27);
        PcalBuiltInSymbols.add("--", "\\.{\\mm}", 1, 27);
        PcalBuiltInSymbols.add("**", "\\.{\\stst}", 1, 28);
        PcalBuiltInSymbols.add("//", "\\.{\\slsl}", 1, 29);
        PcalBuiltInSymbols.add("^^", "\\.{\\ct\\ct}", 1, 30);
        PcalBuiltInSymbols.add("|-", "\\.{\\vdash}", 1, 31);
        PcalBuiltInSymbols.add("|=", "\\.{\\models}", 1, 32);
        PcalBuiltInSymbols.add("-|", "\\.{\\dashv}", 1, 33);
        PcalBuiltInSymbols.add("=|", "\\.{\\eqdash}", 1, 34);
        PcalBuiltInSymbols.add("<:", "\\.{\\ltcolon}", 1, 35);
        PcalBuiltInSymbols.add(":>", "\\.{\\colongt}", 1, 35);
        PcalBuiltInSymbols.add(":=", "\\.{:=}", 1, 35);
        PcalBuiltInSymbols.add("::=", "\\.{::=}", 1, 36);
        PcalBuiltInSymbols.add("(+)", "\\.{\\oplus}", 1, 37);
        PcalBuiltInSymbols.add("(-)", "\\.{\\ominus}", 1, 37);
        PcalBuiltInSymbols.add("\\oplus", "\\.{\\oplus}", 1, 37);
        PcalBuiltInSymbols.add("\\ominus", "\\.{\\ominus}", 1, 37);
        PcalBuiltInSymbols.add("(.)", "\\.{\\odot}", 1, 38);
        PcalBuiltInSymbols.add("\\odot", "\\.{\\odot}", 1, 38);
        PcalBuiltInSymbols.add("(/)", "\\.{\\oslash}", 1, 39);
        PcalBuiltInSymbols.add("\\oslash", "\\.{\\oslash}", 1, 39);
        PcalBuiltInSymbols.add("(\\X)", "\\.{\\otimes}", 1, 40);
        PcalBuiltInSymbols.add("\\otimes", "\\.{\\otimes}", 1, 40);
        PcalBuiltInSymbols.add("\\uplus", "\\.{\\uplus}", 1, 41);
        PcalBuiltInSymbols.add("\\sqcap", "\\.{\\sqcap}", 1, 42);
        PcalBuiltInSymbols.add("\\sqcup", "\\.{\\sqcup}", 1, 43);
        PcalBuiltInSymbols.add("\\div", "\\.{\\div}", 1, 44);
        PcalBuiltInSymbols.add("\\star", "\\.{\\star}", 1, 45);
        PcalBuiltInSymbols.add("\\o", "\\.{\\circ}", 1, 46);
        PcalBuiltInSymbols.add("\\circ", "\\.{\\circ}", 1, 46);
        PcalBuiltInSymbols.add("\\bigcirc", "\\.{\\bigcirc}", 1, 47);
        PcalBuiltInSymbols.add("\\bullet", "\\.{\\bullet}", 1, 48);
        PcalBuiltInSymbols.add("\\in", "\\.{\\in}", 1, 49);
        PcalBuiltInSymbols.add("\\notin", "\\.{\\notin}", 1, 49);
        PcalBuiltInSymbols.add("=", "\\.{=}", 1, 49);
        PcalBuiltInSymbols.add("#", "\\.{\\neq}", 1, 49);
        PcalBuiltInSymbols.add("/=", "\\.{\\neq}", 1, 49);
        PcalBuiltInSymbols.add("<", "\\.{<}", 1, 49);
        PcalBuiltInSymbols.add(">", "\\.{>}", 1, 49);
        PcalBuiltInSymbols.add("=<", "\\.{\\leq}", 1, 49);
        PcalBuiltInSymbols.add("<=", "\\.{\\leq}", 1, 49);
        PcalBuiltInSymbols.add(">=", "\\.{\\geq}", 1, 49);
        PcalBuiltInSymbols.add("\\prec", "\\.{\\prec}", 1, 49);
        PcalBuiltInSymbols.add("\\succ", "\\.{\\succ}", 1, 49);
        PcalBuiltInSymbols.add("\\preceq", "\\.{\\preceq}", 1, 49);
        PcalBuiltInSymbols.add("\\succeq", "\\.{\\succeq}", 1, 49);
        PcalBuiltInSymbols.add("\\sim", "\\.{\\sim}", 1, 49);
        PcalBuiltInSymbols.add("\\simeq", "\\.{\\simeq}", 1, 49);
        PcalBuiltInSymbols.add("\\approx", "\\.{\\approx}", 1, 49);
        PcalBuiltInSymbols.add("\\doteq", "\\.{\\doteq}", 1, 49);
        PcalBuiltInSymbols.add("\\asymp", "\\.{\\asymp}", 1, 50);
        PcalBuiltInSymbols.add("\\sqsubset", "\\.{\\sqsubset}", 1, 51);
        PcalBuiltInSymbols.add("\\sqsupset", "\\.{\\sqsupset}", 1, 51);
        PcalBuiltInSymbols.add("\\sqsubseteq", "\\.{\\sqsubseteq}", 1, 51);
        PcalBuiltInSymbols.add("\\sqsupseteq", "\\.{\\sqsupseteq}", 1, 51);
        PcalBuiltInSymbols.add("\\propto", "\\.{\\propto}", 1, 52);
        PcalBuiltInSymbols.add(":", "\\.{:}", 8, 53);
        PcalBuiltInSymbols.add("->", "\\.{\\rightarrow}", 1, 54);
        PcalBuiltInSymbols.add("|->", "\\.{\\mapsto}", 1, 55);
        PcalBuiltInSymbols.add("<-", "\\.{\\leftarrow}", 1, 56);
        PcalBuiltInSymbols.add("==", "\\.{\\defeq}", 1, 57);
        PcalBuiltInSymbols.add("ELSE", "\\.{\\ELSE}", 2, 58);
        PcalBuiltInSymbols.add("THEN", "\\.{\\THEN}", 2, 58);
        PcalBuiltInSymbols.add("LET", "\\.{\\LET}", 2, 59);
        PcalBuiltInSymbols.add("IN", "\\.{\\IN}", 2, 59);
        PcalBuiltInSymbols.add("[]", "{\\Box}", 2, 60);
        PcalBuiltInSymbols.add("..", "\\.{\\dotdot}", 1, 0);
        PcalBuiltInSymbols.add("...", "\\.{\\dots}", 1, 0);
        PcalBuiltInSymbols.add("$", "\\.{\\,\\$\\,}", 1, 0);
        PcalBuiltInSymbols.add("$$", "\\.{\\,\\$\\$\\,}", 1, 0);
        PcalBuiltInSymbols.add("?", "\\.{?}", 1, 0);
        PcalBuiltInSymbols.add("??", "\\.{\\,??\\,}", 1, 0);
        PcalBuiltInSymbols.add("%", "\\.{\\%}", 1, 0);
        PcalBuiltInSymbols.add("%%", "\\.{\\,\\%\\%\\,}", 1, 0);
        PcalBuiltInSymbols.add("##", "\\.{\\,\\#\\#\\,}", 1, 0);
        PcalBuiltInSymbols.add("@@", "\\.{\\,@@\\,}", 1, 0);
        PcalBuiltInSymbols.add("!!", "\\.{!!}", 1, 0);
        PcalBuiltInSymbols.add("\\times", "\\.{\\times}", 1, 0);
        PcalBuiltInSymbols.add("\\leq", "\\.{\\leq}", 1, 0);
        PcalBuiltInSymbols.add("\\geq", "\\.{\\geq}", 1, 0);
        PcalBuiltInSymbols.add("\\mod", "\\.{\\%}", 1, 0);
        PcalBuiltInSymbols.add("\\wr", "\\.{\\wr}", 1, 0);
        PcalBuiltInSymbols.add("\\cong", "\\.{\\cong}", 1, 0);
        PcalBuiltInSymbols.add("!", "!", 1, 0);
        PcalBuiltInSymbols.add(";", ";", 8, 0);
        PcalBuiltInSymbols.add(",", ",\\,", 8, 0);
        PcalBuiltInSymbols.add(".", ".", 8, 0);
        PcalBuiltInSymbols.add("-.", "\\.{-\\!.\\,}", 9, 0);
        PcalBuiltInSymbols.add("@", "@", 9, 0);
    }

    private static void buildPrefixHashTable() {
        Enumeration builtInEnum = builtInHashTable.keys();
        while (builtInEnum.hasMoreElements()) {
            String symbol = (String)builtInEnum.nextElement();
            if (Misc.IsLetter(symbol.charAt(0)) || symbol.length() > 1 && symbol.charAt(0) == '\\' && Misc.IsLetter(symbol.charAt(1))) continue;
            while (symbol.length() > 0) {
                prefixHashTable.put(symbol, nullString);
                symbol = symbol.substring(0, symbol.length() - 1);
            }
        }
    }
}

