/*
 * Decompiled with CFR 0.152.
 */
package pcal;

import java.util.Vector;
import pcal.AST;
import pcal.ParseAlgorithm;
import pcal.PcalDebug;
import pcal.PcalFixIDs;
import pcal.PcalSymTab;
import pcal.PcalTLAGen;
import pcal.PcalTranslate;
import pcal.exception.PcalFixIDException;
import pcal.exception.PcalSymTabException;
import pcal.exception.PcalTLAGenException;
import pcal.exception.PcalTranslateException;
import pcal.exception.RemoveNameConflictsException;

public class PCalTLAGenerator {
    private PcalSymTab st = null;
    private AST ast = null;

    public PCalTLAGenerator(AST ast) {
        this.ast = ast;
    }

    public void removeNameConflicts() throws RemoveNameConflictsException {
        try {
            this.st = new PcalSymTab(this.ast);
        }
        catch (PcalSymTabException e) {
            throw new RemoveNameConflictsException(e.getMessage());
        }
        this.st.Disambiguate();
        if (this.st.disambiguateReport.size() > 0) {
            PcalDebug.reportWarning("symbols were renamed.");
        }
        if (this.st.errorReport.length() > 0) {
            throw new RemoveNameConflictsException(this.st.errorReport);
        }
        try {
            PcalFixIDs.Fix(this.ast, this.st);
        }
        catch (PcalFixIDException e) {
            throw new RemoveNameConflictsException(e.getMessage());
        }
    }

    public Vector translate() throws RemoveNameConflictsException {
        Vector result = new Vector();
        AST xast = null;
        for (int i = 0; i < this.st.disambiguateReport.size(); ++i) {
            result.addElement(this.st.disambiguateReport.elementAt(i));
        }
        try {
            xast = PcalTranslate.Explode(this.ast, this.st);
        }
        catch (PcalTranslateException e) {
            throw new RemoveNameConflictsException(e);
        }
        try {
            PcalTLAGen tlaGenerator = new PcalTLAGen();
            result = tlaGenerator.generate(xast, this.st, result);
        }
        catch (PcalTLAGenException e) {
            throw new RemoveNameConflictsException(e);
        }
        try {
            if (ParseAlgorithm.hasDefaultInitialization) {
                this.st.CheckForDefaultInitValue();
            }
        }
        catch (PcalSymTabException e) {
            throw new RemoveNameConflictsException(e.getMessage());
        }
        return result;
    }
}

