/*
 * Decompiled with CFR 0.152.
 */
package de.prob.statespace;

import com.google.common.base.Joiner;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.inject.Inject;
import com.google.inject.Provider;
import de.prob.animator.IAnimator;
import de.prob.animator.command.AbstractCommand;
import de.prob.animator.command.CheckIfStateIdValidCommand;
import de.prob.animator.command.ComposedCommand;
import de.prob.animator.command.EvaluationCommand;
import de.prob.animator.command.FindTraceBetweenNodesCommand;
import de.prob.animator.command.FindValidStateCommand;
import de.prob.animator.command.FormulaTypecheckCommand;
import de.prob.animator.command.GetOperationByPredicateCommand;
import de.prob.animator.command.GetOpsFromIds;
import de.prob.animator.command.GetShortestTraceCommand;
import de.prob.animator.command.GetStatesFromPredicate;
import de.prob.animator.command.RegisterFormulaCommand;
import de.prob.animator.domainobjects.AbstractEvalResult;
import de.prob.animator.domainobjects.CSP;
import de.prob.animator.domainobjects.ClassicalB;
import de.prob.animator.domainobjects.FormulaExpand;
import de.prob.animator.domainobjects.IEvalElement;
import de.prob.animator.domainobjects.TypeCheckResult;
import de.prob.annotations.MaxCacheSize;
import de.prob.model.representation.AbstractElement;
import de.prob.model.representation.AbstractModel;
import de.prob.statespace.ITraceDescription;
import de.prob.statespace.State;
import de.prob.statespace.Trace;
import de.prob.statespace.Transition;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateSpace
implements IAnimator {
    Logger logger = LoggerFactory.getLogger(StateSpace.class);
    private transient IAnimator animator;
    private final HashMap<IEvalElement, WeakHashMap<Object, Object>> formulaRegistry = new HashMap();
    private final Set<IEvalElement> subscribedFormulas = new HashSet<IEvalElement>();
    private final LoadingCache<String, State> states;
    private AbstractModel model;
    private AbstractElement mainComponent;

    @Inject
    public StateSpace(Provider<IAnimator> panimator, @MaxCacheSize int maxSize) {
        this.animator = (IAnimator)panimator.get();
        this.states = CacheBuilder.newBuilder().maximumSize((long)maxSize).build((CacheLoader)new StateCacheLoader(this));
    }

    public State getRoot() {
        return this.addState("root");
    }

    public State getState(String id) {
        try {
            return (State)this.states.get((Object)id);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    State addState(String id) {
        State sId = (State)this.states.getIfPresent((Object)id);
        if (sId != null) {
            return sId;
        }
        sId = new State(id, this);
        this.states.put((Object)id, (Object)sId);
        return sId;
    }

    public State getState(int id) {
        if (id == -1) {
            return this.getRoot();
        }
        return this.getState(String.valueOf(id));
    }

    public Object getAt(int stateId) {
        return this.getState(stateId);
    }

    @Override
    public String getId() {
        return this.animator.getId();
    }

    public List<State> getStatesFromPredicate(IEvalElement predicate) {
        GetStatesFromPredicate cmd = new GetStatesFromPredicate(predicate);
        this.execute((AbstractCommand)cmd);
        List<String> ids = cmd.getIds();
        ArrayList<State> sIds = new ArrayList<State>();
        for (String s : ids) {
            sIds.add(this.addState(s));
        }
        return sIds;
    }

    public List<Transition> transitionFromPredicate(State stateId, String name, String predicate, int nrOfSolutions) throws IllegalArgumentException {
        IEvalElement pred = this.model.parseFormula(predicate);
        GetOperationByPredicateCommand command = new GetOperationByPredicateCommand(this, stateId.getId(), name, pred, nrOfSolutions);
        this.execute((AbstractCommand)command);
        if (command.hasErrors()) {
            throw new IllegalArgumentException("Executing operation " + name + " with predicate " + predicate + " produced errors: " + Joiner.on((String)", ").join(command.getErrors()));
        }
        return command.getNewTransitions();
    }

    public boolean isValidOperation(State stateId, String name, String predicate) {
        ClassicalB pred = new ClassicalB(predicate);
        GetOperationByPredicateCommand command = new GetOperationByPredicateCommand(this, stateId.getId(), name, pred, 1);
        this.execute((AbstractCommand)command);
        return !command.hasErrors();
    }

    public TypeCheckResult typeCheck(IEvalElement formula) {
        FormulaTypecheckCommand cmd = new FormulaTypecheckCommand(formula);
        this.execute((AbstractCommand)cmd);
        return cmd.getResult();
    }

    public List<AbstractEvalResult> eval(State state, List<IEvalElement> formulas) {
        return state.eval(formulas);
    }

    public Map<IEvalElement, AbstractEvalResult> valuesAt(State state) {
        state.explore();
        return state.getValues();
    }

    public boolean canBeEvaluated(State state) {
        return state.isInitialised();
    }

    public boolean subscribe(Object subscriber, List<IEvalElement> formulas) {
        boolean success = false;
        ArrayList<RegisterFormulaCommand> subscribeCmds = new ArrayList<RegisterFormulaCommand>();
        for (IEvalElement formulaOfInterest : formulas) {
            if (formulaOfInterest instanceof CSP) {
                this.logger.info("CSP formula {} not subscribed because CSP evaluation is not state based. Use eval method instead", (Object)formulaOfInterest.getCode());
                continue;
            }
            if (this.formulaRegistry.containsKey(formulaOfInterest)) {
                this.formulaRegistry.get(formulaOfInterest).put(subscriber, new WeakReference<IEvalElement>(formulaOfInterest));
                this.subscribedFormulas.add(formulaOfInterest);
                success = true;
                continue;
            }
            WeakHashMap<Object, WeakReference<Object>> subscribers = new WeakHashMap<Object, WeakReference<Object>>();
            subscribers.put(subscriber, new WeakReference<Object>(subscriber));
            this.formulaRegistry.put(formulaOfInterest, subscribers);
            subscribeCmds.add(new RegisterFormulaCommand(formulaOfInterest));
            this.subscribedFormulas.add(formulaOfInterest);
            success = true;
        }
        this.execute((AbstractCommand)new ComposedCommand(subscribeCmds));
        return success;
    }

    public boolean subscribe(Object subscriber, IEvalElement formulaOfInterest) {
        if (formulaOfInterest instanceof CSP) {
            this.logger.info("CSP formula {} not subscribed because CSP evaluation is not state based. Use eval method instead", (Object)formulaOfInterest.getCode());
            return false;
        }
        if (this.formulaRegistry.containsKey(formulaOfInterest)) {
            this.formulaRegistry.get(formulaOfInterest).put(subscriber, new WeakReference<Object>(subscriber));
        } else {
            this.execute((AbstractCommand)new RegisterFormulaCommand(formulaOfInterest));
            WeakHashMap<Object, WeakReference<Object>> subscribers = new WeakHashMap<Object, WeakReference<Object>>();
            subscribers.put(subscriber, new WeakReference<Object>(subscriber));
            this.formulaRegistry.put(formulaOfInterest, subscribers);
        }
        if (!this.subscribedFormulas.contains(formulaOfInterest)) {
            this.subscribedFormulas.add(formulaOfInterest);
        }
        return true;
    }

    public boolean isSubscribed(IEvalElement formula) {
        return this.formulaRegistry.containsKey(formula) && !this.formulaRegistry.get(formula).isEmpty();
    }

    public boolean unsubscribe(Object subscriber, IEvalElement formula) {
        if (this.formulaRegistry.containsKey(formula)) {
            WeakHashMap<Object, Object> subscribers = this.formulaRegistry.get(formula);
            subscribers.remove(subscriber);
            if (subscribers.isEmpty()) {
                this.subscribedFormulas.remove(formula);
            }
            return true;
        }
        return false;
    }

    public Set<IEvalElement> getSubscribedFormulas() {
        ArrayList<IEvalElement> toRemove = new ArrayList<IEvalElement>();
        for (IEvalElement e : this.subscribedFormulas) {
            WeakHashMap<Object, Object> subscribers = this.formulaRegistry.get(e);
            if (subscribers != null && !subscribers.isEmpty()) continue;
            toRemove.add(e);
        }
        this.subscribedFormulas.removeAll(toRemove);
        return this.subscribedFormulas;
    }

    @Override
    public void sendInterrupt() {
        this.animator.sendInterrupt();
    }

    @Override
    public void execute(AbstractCommand command) {
        this.animator.execute(command);
    }

    @Override
    public void execute(AbstractCommand ... commands) {
        this.animator.execute(commands);
    }

    @Override
    public void startTransaction() {
        this.animator.startTransaction();
    }

    @Override
    public void endTransaction() {
        this.animator.endTransaction();
    }

    @Override
    public boolean isBusy() {
        return this.animator.isBusy();
    }

    public String toString() {
        return this.animator.getId();
    }

    public String printOps(State state) {
        StringBuilder sb = new StringBuilder();
        List<Transition> opIds = state.getTransitions();
        sb.append("Operations: \n");
        for (Transition opId : opIds) {
            sb.append("  " + opId.getId() + ": " + opId.getRep());
            sb.append("\n");
        }
        if (!Trace.getExploreStateByDefault()) {
            sb.append("\n Possibly not all transitions shown. ProB does not explore states by default");
        }
        return sb.toString();
    }

    public String printState(State state) {
        StringBuilder sb = new StringBuilder();
        state.explore();
        sb.append("STATE: " + state + "\n\n");
        sb.append("VALUES:\n");
        Map<IEvalElement, AbstractEvalResult> currentState = state.getValues();
        Set<Map.Entry<IEvalElement, AbstractEvalResult>> entrySet = currentState.entrySet();
        for (Map.Entry<IEvalElement, AbstractEvalResult> entry : entrySet) {
            sb.append("  " + entry.getKey().getCode() + " -> " + entry.getValue().toString() + "\n");
        }
        return sb.toString();
    }

    public Trace getTrace(String stateId) {
        GetShortestTraceCommand cmd = new GetShortestTraceCommand(this, stateId);
        this.execute((AbstractCommand)cmd);
        Trace t = this.getTrace(cmd);
        return t;
    }

    public Trace getTrace(String sourceId, String destId) {
        FindTraceBetweenNodesCommand cmd = new FindTraceBetweenNodesCommand(this, sourceId, destId);
        this.execute((AbstractCommand)cmd);
        Trace t = this.getTrace(cmd);
        return t;
    }

    public Trace getTrace(List<String> transitionIds) {
        Trace t = new Trace(this);
        for (String id : transitionIds) {
            t = t.add(id);
        }
        return t;
    }

    public Trace getTrace(ITraceDescription description) {
        return description.getTrace(this);
    }

    public Trace getTraceToState(IEvalElement predicate) {
        FindValidStateCommand cmd = new FindValidStateCommand(this, predicate);
        this.execute((AbstractCommand)cmd);
        return this.getTrace(cmd);
    }

    public void setModel(AbstractModel model, AbstractElement mainComponent) {
        this.model = model;
        this.mainComponent = mainComponent;
    }

    public AbstractModel getModel() {
        return this.model;
    }

    public AbstractElement getMainComponent() {
        return this.mainComponent;
    }

    public Object asType(Class<?> clazz) {
        if (clazz.getSimpleName().equals("AbstractModel")) {
            return this.model;
        }
        if (clazz.equals(this.model.getClass())) {
            return this.model;
        }
        if (clazz.getSimpleName().equals("Trace")) {
            return new Trace(this);
        }
        throw new ClassCastException("An element of class " + clazz + " was not found");
    }

    public Set<Transition> evaluateTransitions(Collection<Transition> transitions, FormulaExpand expansion) {
        GetOpsFromIds cmd = new GetOpsFromIds(transitions, expansion);
        this.execute((AbstractCommand)cmd);
        return new LinkedHashSet<Transition>(transitions);
    }

    public Map<State, Map<IEvalElement, AbstractEvalResult>> evaluateForGivenStates(Collection<State> states, List<IEvalElement> formulas) {
        HashMap<State, Map<IEvalElement, AbstractEvalResult>> result = new HashMap<State, Map<IEvalElement, AbstractEvalResult>>();
        ArrayList<EvaluationCommand> cmds = new ArrayList<EvaluationCommand>();
        for (State stateId : states) {
            if (!stateId.isInitialised()) continue;
            HashMap<IEvalElement, AbstractEvalResult> res = new HashMap<IEvalElement, AbstractEvalResult>();
            result.put(stateId, res);
            Map<IEvalElement, AbstractEvalResult> map = stateId.getValues();
            for (IEvalElement f : formulas) {
                if (map.containsKey(f)) {
                    res.put(f, map.get(f));
                    continue;
                }
                cmds.add(f.getCommand(stateId));
            }
        }
        this.execute((AbstractCommand)new ComposedCommand(cmds));
        for (EvaluationCommand efCmd : cmds) {
            IEvalElement formula = efCmd.getEvalElement();
            AbstractEvalResult value = efCmd.getValue();
            State id = this.addState(efCmd.getStateId());
            ((Map)result.get(id)).put(formula, value);
        }
        return result;
    }

    @Override
    public void kill() {
        this.animator.kill();
    }

    private class StateCacheLoader
    extends CacheLoader<String, State> {
        private final StateSpace stateSpace;

        public StateCacheLoader(StateSpace stateSpace2) {
            this.stateSpace = stateSpace2;
        }

        public State load(String key) throws Exception {
            CheckIfStateIdValidCommand cmd = new CheckIfStateIdValidCommand(key);
            this.stateSpace.execute((AbstractCommand)cmd);
            if (cmd.isValidState()) {
                return new State(key, this.stateSpace);
            }
            throw new IllegalArgumentException(key + " does not represent a valid state in the StateSpace");
        }
    }
}

