/*
 * Decompiled with CFR 0.152.
 */
package de.prob.statespace;

import de.prob.animator.command.AbstractCommand;
import de.prob.animator.domainobjects.FormulaExpand;
import de.prob.parser.BindingGenerator;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.ListPrologTerm;
import de.prob.prolog.term.PrologTerm;
import de.prob.statespace.Transition;
import de.prob.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GetOpFromId
extends AbstractCommand {
    private static final String PROLOG_COMMAND_NAME = "get_op_from_id";
    private final Transition op;
    private final String PARAMS = "Params";
    private final String RETVALS = "RetVals";
    private List<String> params;
    private List<String> returnValues;
    private final FormulaExpand expansion;

    public GetOpFromId(Transition opInfo, FormulaExpand expansion) {
        this.op = opInfo;
        this.expansion = expansion;
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) {
        pto.openTerm(PROLOG_COMMAND_NAME).printAtomOrNumber(this.op.getId()).printAtom(this.expansion.name()).printVariable("Params").printVariable("RetVals").closeTerm();
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) {
        ListPrologTerm plist = BindingGenerator.getList((PrologTerm)((PrologTerm)bindings.get((Object)"Params")));
        this.params = Collections.emptyList();
        if (!plist.isEmpty()) {
            this.params = new ArrayList<String>();
        }
        for (PrologTerm p : plist) {
            this.params.add(StringUtil.generateString(p.getFunctor()));
        }
        ListPrologTerm rlist = BindingGenerator.getList((PrologTerm)((PrologTerm)bindings.get((Object)"RetVals")));
        this.returnValues = Collections.emptyList();
        if (!rlist.isEmpty()) {
            this.returnValues = new ArrayList<String>();
        }
        for (PrologTerm r : rlist) {
            this.returnValues.add(StringUtil.generateString(r.getFunctor()));
        }
        this.op.setInfo(this.expansion, this.params, this.returnValues);
    }

    public List<String> getParams() {
        return this.params;
    }

    public List<String> getReturnValues() {
        return this.returnValues;
    }
}

