/*
 * Decompiled with CFR 0.152.
 */
package de.prob.statespace;

import com.google.inject.Singleton;
import de.prob.model.representation.AbstractElement;
import de.prob.statespace.IAnimationChangeListener;
import de.prob.statespace.IModelChangedListener;
import de.prob.statespace.StateSpace;
import de.prob.statespace.Trace;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AnimationSelector {
    Logger logger = LoggerFactory.getLogger(AnimationSelector.class);
    List<IAnimationChangeListener> traceListeners = new CopyOnWriteArrayList<IAnimationChangeListener>();
    List<IModelChangedListener> modelListeners = new CopyOnWriteArrayList<IModelChangedListener>();
    Map<UUID, Trace> traces = new LinkedHashMap<UUID, Trace>();
    Set<UUID> protectedTraces = new HashSet<UUID>();
    Trace currentTrace = null;
    StateSpace currentStateSpace = null;

    public void registerAnimationChangeListener(IAnimationChangeListener listener) {
        this.traceListeners.add(listener);
        if (this.currentTrace != null) {
            listener.traceChange(this.currentTrace, true);
            listener.animatorStatus(this.currentTrace.getStateSpace().isBusy());
        }
    }

    public void deregisterAnimationChangeListener(IAnimationChangeListener listener) {
        this.traceListeners.remove(listener);
    }

    public void registerModelChangedListener(IModelChangedListener listener) {
        this.modelListeners.add(listener);
        if (this.currentStateSpace != null) {
            listener.modelChanged(this.currentStateSpace);
        }
    }

    public void deregisterModelChangedListeners(IModelChangedListener listener) {
        this.modelListeners.remove(listener);
    }

    public void changeCurrentAnimation(Trace trace) {
        this.currentTrace = trace;
        this.notifyAnimationChange(trace, true);
        if (this.currentTrace != null && this.currentTrace.getStateSpace() != this.currentStateSpace) {
            this.currentStateSpace = this.currentTrace.getStateSpace();
            this.notifyModelChanged(this.currentStateSpace);
        }
    }

    public void addNewAnimation(Trace trace) {
        this.addNewAnimation(trace, true);
    }

    public void addNewAnimation(Trace trace, boolean protect) {
        Trace t = trace;
        if (this.traces.containsKey(trace.getUUID())) {
            t = trace.copy();
        }
        this.traces.put(t.getUUID(), t);
        if (protect) {
            this.protectedTraces.add(t.getUUID());
        }
        this.currentTrace = t;
        this.notifyAnimationChange(t, true);
        StateSpace s = t.getStateSpace();
        if (s != null && !s.equals(this.currentStateSpace)) {
            this.currentStateSpace = s;
            this.notifyModelChanged(s);
        }
    }

    public void setProtected(Trace trace, boolean isProtected) {
        if (isProtected) {
            this.protectedTraces.add(trace.getUUID());
        } else {
            this.protectedTraces.remove(trace.getUUID());
        }
    }

    public void clearUnprotected() {
        ArrayList<Trace> list = new ArrayList<Trace>(this.traces.values());
        boolean currentChanged = false;
        for (Trace trace : list) {
            if (this.protectedTraces.contains(trace.getUUID())) continue;
            if (this.currentTrace != null && trace.getUUID().equals(this.currentTrace.getUUID())) {
                this.currentTrace = null;
                this.currentStateSpace = null;
                currentChanged = true;
            }
            this.traces.remove(trace.getUUID());
        }
        if (currentChanged && !this.traces.isEmpty()) {
            this.currentTrace = this.traces.values().iterator().next();
            this.currentStateSpace = this.currentTrace.getStateSpace();
        }
        this.refresh();
    }

    private void notifyAnimationChange(Trace trace, boolean currentAnimationChanged) {
        if (trace == null || trace != null && !trace.getStateSpace().isBusy()) {
            for (IAnimationChangeListener animationChangeListener : this.traceListeners) {
                try {
                    animationChangeListener.traceChange(trace, currentAnimationChanged);
                }
                catch (Exception e) {
                    this.logger.error("An exception of type " + e.getClass() + " was thrown while executing IAnimationChangeListener of class " + animationChangeListener.getClass() + " with message " + e.getMessage());
                }
            }
        }
    }

    private void notifyStatusChange(boolean busy) {
        for (IAnimationChangeListener animationChangeListener : this.traceListeners) {
            animationChangeListener.animatorStatus(busy);
        }
    }

    private void notifyModelChanged(StateSpace s) {
        for (IModelChangedListener modelChangedListener : this.modelListeners) {
            modelChangedListener.modelChanged(s);
        }
    }

    public Trace getCurrentTrace() {
        return this.currentTrace;
    }

    public List<Trace> getTraces() {
        return new ArrayList<Trace>(this.traces.values());
    }

    public Trace getTrace(UUID uuid) {
        return this.traces.get(uuid);
    }

    public Set<UUID> getProtectedTraces() {
        return this.protectedTraces;
    }

    public AbstractElement getModel(Trace trace) {
        return trace.getModel();
    }

    public String toString() {
        return "Animations Registry";
    }

    public void refresh() {
        this.notifyAnimationChange(this.currentTrace, true);
        this.notifyModelChanged(this.currentStateSpace);
        if (this.currentStateSpace != null) {
            this.notifyStatusChange(this.currentStateSpace.isBusy());
        }
    }

    public void traceChange(Trace trace) {
        UUID uuid = trace.getUUID();
        if (!this.traces.containsKey(uuid)) {
            this.traces.put(uuid, trace);
            this.notifyAnimationChange(this.currentTrace, false);
        } else {
            this.traces.put(uuid, trace);
            if (trace.getUUID().equals(this.currentTrace.getUUID())) {
                this.notifyAnimationChange(trace, true);
                Trace oldT = this.currentTrace;
                this.currentTrace = trace;
                if (oldT.getStateSpace().isBusy() != this.currentTrace.getStateSpace().isBusy()) {
                    this.notifyStatusChange(this.currentTrace.getStateSpace().isBusy());
                }
            } else {
                this.notifyAnimationChange(this.currentTrace, false);
            }
        }
        if (this.currentTrace != null && this.currentTrace.getStateSpace() != this.currentStateSpace) {
            this.currentStateSpace = this.currentTrace.getStateSpace();
            this.notifyModelChanged(this.currentStateSpace);
        }
    }

    @Deprecated
    public void replaceTrace(Trace oldTrace, Trace newTrace) {
        this.traceChange(newTrace);
    }

    public void removeTrace(Trace trace) {
        this.remove(trace);
        this.refresh();
    }

    private void remove(Trace trace) {
        if (!this.traces.containsKey(trace.getUUID())) {
            return;
        }
        if (this.currentTrace == trace) {
            this.traces.remove(trace.getUUID());
            if (this.traces.isEmpty()) {
                this.currentTrace = null;
                this.currentStateSpace = null;
                return;
            }
            this.currentTrace = this.traces.values().iterator().next();
            this.currentStateSpace = this.currentTrace.getStateSpace();
            return;
        }
        this.traces.remove(trace.getUUID());
        this.protectedTraces.remove(trace.getUUID());
    }

    public void notifyAnimatorStatus(String animatorId, boolean busy) {
        if (this.currentTrace != null && this.currentTrace.getStateSpace().getId().equals(animatorId)) {
            this.notifyStatusChange(busy);
        }
    }
}

