/*
 * Decompiled with CFR 0.152.
 */
package de.prob.scripting;

import com.google.inject.Inject;
import com.google.inject.Provider;
import de.prob.animator.command.AbstractCommand;
import de.prob.animator.command.ComposedCommand;
import de.prob.animator.command.SetPreferenceCommand;
import de.prob.animator.command.StartAnimationCommand;
import de.prob.model.representation.AbstractElement;
import de.prob.model.representation.AbstractModel;
import de.prob.statespace.StateSpace;
import java.util.ArrayList;
import java.util.Map;

public class StateSpaceProvider {
    private final Provider<StateSpace> ssProvider;

    @Inject
    public StateSpaceProvider(Provider<StateSpace> ssProvider) {
        this.ssProvider = ssProvider;
    }

    public StateSpace loadFromCommand(AbstractModel model, AbstractElement mainComponent, Map<String, String> preferences, AbstractCommand loadCmd) {
        StateSpace s = (StateSpace)this.ssProvider.get();
        s.setModel(model, mainComponent);
        ArrayList<SetPreferenceCommand> cmds = new ArrayList<SetPreferenceCommand>();
        for (Map.Entry<String, String> pref : preferences.entrySet()) {
            cmds.add(new SetPreferenceCommand(pref.getKey(), pref.getValue()));
        }
        s.execute((AbstractCommand)new ComposedCommand(cmds));
        s.execute(loadCmd);
        s.execute((AbstractCommand)new StartAnimationCommand());
        return s;
    }
}

