/*
 * Decompiled with CFR 0.152.
 */
package de.prob.model.representation;

import com.github.krukow.clj_lang.PersistentHashMap;
import de.prob.animator.domainobjects.IEvalElement;
import de.prob.model.representation.AbstractElement;
import de.prob.model.representation.DependencyGraph;
import de.prob.model.representation.ModelElementList;
import de.prob.scripting.StateSpaceProvider;
import de.prob.statespace.FormalismType;
import de.prob.statespace.StateSpace;
import groovy.util.Eval;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractModel
extends AbstractElement {
    protected final StateSpaceProvider stateSpaceProvider;
    protected File modelFile;
    protected final DependencyGraph graph;

    public AbstractModel(StateSpaceProvider stateSpaceProvider, PersistentHashMap<Class<? extends AbstractElement>, ModelElementList<? extends AbstractElement>> children, DependencyGraph graph, File modelFile) {
        super(children);
        this.stateSpaceProvider = stateSpaceProvider;
        this.graph = graph;
        this.modelFile = modelFile;
    }

    public abstract AbstractElement getComponent(String var1);

    public DependencyGraph getGraph() {
        return this.graph;
    }

    public DependencyGraph.ERefType getRelationship(String comp1, String comp2) {
        return this.getEdge(comp1, comp2);
    }

    public DependencyGraph.ERefType getEdge(String comp1, String comp2) {
        List<DependencyGraph.ERefType> edges = this.graph.getRelationships(comp1, comp2);
        if (edges.isEmpty()) {
            return null;
        }
        return edges.get(0);
    }

    public String toString() {
        return this.graph.toString();
    }

    public abstract IEvalElement parseFormula(String var1);

    public abstract boolean checkSyntax(String var1);

    public abstract FormalismType getFormalismType();

    public File getModelFile() {
        return this.modelFile;
    }

    public StateSpaceProvider getStateSpaceProvider() {
        return this.stateSpaceProvider;
    }

    public Object getProperty(String name) {
        if ("stateSpaceProvider".equals(name)) {
            return this.getStateSpaceProvider();
        }
        if ("modelFile".equals(name)) {
            return this.getModelFile();
        }
        if ("graph".equals(name)) {
            return this.getGraph();
        }
        if ("children".equals(name)) {
            return this.getChildren();
        }
        return null;
    }

    public AbstractElement get(List<String> path) {
        if (path.isEmpty()) {
            return null;
        }
        return (AbstractElement)Eval.x((Object)this, (String)"x.${path.join('.')}");
    }

    public StateSpace load(AbstractElement mainComponent) {
        return this.load(mainComponent, new HashMap<String, String>());
    }

    public abstract StateSpace load(AbstractElement var1, Map<String, String> var2);
}

