/*
 * Decompiled with CFR 0.152.
 */
package de.prob.model.eventb.translate;

import de.prob.animator.domainobjects.EventB;
import de.prob.model.eventb.EventBAxiom;
import de.prob.model.eventb.theory.AxiomaticDefinitionBlock;
import de.prob.model.eventb.theory.DataType;
import de.prob.model.eventb.theory.DirectDefinition;
import de.prob.model.eventb.theory.IOperatorDefinition;
import de.prob.model.eventb.theory.InferenceRule;
import de.prob.model.eventb.theory.MetaVariable;
import de.prob.model.eventb.theory.Operator;
import de.prob.model.eventb.theory.OperatorArgument;
import de.prob.model.eventb.theory.ProofRulesBlock;
import de.prob.model.eventb.theory.RecursiveDefinitionCase;
import de.prob.model.eventb.theory.RecursiveOperatorDefinition;
import de.prob.model.eventb.theory.RewriteRule;
import de.prob.model.eventb.theory.RewriteRuleRHS;
import de.prob.model.eventb.theory.Theory;
import de.prob.model.eventb.theory.Type;
import de.prob.model.representation.ModelElementList;
import de.prob.tmparser.OperatorMapping;
import de.prob.tmparser.TheoryMappingException;
import de.prob.tmparser.TheoryMappingParser;
import de.prob.util.Tuple2;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.extension.IFormulaExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TheoryExtractor
extends DefaultHandler {
    Logger logger = LoggerFactory.getLogger(TheoryExtractor.class);
    private Theory theory;
    private ModelElementList<Theory> imported = new ModelElementList();
    private ModelElementList<Type> typeParameters = new ModelElementList();
    private ModelElementList<DataType> dataTypes = new ModelElementList();
    private ModelElementList<Operator> operators = new ModelElementList();
    private ModelElementList<AxiomaticDefinitionBlock> axiomaticDefinitionsBlocks = new ModelElementList();
    private ModelElementList<EventBAxiom> theorems = new ModelElementList();
    private ModelElementList<ProofRulesBlock> proofRules = new ModelElementList();
    private String dataTypeName;
    private String currentConstructor;
    private Map<String, List<Tuple2<String, String>>> constructors;
    private List<String> types;
    private ModelElementList<Type> typeArguments;
    private Operator operator;
    private ModelElementList<OperatorArgument> opArgs;
    private IOperatorDefinition definition;
    private ModelElementList<RecursiveDefinitionCase> recursiveDefinitions;
    private AxiomaticDefinitionBlock axiomaticDefinitionBlock;
    private Operator axiomaticOperator;
    private ModelElementList<Operator> axiomaticOperators;
    private ModelElementList<EventBAxiom> definitionAxioms;
    private ProofRulesBlock block;
    private ModelElementList<MetaVariable> metaVars;
    private ModelElementList<RewriteRule> rewriteRules;
    private ModelElementList<InferenceRule> inferenceRules;
    private RewriteRule rewriteRule;
    private ModelElementList<RewriteRuleRHS> rightHandSides;
    private List<EventB> given;
    private EventB infer;
    private Set<IFormulaExtension> typeEnv;
    private Map<String, Theory> theoryMap;
    private String project;
    private String name;
    private String workspacePath;
    ModelElementList<Theory> theories = new ModelElementList();

    public TheoryExtractor(String workspacePath, String project, String name, Map<String, Theory> theoryMap) {
        this.workspacePath = workspacePath;
        this.project = project;
        this.name = name;
        this.theoryMap = theoryMap;
        Collection<Object> mappings = new ArrayList<OperatorMapping>();
        try {
            String mappingFileName = workspacePath + File.separator + project + File.separator + name + ".ptm";
            mappings = TheoryMappingParser.parseTheoryMapping((String)name, (String)mappingFileName);
        }
        catch (FileNotFoundException e) {
            this.logger.warn("No .ptm file found for Theory " + name + ". This means that ProB has no information on how to interpret this theory.");
        }
        catch (TheoryMappingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.theory = new Theory(name, project, mappings);
        this.typeEnv = new HashSet<IFormulaExtension>();
    }

    public Theory getTheory() {
        return this.theory;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("org.eventb.theory.core.scTypeParameter")) {
            this.addTypeParameter(attributes);
        } else if (qName.equals("org.eventb.theory.core.useTheory")) {
            this.addUsedTheory(attributes);
        } else if (qName.equals("org.eventb.theory.core.scDatatypeDefinition")) {
            this.beginAddingDataType(attributes);
        } else if (qName.equals("org.eventb.theory.core.scTypeArgument")) {
            this.addTypeArgument(attributes);
        } else if (qName.equals("org.eventb.theory.core.scDatatypeConstructor")) {
            this.beginAddingDataTypeConstructor(attributes);
        } else if (qName.equals("org.eventb.theory.core.scConstructorArgument")) {
            this.addDestructor(attributes);
        } else if (qName.equals("org.eventb.theory.core.scNewOperatorDefinition")) {
            this.beginAddingOperator(attributes);
        } else if (qName.equals("org.eventb.theory.core.scDirectOperatorDefinition")) {
            this.addDirectDefinition(attributes);
        } else if (qName.equals("org.eventb.theory.core.scRecursiveOperatorDefinition")) {
            this.beginRecursiveOpDef(attributes);
        } else if (qName.equals("org.eventb.theory.core.scRecursiveDefinitionCase")) {
            this.addRecursiveDefinitionCase(attributes);
        } else if (qName.equals("org.eventb.theory.core.scNewOperatorDefinition")) {
            this.addDirectDefinition(attributes);
        } else if (qName.equals("org.eventb.theory.core.scOperatorArgument")) {
            this.addOperatorArgument(attributes);
        } else if (qName.equals("org.eventb.theory.core.scAxiomaticDefinitionsBlock")) {
            this.addAxiomaticDefinitionBlock(attributes);
        } else if (qName.equals("org.eventb.theory.core.scAxiomaticOperatorDefinition")) {
            this.beginAddingAxiomaticOperator(attributes);
        } else if (qName.equals("org.eventb.theory.core.scAxiomaticDefinitionAxiom")) {
            this.addDefinitionAxiom(attributes);
        } else if (qName.equals("org.eventb.theory.core.scAxiomaticTypeDefinition")) {
            this.addTypeParameter(attributes);
        } else if (qName.equals("org.eventb.theory.core.scTheorem")) {
            this.addTheorem(attributes);
        } else if (qName.equals("org.eventb.theory.core.scProofRulesBlock")) {
            this.beginProofRulesBlock(attributes);
        } else if (qName.equals("org.eventb.theory.core.scMetavariable")) {
            this.addMetaVariable(attributes);
        } else if (qName.equals("org.eventb.theory.core.scRewriteRule")) {
            this.beginRewriteRule(attributes);
        } else if (qName.equals("org.eventb.theory.core.scRewriteRuleRHS")) {
            this.addRightHandSide(attributes);
        } else if (qName.equals("org.eventb.theory.core.scInferenceRule")) {
            this.beginInferenceRule(attributes);
        } else if (qName.equals("org.eventb.theory.core.scInfer")) {
            this.addInfer(attributes);
        } else if (qName.equals("org.eventb.theory.core.scGiven")) {
            this.addGiven(attributes);
        }
    }

    private void addGiven(Attributes attributes) {
        String predicate = attributes.getValue("org.eventb.core.predicate");
        this.given.add(new EventB(predicate, this.typeEnv));
    }

    private void addInfer(Attributes attributes) {
        String predicate = attributes.getValue("org.eventb.core.predicate");
        this.infer = new EventB(predicate, this.typeEnv);
    }

    private void beginInferenceRule(Attributes attributes) {
        this.given = new ArrayList<EventB>();
    }

    private void addRightHandSide(Attributes attributes) {
        String name = attributes.getValue("org.eventb.core.label");
        String predicate = attributes.getValue("org.eventb.core.predicate");
        String formula = attributes.getValue("org.eventb.theory.core.formula");
        this.rightHandSides = this.rightHandSides.addElement(new RewriteRuleRHS(name, predicate, formula, this.typeEnv));
    }

    private void beginRewriteRule(Attributes attributes) {
        String label = attributes.getValue("org.eventb.core.label");
        String applicability = attributes.getValue("org.eventb.theory.core.applicability");
        boolean complete = "true".equals(attributes.getValue("org.eventb.theory.core.complete"));
        String desc = attributes.getValue("org.eventb.theory.core.desc");
        String formula = attributes.getValue("org.eventb.theory.core.formula");
        this.rewriteRule = new RewriteRule(label, applicability, complete, desc, formula, this.typeEnv);
        this.rightHandSides = new ModelElementList();
        this.rewriteRules = this.rewriteRules.addElement(this.rewriteRule);
    }

    private void addMetaVariable(Attributes attributes) {
        String name = attributes.getValue("name");
        String type = attributes.getValue("org.eventb.core.type");
        this.metaVars = this.metaVars.addElement(new MetaVariable(name, type, this.typeEnv));
    }

    private void beginProofRulesBlock(Attributes attributes) {
        String name = attributes.getValue("org.eventb.core.label");
        if (name == null) {
            name = attributes.getValue("name");
        }
        this.block = new ProofRulesBlock(name);
        this.metaVars = new ModelElementList();
        this.rewriteRules = new ModelElementList();
        this.inferenceRules = new ModelElementList();
        this.proofRules = this.proofRules.addElement(this.block);
    }

    private void addTheorem(Attributes attributes) {
        String label = attributes.getValue("org.eventb.core.label");
        String predicate = attributes.getValue("org.eventb.core.predicate");
        this.theorems = this.theorems.addElement(new EventBAxiom(label, predicate, true, this.typeEnv));
    }

    private void addAxiomaticDefinitionBlock(Attributes attributes) {
        String name = attributes.getValue("org.eventb.core.label");
        this.axiomaticDefinitionBlock = new AxiomaticDefinitionBlock(name);
        this.typeArguments = new ModelElementList();
        this.axiomaticOperators = new ModelElementList();
        this.definitionAxioms = new ModelElementList();
        this.axiomaticDefinitionsBlocks = this.axiomaticDefinitionsBlocks.addElement(this.axiomaticDefinitionBlock);
    }

    private void beginAddingAxiomaticOperator(Attributes attributes) {
        this.axiomaticOperator = this.createOperator(attributes);
        this.opArgs = new ModelElementList();
    }

    private void addDefinitionAxiom(Attributes attributes) {
        String label = attributes.getValue("org.eventb.core.label");
        String predicate = attributes.getValue("org.eventb.core.predicate");
        this.definitionAxioms = this.definitionAxioms.addElement(new EventBAxiom(label, predicate, false, this.typeEnv));
    }

    private void addOperatorArgument(Attributes attributes) {
        String identifier = attributes.getValue("name");
        String type = attributes.getValue("org.eventb.core.type");
        this.opArgs = this.opArgs.addElement(new OperatorArgument(identifier, type, this.typeEnv));
    }

    private void addDirectDefinition(Attributes attributes) {
        String formula = attributes.getValue("org.eventb.theory.core.formula");
        this.definition = new DirectDefinition(formula, this.typeEnv);
    }

    private void addRecursiveDefinitionCase(Attributes attributes) {
        String expression = attributes.getValue("org.eventb.core.expression");
        String formula = attributes.getValue("org.eventb.theory.core.formula");
        this.recursiveDefinitions = this.recursiveDefinitions.addElement(new RecursiveDefinitionCase(expression, formula));
    }

    private void beginRecursiveOpDef(Attributes attributes) {
        String indArg = attributes.getValue("org.eventb.theory.core.inductiveArgument");
        this.definition = new RecursiveOperatorDefinition(indArg, this.typeEnv);
        this.recursiveDefinitions = new ModelElementList();
    }

    private void beginAddingOperator(Attributes attributes) {
        this.operator = this.createOperator(attributes);
        this.opArgs = new ModelElementList();
    }

    private Operator createOperator(Attributes attributes) {
        String label = attributes.getValue("org.eventb.core.label");
        boolean associative = "true".equals(attributes.getValue("org.eventb.theory.core.associative"));
        boolean commutative = "true".equals(attributes.getValue("org.eventb.theory.core.commutative"));
        boolean formulaType = "true".equals(attributes.getValue("org.eventb.theory.core.formulaType"));
        String notationType = attributes.getValue("org.eventb.theory.core.notationType");
        String groupId = attributes.getValue("org.eventb.theory.core.groupID");
        String predicate = attributes.getValue("org.eventb.core.predicate");
        String type = attributes.getValue("org.eventb.theory.core.type");
        String wd = attributes.getValue("org.eventb.theory.core.wd");
        return new Operator(this.theory.getName(), label, associative, commutative, formulaType, notationType, groupId, type, wd, predicate, this.typeEnv);
    }

    private void addDestructor(Attributes attributes) {
        String name = attributes.getValue("name");
        String type = attributes.getValue("org.eventb.core.type");
        this.constructors.get(this.currentConstructor).add(new Tuple2<String, String>(name, type));
    }

    private void beginAddingDataTypeConstructor(Attributes attributes) {
        String name;
        this.currentConstructor = name = attributes.getValue("name");
        this.constructors.put(this.currentConstructor, new ArrayList());
    }

    private void beginAddingDataType(Attributes attributes) {
        String name;
        this.dataTypeName = name = attributes.getValue("name");
        this.constructors = new HashMap<String, List<Tuple2<String, String>>>();
        this.types = new ArrayList<String>();
    }

    private void addUsedTheory(Attributes attributes) throws SAXException {
        String target = attributes.getValue("org.eventb.core.scTarget");
        String path = target.substring(0, target.indexOf(124));
        if (this.theoryMap.containsKey(path)) {
            this.imported = this.imported.addElement(this.theoryMap.get(path));
        } else {
            try {
                String dir = path.substring(path.indexOf(47) + 1, path.lastIndexOf(47));
                String name = path.substring(path.lastIndexOf(47) + 1, path.lastIndexOf(46));
                SAXParserFactory parserFactory = SAXParserFactory.newInstance();
                SAXParser saxParser = parserFactory.newSAXParser();
                TheoryExtractor extractor = new TheoryExtractor(this.workspacePath, dir, name, this.theoryMap);
                saxParser.parse(new File(this.workspacePath + path), (DefaultHandler)extractor);
                this.theories = this.theories.addElement(extractor.getTheory());
                this.typeEnv.addAll(extractor.getTypeEnv());
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void addTypeParameter(Attributes attributes) {
        String name = attributes.getValue("name");
        Type p = new Type(name, this.typeEnv);
        this.typeParameters = this.typeParameters.addElement(p);
    }

    private void addTypeArgument(Attributes attributes) {
        String name = attributes.getValue("name");
        this.types.add(name);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("org.eventb.theory.core.scDatatypeDefinition")) {
            this.finishDataType();
        } else if (qName.equals("org.eventb.theory.core.scNewOperatorDefinition")) {
            this.finishOperator();
        } else if (qName.equals("org.eventb.theory.core.scRecursiveDefinitionCase")) {
            this.finishRecursiveDefinition();
        } else if (qName.equals("org.eventb.theory.core.scAxiomaticOperatorDefinition")) {
            this.finishAxiomaticOperator();
        } else if (qName.equals("org.eventb.theory.core.scAxiomaticDefinitionsBlock")) {
            this.finishAxiomaticDefinitionBlock();
        } else if (qName.equals("org.eventb.theory.core.scProofRulesBlock")) {
            this.finishProofRulesBlock();
        } else if (qName.equals("org.eventb.theory.core.scRewriteRule")) {
            this.finishRewriteRule();
        } else if (qName.equals("org.eventb.theory.core.scInferenceRule")) {
            this.finishInferenceRule();
        }
    }

    private void finishAxiomaticDefinitionBlock() {
        this.axiomaticDefinitionBlock = this.axiomaticDefinitionBlock.set(EventBAxiom.class, this.definitionAxioms);
        this.axiomaticDefinitionBlock = this.axiomaticDefinitionBlock.set(Operator.class, this.axiomaticOperators);
        this.axiomaticDefinitionBlock = this.axiomaticDefinitionBlock.set(Type.class, this.typeArguments);
    }

    private void finishInferenceRule() {
        this.inferenceRules = this.inferenceRules.addElement(new InferenceRule(this.given, this.infer));
    }

    private void finishRewriteRule() {
        this.rewriteRule = this.rewriteRule.addRightHandSide(this.rightHandSides);
    }

    private void finishProofRulesBlock() {
        this.block = this.block.set(InferenceRule.class, this.inferenceRules);
        this.block = this.block.set(MetaVariable.class, this.metaVars);
        this.block = this.block.set(RewriteRule.class, this.rewriteRules);
    }

    private void finishRecursiveDefinition() {
        this.definition = ((RecursiveOperatorDefinition)this.definition).addCases(this.recursiveDefinitions);
    }

    private void finishAxiomaticOperator() {
        this.axiomaticOperator = this.axiomaticOperator.addArguments(this.opArgs);
        this.axiomaticOperators = this.axiomaticOperators.addElement(this.axiomaticOperator);
        this.typeEnv.add(this.axiomaticOperator.getFormulaExtension());
    }

    private void finishOperator() {
        this.operator = this.operator.setDefinition(this.definition);
        this.operator = this.operator.addArguments(this.opArgs);
        this.typeEnv.add(this.operator.getFormulaExtension());
        this.operators = this.operators.addElement(this.operator);
        if (this.recursiveDefinitions != null) {
            for (RecursiveDefinitionCase def : this.recursiveDefinitions) {
                def.parseCase(this.typeEnv);
            }
            this.recursiveDefinitions = null;
        }
    }

    private void finishDataType() {
        DataType dataType = new DataType(this.dataTypeName, this.constructors, this.types);
        Set<IFormulaExtension> newExts = dataType.getFormulaExtensions(FormulaFactory.getInstance(this.typeEnv));
        this.dataTypes = this.dataTypes.addElement(dataType);
        this.typeEnv.addAll(newExts);
    }

    @Override
    public void endDocument() throws SAXException {
        this.theory = this.theory.set(DataType.class, this.dataTypes);
        this.theory = this.theory.set(Theory.class, this.imported);
        this.theory = this.theory.set(Operator.class, this.operators);
        this.theory = this.theory.set(AxiomaticDefinitionBlock.class, this.axiomaticDefinitionsBlocks);
        this.theory = this.theory.set(ProofRulesBlock.class, this.proofRules);
        this.theory = this.theory.set(EventBAxiom.class, this.theorems);
        this.theory = this.theory.set(Type.class, this.typeParameters);
        this.theoryMap.put(this.project + File.separator + this.name, this.theory);
        this.theory = this.theory.setTypeEnvironment(this.typeEnv);
        this.theories = this.theories.addElement(this.theory);
    }

    public ModelElementList<Theory> getTheories() {
        return this.theories;
    }

    public Set<IFormulaExtension> getTypeEnv() {
        return this.typeEnv;
    }
}

