/*
 * Decompiled with CFR 0.152.
 */
package de.prob.model.eventb.translate;

import de.prob.model.eventb.Context;
import de.prob.model.eventb.Event;
import de.prob.model.eventb.EventBGuard;
import de.prob.model.eventb.EventBMachine;
import de.prob.model.eventb.ProofObligation;
import de.prob.model.eventb.translate.ProofDescriptionExtractor;
import de.prob.model.eventb.translate.ProofStatusExtractor;
import de.prob.model.representation.ModelElementList;
import de.prob.util.Tuple2;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ProofExtractor {
    Logger logger = LoggerFactory.getLogger(ProofExtractor.class);
    Map<String, String> descriptions;
    Set<String> discharged;
    List<ProofObligation> proofs = new ArrayList<ProofObligation>();

    public ProofExtractor(Context c, String baseFileName) throws SAXException {
        this.extractProofs(baseFileName);
        this.addProofs(c);
    }

    public ProofExtractor(EventBMachine m, String baseFileName) throws SAXException {
        this.extractProofs(baseFileName);
        this.addProofs(m);
    }

    private void extractProofs(String baseFileName) throws SAXException {
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            SAXParser saxParser = parserFactory.newSAXParser();
            String bpoFileName = baseFileName + ".bpo";
            File bpoFile = new File(bpoFileName);
            if (bpoFile.exists()) {
                ProofDescriptionExtractor ext1 = new ProofDescriptionExtractor();
                saxParser.parse(bpoFile, (DefaultHandler)ext1);
                this.descriptions = ext1.getProofDescriptions();
            } else {
                this.descriptions = new HashMap<String, String>();
                this.logger.info("Could not find file " + bpoFileName + ". Assuming that no proofs have been generated for model element.");
            }
            String bpsFileName = baseFileName + ".bps";
            File bpsFile = new File(bpsFileName);
            if (bpsFile.exists()) {
                ProofStatusExtractor ext2 = new ProofStatusExtractor();
                saxParser.parse(bpsFile, (DefaultHandler)ext2);
                this.discharged = ext2.getDischargedProofs();
            } else {
                this.discharged = new HashSet<String>();
                this.logger.info("Could not find file " + bpsFileName + ". Assuming that no proofs are discharged for model element.");
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void addProofs(Context c) {
        for (Map.Entry<String, String> entry : this.descriptions.entrySet()) {
            String name = entry.getKey();
            String desc = entry.getValue();
            boolean isDischarged = this.discharged.contains(name);
            String[] split = name.split("/");
            String type = split.length == 1 ? split[0] : (split.length == 2 ? split[1] : split[2]);
            String source = c.getName();
            ArrayList<Tuple2<String, String>> elements = new ArrayList<Tuple2<String, String>>();
            if ("THM".equals(type)) {
                elements.add(new Tuple2<String, String>("axiom", split[0]));
                this.proofs.add(new ProofObligation(source, name, isDischarged, desc, elements));
                continue;
            }
            if ("WD".equals(type)) {
                elements.add(new Tuple2<String, String>("axiom", split[0]));
                this.proofs.add(new ProofObligation(source, name, isDischarged, desc, elements));
                continue;
            }
            this.proofs.add(new ProofObligation(source, name, isDischarged, desc, elements));
        }
    }

    private void addProofs(EventBMachine m) {
        for (Map.Entry<String, String> entry : this.descriptions.entrySet()) {
            String name = entry.getKey();
            String desc = entry.getValue();
            boolean isDischarged = this.discharged.contains(name);
            String[] split = name.split("/");
            String type = split.length == 1 ? split[0] : (split.length == 2 ? split[1] : split[2]);
            String source = m.getName();
            ArrayList<Tuple2<String, String>> elements = new ArrayList<Tuple2<String, String>>();
            if ("GRD".equals(type)) {
                Event concreteEvent = m.getEvent(split[0]);
                for (Event event : concreteEvent.getRefines()) {
                    if (event.getGuards().getElement(split[1]) == null) continue;
                    EventBGuard guard = event.getGuards().getElement(split[1]);
                    elements.add(new Tuple2<String, String>("event", event.getName()));
                    elements.add(new Tuple2<String, String>("guard", guard.getName()));
                }
                elements.add(new Tuple2<String, String>("event", concreteEvent.getName()));
                this.proofs.add(new ProofObligation(source, name, isDischarged, desc, elements));
                continue;
            }
            if ("INV".equals(type)) {
                elements.add(new Tuple2<String, String>("event", "invariant"));
                this.proofs.add(new ProofObligation(source, name, isDischarged, desc, elements));
                continue;
            }
            if ("THM".equals(type)) {
                if (split.length == 2) {
                    elements.add(new Tuple2<String, String>("invariant", split[0]));
                } else {
                    elements.add(new Tuple2<String, String>("guard", split[1]));
                    elements.add(new Tuple2<String, String>("event", split[0]));
                }
                this.proofs.add(new ProofObligation(source, name, isDischarged, desc, elements));
                continue;
            }
            if ("WD".equals(type)) {
                if (split.length == 2) {
                    elements.add(new Tuple2<String, String>("invariant", split[0]));
                    continue;
                }
                Event event = m.getEvent(split[0]);
                if (event.getActions().getElement(split[1]) != null) {
                    elements.add(new Tuple2<String, String>("event", event.getName()));
                    elements.add(new Tuple2<String, String>("action", split[1]));
                } else {
                    elements.add(new Tuple2<String, String>("event", event.getName()));
                    elements.add(new Tuple2<String, String>("guard", split[1]));
                }
                this.proofs.add(new ProofObligation(source, name, isDischarged, desc, elements));
                continue;
            }
            this.proofs.add(new ProofObligation(source, name, isDischarged, desc, elements));
        }
    }

    public ModelElementList<ProofObligation> getProofs() {
        return new ModelElementList<ProofObligation>(this.proofs);
    }
}

