/*
 * Decompiled with CFR 0.152.
 */
package de.prob.model.eventb.translate;

import de.prob.animator.domainobjects.EventB;
import de.prob.model.eventb.Context;
import de.prob.model.eventb.Event;
import de.prob.model.eventb.EventBAction;
import de.prob.model.eventb.EventBAxiom;
import de.prob.model.eventb.EventBConstant;
import de.prob.model.eventb.EventBGuard;
import de.prob.model.eventb.EventBInvariant;
import de.prob.model.eventb.EventBMachine;
import de.prob.model.eventb.EventBModel;
import de.prob.model.eventb.EventBVariable;
import de.prob.model.eventb.EventParameter;
import de.prob.model.eventb.ProofObligation;
import de.prob.model.eventb.Variant;
import de.prob.model.eventb.Witness;
import de.prob.model.eventb.translate.ProofExtractor;
import de.prob.model.representation.AbstractElement;
import de.prob.model.representation.Action;
import de.prob.model.representation.Axiom;
import de.prob.model.representation.BEvent;
import de.prob.model.representation.Constant;
import de.prob.model.representation.DependencyGraph;
import de.prob.model.representation.Guard;
import de.prob.model.representation.Invariant;
import de.prob.model.representation.Machine;
import de.prob.model.representation.ModelElementList;
import de.prob.model.representation.Variable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eventb.core.ast.extension.IFormulaExtension;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MachineXmlHandler
extends DefaultHandler {
    private EventBModel model;
    private final Set<IFormulaExtension> typeEnv;
    private EventBMachine machine;
    private final List<String> seesNames = new ArrayList<String>();
    private final String directoryPath;
    private final List<Context> sees = new ArrayList<Context>();
    private final List<EventBMachine> refines = new ArrayList<EventBMachine>();
    private final List<EventBInvariant> invariants = new ArrayList<EventBInvariant>();
    private final List<EventBInvariant> inheritedInvariants = new ArrayList<EventBInvariant>();
    private final List<EventBVariable> variables = new ArrayList<EventBVariable>();
    private final List<Event> events = new ArrayList<Event>();
    private final List<Variant> variant = new ArrayList<Variant>();
    private Context internalContext;
    private List<Context> Extends;
    private List<de.prob.model.representation.Set> sets;
    private List<EventBAxiom> axioms;
    private List<EventBAxiom> inheritedAxioms;
    private List<EventBConstant> constants;
    private boolean extractingContext = false;
    private Event event;
    private List<Event> refinesForEvent;
    private List<EventBAction> actions;
    private List<EventBGuard> guards;
    private List<EventParameter> parameters;
    private List<Witness> witnesses;
    private boolean extractingEvent = false;
    private final Map<String, Map<String, EventBAxiom>> axiomCache = new HashMap<String, Map<String, EventBAxiom>>();
    private final Map<String, Map<String, EventBInvariant>> invariantCache = new HashMap<String, Map<String, EventBInvariant>>();
    private final Map<String, Map<String, Event>> eventCache = new HashMap<String, Map<String, Event>>();

    public MachineXmlHandler(EventBModel model, String fileName, Set<IFormulaExtension> typeEnv) {
        this.model = model;
        this.typeEnv = typeEnv;
        String name = fileName.substring(fileName.lastIndexOf(File.separatorChar) + 1, fileName.lastIndexOf("."));
        this.directoryPath = fileName.substring(0, fileName.lastIndexOf(File.separatorChar));
        this.machine = new EventBMachine(name);
        this.axiomCache.put(name, new HashMap());
        this.invariantCache.put(name, new HashMap());
        this.eventCache.put(name, new HashMap());
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("org.eventb.core.scRefinesMachine")) {
            this.addRefinedMachine(attributes);
        } else if (qName.equals("org.eventb.core.scSeesContext")) {
            this.addSeesContext(attributes);
        } else if (qName.equals("org.eventb.core.scInternalContext")) {
            this.beginContextExtraction(attributes);
        } else if (this.extractingContext && qName.equals("org.eventb.core.scExtendsContext")) {
            this.addExtendedContext(attributes);
        } else if (this.extractingContext && qName.equals("org.eventb.core.scAxiom")) {
            this.addAxiom(attributes);
        } else if (this.extractingContext && qName.equals("org.eventb.core.scConstant")) {
            this.addConstant(attributes);
        } else if (this.extractingContext && qName.equals("org.eventb.core.scCarrierSet")) {
            this.addSet(attributes);
        } else if (qName.equals("org.eventb.core.scInvariant")) {
            this.addInvariant(attributes);
        } else if (qName.equals("org.eventb.core.scVariable")) {
            this.addVariable(attributes);
        } else if (qName.equals("org.eventb.core.scVariant")) {
            this.addVariant(attributes);
        } else if (qName.equals("org.eventb.core.scEvent")) {
            this.beginEventExtraction(attributes);
        } else if (this.extractingEvent && qName.equals("org.eventb.core.scAction")) {
            this.addAction(attributes);
        } else if (this.extractingEvent && qName.equals("org.eventb.core.scGuard")) {
            this.addGuard(attributes);
        } else if (this.extractingEvent && qName.equals("org.eventb.core.scParameter")) {
            this.addEventParameter(attributes);
        } else if (this.extractingEvent && qName.equals("org.eventb.core.scRefinesEvent")) {
            this.addRefinedEvent(attributes);
        } else if (this.extractingEvent && qName.equals("org.eventb.core.scWitness")) {
            this.addWitness(attributes);
        }
    }

    private void addWitness(Attributes attributes) {
        String name = attributes.getValue("org.eventb.core.label");
        String predicate = attributes.getValue("org.eventb.core.predicate");
        this.witnesses.add(new Witness(name, predicate, this.typeEnv));
    }

    private void addRefinedEvent(Attributes attributes) {
        String target = attributes.getValue("org.eventb.core.scTarget");
        String internalName = target.substring(target.lastIndexOf(35) + 1, target.length());
        internalName = internalName.endsWith("\\\\") ? internalName.substring(0, internalName.length() - 1) : internalName.replace("\\", "");
        String fileSource = target.substring(0, target.indexOf(124));
        String refinedMachineName = fileSource.substring(fileSource.lastIndexOf(47) + 1, fileSource.lastIndexOf(46));
        this.refinesForEvent.add(this.eventCache.get(refinedMachineName).get(internalName));
    }

    private void addEventParameter(Attributes attributes) {
        String name = attributes.getValue("name");
        this.parameters.add(new EventParameter(name));
    }

    private void addGuard(Attributes attributes) {
        String name = attributes.getValue("org.eventb.core.label");
        String predicate = attributes.getValue("org.eventb.core.predicate");
        boolean theorem = "true".equals(attributes.getValue("org.eventb.core.theorem"));
        this.guards.add(new EventBGuard(name, predicate, theorem, this.typeEnv));
    }

    private void addAction(Attributes attributes) {
        String name = attributes.getValue("org.eventb.core.label");
        String assignment = attributes.getValue("org.eventb.core.assignment");
        this.actions.add(new EventBAction(name, assignment, this.typeEnv));
    }

    private void beginEventExtraction(Attributes attributes) {
        String crazyRodinInternalName = attributes.getValue("name");
        String name = attributes.getValue("org.eventb.core.label");
        String convergence = attributes.getValue("org.eventb.core.convergence");
        String extended = attributes.getValue("org.eventb.core.extended");
        Event.EventType eventType = "0".equals(convergence) ? Event.EventType.ORDINARY : ("1".equals(convergence) ? Event.EventType.CONVERGENT : Event.EventType.ANTICIPATED);
        this.event = new Event(name, eventType, Boolean.valueOf(extended));
        this.eventCache.get(this.machine.getName()).put(crazyRodinInternalName, this.event);
        this.extractingEvent = true;
        this.refinesForEvent = new ArrayList<Event>();
        this.guards = new ArrayList<EventBGuard>();
        this.actions = new ArrayList<EventBAction>();
        this.witnesses = new ArrayList<Witness>();
        this.parameters = new ArrayList<EventParameter>();
    }

    private void addVariant(Attributes attributes) {
        String expression = attributes.getValue("org.eventb.core.expression");
        this.variant.add(new Variant(expression, this.typeEnv));
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.extractingContext && qName.equals("org.eventb.core.scInternalContext")) {
            this.endContextExtraction();
        }
        if (this.extractingEvent && qName.equals("org.eventb.core.scEvent")) {
            this.endEventExtraction();
        }
    }

    private void endEventExtraction() {
        this.event = this.event.set(Action.class, new ModelElementList<EventBAction>(this.actions));
        this.event = this.event.set(Guard.class, new ModelElementList<EventBGuard>(this.guards));
        this.event = this.event.set(EventParameter.class, new ModelElementList<EventParameter>(this.parameters));
        this.event = this.event.set(Event.class, new ModelElementList<Event>(this.refinesForEvent));
        this.event = this.event.set(Witness.class, new ModelElementList<Witness>(this.witnesses));
        this.events.add(this.event);
        this.extractingEvent = false;
    }

    private void addVariable(Attributes attributes) {
        String name = attributes.getValue("name");
        boolean concrete = "true".equals(attributes.getValue("org.eventb.core.concrete"));
        String unit = attributes.getValue("de.prob.units.unitPragmaAttribute");
        if (concrete) {
            this.variables.add(new EventBVariable(name, unit));
        }
    }

    private void addRefinedMachine(Attributes attributes) {
        String target = attributes.getValue("org.eventb.core.scTarget");
        String machineName = target.substring(target.lastIndexOf("/") + 1, target.lastIndexOf("."));
        this.model = this.model.addRelationship(this.machine.getName(), machineName, DependencyGraph.ERefType.REFINES);
        AbstractElement component = this.model.getComponent(machineName);
        if (component != null) {
            EventBMachine mch = (EventBMachine)component;
            this.refines.add(mch);
        } else {
            try {
                SAXParserFactory parserFactory = SAXParserFactory.newInstance();
                SAXParser saxParser = parserFactory.newSAXParser();
                String fileName = this.directoryPath + File.separatorChar + machineName + ".bcm";
                MachineXmlHandler handler = new MachineXmlHandler(this.model, fileName, this.typeEnv);
                saxParser.parse(new File(fileName), (DefaultHandler)handler);
                this.axiomCache.putAll(handler.getAxiomCache());
                this.invariantCache.putAll(handler.getInvariantCache());
                this.eventCache.putAll(handler.getEventCache());
                this.refines.add(handler.getMachine());
                this.model = handler.getModel();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void addInvariant(Attributes attributes) {
        String source = attributes.getValue("org.eventb.core.source");
        String internalName = source.substring(source.lastIndexOf(35) + 1, source.length());
        internalName = internalName.replace("\\", "");
        String filePath = source.substring(0, source.indexOf("|"));
        String machineName = filePath.substring(filePath.lastIndexOf("/") + 1, filePath.lastIndexOf("."));
        if (machineName.equals(this.machine.getName())) {
            String label = attributes.getValue("org.eventb.core.label");
            String predicate = attributes.getValue("org.eventb.core.predicate");
            boolean theorem = attributes.getValue("org.eventb.core.theorem").equals("true");
            EventBInvariant inv = new EventBInvariant(label, predicate, (Boolean)theorem, this.typeEnv);
            this.invariants.add(inv);
            this.invariantCache.get(this.machine.getName()).put(internalName, inv);
        } else {
            this.inheritedInvariants.add(this.invariantCache.get(machineName).get(internalName));
        }
    }

    private void addSet(Attributes attributes) {
        String name = attributes.getValue("name");
        this.sets.add(new de.prob.model.representation.Set(new EventB(name)));
    }

    private void addConstant(Attributes attributes) {
        String name = attributes.getValue("name");
        boolean symbolic = "true".equals(attributes.getValue("de.prob.symbolic.symbolicAttribute"));
        String unit = attributes.getValue("de.prob.units.unitPragmaAttribute");
        this.constants.add(new EventBConstant(name, symbolic, unit));
    }

    private void addExtendedContext(Attributes attributes) {
        String source = attributes.getValue("org.eventb.core.scTarget");
        String contextName = source.substring(source.lastIndexOf(35) + 1, source.length());
        this.model.addRelationship(this.internalContext.getName(), contextName, DependencyGraph.ERefType.EXTENDS);
        Context extended = (Context)this.model.getComponent(contextName);
        this.Extends.add(extended);
    }

    private void addAxiom(Attributes attributes) {
        String source = attributes.getValue("org.eventb.core.source");
        String internalName = source.substring(source.lastIndexOf(35) + 1, source.length());
        internalName = internalName.replace("\\", "");
        String filePath = source.substring(0, source.indexOf(124));
        String contextName = filePath.substring(filePath.lastIndexOf("/") + 1, filePath.lastIndexOf("."));
        if (contextName.equals(this.internalContext.getName())) {
            String label = attributes.getValue("org.eventb.core.label");
            String predicate = attributes.getValue("org.eventb.core.predicate");
            boolean theorem = attributes.getValue("org.eventb.core.theorem").equals("true");
            EventBAxiom axiom = new EventBAxiom(label, predicate, theorem, this.typeEnv);
            this.axioms.add(axiom);
            this.axiomCache.get(this.internalContext.getName()).put(internalName, axiom);
        } else {
            this.inheritedAxioms.add(this.axiomCache.get(contextName).get(internalName));
        }
    }

    private void addSeesContext(Attributes attributes) {
        String target = attributes.getValue("org.eventb.core.scTarget");
        String contextName = target.substring(target.lastIndexOf("/") + 1, target.lastIndexOf("."));
        this.model = this.model.addRelationship(this.machine.getName(), contextName, DependencyGraph.ERefType.SEES);
        this.seesNames.add(contextName);
        AbstractElement context = this.model.getComponent(contextName);
        if (context != null) {
            this.sees.add((Context)context);
        }
    }

    private void beginContextExtraction(Attributes attributes) {
        String name = attributes.getValue("name");
        if (this.model.getComponent(name) != null) {
            this.extractingContext = false;
            return;
        }
        this.extractingContext = true;
        this.internalContext = new Context(name);
        this.axiomCache.put(name, new HashMap());
        this.Extends = new ArrayList<Context>();
        this.axioms = new ArrayList<EventBAxiom>();
        this.inheritedAxioms = new ArrayList<EventBAxiom>();
        this.sets = new ArrayList<de.prob.model.representation.Set>();
        this.constants = new ArrayList<EventBConstant>();
    }

    private void endContextExtraction() throws SAXException {
        ModelElementList<EventBAxiom> axms = new ModelElementList<EventBAxiom>(this.inheritedAxioms);
        axms = axms.addMultiple(this.axioms);
        this.internalContext = this.internalContext.set(Axiom.class, axms);
        this.internalContext = this.internalContext.set(Constant.class, new ModelElementList<EventBConstant>(this.constants));
        this.internalContext = this.internalContext.set(Context.class, new ModelElementList<Context>(this.Extends));
        this.internalContext = this.internalContext.set(de.prob.model.representation.Set.class, new ModelElementList<de.prob.model.representation.Set>(this.sets));
        ProofExtractor extractor = new ProofExtractor(this.internalContext, this.directoryPath + File.separatorChar + this.internalContext.getName());
        this.internalContext = this.internalContext.set(ProofObligation.class, extractor.getProofs());
        this.model = this.model.addContext(this.internalContext);
        if (this.seesNames.contains(this.internalContext.getName())) {
            this.sees.add(this.internalContext);
        }
        this.extractingContext = false;
    }

    @Override
    public void endDocument() throws SAXException {
        this.machine = this.machine.set(Event.class, new ModelElementList<Event>(this.events));
        ModelElementList<EventBInvariant> invs = new ModelElementList<EventBInvariant>(this.inheritedInvariants);
        invs = invs.addMultiple(this.invariants);
        this.machine = this.machine.set(Invariant.class, invs);
        this.machine = this.machine.set(Machine.class, new ModelElementList<EventBMachine>(this.refines));
        this.machine = this.machine.set(Context.class, new ModelElementList<Context>(this.sees));
        this.machine = this.machine.set(Variable.class, new ModelElementList<EventBVariable>(this.variables));
        this.machine = this.machine.set(Variant.class, new ModelElementList<Variant>(this.variant));
        this.machine = this.machine.set(BEvent.class, new ModelElementList<Event>(this.events));
        ProofExtractor proofExtractor = new ProofExtractor(this.machine, this.directoryPath + File.separatorChar + this.machine.getName());
        this.machine = this.machine.set(ProofObligation.class, proofExtractor.getProofs());
        this.model = this.model.addMachine(this.machine);
    }

    public Map<String, Map<String, EventBAxiom>> getAxiomCache() {
        return this.axiomCache;
    }

    public Map<String, Map<String, EventBInvariant>> getInvariantCache() {
        return this.invariantCache;
    }

    public Map<String, Map<String, Event>> getEventCache() {
        return this.eventCache;
    }

    public EventBMachine getMachine() {
        return this.machine;
    }

    public EventBModel getModel() {
        return this.model;
    }
}

