/*
 * Decompiled with CFR 0.152.
 */
package de.prob.model.eventb.translate;

import de.be4.classicalb.core.parser.analysis.prolog.ASTProlog;
import de.be4.classicalb.core.parser.analysis.prolog.PositionPrinter;
import de.be4.classicalb.core.parser.node.Node;
import de.be4.classicalb.core.parser.node.Switch;
import de.prob.model.eventb.Context;
import de.prob.model.eventb.EventBConstant;
import de.prob.model.eventb.EventBMachine;
import de.prob.model.eventb.EventBModel;
import de.prob.model.eventb.EventBVariable;
import de.prob.model.eventb.ProofObligation;
import de.prob.model.eventb.theory.Theory;
import de.prob.model.eventb.translate.ContextTranslator;
import de.prob.model.eventb.translate.EventBMachineTranslator;
import de.prob.model.eventb.translate.RodinPosPrinter;
import de.prob.model.eventb.translate.TheoryTranslator;
import de.prob.model.representation.AbstractElement;
import de.prob.model.representation.Machine;
import de.prob.prolog.output.IPrologTermOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class EventBModelTranslator {
    List<EventBMachineTranslator> machineTranslators = new ArrayList<EventBMachineTranslator>();
    List<ContextTranslator> contextTranslators = new ArrayList<ContextTranslator>();
    List<ProofObligation> proofObligations = new ArrayList<ProofObligation>();
    private final TheoryTranslator theoryTranslator;
    private final EventBModel model;

    public EventBModelTranslator(EventBModel model, AbstractElement mainComponent) {
        this.model = model;
        for (Machine machine : this.extractMachineHierarchy(mainComponent, model)) {
            EventBMachine ebM = (EventBMachine)machine;
            this.machineTranslators.add(new EventBMachineTranslator(ebM));
            this.proofObligations.addAll(ebM.getProofs());
        }
        for (Context context : this.extractContextHierarchy(mainComponent, model)) {
            this.contextTranslators.add(new ContextTranslator(context));
            this.proofObligations.addAll(context.getProofs());
        }
        this.theoryTranslator = new TheoryTranslator(model.getChildrenOfType(Theory.class));
    }

    public List<EventBMachine> extractMachineHierarchy(AbstractElement mainComponent, EventBModel model) {
        if (mainComponent instanceof Context) {
            return Collections.emptyList();
        }
        ArrayList<EventBMachine> machines = new ArrayList<EventBMachine>();
        if (mainComponent instanceof EventBMachine) {
            EventBMachine machine = (EventBMachine)mainComponent;
            machines.add(machine);
            machines.addAll(this.extractMachines(machine, model));
        }
        return machines;
    }

    private List<EventBMachine> extractMachines(EventBMachine machine, EventBModel model) {
        if (machine.getRefines().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<EventBMachine> machines = new ArrayList<EventBMachine>();
        for (EventBMachine eventBMachine : machine.getRefines()) {
            EventBMachine refinedMachine = model.getMachine(eventBMachine.getName());
            machines.add(refinedMachine);
            machines.addAll(this.extractMachines(refinedMachine, model));
        }
        return machines;
    }

    public List<Context> extractContextHierarchy(AbstractElement mainComponent, EventBModel model) {
        if (mainComponent instanceof Context) {
            return this.extractContextHierarchy((Context)mainComponent, model);
        }
        if (mainComponent instanceof EventBMachine) {
            return this.extractContextHierarchy((EventBMachine)mainComponent, model);
        }
        return Collections.emptyList();
    }

    private List<Context> extractContextHierarchy(EventBMachine machine, EventBModel model) {
        ArrayList<Context> contexts = new ArrayList<Context>();
        for (Context c : machine.getSees()) {
            Context seenContext = model.getContext(c.getName());
            contexts.add(seenContext);
            List<Context> contextHierarchy = this.extractContextHierarchy(seenContext, model);
            for (Context context : contextHierarchy) {
                if (contexts.contains(context)) continue;
                contexts.add(context);
            }
        }
        return contexts;
    }

    private List<Context> extractContextHierarchy(Context context, EventBModel model) {
        ArrayList<Context> contexts = new ArrayList<Context>();
        contexts.add(context);
        for (Context c : context.getExtends()) {
            Context extendedContext = model.getContext(c.getName());
            contexts.add(extendedContext);
            List<Context> contextHierarchy = this.extractContextHierarchy(extendedContext, model);
            for (Context c2 : contextHierarchy) {
                if (contexts.contains(c2)) continue;
                contexts.add(c2);
            }
        }
        return contexts;
    }

    public void printProlog(IPrologTermOutput pto) {
        RodinPosPrinter labelPrinter = new RodinPosPrinter();
        ArrayList<Node> machineNodes = new ArrayList<Node>();
        ArrayList<Node> contextNodes = new ArrayList<Node>();
        for (EventBMachineTranslator trans : this.machineTranslators) {
            machineNodes.add(trans.translateMachine());
            labelPrinter.addNodeInfos(trans.getNodeInfos());
        }
        for (ContextTranslator t : this.contextTranslators) {
            contextNodes.add(t.translateContext());
            labelPrinter.addNodeInfos(t.getNodeInfos());
        }
        ASTProlog printer = new ASTProlog(pto, (PositionPrinter)labelPrinter);
        pto.openTerm("load_event_b_project");
        pto.openList();
        for (Node node : machineNodes) {
            node.apply((Switch)printer);
        }
        pto.closeList();
        pto.openList();
        for (Node node : contextNodes) {
            node.apply((Switch)printer);
        }
        pto.closeList();
        pto.openList();
        pto.openTerm("exporter_version");
        pto.printNumber(3L);
        pto.closeTerm();
        for (ProofObligation po : this.proofObligations) {
            po.toProlog(pto);
        }
        this.theoryTranslator.toProlog(pto);
        this.printPragmas(pto);
        pto.closeList();
        pto.printVariable("_Error");
        pto.closeTerm();
    }

    private void printPragmas(IPrologTermOutput pto) {
        for (Machine machine : this.model.getChildrenOfType(Machine.class)) {
            EventBMachine ebM = (EventBMachine)machine;
            for (EventBVariable var : ebM.getVariables()) {
                if (!var.hasUnit()) continue;
                pto.openTerm("pragma");
                pto.printAtom("unit");
                pto.printAtom(machine.getName());
                pto.printAtom(var.getName());
                pto.openList();
                pto.printAtom(var.getUnit());
                pto.closeList();
                pto.closeTerm();
            }
        }
        for (Context context : this.model.getChildrenOfType(Context.class)) {
            for (EventBConstant constant : context.getConstants()) {
                if (!constant.hasUnit()) continue;
                pto.openTerm("pragma");
                pto.printAtom("unit");
                pto.printAtom(context.getName());
                pto.printAtom(constant.getName());
                pto.openList();
                pto.printAtom(constant.getUnit());
                pto.closeList();
                pto.closeTerm();
            }
        }
    }
}

