/*
 * Decompiled with CFR 0.152.
 */
package de.prob.model.eventb.theory;

import com.google.common.base.Objects;
import de.prob.animator.domainobjects.EventB;
import de.prob.model.eventb.theory.IOperatorDefinition;
import de.prob.model.eventb.theory.OperatorArgument;
import de.prob.model.representation.AbstractElement;
import de.prob.model.representation.ModelElementList;
import de.prob.unicode.UnicodeTranslator;
import java.util.List;
import java.util.Set;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.ExtendedExpression;
import org.eventb.core.ast.ExtendedPredicate;
import org.eventb.core.ast.Predicate;
import org.eventb.core.ast.Type;
import org.eventb.core.ast.extension.ExtensionFactory;
import org.eventb.core.ast.extension.IArity;
import org.eventb.core.ast.extension.ICompatibilityMediator;
import org.eventb.core.ast.extension.IExpressionExtension;
import org.eventb.core.ast.extension.IExtendedFormula;
import org.eventb.core.ast.extension.IExtensionKind;
import org.eventb.core.ast.extension.IFormulaExtension;
import org.eventb.core.ast.extension.IOperatorProperties;
import org.eventb.core.ast.extension.IPredicateExtension;
import org.eventb.core.ast.extension.IPriorityMediator;
import org.eventb.core.ast.extension.ITypeCheckMediator;
import org.eventb.core.ast.extension.ITypeMediator;
import org.eventb.core.ast.extension.IWDMediator;
import org.eventb.internal.core.ast.extension.ExtensionKind;

public class Operator
extends AbstractElement {
    private final boolean associative;
    private final IOperatorProperties.FormulaType formulaType;
    private final IOperatorProperties.Notation notation;
    private final boolean commutative;
    private IOperatorDefinition definition;
    private final String theoryName;
    private IFormulaExtension extension;
    private final ModelElementList<OperatorArgument> operatorArguments;
    private final String groupId;
    private final EventB wd;
    private final EventB type;
    private final EventB predicate;
    private EventB syntax;

    public Operator(String theoryName, String operator, boolean associative, boolean commutative, boolean formulaType, String notationType, String groupId, String type, String wd, String predicate, Set<IFormulaExtension> typeEnv) {
        this(theoryName, new EventB(operator, typeEnv), associative, commutative, formulaType ? IOperatorProperties.FormulaType.EXPRESSION : IOperatorProperties.FormulaType.PREDICATE, notationType.equals("PREFIX") ? IOperatorProperties.Notation.PREFIX : (notationType.equals("INFIX") ? IOperatorProperties.Notation.INFIX : IOperatorProperties.Notation.POSTFIX), groupId, type == null ? null : new EventB(type, typeEnv), new EventB(wd, typeEnv), new EventB(predicate, typeEnv), null, null);
    }

    public Operator(String theoryName, EventB syntax, boolean associative, boolean commutative, IOperatorProperties.FormulaType formulaType, IOperatorProperties.Notation notationType, String groupId, EventB type, EventB wd, EventB predicate, ModelElementList<OperatorArgument> operatorArguments, IOperatorDefinition definition) {
        this.theoryName = theoryName;
        this.groupId = groupId;
        this.syntax = syntax;
        this.associative = associative;
        this.commutative = commutative;
        this.formulaType = formulaType;
        this.notation = notationType;
        this.type = type;
        this.wd = wd;
        this.predicate = predicate;
        this.definition = definition;
        this.operatorArguments = operatorArguments;
    }

    public Operator addArguments(ModelElementList<OperatorArgument> arguments) {
        return new Operator(this.theoryName, this.syntax, this.associative, this.commutative, this.formulaType, this.notation, this.groupId, this.type, this.wd, this.predicate, arguments, this.definition);
    }

    public EventB getSyntax() {
        return this.syntax;
    }

    public boolean isAssociative() {
        return this.associative;
    }

    public boolean isCommutative() {
        return this.commutative;
    }

    public IOperatorProperties.FormulaType getFormulaType() {
        return this.formulaType;
    }

    public IOperatorProperties.Notation getNotation() {
        return this.notation;
    }

    public IOperatorDefinition getDefinition() {
        return this.definition;
    }

    public Operator setDefinition(IOperatorDefinition definition) {
        return new Operator(this.theoryName, this.syntax, this.associative, this.commutative, this.formulaType, this.notation, this.groupId, this.type, this.wd, this.predicate, this.operatorArguments, definition);
    }

    public List<OperatorArgument> getArguments() {
        return this.operatorArguments;
    }

    public String getParentTheory() {
        return this.theoryName;
    }

    public EventB getWD() {
        return this.wd;
    }

    public EventB getPredicate() {
        return this.predicate;
    }

    public EventB getType() {
        return this.type;
    }

    public String toString() {
        return this.syntax.getCode();
    }

    public IFormulaExtension getFormulaExtension() {
        if (this.extension == null) {
            this.extension = this.formulaType.equals((Object)IOperatorProperties.FormulaType.PREDICATE) ? new PredicateOperatorExtension(this.syntax) : new ExpressionOperatorExtension(this.syntax);
        }
        return this.extension;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Operator other = (Operator)obj;
        return Objects.equal((Object)this.syntax, (Object)other.syntax) && Objects.equal((Object)this.theoryName, (Object)other.theoryName);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.syntax, this.theoryName});
    }

    private class ExpressionOperatorExtension
    extends OperatorExtension
    implements IExpressionExtension {
        public ExpressionOperatorExtension(EventB syntax) {
            super(syntax);
        }

        public Type synthesizeType(Expression[] childExprs, Predicate[] childPreds, ITypeMediator mediator) {
            return null;
        }

        public boolean verifyType(Type proposedType, Expression[] childExprs, Predicate[] childPreds) {
            return true;
        }

        public Type typeCheck(ExtendedExpression expression, ITypeCheckMediator tcMediator) {
            return null;
        }

        public boolean isATypeConstructor() {
            return false;
        }
    }

    private class PredicateOperatorExtension
    extends OperatorExtension
    implements IPredicateExtension {
        public PredicateOperatorExtension(EventB syntax) {
            super(syntax);
        }

        public void typeCheck(ExtendedPredicate predicate, ITypeCheckMediator tcMediator) {
        }
    }

    private class OperatorExtension
    implements IFormulaExtension {
        private final String unicode;

        public OperatorExtension(EventB syntax) {
            this.unicode = UnicodeTranslator.toUnicode((String)syntax.getCode());
        }

        public String getSyntaxSymbol() {
            return this.unicode;
        }

        public Predicate getWDPredicate(IExtendedFormula formula, IWDMediator wdMediator) {
            return wdMediator.makeTrueWD();
        }

        public boolean conjoinChildrenWD() {
            return true;
        }

        public String getId() {
            return Operator.this.theoryName + "." + this.unicode;
        }

        public String getGroupId() {
            return Operator.this.groupId;
        }

        public IExtensionKind getKind() {
            if (Operator.this.formulaType.equals((Object)IOperatorProperties.FormulaType.EXPRESSION) && Operator.this.notation.equals((Object)IOperatorProperties.Notation.INFIX) && Operator.this.associative) {
                return new ExtensionKind(Operator.this.notation, Operator.this.formulaType, ExtensionFactory.TWO_OR_MORE_EXPRS, true);
            }
            return new ExtensionKind(Operator.this.notation, Operator.this.formulaType, ExtensionFactory.makeAllExpr((IArity)ExtensionFactory.makeArity((int)Operator.this.getArguments().size(), (int)Operator.this.getArguments().size())), false);
        }

        public Object getOrigin() {
            return null;
        }

        public void addCompatibilities(ICompatibilityMediator mediator) {
        }

        public void addPriorities(IPriorityMediator mediator) {
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof OperatorExtension) {
                return ((OperatorExtension)obj).getId().equals(this.getId());
            }
            return false;
        }

        public int hashCode() {
            return this.getId().hashCode();
        }

        public String toString() {
            return "operator " + this.getSyntaxSymbol();
        }
    }
}

