/*
 * Decompiled with CFR 0.152.
 */
package de.prob.model.classicalb;

import com.google.common.base.Joiner;
import de.be4.classicalb.core.parser.analysis.DepthFirstAdapter;
import de.be4.classicalb.core.parser.node.AAssertionsMachineClause;
import de.be4.classicalb.core.parser.node.AConstantsMachineClause;
import de.be4.classicalb.core.parser.node.AConstraintsMachineClause;
import de.be4.classicalb.core.parser.node.ADeferredSetSet;
import de.be4.classicalb.core.parser.node.AEnumeratedSetSet;
import de.be4.classicalb.core.parser.node.AExpressionParseUnit;
import de.be4.classicalb.core.parser.node.AIdentifierExpression;
import de.be4.classicalb.core.parser.node.AInvariantMachineClause;
import de.be4.classicalb.core.parser.node.AMachineHeader;
import de.be4.classicalb.core.parser.node.AOperation;
import de.be4.classicalb.core.parser.node.APreconditionSubstitution;
import de.be4.classicalb.core.parser.node.APredicateParseUnit;
import de.be4.classicalb.core.parser.node.APropertiesMachineClause;
import de.be4.classicalb.core.parser.node.ASelectSubstitution;
import de.be4.classicalb.core.parser.node.ASubstitutionParseUnit;
import de.be4.classicalb.core.parser.node.AVariablesMachineClause;
import de.be4.classicalb.core.parser.node.EOF;
import de.be4.classicalb.core.parser.node.Node;
import de.be4.classicalb.core.parser.node.PExpression;
import de.be4.classicalb.core.parser.node.PParseUnit;
import de.be4.classicalb.core.parser.node.PPredicate;
import de.be4.classicalb.core.parser.node.PSubstitution;
import de.be4.classicalb.core.parser.node.Start;
import de.be4.classicalb.core.parser.node.Switch;
import de.be4.classicalb.core.parser.node.TIdentifierLiteral;
import de.prob.animator.domainobjects.ClassicalB;
import de.prob.model.classicalb.Assertion;
import de.prob.model.classicalb.ClassicalBAction;
import de.prob.model.classicalb.ClassicalBConstant;
import de.prob.model.classicalb.ClassicalBGuard;
import de.prob.model.classicalb.ClassicalBInvariant;
import de.prob.model.classicalb.ClassicalBMachine;
import de.prob.model.classicalb.ClassicalBVariable;
import de.prob.model.classicalb.Constraint;
import de.prob.model.classicalb.Operation;
import de.prob.model.classicalb.Parameter;
import de.prob.model.classicalb.PredicateConjunctionSplitter;
import de.prob.model.classicalb.Property;
import de.prob.model.representation.Action;
import de.prob.model.representation.BEvent;
import de.prob.model.representation.Constant;
import de.prob.model.representation.Guard;
import de.prob.model.representation.Invariant;
import de.prob.model.representation.ModelElementList;
import de.prob.model.representation.Set;
import de.prob.model.representation.Variable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class DomBuilder
extends DepthFirstAdapter {
    private static final EOF EOF = new EOF();
    private String name;
    private final List<Parameter> parameters = new ArrayList<Parameter>();
    private final List<Constraint> constraints = new ArrayList<Constraint>();
    private final List<ClassicalBConstant> constants = new ArrayList<ClassicalBConstant>();
    private final List<Property> properties = new ArrayList<Property>();
    private final List<ClassicalBVariable> variables = new ArrayList<ClassicalBVariable>();
    private final List<ClassicalBInvariant> invariants = new ArrayList<ClassicalBInvariant>();
    private final List<Set> sets = new ArrayList<Set>();
    private final List<Assertion> assertions = new ArrayList<Assertion>();
    private final List<Operation> operations = new ArrayList<Operation>();
    private final java.util.Set<String> usedIds = new HashSet<String>();
    private String prefix;
    private LinkedList<TIdentifierLiteral> machineId;

    public DomBuilder(String prefix) {
        this.prefix = prefix;
    }

    public void outStart(Start node) {
        super.outStart(node);
    }

    public ClassicalBMachine build(Start ast) {
        ((Start)ast.clone()).apply((Switch)this);
        return this.getMachine();
    }

    public LinkedList<TIdentifierLiteral> getMachineId() {
        return this.machineId;
    }

    public ClassicalBMachine getMachine() {
        ClassicalBMachine machine = new ClassicalBMachine(this.name);
        machine = machine.set(Assertion.class, new ModelElementList<Assertion>(this.assertions));
        machine = machine.set(Constant.class, new ModelElementList<ClassicalBConstant>(this.constants));
        machine = machine.set(Constraint.class, new ModelElementList<Constraint>(this.constraints));
        machine = machine.set(Property.class, new ModelElementList<Property>(this.properties));
        machine = machine.set(Invariant.class, new ModelElementList<ClassicalBInvariant>(this.invariants));
        machine = machine.set(Parameter.class, new ModelElementList<Parameter>(this.parameters));
        machine = machine.set(Set.class, new ModelElementList<Set>(this.sets));
        machine = machine.set(Variable.class, new ModelElementList<ClassicalBVariable>(this.variables));
        machine = machine.set(BEvent.class, new ModelElementList<Operation>(this.operations));
        return machine;
    }

    public void outAMachineHeader(AMachineHeader node) {
        this.name = this.extractIdentifierName(node.getName());
        this.machineId = node.getName();
        if (this.prefix != null && !this.prefix.equals(this.name)) {
            this.name = this.prefix + "." + this.name;
        }
        for (PExpression expression : node.getParameters()) {
            this.parameters.add(new Parameter(this.createExpressionAST(expression)));
        }
    }

    public void outAConstraintsMachineClause(AConstraintsMachineClause node) {
        List<PPredicate> predicates = this.getPredicates((Node)node);
        for (PPredicate pPredicate : predicates) {
            this.constraints.add(new Constraint(this.createPredicateAST(pPredicate)));
        }
    }

    public void outAConstantsMachineClause(AConstantsMachineClause node) {
        for (PExpression pExpression : node.getIdentifiers()) {
            this.constants.add(new ClassicalBConstant(this.createExpressionAST(pExpression)));
        }
    }

    public void outAPropertiesMachineClause(APropertiesMachineClause node) {
        for (PPredicate pPredicate : this.getPredicates((Node)node)) {
            this.properties.add(new Property(this.createPredicateAST(pPredicate)));
        }
    }

    public void outAVariablesMachineClause(AVariablesMachineClause node) {
        for (PExpression pExpression : node.getIdentifiers()) {
            if (this.prefix != null) {
                this.usedIds.add(((TIdentifierLiteral)((AIdentifierExpression)pExpression).getIdentifier().get(0)).getText());
            }
            this.variables.add(new ClassicalBVariable(this.createExpressionAST(pExpression)));
        }
    }

    public void outAInvariantMachineClause(AInvariantMachineClause node) {
        List<PPredicate> predicates = this.getPredicates((Node)node);
        for (PPredicate pPredicate : predicates) {
            this.invariants.add(new ClassicalBInvariant(this.createPredicateAST(pPredicate)));
        }
    }

    public void outADeferredSetSet(ADeferredSetSet node) {
        this.sets.add(new Set(new ClassicalB(this.extractIdentifierName(node.getIdentifier()))));
    }

    public void outAEnumeratedSetSet(AEnumeratedSetSet node) {
        this.sets.add(new Set(new ClassicalB(this.extractIdentifierName(node.getIdentifier()))));
    }

    public void outAAssertionsMachineClause(AAssertionsMachineClause node) {
        for (PPredicate pPredicate : this.getPredicates((Node)node)) {
            this.assertions.add(new Assertion(this.createPredicateAST(pPredicate)));
        }
    }

    public void inAOperation(AOperation node) {
        List<PPredicate> predicates;
        PPredicate condition;
        String name = this.extractIdentifierName(node.getOpName());
        if (this.prefix != null && !this.prefix.equals(name)) {
            name = this.prefix + "." + name;
        }
        LinkedList paramIds = node.getParameters();
        List<String> params = this.extractIdentifiers(paramIds);
        List<String> output = this.extractIdentifiers(node.getReturnValues());
        Operation operation = new Operation(name, params, output);
        PSubstitution body = node.getOperationBody();
        ArrayList<ClassicalBGuard> guards = new ArrayList<ClassicalBGuard>();
        if (body instanceof ASelectSubstitution) {
            condition = ((ASelectSubstitution)body).getCondition();
            predicates = this.getPredicates((Node)condition);
            for (PPredicate pPredicate : predicates) {
                guards.add(new ClassicalBGuard(this.createPredicateAST(pPredicate)));
            }
        }
        if (body instanceof APreconditionSubstitution) {
            condition = ((APreconditionSubstitution)body).getPredicate();
            predicates = this.getPredicates((Node)condition);
            for (PPredicate pPredicate : predicates) {
                guards.add(new ClassicalBGuard(this.createPredicateAST(pPredicate)));
            }
        }
        ArrayList<ClassicalBAction> actions = new ArrayList<ClassicalBAction>();
        actions.add(new ClassicalBAction(this.createSubstitutionAST(body)));
        operation = operation.set(Action.class, new ModelElementList(actions));
        operation = operation.set(Guard.class, new ModelElementList(guards));
        this.operations.add(operation);
    }

    private String extractIdentifierName(LinkedList<TIdentifierLiteral> nameL) {
        String text;
        if (nameL.size() == 1) {
            text = nameL.get(0).getText();
        } else {
            ArrayList<String> list = new ArrayList<String>();
            for (TIdentifierLiteral t : nameL) {
                list.add(t.getText());
            }
            text = Joiner.on((String)".").join(list);
        }
        return text;
    }

    private List<String> extractIdentifiers(LinkedList<PExpression> identifiers) {
        ArrayList<String> params = new ArrayList<String>();
        for (PExpression pExpression : identifiers) {
            if (!(pExpression instanceof AIdentifierExpression)) continue;
            params.add(this.extractIdentifierName(((AIdentifierExpression)pExpression).getIdentifier()));
        }
        return params;
    }

    private List<PPredicate> getPredicates(Node node) {
        PredicateConjunctionSplitter s = new PredicateConjunctionSplitter();
        node.apply((Switch)s);
        return s.getPredicates();
    }

    private Start createExpressionAST(PExpression expression) {
        Start start = new Start();
        AExpressionParseUnit node = new AExpressionParseUnit();
        start.setPParseUnit((PParseUnit)node);
        start.setEOF(EOF);
        node.setExpression((PExpression)expression.clone());
        node.getExpression().apply((Switch)new RenameIdentifiers());
        return start;
    }

    private Start createPredicateAST(PPredicate pPredicate) {
        Start start = new Start();
        APredicateParseUnit node2 = new APredicateParseUnit();
        start.setPParseUnit((PParseUnit)node2);
        start.setEOF(EOF);
        node2.setPredicate((PPredicate)pPredicate.clone());
        node2.getPredicate().apply((Switch)new RenameIdentifiers());
        return start;
    }

    private Start createSubstitutionAST(PSubstitution pSub) {
        Start start = new Start();
        ASubstitutionParseUnit node2 = new ASubstitutionParseUnit();
        start.setPParseUnit((PParseUnit)node2);
        start.setEOF(EOF);
        node2.setSubstitution((PSubstitution)pSub.clone());
        node2.getSubstitution().apply((Switch)new RenameIdentifiers());
        return start;
    }

    private class RenameIdentifiers
    extends DepthFirstAdapter {
        private RenameIdentifiers() {
        }

        public void inAIdentifierExpression(AIdentifierExpression node) {
            if (DomBuilder.this.prefix != null) {
                String id = ((TIdentifierLiteral)node.getIdentifier().get(0)).getText();
                if (DomBuilder.this.usedIds.contains(id)) {
                    node.getIdentifier().set(0, new TIdentifierLiteral(DomBuilder.this.prefix + "." + id));
                }
            }
        }
    }
}

