/*
 * Decompiled with CFR 0.152.
 */
package de.prob.model.classicalb;

import com.google.common.base.Joiner;
import de.be4.classicalb.core.parser.analysis.DepthFirstAdapter;
import de.be4.classicalb.core.parser.node.AIdentifierExpression;
import de.be4.classicalb.core.parser.node.AImplementationMachineParseUnit;
import de.be4.classicalb.core.parser.node.AImportsMachineClause;
import de.be4.classicalb.core.parser.node.AMachineReference;
import de.be4.classicalb.core.parser.node.ARefinementMachineParseUnit;
import de.be4.classicalb.core.parser.node.ASeesMachineClause;
import de.be4.classicalb.core.parser.node.AUsesMachineClause;
import de.be4.classicalb.core.parser.node.PExpression;
import de.be4.classicalb.core.parser.node.PMachineReference;
import de.be4.classicalb.core.parser.node.Start;
import de.be4.classicalb.core.parser.node.Switch;
import de.be4.classicalb.core.parser.node.TIdentifierLiteral;
import de.prob.model.classicalb.ClassicalBMachine;
import de.prob.model.classicalb.DomBuilder;
import de.prob.model.representation.DependencyGraph;
import de.prob.model.representation.ModelElementList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DependencyWalker
extends DepthFirstAdapter {
    private DependencyGraph graph;
    private final String prefix;
    private final String name;
    private final Map<String, Start> map;
    private ModelElementList<ClassicalBMachine> machines;
    private Set<LinkedList<TIdentifierLiteral>> machineIds = new HashSet<LinkedList<TIdentifierLiteral>>();

    public DependencyWalker(LinkedList<TIdentifierLiteral> machine, ModelElementList<ClassicalBMachine> machines, DependencyGraph graph, Map<String, Start> map) {
        this.name = this.extractMachineName(machine);
        this.prefix = this.extractMachinePrefix(machine);
        this.machines = machines;
        this.graph = graph;
        this.map = map;
    }

    public void caseASeesMachineClause(ASeesMachineClause node) {
        this.registerMachineNames(node.getMachineNames(), DependencyGraph.ERefType.SEES);
    }

    public void caseAUsesMachineClause(AUsesMachineClause node) {
        this.registerMachineNames(node.getMachineNames(), DependencyGraph.ERefType.USES);
    }

    public void caseAImportsMachineClause(AImportsMachineClause node) {
        LinkedList machineReferences = node.getMachineReferences();
        for (PMachineReference r : machineReferences) {
            String dest = this.extractMachineName(((AMachineReference)r).getMachineName());
            this.addMachine(dest, this.prefix, DependencyGraph.ERefType.IMPORTS);
        }
    }

    public void caseAMachineReference(AMachineReference node) {
        String dest = this.extractMachineName(node.getMachineName());
        String prefix = this.extractMachinePrefix(node.getMachineName());
        this.addMachine(dest, this.concat(this.prefix, prefix), DependencyGraph.ERefType.INCLUDES);
    }

    public void outARefinementMachineParseUnit(ARefinementMachineParseUnit node) {
        this.registerRefinementMachine(node.getRefMachine());
    }

    public void outAImplementationMachineParseUnit(AImplementationMachineParseUnit node) {
        this.registerRefinementMachine(node.getRefMachine());
    }

    private void registerRefinementMachine(TIdentifierLiteral refMachine) {
        String dest = refMachine.getText();
        this.addMachine(dest, this.prefix, DependencyGraph.ERefType.REFINES);
    }

    private void registerMachineNames(List<PExpression> machineNames, DependencyGraph.ERefType depType) {
        for (PExpression machineName : machineNames) {
            if (!(machineName instanceof AIdentifierExpression)) continue;
            AIdentifierExpression identifier = (AIdentifierExpression)machineName;
            String dest = this.extractMachineName(identifier.getIdentifier());
            this.addMachine(dest, depType == DependencyGraph.ERefType.USES ? dest : this.prefix, depType);
        }
    }

    private String extractMachineName(LinkedList<TIdentifierLiteral> list) {
        this.machineIds.add(list);
        return list.getLast().getText();
    }

    private String extractMachinePrefix(LinkedList<TIdentifierLiteral> list) {
        if (list.size() > 1) {
            List subList = list.subList(0, list.size() - 1);
            ArrayList<String> names = new ArrayList<String>();
            for (TIdentifierLiteral tIdentifierLiteral : subList) {
                names.add(tIdentifierLiteral.getText());
            }
            return Joiner.on((String)".").join(names);
        }
        return null;
    }

    private ClassicalBMachine makeMachine(String dest, String prefix) {
        DomBuilder builder = new DomBuilder(prefix);
        Start start = this.map.get(dest);
        start.apply((Switch)builder);
        return builder.getMachine();
    }

    private void addMachine(String dest, String prefix, DependencyGraph.ERefType refType) {
        ClassicalBMachine newMachine = this.makeMachine(dest, prefix);
        String name = newMachine.getName();
        this.machines = this.machines.addElement(newMachine);
        this.graph = this.graph.addEdge(this.concat(this.prefix, this.name), name, refType);
    }

    public String concat(String prefix, String name) {
        if (prefix == null) {
            return name;
        }
        return prefix + "." + name;
    }

    public ModelElementList<ClassicalBMachine> getMachines() {
        return this.machines;
    }

    public DependencyGraph getGraph() {
        return this.graph;
    }

    public Set<LinkedList<TIdentifierLiteral>> getMachineIds() {
        return this.machineIds;
    }
}

