/*
 * Decompiled with CFR 0.152.
 */
package de.prob.cli;

import com.google.inject.Inject;
import com.google.inject.Provider;
import de.prob.annotations.Home;
import de.prob.cli.ModuleCli;
import de.prob.cli.OsSpecificInfo;
import de.prob.cli.ProcessHandle;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PrologProcessProvider
implements Provider<ProcessHandle> {
    private final Logger logger = LoggerFactory.getLogger(PrologProcessProvider.class);
    private final String debuggingKey;
    private final String dir;
    private final OsSpecificInfo osInfo;

    public ProcessHandle get() {
        return this.makeProcess();
    }

    @Inject
    public PrologProcessProvider(OsSpecificInfo osInfo, @ModuleCli.DebuggingKey String debuggingKey, @Home String path) {
        this.osInfo = osInfo;
        this.debuggingKey = debuggingKey;
        this.dir = this.checkCliPath(path);
    }

    private ProcessHandle makeProcess() {
        String executable = this.dir + this.osInfo.getCliName();
        List<String> command = this.makeCommand(executable);
        Process prologProcess = null;
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.command(command);
        pb.environment().put("PROB_DEBUGGING_KEY", this.debuggingKey);
        pb.environment().put("TRAILSTKSIZE", "1M");
        pb.environment().put("PROLOGINCSIZE", "50M");
        pb.environment().put("PROB_HOME", this.dir);
        pb.redirectErrorStream(true);
        try {
            this.logger.info("Starting ProB's Prolog Core. Path is {}", (Object)executable);
            prologProcess = pb.start();
            this.logger.debug("Cli started");
        }
        catch (IOException e) {
            String msg = "Problem while starting up ProB CLI. Tried to execute: " + executable;
            this.logger.error(msg, (Throwable)e);
            return null;
        }
        if (prologProcess == null) {
            this.logger.error("CLI Process is null. Cannot start Prolog part of ProB.");
            return null;
        }
        this.setShutdownHook(prologProcess);
        return new ProcessHandle(prologProcess, this.debuggingKey);
    }

    private void setShutdownHook(final Process p) {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                p.destroy();
            }
        }));
    }

    private List<String> makeCommand(String executable) {
        ArrayList<String> command = new ArrayList<String>();
        if (this.osInfo.getHelperCmd() != null) {
            command.add(this.osInfo.getHelperCmd());
        }
        command.add(executable);
        command.add("-sf");
        return command;
    }

    private String checkCliPath(String dirname) {
        File dir = new File(dirname);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dirname;
    }
}

