/*
 * Decompiled with CFR 0.152.
 */
package de.prob.check;

import de.prob.animator.command.LtlCheckingCommand;
import de.prob.animator.domainobjects.AbstractEvalResult;
import de.prob.animator.domainobjects.LTL;
import de.prob.check.IModelCheckingResult;
import de.prob.statespace.ITraceDescription;
import de.prob.statespace.StateSpace;
import de.prob.statespace.Trace;
import de.prob.statespace.Transition;
import java.util.ArrayList;
import java.util.List;

public class LTLCounterExample
extends AbstractEvalResult
implements IModelCheckingResult,
ITraceDescription {
    private final LTL formula;
    private final List<Transition> pathToCE;
    private final List<Transition> counterExample;
    private final int loopEntry;
    private final LtlCheckingCommand.PathType pathType;

    public LTLCounterExample(LTL formula, List<Transition> pathToCE, List<Transition> counterExample, int loopEntry, LtlCheckingCommand.PathType pathType) {
        this.formula = formula;
        this.pathToCE = pathToCE;
        this.counterExample = counterExample;
        this.loopEntry = loopEntry;
        this.pathType = pathType;
    }

    public Transition getLoopEntry() {
        if (this.loopEntry == -1) {
            return null;
        }
        return this.counterExample.get(this.loopEntry);
    }

    public LtlCheckingCommand.PathType getPathType() {
        return this.pathType;
    }

    public List<Transition> getOpList() {
        ArrayList<Transition> ops = new ArrayList<Transition>();
        ops.addAll(this.pathToCE);
        ops.addAll(this.counterExample);
        return ops;
    }

    public String getCode() {
        return this.formula.getCode();
    }

    @Override
    public String getMessage() {
        return "LTL counterexample found";
    }

    @Override
    public Trace getTrace(StateSpace s) {
        Trace t = new Trace(s);
        t = t.addTransitions(this.pathToCE);
        t = t.addTransitions(this.counterExample);
        return t;
    }

    public String toString() {
        return this.getMessage();
    }
}

