/*
 * Decompiled with CFR 0.152.
 */
package de.prob.check;

import de.be4.ltl.core.parser.LtlParseException;
import de.prob.animator.command.AbstractCommand;
import de.prob.animator.command.LTLCheckingJob;
import de.prob.animator.domainobjects.LTL;
import de.prob.check.IModelCheckJob;
import de.prob.check.IModelCheckListener;
import de.prob.check.IModelCheckingResult;
import de.prob.check.ModelChecker;
import de.prob.check.NotYetFinished;
import de.prob.model.eventb.EventBModel;
import de.prob.statespace.StateSpace;

public class LTLChecker
implements IModelCheckJob {
    private final StateSpace s;
    private final IModelCheckListener ui;
    private final String jobId;
    private final LTLCheckingJob job;

    public LTLChecker(StateSpace s, String formula) throws LtlParseException {
        this(s, s.getModel() instanceof EventBModel ? LTL.parseEventB(formula) : new LTL(formula));
    }

    public LTLChecker(StateSpace s, LTL formula) {
        this(s, formula, null);
    }

    public LTLChecker(StateSpace s, LTL formula, IModelCheckListener ui) {
        if (formula == null) {
            throw new IllegalArgumentException("Cannot perform LTL checking without a correctly parsed LTL Formula");
        }
        this.s = s;
        this.ui = ui;
        this.jobId = ModelChecker.generateJobId();
        this.job = new LTLCheckingJob(s, formula, this.jobId, ui);
    }

    @Override
    public IModelCheckingResult call() throws Exception {
        long time = System.currentTimeMillis();
        this.s.execute((AbstractCommand)this.job);
        IModelCheckingResult result = this.job.getResult();
        if (this.ui != null) {
            this.ui.isFinished(this.jobId, System.currentTimeMillis() - time, result, null);
        }
        return result;
    }

    @Override
    public IModelCheckingResult getResult() {
        if (this.job.getResult() == null) {
            return new NotYetFinished("No result was calculated", -1);
        }
        return this.job.getResult();
    }

    @Override
    public String getJobId() {
        return this.jobId;
    }

    @Override
    public StateSpace getStateSpace() {
        return this.s;
    }
}

