/*
 * Decompiled with CFR 0.152.
 */
package de.prob.check;

import de.prob.animator.command.AbstractCommand;
import de.prob.animator.command.ModelCheckingJob;
import de.prob.animator.command.SetBGoalCommand;
import de.prob.animator.domainobjects.IEvalElement;
import de.prob.check.CheckError;
import de.prob.check.IModelCheckJob;
import de.prob.check.IModelCheckListener;
import de.prob.check.IModelCheckingResult;
import de.prob.check.ModelChecker;
import de.prob.check.ModelCheckingOptions;
import de.prob.check.NotYetFinished;
import de.prob.exception.ProBError;
import de.prob.statespace.StateSpace;

public class ConsistencyChecker
implements IModelCheckJob {
    private final StateSpace s;
    private final String jobId;
    private final IModelCheckListener ui;
    private final ModelCheckingJob job;
    private final IEvalElement goal;
    private final ModelCheckingOptions options;

    public ConsistencyChecker(StateSpace s) {
        this(s, ModelCheckingOptions.DEFAULT);
    }

    public ConsistencyChecker(StateSpace s, ModelCheckingOptions options) {
        this(s, options, null);
    }

    public ConsistencyChecker(StateSpace s, ModelCheckingOptions options, IEvalElement goal) {
        this(s, options, goal, null);
    }

    public ConsistencyChecker(StateSpace s, ModelCheckingOptions options, IEvalElement goal, IModelCheckListener ui) {
        this.s = s;
        this.options = options;
        this.goal = goal;
        this.ui = ui;
        this.jobId = ModelChecker.generateJobId();
        this.job = new ModelCheckingJob(options, this.jobId, ui);
    }

    @Override
    public IModelCheckingResult call() throws Exception {
        long time = System.currentTimeMillis();
        if (this.goal != null) {
            try {
                SetBGoalCommand cmd = new SetBGoalCommand(this.goal);
                this.s.execute((AbstractCommand)cmd);
            }
            catch (ProBError e) {
                return new CheckError("Type error in specified goal.");
            }
        } else if (this.options.getPrologOptions().contains((Object)ModelCheckingOptions.Options.find_goal)) {
            return new CheckError("Cannot search for goal because no goal is specified.");
        }
        this.s.execute((AbstractCommand)this.job);
        IModelCheckingResult result = this.job.getResult();
        if (this.ui != null) {
            this.ui.isFinished(this.jobId, System.currentTimeMillis() - time, result, this.job.getStats());
        }
        return result;
    }

    @Override
    public IModelCheckingResult getResult() {
        if (this.job.getResult() == null) {
            return new NotYetFinished("No result was calculated", -1);
        }
        return this.job.getResult();
    }

    @Override
    public String getJobId() {
        return this.jobId;
    }

    @Override
    public StateSpace getStateSpace() {
        return this.s;
    }

    public static ModelChecker create(StateSpace s) {
        return new ModelChecker(new ConsistencyChecker(s));
    }

    public static ModelChecker create(StateSpace s, ModelCheckingOptions options) {
        return new ModelChecker(new ConsistencyChecker(s, options));
    }
}

