/*
 * Decompiled with CFR 0.152.
 */
package de.prob.check;

import de.prob.animator.command.AbstractCommand;
import de.prob.animator.command.ConstraintBasedInvariantCheckCommand;
import de.prob.check.IModelCheckJob;
import de.prob.check.IModelCheckListener;
import de.prob.check.IModelCheckingResult;
import de.prob.check.ModelChecker;
import de.prob.check.NotYetFinished;
import de.prob.statespace.StateSpace;
import java.util.List;

public class CBCInvariantChecker
implements IModelCheckJob {
    private final ConstraintBasedInvariantCheckCommand command;
    private final StateSpace s;
    private final IModelCheckListener ui;
    private final String jobId;

    public CBCInvariantChecker(StateSpace s) {
        this(s, null);
    }

    public CBCInvariantChecker(StateSpace s, List<String> eventNames) {
        this(s, eventNames, null);
    }

    public CBCInvariantChecker(StateSpace s, List<String> eventNames, IModelCheckListener ui) {
        this.s = s;
        this.ui = ui;
        this.jobId = ModelChecker.generateJobId();
        this.command = new ConstraintBasedInvariantCheckCommand(s, eventNames);
    }

    @Override
    public IModelCheckingResult call() throws Exception {
        long time = System.currentTimeMillis();
        if (this.ui != null) {
            this.ui.updateStats(this.jobId, 0L, new NotYetFinished("Deadlock check started", 0), null);
        }
        this.s.execute((AbstractCommand)this.command);
        if (this.ui != null) {
            this.ui.isFinished(this.jobId, System.currentTimeMillis() - time, this.command.getResult(), null);
        }
        return this.command.getResult();
    }

    @Override
    public IModelCheckingResult getResult() {
        if (this.command.getResult() == null) {
            return new NotYetFinished("No result was calculated", -1);
        }
        return this.command.getResult();
    }

    @Override
    public String getJobId() {
        return this.jobId;
    }

    @Override
    public StateSpace getStateSpace() {
        return this.s;
    }
}

