/*
 * Decompiled with CFR 0.152.
 */
package de.prob.animator.domainobjects;

import de.be4.classicalb.core.parser.BParser;
import de.be4.classicalb.core.parser.analysis.prolog.ASTProlog;
import de.be4.classicalb.core.parser.exceptions.BException;
import de.be4.classicalb.core.parser.node.AExpressionParseUnit;
import de.be4.classicalb.core.parser.node.APredicateParseUnit;
import de.be4.classicalb.core.parser.node.EOF;
import de.be4.classicalb.core.parser.node.Node;
import de.be4.classicalb.core.parser.node.Start;
import de.be4.classicalb.core.parser.node.Switch;
import de.prob.animator.command.EvaluateFormulaCommand;
import de.prob.animator.command.EvaluationCommand;
import de.prob.animator.domainobjects.AbstractEvalElement;
import de.prob.animator.domainobjects.EvalElementType;
import de.prob.animator.domainobjects.EvaluationException;
import de.prob.animator.domainobjects.FormulaExpand;
import de.prob.animator.domainobjects.IBEvalElement;
import de.prob.model.classicalb.PrettyPrinter;
import de.prob.model.representation.FormulaUUID;
import de.prob.model.representation.IFormulaUUID;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.statespace.State;
import de.prob.translator.TranslatingVisitor;
import de.prob.translator.types.BObject;

public class ClassicalB
extends AbstractEvalElement
implements IBEvalElement {
    private final FormulaUUID uuid = new FormulaUUID();
    private final Start ast;

    public ClassicalB(String code) {
        this(code, FormulaExpand.truncate);
    }

    public ClassicalB(String code, FormulaExpand expansion) {
        Start ast;
        try {
            ast = BParser.parse((String)("#FORMULA " + code));
        }
        catch (BException e) {
            try {
                ast = BParser.parse((String)("#SUBSTITUTION " + code));
            }
            catch (BException f) {
                throw new EvaluationException(f.getMessage(), f);
            }
        }
        this.ast = ast;
        this.code = this.prettyprint((Node)ast);
        this.expansion = expansion;
    }

    public ClassicalB(Start ast) {
        this(ast, FormulaExpand.truncate);
    }

    public ClassicalB(Start ast, FormulaExpand expansion) {
        this.ast = ast;
        this.expansion = expansion;
        this.code = this.prettyprint((Node)ast);
    }

    @Override
    public String getKind() {
        return this.ast.getPParseUnit() instanceof AExpressionParseUnit ? EvalElementType.EXPRESSION.toString() : (this.ast.getPParseUnit() instanceof APredicateParseUnit ? EvalElementType.PREDICATE.toString() : EvalElementType.ASSIGNMENT.toString());
    }

    public Start getAst() {
        return this.ast;
    }

    public String toString() {
        return this.code;
    }

    @Override
    public void printProlog(IPrologTermOutput pout) {
        if (this.getKind().equals(EvalElementType.ASSIGNMENT.toString())) {
            throw new EvaluationException("Subsitutions are currently unsupported for evaluation");
        }
        ASTProlog prolog = new ASTProlog(pout, null);
        if (this.ast.getEOF() == null) {
            this.ast.setEOF(new EOF());
        }
        this.ast.apply((Switch)prolog);
    }

    private String prettyprint(Node predicate) {
        PrettyPrinter prettyPrinter = new PrettyPrinter();
        predicate.apply((Switch)prettyPrinter);
        return prettyPrinter.getPrettyPrint();
    }

    @Override
    public String serialized() {
        return "#ClassicalB:" + this.code;
    }

    @Override
    public IFormulaUUID getFormulaId() {
        return this.uuid;
    }

    @Override
    public EvaluationCommand getCommand(State stateId) {
        return new EvaluateFormulaCommand(this, stateId.getId());
    }

    @Override
    public BObject translate() {
        if (!this.getKind().equals(EvalElementType.EXPRESSION.toString())) {
            throw new IllegalArgumentException();
        }
        TranslatingVisitor v = new TranslatingVisitor();
        this.getAst().apply((Switch)v);
        return v.getResult();
    }
}

