/*
 * Decompiled with CFR 0.152.
 */
package de.prob.animator.command;

import de.be4.classicalb.core.parser.analysis.prolog.NodeIdAssignment;
import de.be4.classicalb.core.parser.analysis.prolog.RecursiveMachineLoader;
import de.prob.animator.command.AbstractCommand;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.output.StructuredPrologOutput;
import de.prob.prolog.term.PrologTerm;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadBProjectCommand
extends AbstractCommand {
    private static final String PROLOG_COMMAND_NAME = "load_classical_b_from_list_of_facts";
    Logger logger = LoggerFactory.getLogger(LoadBProjectCommand.class);
    private NodeIdAssignment nodeIdMapping;
    private final RecursiveMachineLoader rml;
    private File mainMachine;

    public LoadBProjectCommand(RecursiveMachineLoader rml, File f) {
        this.rml = rml;
        this.mainMachine = f;
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) {
        pto.openTerm(PROLOG_COMMAND_NAME);
        pto.printAtom(this.mainMachine.getAbsolutePath());
        pto.openList();
        this.printLoadTerm(this.rml, pto);
        pto.closeList();
        pto.closeTerm();
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) {
    }

    private void printLoadTerm(RecursiveMachineLoader rml, IPrologTermOutput pto) {
        StructuredPrologOutput parserOutput = new StructuredPrologOutput();
        rml.printAsProlog((IPrologTermOutput)parserOutput);
        this.nodeIdMapping = rml.getNodeIdMapping();
        for (PrologTerm term : parserOutput.getSentences()) {
            pto.printTerm(term);
        }
    }

    public NodeIdAssignment getNodeIdMapping() {
        return this.nodeIdMapping;
    }
}

