/*
 * Decompiled with CFR 0.152.
 */
package de.prob.animator.command;

import de.prob.animator.command.AbstractCommand;
import de.prob.parser.BindingGenerator;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.ListPrologTerm;
import de.prob.prolog.term.PrologTerm;
import java.util.List;

public class GetOperationsWithTimeout
extends AbstractCommand {
    private static final String PROLOG_COMMAND_NAME = "op_timeout_occurred";
    private static final String TIMEOUT_VARIABLE = "TO";
    private final String state;
    private List<String> timeouts;

    public GetOperationsWithTimeout(String state) {
        this.state = state;
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) {
        ListPrologTerm list = BindingGenerator.getList(bindings, (String)TIMEOUT_VARIABLE);
        this.timeouts = PrologTerm.atomicStrings((Iterable)list);
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) {
        pto.openTerm(PROLOG_COMMAND_NAME).printAtomOrNumber(this.state).printVariable(TIMEOUT_VARIABLE).closeTerm();
    }

    public List<String> getTimeouts() {
        return this.timeouts;
    }
}

