/*
 * Decompiled with CFR 0.152.
 */
package de.prob.animator.command;

import de.prob.animator.command.AbstractCommand;
import de.prob.animator.command.IStateSpaceModifier;
import de.prob.animator.domainobjects.LTL;
import de.prob.parser.BindingGenerator;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.CompoundPrologTerm;
import de.prob.prolog.term.ListPrologTerm;
import de.prob.prolog.term.PrologTerm;
import de.prob.statespace.ITraceDescription;
import de.prob.statespace.State;
import de.prob.statespace.StateSpace;
import de.prob.statespace.Trace;
import de.prob.statespace.Transition;
import java.util.ArrayList;
import java.util.List;

public class ExecuteUntilCommand
extends AbstractCommand
implements IStateSpaceModifier,
ITraceDescription {
    private static final String PROLOG_COMMAND_NAME = "generate_trace_until_condition_fulfilled";
    private static final String TRACE_VARIABLE = "Trace";
    private static final String RESULT_VARIABLE = "Result";
    private final List<Transition> resultTrace = new ArrayList<Transition>();
    private final State startstate;
    private final LTL condition;
    private final StateSpace statespace;
    private PrologTerm result;

    public ExecuteUntilCommand(StateSpace statespace, State startstate, LTL condition) {
        this.statespace = statespace;
        this.startstate = startstate;
        this.condition = condition;
    }

    @Override
    public void writeCommand(IPrologTermOutput pout) {
        pout.openTerm(PROLOG_COMMAND_NAME);
        pout.printAtomOrNumber(this.startstate.getId());
        this.condition.printProlog(pout);
        pout.printVariable(TRACE_VARIABLE);
        pout.printVariable(RESULT_VARIABLE);
        pout.closeTerm();
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) {
        ListPrologTerm trace = BindingGenerator.getList((PrologTerm)((PrologTerm)bindings.get((Object)TRACE_VARIABLE)));
        this.result = (PrologTerm)bindings.get((Object)RESULT_VARIABLE);
        for (PrologTerm term : trace) {
            CompoundPrologTerm t = BindingGenerator.getCompoundTerm((PrologTerm)term, (int)4);
            Transition operation = Transition.createTransitionFromCompoundPrologTerm(this.statespace, t);
            this.resultTrace.add(operation);
        }
    }

    @Override
    public List<Transition> getNewTransitions() {
        return this.resultTrace;
    }

    public State getFinalState() {
        return this.resultTrace.get(this.resultTrace.size() - 1).getDestination();
    }

    @Override
    public Trace getTrace(StateSpace s) throws RuntimeException {
        Trace t = s.getTrace(this.startstate.getId());
        return t.addTransitions(this.resultTrace);
    }

    public boolean isSuccess() {
        return this.result.getFunctor().equals("ltl_found");
    }

    public boolean conditionNotReached() {
        return this.result.getFunctor().equals("maximum_nr_of_steps_reached");
    }

    public boolean hasTypeError() {
        return this.result.getFunctor().equals("typeerror");
    }

    public boolean isDeadlocked() {
        return this.result.getFunctor().equals("deadlock");
    }
}

