/*
 * Decompiled with CFR 0.152.
 */
package de.prob.animator.command;

import de.prob.animator.command.EvaluationCommand;
import de.prob.animator.domainobjects.EvalResult;
import de.prob.animator.domainobjects.IEvalElement;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.PrologTerm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluateFormulaCommand
extends EvaluationCommand {
    private static final String PROLOG_COMMAND_NAME = "evaluate_formula";
    Logger logger = LoggerFactory.getLogger(EvaluateFormulaCommand.class);
    private static final String EVALUATE_RESULT_VARIABLE = "Res";

    public EvaluateFormulaCommand(IEvalElement evalElement, String id) {
        super(evalElement, id);
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) {
        PrologTerm term = (PrologTerm)bindings.get((Object)EVALUATE_RESULT_VARIABLE);
        this.value = EvalResult.getEvalResult(term);
    }

    @Override
    public void writeCommand(IPrologTermOutput pout) {
        pout.openTerm(PROLOG_COMMAND_NAME);
        pout.printAtomOrNumber(this.stateId);
        pout.openTerm("eval");
        this.evalElement.printProlog(pout);
        pout.printAtom(this.evalElement.getKind().toString());
        pout.printAtom(this.evalElement.getCode());
        pout.printAtom(this.evalElement.expansion().name());
        pout.closeTerm();
        pout.printVariable(EVALUATE_RESULT_VARIABLE);
        pout.closeTerm();
    }
}

