/*
 * Decompiled with CFR 0.152.
 */
package de.prob.animator.command;

import de.prob.animator.command.AbstractCommand;
import de.prob.animator.command.IStateSpaceModifier;
import de.prob.check.CBCInvariantViolationFound;
import de.prob.check.CheckInterrupted;
import de.prob.check.IModelCheckingResult;
import de.prob.check.InvariantCheckCounterExample;
import de.prob.check.ModelCheckOk;
import de.prob.check.NotYetFinished;
import de.prob.exception.ProBError;
import de.prob.parser.BindingGenerator;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.CompoundPrologTerm;
import de.prob.prolog.term.ListPrologTerm;
import de.prob.prolog.term.PrologTerm;
import de.prob.statespace.StateSpace;
import de.prob.statespace.Transition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstraintBasedInvariantCheckCommand
extends AbstractCommand
implements IStateSpaceModifier {
    Logger logger = LoggerFactory.getLogger(ConstraintBasedInvariantCheckCommand.class);
    private static final String PROLOG_COMMAND_NAME = "prob2_invariant_check";
    private static final String RESULT_VARIABLE = "R";
    private final Collection<String> events;
    private IModelCheckingResult result;
    private final List<InvariantCheckCounterExample> counterexamples = new ArrayList<InvariantCheckCounterExample>();
    private final List<Transition> newTransitions = new ArrayList<Transition>();
    private final StateSpace s;

    public ConstraintBasedInvariantCheckCommand(StateSpace s, Collection<String> events) {
        this.s = s;
        this.events = events == null ? null : Collections.unmodifiableCollection(new ArrayList<String>(events));
    }

    public Collection<String> getEvents() {
        return this.events;
    }

    public List<InvariantCheckCounterExample> getCounterExamples() {
        return this.counterexamples;
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) {
        pto.openTerm(PROLOG_COMMAND_NAME);
        if (this.events != null && !this.events.isEmpty()) {
            pto.openTerm("ops");
            pto.openList();
            for (String event : this.events) {
                pto.printAtom(event);
            }
            pto.closeList();
            pto.closeTerm();
        } else {
            pto.printAtom("all");
        }
        pto.printVariable(RESULT_VARIABLE);
        pto.closeTerm();
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) {
        PrologTerm resultTerm = (PrologTerm)bindings.get((Object)RESULT_VARIABLE);
        if (resultTerm.hasFunctor("interrupted", 0)) {
            this.result = new NotYetFinished("The invariant check has been interrupted by the user.", -1);
        } else if (resultTerm.isList()) {
            ListPrologTerm ceTerm = (ListPrologTerm)resultTerm;
            this.counterexamples.addAll(this.extractExamples(ceTerm));
            this.result = ceTerm.isEmpty() ? new ModelCheckOk("No Invariant violation was found") : new CBCInvariantViolationFound(this.counterexamples);
        } else {
            String msg = "unexpected result from invariant check: " + resultTerm;
            this.logger.error(msg);
            throw new ProBError(msg);
        }
    }

    private List<InvariantCheckCounterExample> extractExamples(ListPrologTerm ceTerm) {
        ArrayList<InvariantCheckCounterExample> examples = new ArrayList<InvariantCheckCounterExample>();
        for (PrologTerm t : ceTerm) {
            CompoundPrologTerm term = (CompoundPrologTerm)t;
            String eventName = PrologTerm.atomicString((PrologTerm)term.getArgument(1));
            Transition step1 = Transition.createTransitionFromCompoundPrologTerm(this.s, BindingGenerator.getCompoundTerm((PrologTerm)term.getArgument(2), (int)4));
            Transition step2 = Transition.createTransitionFromCompoundPrologTerm(this.s, BindingGenerator.getCompoundTerm((PrologTerm)term.getArgument(3), (int)4));
            InvariantCheckCounterExample ce = new InvariantCheckCounterExample(eventName, step1, step2);
            this.newTransitions.add(step1);
            this.newTransitions.add(step2);
            examples.add(ce);
        }
        return examples;
    }

    public IModelCheckingResult getResult() {
        return this.result == null && this.interrupted ? new CheckInterrupted() : this.result;
    }

    @Override
    public List<Transition> getNewTransitions() {
        return this.newTransitions;
    }

    @Override
    public boolean blockAnimator() {
        return true;
    }
}

