/*
 * Decompiled with CFR 0.152.
 */
package de.prob.animator.command;

import de.prob.animator.command.AbstractCommand;
import de.prob.parser.ISimplifiedROMap;
import de.prob.parser.ResultParserException;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.PrologTerm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckBooleanPropertyCommand
extends AbstractCommand {
    private static final String PROLOG_COMMAND_NAME = "state_property";
    private final Logger logger = LoggerFactory.getLogger(CheckBooleanPropertyCommand.class);
    private static final String PROP_RESULT = "PropResult";
    private final String stateId;
    private final String propertyName;
    private Boolean result;

    protected CheckBooleanPropertyCommand(String propertyName, String stateId) {
        this.propertyName = propertyName;
        this.stateId = stateId;
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) {
        String functor = ((PrologTerm)bindings.get((Object)PROP_RESULT)).getFunctor();
        this.checkIfBoolean(functor);
        this.result = Boolean.valueOf(functor);
    }

    private void checkIfBoolean(String functor) {
        if (!"true".equals(functor) && !"false".equals(functor)) {
            this.result = null;
            this.logger.error("Expected true or false, but was: {}", (Object)functor);
            throw new ResultParserException("Expected true or false, but was: " + functor, null);
        }
    }

    private static void writeCommand(IPrologTermOutput pto, String propertyName, String stateId) {
        pto.openTerm(PROLOG_COMMAND_NAME);
        pto.printAtom(propertyName);
        pto.printAtomOrNumber(stateId);
        pto.printVariable(PROP_RESULT);
        pto.closeTerm();
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) {
        CheckBooleanPropertyCommand.writeCommand(pto, this.propertyName, this.stateId);
    }

    public boolean getResult() {
        if (this.result == null) {
            throw new IllegalStateException("Cannot get result before finishing query");
        }
        return this.result;
    }

    public String getStateId() {
        return this.stateId;
    }
}

