/*
 * Decompiled with CFR 0.152.
 */
package de.prob;

import com.google.inject.Inject;
import de.prob.cli.ProBInstanceProvider;
import de.prob.scripting.ScriptEngineProvider;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import javax.script.ScriptEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Shell {
    private final ScriptEngineProvider sep;
    private final Logger logger = LoggerFactory.getLogger(Shell.class);
    private ProBInstanceProvider ProBs;

    @Inject
    public Shell(ScriptEngineProvider executor, ProBInstanceProvider ProBs) {
        this.sep = executor;
        this.ProBs = ProBs;
    }

    private void runScript(String dir, File script, boolean silent) throws Throwable {
        if (script.isDirectory()) {
            File[] files;
            long time = System.currentTimeMillis();
            for (File file : files = script.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File arg0, String arg1) {
                    return arg1.endsWith(".groovy");
                }
            })) {
                this.runScript(script.getAbsolutePath(), file, silent);
            }
            if (!silent) {
                System.out.println("TOTAL TIME: " + (System.currentTimeMillis() - time));
            }
        } else {
            this.runSingleScript(script.getParent(), script, silent);
        }
    }

    private void runSingleScript(String dir, File script, boolean silent) throws Throwable {
        long time = System.currentTimeMillis();
        this.logger.debug("Runnning script: {}", (Object)script.getAbsolutePath());
        ScriptEngine executor = this.sep.get();
        executor.put("dir", dir);
        executor.put("inConsole", false);
        if (!silent) {
            System.out.print(script.getName());
        }
        FileReader fr = new FileReader(script);
        Object res = executor.eval(fr);
        this.ProBs.shutdownAll();
        if (!silent) {
            double seconds = (double)(System.currentTimeMillis() - time) / 1000.0;
            System.out.println(" - " + res.toString() + " (" + String.format("%.4g", seconds) + " s)");
        }
    }

    public void runScript(File file) throws Throwable {
        this.runScript(file, true);
    }

    public void runScript(File file, boolean silent) throws Throwable {
        this.runScript(file.getAbsolutePath(), file, silent);
    }
}

