/*
 * Decompiled with CFR 0.152.
 */
package de.prob;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import de.prob.MainModule;
import de.prob.Shell;
import de.prob.scripting.Downloader;
import de.prob.scripting.FileHandler;
import java.io.File;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    public static int maxCacheSize = 100;
    private final Logger logger = LoggerFactory.getLogger(Main.class);
    private final CommandLineParser parser;
    private final Options options;
    private final Shell shell;
    private static Injector INJECTOR = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new MainModule()});
    public static final String PREFERENCE_FILE_NAME = "prob2preferences";
    public static final String PROB_HOME = Main.getProBDirectory();
    public static final String LOG_CONFIG = System.getProperty("PROB_LOG_CONFIG") == null ? "production.xml" : System.getProperty("PROB_LOG_CONFIG");
    private final Downloader downloader;

    public static Injector getInjector() {
        return INJECTOR;
    }

    public static void setInjector(Injector i) {
        INJECTOR = i;
    }

    @Inject
    public Main(CommandLineParser parser, Options options, Shell shell, Downloader downloader) {
        this.parser = parser;
        this.options = options;
        this.shell = shell;
        this.downloader = downloader;
        this.logger.debug("Java version: {}", (Object)System.getProperty("java.version"));
    }

    private void run(String[] args) throws Throwable {
        try {
            String value;
            CommandLine line = this.parser.parse(this.options, args);
            if (line.hasOption("upgrade") || line.hasOption("cli")) {
                String version;
                String string = version = line.hasOption("upgrade") ? line.getOptionValue("upgrade") : line.getOptionValue("cli");
                if (version == null) {
                    version = "latest";
                }
                if (version.equals("cspm")) {
                    System.out.println(this.downloader.installCSPM());
                } else {
                    System.out.println(this.downloader.downloadCli(version));
                }
            }
            if (line.hasOption("maxCacheSize")) {
                this.logger.debug("setting maximum cache size requested");
                value = line.getOptionValue("maxCacheSize");
                this.logger.debug("retrieved maxSize");
                maxCacheSize = Integer.valueOf(value);
                this.logger.debug("Max size set successfully to {}", (Object)value);
            }
            if (line.hasOption("script")) {
                this.logger.debug("Run Script");
                value = line.getOptionValue("script");
                this.shell.runScript(new File(value), false);
            }
        }
        catch (ParseException exp) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("java -jar probcli.jar", this.options);
            System.exit(-1);
        }
    }

    public static String getProBDirectory() {
        String homedir = System.getProperty("prob.home");
        if (homedir != null) {
            return homedir + File.separator;
        }
        return System.getProperty("user.home") + File.separator + ".prob" + File.separator;
    }

    public static Map<String, String> getGlobalPreferences(Map<String, String> localPrefs) {
        FileHandler handler = new FileHandler();
        String preferenceFileName = Main.getProBDirectory() + PREFERENCE_FILE_NAME;
        Map<String, String> prefs = handler.getMapOfStrings(preferenceFileName);
        if (prefs == null) {
            return localPrefs;
        }
        prefs.putAll(localPrefs);
        return prefs;
    }

    public static void main(String[] args) {
        try {
            System.setProperty("PROB_LOG_CONFIG", LOG_CONFIG);
            Main main = (Main)Main.getInjector().getInstance(Main.class);
            main.run(args);
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(-1);
        }
        System.exit(0);
    }
}

