/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.matchers;

import org.parboiled.MatcherContext;
import org.parboiled.Rule;
import org.parboiled.common.Preconditions;
import org.parboiled.matchers.SequenceMatcher;

public class StringMatcher
extends SequenceMatcher {
    public final char[] characters;

    public StringMatcher(Rule[] charMatchers, char[] characters) {
        super(Preconditions.checkArgNotNull(charMatchers, "charMatchers"));
        this.characters = characters;
    }

    public String getLabel() {
        return super.getLabel() != null ? super.getLabel() : '\"' + String.valueOf(this.characters) + '\"';
    }

    public boolean hasCustomLabel() {
        return true;
    }

    public boolean match(MatcherContext context) {
        if (!context.fastStringMatching()) {
            return super.match(context);
        }
        if (!context.getInputBuffer().test(context.getCurrentIndex(), this.characters)) {
            return false;
        }
        context.advanceIndex(this.characters.length);
        context.createNode();
        return true;
    }
}

