/* This file was generated by SableCC (http://www.sablecc.org/). */

package de.stups.probkodkod.parser.parser;

import de.stups.probkodkod.parser.lexer.*;
import de.stups.probkodkod.parser.node.*;
import de.stups.probkodkod.parser.analysis.*;
import java.util.*;
import de.hhu.stups.sablecc.patch.*;


import java.io.DataInputStream;
import java.io.BufferedInputStream;
import java.io.IOException;

@SuppressWarnings({"rawtypes","unchecked","unused"})
public class Parser implements IParser
{
    public final Analysis ignoredTokens = new AnalysisAdapter();

    protected ArrayList nodeList;

    private final Lexer lexer;
    private final ListIterator stack = new LinkedList().listIterator();
    private int last_pos;
    private int last_line;
    private Token last_token;
    private final TokenIndex converter = new TokenIndex();
    private final int[] action = new int[2];

    private final static int SHIFT = 0;
    private final static int REDUCE = 1;
    private final static int ACCEPT = 2;
    private final static int ERROR = 3;
    
    private ArrayList firstPopped = null;
    private ArrayList lastPopped = null;
    private ITokenListContainer lex;

    public Parser(  Lexer lexer)
    {
        this.lexer = lexer;
        this.lex = lexer; 
    }
    
     
    private Map<PositionedNode, SourcecodeRange> mapping = new HashMap<PositionedNode, SourcecodeRange>();    
    public Map<PositionedNode, SourcecodeRange> getMapping() { 	return this.mapping; }

   private void checkResult(Object elementToCheck) {
       checkResult(elementToCheck, false);
   }

	 
	private void checkResult(Object elementToCheck, boolean slurp) {
		// nodes with no tokens or sub nodes at all may exist
		if (this.firstPopped == null) {
			return;
		}

		if (elementToCheck instanceof LinkedList) {
			/*
			 * special case: this is a list of nodes, for example an identifier
			 * list, so we don't want to check the list but the last element
			 * added to it
			 */
			final LinkedList nodeList = (LinkedList) elementToCheck;

			if (nodeList.size() > 0) {
				elementToCheck = nodeList.get(nodeList.size() - 1);
			} else {
				// no positions for empty lists...
				return;
			}
		}

		if (!(elementToCheck instanceof PositionedNode)) {
			throw new Error(
					"Unexpected elementToCheck (not instanceof PositionedNode): "
							+ elementToCheck.getClass().getSimpleName() + "/"
							+ elementToCheck);
		}

		if (!this.getMapping().containsKey(elementToCheck) || slurp ) {
			final PositionedNode node = (PositionedNode) elementToCheck;

			// dealing with a one-token element
			if (this.lastPopped == null) {
				this.lastPopped = this.firstPopped;
			}

			final int begin = findBeginPos(this.lastPopped, node);
			int end = findEndPos(this.firstPopped);
			if (end == -1) end = begin;
			final SourcecodeRange range = new SourcecodeRange(begin, end);

			this.getMapping().put(node, range);

			node.setStartPos(createBeginPos(begin));
			node.setEndPos(createEndPos(end));
		}
	}
	
	 
	private int findBeginPos(final ArrayList list,
			PositionedNode n) {
		Object first = list.get(0);
		if (!(first instanceof PositionedNode) && !(first instanceof IToken)) {
			List list2 = (List) first;

			if (list2.size() > 0) {
				first = list2.get(0);
			} else {
				/*
				 * Sometimes (haven't found out why) we get empty list here. In
				 * the only observed cases we were looking for the source range
				 * of the whole parse unit. Then the index is 0.
				 */
				return 0;
			}
		}

		if (first instanceof IToken) {
			return findIndex((IToken) first);
		}

		final PositionedNode node = (PositionedNode) first;
		final SourcecodeRange item = this.getMapping().get(node);
		if (item == null){
			System.err.println(n.getClass().getSimpleName() + " / " + node.getClass().getSimpleName() + ": " + node);
		}
		return item.getBeginIndex();
	}

	 
	private int findEndPos(final ArrayList list) {
		Object last = list.get(list.size() - 1);
		if (!(last instanceof PositionedNode) && !(last instanceof IToken)) {
			final List list2 = (List) last;
			last = list2.get(list2.size() - 1);
		}

		if (last instanceof IToken) {
			return findIndex((IToken) last);
		}

		final PositionedNode node = (PositionedNode) last;
		final SourcecodeRange item = this.getMapping().get(node);
		if (item == null)
			return -1;
		return item.getEndIndex();
	}

	private int findIndex(final IToken token) {
		final List<IToken> list = this.lex.getTokenList();

		for (int i = list.size() - 1; i >= 0; i--) {
			if (list.get(i) == token) {
				return i;
			}
		}

		return -1;
	}

	private SourcePosition createBeginPos(final int index) {
		final List<IToken> list = this.lex.getTokenList();
		final IToken token = list.get(index);
		return new SourcePosition(token.getLine(), token.getPos());
	}

	private SourcePosition createEndPos(final int index) {
		final List<IToken> list = this.lex.getTokenList();
		final IToken token = list.get(index);
		return new SourcePosition(token.getLine(), token.getPos()
				+ token.getText().length());
	}
	     
    private void push(int numstate, ArrayList listNode) throws ParserException, LexerException, IOException
    {
        this.nodeList = listNode;

        if(!this.stack.hasNext())
        {
            this.stack.add(new State(numstate, this.nodeList));
            return;
        }

        State s = (State) this.stack.next();
        s.state = numstate;
        s.nodes = this.nodeList;
    }

    private int goTo(int index)
    {
        int state = state();
        int low = 1;
        int high = gotoTable[index].length - 1;
        int value = gotoTable[index][0][1];

        while(low <= high)
        {
            int middle = (low + high) / 2;

            if(state < gotoTable[index][middle][0])
            {
                high = middle - 1;
            }
            else if(state > gotoTable[index][middle][0])
            {
                low = middle + 1;
            }
            else
            {
                value = gotoTable[index][middle][1];
                break;
            }
        }

        return value;
    }

    private int state()
    {
        State s = (State) this.stack.previous();
        this.stack.next();
        return s.state;
    }

    private ArrayList pop()
    {
    	ArrayList list = ((State) this.stack.previous()).nodes; 
		if (this.firstPopped == null) {
			this.firstPopped = list;
		} else {
			this.lastPopped = list;
		}
        return list;
    }

    private int index(Switchable token)
    {
        this.converter.index = -1;
        token.apply(this.converter);
        return this.converter.index;
    }

     
    public Start parse() throws ParserException, LexerException, IOException
    {
    	this.getMapping().clear();
    
        push(0, null);
        List<Node> ign = null;
        while(true)
        {
            while(index(this.lexer.peek()) == -1)
            {
                if(ign == null)
                {
                    ign = new LinkedList<Node>();
                }

                ign.add(this.lexer.next());
            }

            if(ign != null)
            {
                this.ignoredTokens.setIn(this.lexer.peek(), ign);
                ign = null;
            }

            this.last_pos = this.lexer.peek().getPos();
            this.last_line = this.lexer.peek().getLine();
            this.last_token = this.lexer.peek();

            int index = index(this.lexer.peek());
            this.action[0] = Parser.actionTable[state()][0][1];
            this.action[1] = Parser.actionTable[state()][0][2];

            int low = 1;
            int high = Parser.actionTable[state()].length - 1;

            while(low <= high)
            {
                int middle = (low + high) / 2;

                if(index < Parser.actionTable[state()][middle][0])
                {
                    high = middle - 1;
                }
                else if(index > Parser.actionTable[state()][middle][0])
                {
                    low = middle + 1;
                }
                else
                {
                    this.action[0] = Parser.actionTable[state()][middle][1];
                    this.action[1] = Parser.actionTable[state()][middle][2];
                    break;
                }
            }

            switch(this.action[0])
            {
                case SHIFT:
		    {
		        ArrayList list = new ArrayList();
		        list.add(this.lexer.next());
                        push(this.action[1], list);
                    }
		    break;
                case REDUCE:
                    switch(this.action[1])
                    {
                    case 0: /* reduce AProblemAction */
		    {
			ArrayList list = new0();
			push(goTo(0), list);
		    }
		    break;
                    case 1: /* reduce ARequestAction */
		    {
			ArrayList list = new1();
			push(goTo(0), list);
		    }
		    break;
                    case 2: /* reduce AListAction */
		    {
			ArrayList list = new2();
			push(goTo(0), list);
		    }
		    break;
                    case 3: /* reduce AStopAction */
		    {
			ArrayList list = new3();
			push(goTo(0), list);
		    }
		    break;
                    case 4: /* reduce AResetAction */
		    {
			ArrayList list = new4();
			push(goTo(0), list);
		    }
		    break;
                    case 5: /* reduce ANoneAction */
		    {
			ArrayList list = new5();
			push(goTo(0), list);
		    }
		    break;
                    case 6: /* reduce AAproblem1Problem */
		    {
			ArrayList list = new6();
			push(goTo(1), list);
		    }
		    break;
                    case 7: /* reduce AAproblem2Problem */
		    {
			ArrayList list = new7();
			push(goTo(1), list);
		    }
		    break;
                    case 8: /* reduce AAproblem3Problem */
		    {
			ArrayList list = new8();
			push(goTo(1), list);
		    }
		    break;
                    case 9: /* reduce AAproblem4Problem */
		    {
			ArrayList list = new9();
			push(goTo(1), list);
		    }
		    break;
                    case 10: /* reduce APosZnumber */
		    {
			ArrayList list = new10();
			push(goTo(2), list);
		    }
		    break;
                    case 11: /* reduce ANegZnumber */
		    {
			ArrayList list = new11();
			push(goTo(2), list);
		    }
		    break;
                    case 12: /* reduce AStandardType */
		    {
			ArrayList list = new12();
			push(goTo(3), list);
		    }
		    break;
                    case 13: /* reduce AAintstype1Type */
		    {
			ArrayList list = new13();
			push(goTo(3), list);
		    }
		    break;
                    case 14: /* reduce AAintstype2Type */
		    {
			ArrayList list = new14();
			push(goTo(3), list);
		    }
		    break;
                    case 15: /* reduce APowpart */
		    {
			ArrayList list = new15();
			push(goTo(4), list);
		    }
		    break;
                    case 16: /* reduce ABitpart */
		    {
			ArrayList list = new16();
			push(goTo(5), list);
		    }
		    break;
                    case 17: /* reduce AArelation1Relation */
		    {
			ArrayList list = new17();
			push(goTo(6), list);
		    }
		    break;
                    case 18: /* reduce AArelation2Relation */
		    {
			ArrayList list = new18();
			push(goTo(6), list);
		    }
		    break;
                    case 19: /* reduce AArelation3Relation */
		    {
			ArrayList list = new19();
			push(goTo(6), list);
		    }
		    break;
                    case 20: /* reduce AArelation4Relation */
		    {
			ArrayList list = new20();
			push(goTo(6), list);
		    }
		    break;
                    case 21: /* reduce AExactReltype */
		    {
			ArrayList list = new21();
			push(goTo(7), list);
		    }
		    break;
                    case 22: /* reduce ASubsetReltype */
		    {
			ArrayList list = new22();
			push(goTo(7), list);
		    }
		    break;
                    case 23: /* reduce ATupleset */
		    {
			ArrayList list = new23();
			push(goTo(8), list);
		    }
		    break;
                    case 24: /* reduce ATuple */
		    {
			ArrayList list = new24();
			push(goTo(9), list);
		    }
		    break;
                    case 25: /* reduce ATyperefRange */
		    {
			ArrayList list = new25();
			push(goTo(10), list);
		    }
		    break;
                    case 26: /* reduce ADefaultRange */
		    {
			ArrayList list = new26();
			push(goTo(10), list);
		    }
		    break;
                    case 27: /* reduce AFormula */
		    {
			ArrayList list = new27();
			push(goTo(11), list);
		    }
		    break;
                    case 28: /* reduce AConstInnerformula */
		    {
			ArrayList list = new28();
			push(goTo(12), list);
		    }
		    break;
                    case 29: /* reduce AMultInnerformula */
		    {
			ArrayList list = new29();
			push(goTo(12), list);
		    }
		    break;
                    case 30: /* reduce ARel$In1Innerformula */
		    {
			ArrayList list = new30();
			push(goTo(12), list);
		    }
		    break;
                    case 31: /* reduce ARel$Equals1Innerformula */
		    {
			ArrayList list = new31();
			push(goTo(12), list);
		    }
		    break;
                    case 32: /* reduce ANotInnerformula */
		    {
			ArrayList list = new32();
			push(goTo(12), list);
		    }
		    break;
                    case 33: /* reduce AAandinnerformula1Innerformula */
		    {
			ArrayList list = new33();
			push(goTo(12), list);
		    }
		    break;
                    case 34: /* reduce AAandinnerformula2Innerformula */
		    {
			ArrayList list = new34();
			push(goTo(12), list);
		    }
		    break;
                    case 35: /* reduce ABinaryInnerformula */
		    {
			ArrayList list = new35();
			push(goTo(12), list);
		    }
		    break;
                    case 36: /* reduce AQuantInnerformula */
		    {
			ArrayList list = new36();
			push(goTo(12), list);
		    }
		    break;
                    case 37: /* reduce AInt$Equals1Innerformula */
		    {
			ArrayList list = new37();
			push(goTo(12), list);
		    }
		    break;
                    case 38: /* reduce AInt$Greater1Innerformula */
		    {
			ArrayList list = new38();
			push(goTo(12), list);
		    }
		    break;
                    case 39: /* reduce AInt$Greaterequal1Innerformula */
		    {
			ArrayList list = new39();
			push(goTo(12), list);
		    }
		    break;
                    case 40: /* reduce AInt$Lesser1Innerformula */
		    {
			ArrayList list = new40();
			push(goTo(12), list);
		    }
		    break;
                    case 41: /* reduce AInt$Lesserequal1Innerformula */
		    {
			ArrayList list = new41();
			push(goTo(12), list);
		    }
		    break;
                    case 42: /* reduce AFuncInnerformula */
		    {
			ArrayList list = new42();
			push(goTo(12), list);
		    }
		    break;
                    case 43: /* reduce ATrueLogConst */
		    {
			ArrayList list = new43();
			push(goTo(13), list);
		    }
		    break;
                    case 44: /* reduce AFalseLogConst */
		    {
			ArrayList list = new44();
			push(goTo(13), list);
		    }
		    break;
                    case 45: /* reduce ATotalLogopFunction */
		    {
			ArrayList list = new45();
			push(goTo(14), list);
		    }
		    break;
                    case 46: /* reduce APartialLogopFunction */
		    {
			ArrayList list = new46();
			push(goTo(14), list);
		    }
		    break;
                    case 47: /* reduce AOrLogopBinary */
		    {
			ArrayList list = new47();
			push(goTo(15), list);
		    }
		    break;
                    case 48: /* reduce AImpliesLogopBinary */
		    {
			ArrayList list = new48();
			push(goTo(15), list);
		    }
		    break;
                    case 49: /* reduce AIffLogopBinary */
		    {
			ArrayList list = new49();
			push(goTo(15), list);
		    }
		    break;
                    case 50: /* reduce AAllQuantifier */
		    {
			ArrayList list = new50();
			push(goTo(16), list);
		    }
		    break;
                    case 51: /* reduce AExistsQuantifier */
		    {
			ArrayList list = new51();
			push(goTo(16), list);
		    }
		    break;
                    case 52: /* reduce ANilDecls */
		    {
			ArrayList list = new52();
			push(goTo(17), list);
		    }
		    break;
                    case 53: /* reduce AConsDecls */
		    {
			ArrayList list = new53();
			push(goTo(17), list);
		    }
		    break;
                    case 54: /* reduce AOneMultiplicity */
		    {
			ArrayList list = new54();
			push(goTo(18), list);
		    }
		    break;
                    case 55: /* reduce ASomeMultiplicity */
		    {
			ArrayList list = new55();
			push(goTo(18), list);
		    }
		    break;
                    case 56: /* reduce ANoMultiplicity */
		    {
			ArrayList list = new56();
			push(goTo(18), list);
		    }
		    break;
                    case 57: /* reduce ALoneMultiplicity */
		    {
			ArrayList list = new57();
			push(goTo(18), list);
		    }
		    break;
                    case 58: /* reduce ASetMultiplicity */
		    {
			ArrayList list = new58();
			push(goTo(18), list);
		    }
		    break;
                    case 59: /* reduce AExpression */
		    {
			ArrayList list = new59();
			push(goTo(19), list);
		    }
		    break;
                    case 60: /* reduce AConstInnerexpression */
		    {
			ArrayList list = new60();
			push(goTo(20), list);
		    }
		    break;
                    case 61: /* reduce AUnaryInnerexpression */
		    {
			ArrayList list = new61();
			push(goTo(20), list);
		    }
		    break;
                    case 62: /* reduce AMultiInnerexpression */
		    {
			ArrayList list = new62();
			push(goTo(20), list);
		    }
		    break;
                    case 63: /* reduce ABinaryInnerexpression */
		    {
			ArrayList list = new63();
			push(goTo(20), list);
		    }
		    break;
                    case 64: /* reduce ARelrefInnerexpression */
		    {
			ArrayList list = new64();
			push(goTo(20), list);
		    }
		    break;
                    case 65: /* reduce AVarrefInnerexpression */
		    {
			ArrayList list = new65();
			push(goTo(20), list);
		    }
		    break;
                    case 66: /* reduce ACompInnerexpression */
		    {
			ArrayList list = new66();
			push(goTo(20), list);
		    }
		    break;
                    case 67: /* reduce APrjInnerexpression */
		    {
			ArrayList list = new67();
			push(goTo(20), list);
		    }
		    break;
                    case 68: /* reduce ACastInnerexpression */
		    {
			ArrayList list = new68();
			push(goTo(20), list);
		    }
		    break;
                    case 69: /* reduce AIfInnerexpression */
		    {
			ArrayList list = new69();
			push(goTo(20), list);
		    }
		    break;
                    case 70: /* reduce APow2ExprCast */
		    {
			ArrayList list = new70();
			push(goTo(21), list);
		    }
		    break;
                    case 71: /* reduce AIntsetExprCast */
		    {
			ArrayList list = new71();
			push(goTo(21), list);
		    }
		    break;
                    case 72: /* reduce AEmptyExprConst */
		    {
			ArrayList list = new72();
			push(goTo(22), list);
		    }
		    break;
                    case 73: /* reduce AIdenExprConst */
		    {
			ArrayList list = new73();
			push(goTo(22), list);
		    }
		    break;
                    case 74: /* reduce AUnivExprConst */
		    {
			ArrayList list = new74();
			push(goTo(22), list);
		    }
		    break;
                    case 75: /* reduce AUnionExprMultop */
		    {
			ArrayList list = new75();
			push(goTo(23), list);
		    }
		    break;
                    case 76: /* reduce AInterExprMultop */
		    {
			ArrayList list = new76();
			push(goTo(23), list);
		    }
		    break;
                    case 77: /* reduce AProductExprMultop */
		    {
			ArrayList list = new77();
			push(goTo(23), list);
		    }
		    break;
                    case 78: /* reduce ADiffExprBinop */
		    {
			ArrayList list = new78();
			push(goTo(24), list);
		    }
		    break;
                    case 79: /* reduce AJoinExprBinop */
		    {
			ArrayList list = new79();
			push(goTo(24), list);
		    }
		    break;
                    case 80: /* reduce AOverwriteExprBinop */
		    {
			ArrayList list = new80();
			push(goTo(24), list);
		    }
		    break;
                    case 81: /* reduce ATransposeExprUnop */
		    {
			ArrayList list = new81();
			push(goTo(25), list);
		    }
		    break;
                    case 82: /* reduce AClosureExprUnop */
		    {
			ArrayList list = new82();
			push(goTo(25), list);
		    }
		    break;
                    case 83: /* reduce AIntexpression */
		    {
			ArrayList list = new83();
			push(goTo(26), list);
		    }
		    break;
                    case 84: /* reduce AConstInnerintexpression */
		    {
			ArrayList list = new84();
			push(goTo(27), list);
		    }
		    break;
                    case 85: /* reduce ACardInnerintexpression */
		    {
			ArrayList list = new85();
			push(goTo(27), list);
		    }
		    break;
                    case 86: /* reduce ABinaryInnerintexpression */
		    {
			ArrayList list = new86();
			push(goTo(27), list);
		    }
		    break;
                    case 87: /* reduce ACastInnerintexpression */
		    {
			ArrayList list = new87();
			push(goTo(27), list);
		    }
		    break;
                    case 88: /* reduce AAddIntexprBinop */
		    {
			ArrayList list = new88();
			push(goTo(28), list);
		    }
		    break;
                    case 89: /* reduce ASubIntexprBinop */
		    {
			ArrayList list = new89();
			push(goTo(28), list);
		    }
		    break;
                    case 90: /* reduce AMulIntexprBinop */
		    {
			ArrayList list = new90();
			push(goTo(28), list);
		    }
		    break;
                    case 91: /* reduce ADivIntexprBinop */
		    {
			ArrayList list = new91();
			push(goTo(28), list);
		    }
		    break;
                    case 92: /* reduce AModIntexprBinop */
		    {
			ArrayList list = new92();
			push(goTo(28), list);
		    }
		    break;
                    case 93: /* reduce AArequest1Request */
		    {
			ArrayList list = new93();
			push(goTo(29), list);
		    }
		    break;
                    case 94: /* reduce AArequest2Request */
		    {
			ArrayList list = new94();
			push(goTo(29), list);
		    }
		    break;
                    case 95: /* reduce AAargument1Argument */
		    {
			ArrayList list = new95();
			push(goTo(30), list);
		    }
		    break;
                    case 96: /* reduce AAargument2Argument */
		    {
			ArrayList list = new96();
			push(goTo(30), list);
		    }
		    break;
                    case 97: /* reduce APosReqtype */
		    {
			ArrayList list = new97();
			push(goTo(31), list);
		    }
		    break;
                    case 98: /* reduce ANegReqtype */
		    {
			ArrayList list = new98();
			push(goTo(31), list);
		    }
		    break;
                    case 99: /* reduce AList */
		    {
			ArrayList list = new99();
			push(goTo(32), list);
		    }
		    break;
                    case 100: /* reduce AStop */
		    {
			ArrayList list = new100();
			push(goTo(33), list);
		    }
		    break;
                    case 101: /* reduce AReset */
		    {
			ArrayList list = new101();
			push(goTo(34), list);
		    }
		    break;
                    case 102: /* reduce ATerminal$Type */
		    {
			ArrayList list = new102();
			push(goTo(35), list);
		    }
		    break;
                    case 103: /* reduce ANonTerminal$Type */
		    {
			ArrayList list = new103();
			push(goTo(35), list);
		    }
		    break;
                    case 104: /* reduce ATerminal$Relation */
		    {
			ArrayList list = new104();
			push(goTo(36), list);
		    }
		    break;
                    case 105: /* reduce ANonTerminal$Relation */
		    {
			ArrayList list = new105();
			push(goTo(36), list);
		    }
		    break;
                    case 106: /* reduce ATerminal$Identifier */
		    {
			ArrayList list = new106();
			push(goTo(37), list);
		    }
		    break;
                    case 107: /* reduce ANonTerminal$Identifier */
		    {
			ArrayList list = new107();
			push(goTo(37), list);
		    }
		    break;
                    case 108: /* reduce ATerminal$Tuple */
		    {
			ArrayList list = new108();
			push(goTo(38), list);
		    }
		    break;
                    case 109: /* reduce ANonTerminal$Tuple */
		    {
			ArrayList list = new109();
			push(goTo(38), list);
		    }
		    break;
                    case 110: /* reduce ATerminal$Number */
		    {
			ArrayList list = new110();
			push(goTo(39), list);
		    }
		    break;
                    case 111: /* reduce ANonTerminal$Number */
		    {
			ArrayList list = new111();
			push(goTo(39), list);
		    }
		    break;
                    case 112: /* reduce ATerminal$Formula */
		    {
			ArrayList list = new112();
			push(goTo(40), list);
		    }
		    break;
                    case 113: /* reduce ANonTerminal$Formula */
		    {
			ArrayList list = new113();
			push(goTo(40), list);
		    }
		    break;
                    case 114: /* reduce ATerminal$Expression */
		    {
			ArrayList list = new114();
			push(goTo(41), list);
		    }
		    break;
                    case 115: /* reduce ANonTerminal$Expression */
		    {
			ArrayList list = new115();
			push(goTo(41), list);
		    }
		    break;
                    case 116: /* reduce ATerminal$Argument */
		    {
			ArrayList list = new116();
			push(goTo(42), list);
		    }
		    break;
                    case 117: /* reduce ANonTerminal$Argument */
		    {
			ArrayList list = new117();
			push(goTo(42), list);
		    }
		    break;
                    }
                    break;
                case ACCEPT:
                    {
                        EOF node2 = (EOF) this.lexer.next();
                        PAction node1 = (PAction) pop().get(0);
                        Start node = new Start(node1, node2);
                        return node;
                    }
                case ERROR:
                    throw new ParserException(this.last_token,
                        "[" + this.last_line + "," + this.last_pos + "] " ,
                        Parser.errorMessages[Parser.errors[this.action[1]]]);
            }
        }
    }



     
    ArrayList new0() /* reduce AProblemAction */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PAction pactionNode1;
        {
            // Block
        PProblem pproblemNode2;
        pproblemNode2 = (PProblem)nodeArrayList1.get(0);

        pactionNode1 = new AProblemAction(pproblemNode2);
        }
	nodeList.add(pactionNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new1() /* reduce ARequestAction */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PAction pactionNode1;
        {
            // Block
        PRequest prequestNode2;
        prequestNode2 = (PRequest)nodeArrayList1.get(0);

        pactionNode1 = new ARequestAction(prequestNode2);
        }
	nodeList.add(pactionNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new2() /* reduce AListAction */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PAction pactionNode1;
        {
            // Block
        PList plistNode2;
        plistNode2 = (PList)nodeArrayList1.get(0);

        pactionNode1 = new AListAction(plistNode2);
        }
	nodeList.add(pactionNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new3() /* reduce AStopAction */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PAction pactionNode1;
        {
            // Block
        PStop pstopNode2;
        pstopNode2 = (PStop)nodeArrayList1.get(0);

        pactionNode1 = new AStopAction(pstopNode2);
        }
	nodeList.add(pactionNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new4() /* reduce AResetAction */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PAction pactionNode1;
        {
            // Block
        PReset presetNode2;
        presetNode2 = (PReset)nodeArrayList1.get(0);

        pactionNode1 = new AResetAction(presetNode2);
        }
	nodeList.add(pactionNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new5() /* reduce ANoneAction */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

        PAction pactionNode1;
        {
            // Block

        pactionNode1 = new ANoneAction();
        }
	nodeList.add(pactionNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new6() /* reduce AAproblem1Problem */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList7 = pop();
          ArrayList nodeArrayList6 = pop();
          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PProblem pproblemNode1;
        {
            // Block
        TKeywordProblem tkeywordproblemNode2;
        TIdentifier tidentifierNode3;
        TParenl tparenlNode4;
        LinkedList listNode5 = new LinkedList();
        TParenr tparenrNode6;
        TParenl tparenlNode7;
        LinkedList listNode8 = new LinkedList();
        TParenr tparenrNode9;
        PFormula pformulaNode10;
        tkeywordproblemNode2 = (TKeywordProblem)nodeArrayList1.get(0);
        tidentifierNode3 = (TIdentifier)nodeArrayList2.get(0);
        tparenlNode4 = (TParenl)nodeArrayList3.get(0);
        {
            // Block
        }
        tparenrNode6 = (TParenr)nodeArrayList4.get(0);
        tparenlNode7 = (TParenl)nodeArrayList5.get(0);
        {
            // Block
        }
        tparenrNode9 = (TParenr)nodeArrayList6.get(0);
        pformulaNode10 = (PFormula)nodeArrayList7.get(0);

        pproblemNode1 = new AProblem(tkeywordproblemNode2, tidentifierNode3, tparenlNode4, listNode5, tparenrNode6, tparenlNode7, listNode8, tparenrNode9, pformulaNode10);
        }
	nodeList.add(pproblemNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new7() /* reduce AAproblem2Problem */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList8 = pop();
          ArrayList nodeArrayList7 = pop();
          ArrayList nodeArrayList6 = pop();
          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PProblem pproblemNode1;
        {
            // Block
        TKeywordProblem tkeywordproblemNode2;
        TIdentifier tidentifierNode3;
        TParenl tparenlNode4;
        LinkedList listNode6 = new LinkedList();
        TParenr tparenrNode7;
        TParenl tparenlNode8;
        LinkedList listNode9 = new LinkedList();
        TParenr tparenrNode10;
        PFormula pformulaNode11;
        tkeywordproblemNode2 = (TKeywordProblem)nodeArrayList1.get(0);
        tidentifierNode3 = (TIdentifier)nodeArrayList2.get(0);
        tparenlNode4 = (TParenl)nodeArrayList3.get(0);
        {
            // Block
        LinkedList listNode5 = new LinkedList();
        listNode5 = (LinkedList)nodeArrayList4.get(0);
	if(listNode5 != null) //Macro:ParserTypedLinkedListAddAll
	{
      listNode6.addAll(listNode5);
  	  //listNode6 = listNode5;
	}
        }
        tparenrNode7 = (TParenr)nodeArrayList5.get(0);
        tparenlNode8 = (TParenl)nodeArrayList6.get(0);
        {
            // Block
        }
        tparenrNode10 = (TParenr)nodeArrayList7.get(0);
        pformulaNode11 = (PFormula)nodeArrayList8.get(0);

        pproblemNode1 = new AProblem(tkeywordproblemNode2, tidentifierNode3, tparenlNode4, listNode6, tparenrNode7, tparenlNode8, listNode9, tparenrNode10, pformulaNode11);
        }
	nodeList.add(pproblemNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new8() /* reduce AAproblem3Problem */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList8 = pop();
          ArrayList nodeArrayList7 = pop();
          ArrayList nodeArrayList6 = pop();
          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PProblem pproblemNode1;
        {
            // Block
        TKeywordProblem tkeywordproblemNode2;
        TIdentifier tidentifierNode3;
        TParenl tparenlNode4;
        LinkedList listNode5 = new LinkedList();
        TParenr tparenrNode6;
        TParenl tparenlNode7;
        LinkedList listNode9 = new LinkedList();
        TParenr tparenrNode10;
        PFormula pformulaNode11;
        tkeywordproblemNode2 = (TKeywordProblem)nodeArrayList1.get(0);
        tidentifierNode3 = (TIdentifier)nodeArrayList2.get(0);
        tparenlNode4 = (TParenl)nodeArrayList3.get(0);
        {
            // Block
        }
        tparenrNode6 = (TParenr)nodeArrayList4.get(0);
        tparenlNode7 = (TParenl)nodeArrayList5.get(0);
        {
            // Block
        LinkedList listNode8 = new LinkedList();
        listNode8 = (LinkedList)nodeArrayList6.get(0);
	if(listNode8 != null) //Macro:ParserTypedLinkedListAddAll
	{
      listNode9.addAll(listNode8);
  	  //listNode9 = listNode8;
	}
        }
        tparenrNode10 = (TParenr)nodeArrayList7.get(0);
        pformulaNode11 = (PFormula)nodeArrayList8.get(0);

        pproblemNode1 = new AProblem(tkeywordproblemNode2, tidentifierNode3, tparenlNode4, listNode5, tparenrNode6, tparenlNode7, listNode9, tparenrNode10, pformulaNode11);
        }
	nodeList.add(pproblemNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new9() /* reduce AAproblem4Problem */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList9 = pop();
          ArrayList nodeArrayList8 = pop();
          ArrayList nodeArrayList7 = pop();
          ArrayList nodeArrayList6 = pop();
          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PProblem pproblemNode1;
        {
            // Block
        TKeywordProblem tkeywordproblemNode2;
        TIdentifier tidentifierNode3;
        TParenl tparenlNode4;
        LinkedList listNode6 = new LinkedList();
        TParenr tparenrNode7;
        TParenl tparenlNode8;
        LinkedList listNode10 = new LinkedList();
        TParenr tparenrNode11;
        PFormula pformulaNode12;
        tkeywordproblemNode2 = (TKeywordProblem)nodeArrayList1.get(0);
        tidentifierNode3 = (TIdentifier)nodeArrayList2.get(0);
        tparenlNode4 = (TParenl)nodeArrayList3.get(0);
        {
            // Block
        LinkedList listNode5 = new LinkedList();
        listNode5 = (LinkedList)nodeArrayList4.get(0);
	if(listNode5 != null) //Macro:ParserTypedLinkedListAddAll
	{
      listNode6.addAll(listNode5);
  	  //listNode6 = listNode5;
	}
        }
        tparenrNode7 = (TParenr)nodeArrayList5.get(0);
        tparenlNode8 = (TParenl)nodeArrayList6.get(0);
        {
            // Block
        LinkedList listNode9 = new LinkedList();
        listNode9 = (LinkedList)nodeArrayList7.get(0);
	if(listNode9 != null) //Macro:ParserTypedLinkedListAddAll
	{
      listNode10.addAll(listNode9);
  	  //listNode10 = listNode9;
	}
        }
        tparenrNode11 = (TParenr)nodeArrayList8.get(0);
        pformulaNode12 = (PFormula)nodeArrayList9.get(0);

        pproblemNode1 = new AProblem(tkeywordproblemNode2, tidentifierNode3, tparenlNode4, listNode6, tparenrNode7, tparenlNode8, listNode10, tparenrNode11, pformulaNode12);
        }
	nodeList.add(pproblemNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new10() /* reduce APosZnumber */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PZnumber pznumberNode1;
        {
            // Block
        TNumber tnumberNode2;
        tnumberNode2 = (TNumber)nodeArrayList1.get(0);

        pznumberNode1 = new APosZnumber(tnumberNode2);
        }
	nodeList.add(pznumberNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new11() /* reduce ANegZnumber */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PZnumber pznumberNode1;
        {
            // Block
        TMinus tminusNode2;
        TNumber tnumberNode3;
        tminusNode2 = (TMinus)nodeArrayList1.get(0);
        tnumberNode3 = (TNumber)nodeArrayList2.get(0);

        pznumberNode1 = new ANegZnumber(tminusNode2, tnumberNode3);
        }
	nodeList.add(pznumberNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new12() /* reduce AStandardType */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PType ptypeNode1;
        {
            // Block
        TParenl tparenlNode2;
        TIdentifier tidentifierNode3;
        TNumber tnumberNode4;
        TParenr tparenrNode5;
        tparenlNode2 = (TParenl)nodeArrayList1.get(0);
        tidentifierNode3 = (TIdentifier)nodeArrayList2.get(0);
        tnumberNode4 = (TNumber)nodeArrayList3.get(0);
        tparenrNode5 = (TParenr)nodeArrayList4.get(0);

        ptypeNode1 = new AStandardType(tparenlNode2, tidentifierNode3, tnumberNode4, tparenrNode5);
        }
	nodeList.add(ptypeNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new13() /* reduce AAintstype1Type */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PType ptypeNode1;
        {
            // Block
        TParenl tparenlNode2;
        TKeywordInts tkeywordintsNode3;
        PPowpart ppowpartNode4;
          Object nullNode5 = null;
        TParenr tparenrNode6;
        tparenlNode2 = (TParenl)nodeArrayList1.get(0);
        tkeywordintsNode3 = (TKeywordInts)nodeArrayList2.get(0);
        ppowpartNode4 = (PPowpart)nodeArrayList3.get(0);
        tparenrNode6 = (TParenr)nodeArrayList4.get(0);

        ptypeNode1 = new AIntsType(tparenlNode2, tkeywordintsNode3, ppowpartNode4, null, tparenrNode6);
        }
	nodeList.add(ptypeNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new14() /* reduce AAintstype2Type */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PType ptypeNode1;
        {
            // Block
        TParenl tparenlNode2;
        TKeywordInts tkeywordintsNode3;
        PPowpart ppowpartNode4;
        PBitpart pbitpartNode5;
        TParenr tparenrNode6;
        tparenlNode2 = (TParenl)nodeArrayList1.get(0);
        tkeywordintsNode3 = (TKeywordInts)nodeArrayList2.get(0);
        ppowpartNode4 = (PPowpart)nodeArrayList3.get(0);
        pbitpartNode5 = (PBitpart)nodeArrayList4.get(0);
        tparenrNode6 = (TParenr)nodeArrayList5.get(0);

        ptypeNode1 = new AIntsType(tparenlNode2, tkeywordintsNode3, ppowpartNode4, pbitpartNode5, tparenrNode6);
        }
	nodeList.add(ptypeNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new15() /* reduce APowpart */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PPowpart ppowpartNode1;
        {
            // Block
        TParenl tparenlNode2;
        TIdentifier tidentifierNode3;
        PZnumber pznumberNode4;
        PZnumber pznumberNode5;
        TParenr tparenrNode6;
        tparenlNode2 = (TParenl)nodeArrayList1.get(0);
        tidentifierNode3 = (TIdentifier)nodeArrayList2.get(0);
        pznumberNode4 = (PZnumber)nodeArrayList3.get(0);
        pznumberNode5 = (PZnumber)nodeArrayList4.get(0);
        tparenrNode6 = (TParenr)nodeArrayList5.get(0);

        ppowpartNode1 = new APowpart(tparenlNode2, tidentifierNode3, pznumberNode4, pznumberNode5, tparenrNode6);
        }
	nodeList.add(ppowpartNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new16() /* reduce ABitpart */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PBitpart pbitpartNode1;
        {
            // Block
        TParenl tparenlNode2;
        TIdentifier tidentifierNode3;
        PZnumber pznumberNode4;
        PZnumber pznumberNode5;
        TParenr tparenrNode6;
        tparenlNode2 = (TParenl)nodeArrayList1.get(0);
        tidentifierNode3 = (TIdentifier)nodeArrayList2.get(0);
        pznumberNode4 = (PZnumber)nodeArrayList3.get(0);
        pznumberNode5 = (PZnumber)nodeArrayList4.get(0);
        tparenrNode6 = (TParenr)nodeArrayList5.get(0);

        pbitpartNode1 = new ABitpart(tparenlNode2, tidentifierNode3, pznumberNode4, pznumberNode5, tparenrNode6);
        }
	nodeList.add(pbitpartNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new17() /* reduce AArelation1Relation */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PRelation prelationNode1;
        {
            // Block
        TParenl tparenlNode2;
        TIdentifier tidentifierNode3;
          Object nullNode4 = null;
        PReltype preltypeNode5;
        LinkedList listNode7 = new LinkedList();
          Object nullNode8 = null;
        TParenr tparenrNode9;
        tparenlNode2 = (TParenl)nodeArrayList1.get(0);
        tidentifierNode3 = (TIdentifier)nodeArrayList2.get(0);
        preltypeNode5 = (PReltype)nodeArrayList3.get(0);
        {
            // Block
        LinkedList listNode6 = new LinkedList();
        listNode6 = (LinkedList)nodeArrayList4.get(0);
	if(listNode6 != null) //Macro:ParserTypedLinkedListAddAll
	{
      listNode7.addAll(listNode6);
  	  //listNode7 = listNode6;
	}
        }
        tparenrNode9 = (TParenr)nodeArrayList5.get(0);

        prelationNode1 = new ARelation(tparenlNode2, tidentifierNode3, null, preltypeNode5, listNode7, null, tparenrNode9);
        }
	nodeList.add(prelationNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new18() /* reduce AArelation2Relation */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList6 = pop();
          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PRelation prelationNode1;
        {
            // Block
        TParenl tparenlNode2;
        TIdentifier tidentifierNode3;
        TKeywordSingleton tkeywordsingletonNode4;
        PReltype preltypeNode5;
        LinkedList listNode7 = new LinkedList();
          Object nullNode8 = null;
        TParenr tparenrNode9;
        tparenlNode2 = (TParenl)nodeArrayList1.get(0);
        tidentifierNode3 = (TIdentifier)nodeArrayList2.get(0);
        tkeywordsingletonNode4 = (TKeywordSingleton)nodeArrayList3.get(0);
        preltypeNode5 = (PReltype)nodeArrayList4.get(0);
        {
            // Block
        LinkedList listNode6 = new LinkedList();
        listNode6 = (LinkedList)nodeArrayList5.get(0);
	if(listNode6 != null) //Macro:ParserTypedLinkedListAddAll
	{
      listNode7.addAll(listNode6);
  	  //listNode7 = listNode6;
	}
        }
        tparenrNode9 = (TParenr)nodeArrayList6.get(0);

        prelationNode1 = new ARelation(tparenlNode2, tidentifierNode3, tkeywordsingletonNode4, preltypeNode5, listNode7, null, tparenrNode9);
        }
	nodeList.add(prelationNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new19() /* reduce AArelation3Relation */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList6 = pop();
          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PRelation prelationNode1;
        {
            // Block
        TParenl tparenlNode2;
        TIdentifier tidentifierNode3;
          Object nullNode4 = null;
        PReltype preltypeNode5;
        LinkedList listNode7 = new LinkedList();
        PTupleset ptuplesetNode8;
        TParenr tparenrNode9;
        tparenlNode2 = (TParenl)nodeArrayList1.get(0);
        tidentifierNode3 = (TIdentifier)nodeArrayList2.get(0);
        preltypeNode5 = (PReltype)nodeArrayList3.get(0);
        {
            // Block
        LinkedList listNode6 = new LinkedList();
        listNode6 = (LinkedList)nodeArrayList4.get(0);
	if(listNode6 != null) //Macro:ParserTypedLinkedListAddAll
	{
      listNode7.addAll(listNode6);
  	  //listNode7 = listNode6;
	}
        }
        ptuplesetNode8 = (PTupleset)nodeArrayList5.get(0);
        tparenrNode9 = (TParenr)nodeArrayList6.get(0);

        prelationNode1 = new ARelation(tparenlNode2, tidentifierNode3, null, preltypeNode5, listNode7, ptuplesetNode8, tparenrNode9);
        }
	nodeList.add(prelationNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new20() /* reduce AArelation4Relation */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList7 = pop();
          ArrayList nodeArrayList6 = pop();
          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PRelation prelationNode1;
        {
            // Block
        TParenl tparenlNode2;
        TIdentifier tidentifierNode3;
        TKeywordSingleton tkeywordsingletonNode4;
        PReltype preltypeNode5;
        LinkedList listNode7 = new LinkedList();
        PTupleset ptuplesetNode8;
        TParenr tparenrNode9;
        tparenlNode2 = (TParenl)nodeArrayList1.get(0);
        tidentifierNode3 = (TIdentifier)nodeArrayList2.get(0);
        tkeywordsingletonNode4 = (TKeywordSingleton)nodeArrayList3.get(0);
        preltypeNode5 = (PReltype)nodeArrayList4.get(0);
        {
            // Block
        LinkedList listNode6 = new LinkedList();
        listNode6 = (LinkedList)nodeArrayList5.get(0);
	if(listNode6 != null) //Macro:ParserTypedLinkedListAddAll
	{
      listNode7.addAll(listNode6);
  	  //listNode7 = listNode6;
	}
        }
        ptuplesetNode8 = (PTupleset)nodeArrayList6.get(0);
        tparenrNode9 = (TParenr)nodeArrayList7.get(0);

        prelationNode1 = new ARelation(tparenlNode2, tidentifierNode3, tkeywordsingletonNode4, preltypeNode5, listNode7, ptuplesetNode8, tparenrNode9);
        }
	nodeList.add(prelationNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new21() /* reduce AExactReltype */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PReltype preltypeNode1;
        {
            // Block
        TKeywordExact tkeywordexactNode2;
        tkeywordexactNode2 = (TKeywordExact)nodeArrayList1.get(0);

        preltypeNode1 = new AExactReltype(tkeywordexactNode2);
        }
	nodeList.add(preltypeNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new22() /* reduce ASubsetReltype */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PReltype preltypeNode1;
        {
            // Block
        TKeywordSubset tkeywordsubsetNode2;
        tkeywordsubsetNode2 = (TKeywordSubset)nodeArrayList1.get(0);

        preltypeNode1 = new ASubsetReltype(tkeywordsubsetNode2);
        }
	nodeList.add(preltypeNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new23() /* reduce ATupleset */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PTupleset ptuplesetNode1;
        {
            // Block
        TParenl tparenlNode2;
        LinkedList listNode4 = new LinkedList();
        TParenr tparenrNode5;
        tparenlNode2 = (TParenl)nodeArrayList1.get(0);
        {
            // Block
        LinkedList listNode3 = new LinkedList();
        listNode3 = (LinkedList)nodeArrayList2.get(0);
	if(listNode3 != null) //Macro:ParserTypedLinkedListAddAll
	{
      listNode4.addAll(listNode3);
  	  //listNode4 = listNode3;
	}
        }
        tparenrNode5 = (TParenr)nodeArrayList3.get(0);

        ptuplesetNode1 = new ATupleset(tparenlNode2, listNode4, tparenrNode5);
        }
	nodeList.add(ptuplesetNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new24() /* reduce ATuple */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PTuple ptupleNode1;
        {
            // Block
        TAnglel tanglelNode2;
        LinkedList listNode4 = new LinkedList();
        TAngler tanglerNode5;
        tanglelNode2 = (TAnglel)nodeArrayList1.get(0);
        {
            // Block
        LinkedList listNode3 = new LinkedList();
        listNode3 = (LinkedList)nodeArrayList2.get(0);
	if(listNode3 != null) //Macro:ParserTypedLinkedListAddAll
	{
      listNode4.addAll(listNode3);
  	  //listNode4 = listNode3;
	}
        }
        tanglerNode5 = (TAngler)nodeArrayList3.get(0);

        ptupleNode1 = new ATuple(tanglelNode2, listNode4, tanglerNode5);
        }
	nodeList.add(ptupleNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new25() /* reduce ATyperefRange */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PRange prangeNode1;
        {
            // Block
        TIdentifier tidentifierNode2;
        tidentifierNode2 = (TIdentifier)nodeArrayList1.get(0);

        prangeNode1 = new ATyperefRange(tidentifierNode2);
        }
	nodeList.add(prangeNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new26() /* reduce ADefaultRange */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PRange prangeNode1;
        {
            // Block
        TBracketl tbracketlNode2;
        TIdentifier tidentifierNode3;
        TNumber tnumberNode4;
        TNumber tnumberNode5;
        TBracketr tbracketrNode6;
        tbracketlNode2 = (TBracketl)nodeArrayList1.get(0);
        tidentifierNode3 = (TIdentifier)nodeArrayList2.get(0);
        tnumberNode4 = (TNumber)nodeArrayList3.get(0);
        tnumberNode5 = (TNumber)nodeArrayList4.get(0);
        tbracketrNode6 = (TBracketr)nodeArrayList5.get(0);

        prangeNode1 = new ADefaultRange(tbracketlNode2, tidentifierNode3, tnumberNode4, tnumberNode5, tbracketrNode6);
        }
	nodeList.add(prangeNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new27() /* reduce AFormula */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PFormula pformulaNode1;
        {
            // Block
        TParenl tparenlNode2;
        PInnerformula pinnerformulaNode3;
        TParenr tparenrNode4;
        tparenlNode2 = (TParenl)nodeArrayList1.get(0);
        pinnerformulaNode3 = (PInnerformula)nodeArrayList2.get(0);
        tparenrNode4 = (TParenr)nodeArrayList3.get(0);

        pformulaNode1 = new AFormula(tparenlNode2, pinnerformulaNode3, tparenrNode4);
        }
	nodeList.add(pformulaNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new28() /* reduce AConstInnerformula */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PInnerformula pinnerformulaNode1;
        {
            // Block
        PLogConst plogconstNode2;
        plogconstNode2 = (PLogConst)nodeArrayList1.get(0);

        pinnerformulaNode1 = new AConstInnerformula(plogconstNode2);
        }
	nodeList.add(pinnerformulaNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new29() /* reduce AMultInnerformula */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PInnerformula pinnerformulaNode1;
        {
            // Block
        PMultiplicity pmultiplicityNode2;
        PExpression pexpressionNode3;
        pmultiplicityNode2 = (PMultiplicity)nodeArrayList1.get(0);
        pexpressionNode3 = (PExpression)nodeArrayList2.get(0);

        pinnerformulaNode1 = new AMultInnerformula(pmultiplicityNode2, pexpressionNode3);
        }
	nodeList.add(pinnerformulaNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new30() /* reduce ARel$In1Innerformula */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PInnerformula pinnerformulaNode1;
        {
            // Block
        PLogopRel plogoprelNode2;
        PExpression pexpressionNode4;
        PExpression pexpressionNode5;
        {
            // Block
        TKeywordIn tkeywordinNode3;
        tkeywordinNode3 = (TKeywordIn)nodeArrayList1.get(0);

        plogoprelNode2 = new AInLogopRel(tkeywordinNode3);
        }
        pexpressionNode4 = (PExpression)nodeArrayList2.get(0);
        pexpressionNode5 = (PExpression)nodeArrayList3.get(0);

        pinnerformulaNode1 = new ARelInnerformula(plogoprelNode2, pexpressionNode4, pexpressionNode5);
        }
	nodeList.add(pinnerformulaNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new31() /* reduce ARel$Equals1Innerformula */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PInnerformula pinnerformulaNode1;
        {
            // Block
        PLogopRel plogoprelNode2;
        PExpression pexpressionNode4;
        PExpression pexpressionNode5;
        {
            // Block
        TKeywordEquals tkeywordequalsNode3;
        tkeywordequalsNode3 = (TKeywordEquals)nodeArrayList1.get(0);

        plogoprelNode2 = new AEqualsLogopRel(tkeywordequalsNode3);
        }
        pexpressionNode4 = (PExpression)nodeArrayList2.get(0);
        pexpressionNode5 = (PExpression)nodeArrayList3.get(0);

        pinnerformulaNode1 = new ARelInnerformula(plogoprelNode2, pexpressionNode4, pexpressionNode5);
        }
	nodeList.add(pinnerformulaNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new32() /* reduce ANotInnerformula */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PInnerformula pinnerformulaNode1;
        {
            // Block
        TKeywordNot tkeywordnotNode2;
        PFormula pformulaNode3;
        tkeywordnotNode2 = (TKeywordNot)nodeArrayList1.get(0);
        pformulaNode3 = (PFormula)nodeArrayList2.get(0);

        pinnerformulaNode1 = new ANotInnerformula(tkeywordnotNode2, pformulaNode3);
        }
	nodeList.add(pinnerformulaNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new33() /* reduce AAandinnerformula1Innerformula */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PInnerformula pinnerformulaNode1;
        {
            // Block
        TKeywordAnd tkeywordandNode2;
        LinkedList listNode3 = new LinkedList();
        tkeywordandNode2 = (TKeywordAnd)nodeArrayList1.get(0);
        {
            // Block
        }

        pinnerformulaNode1 = new AAndInnerformula(tkeywordandNode2, listNode3);
        }
	nodeList.add(pinnerformulaNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new34() /* reduce AAandinnerformula2Innerformula */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PInnerformula pinnerformulaNode1;
        {
            // Block
        TKeywordAnd tkeywordandNode2;
        LinkedList listNode4 = new LinkedList();
        tkeywordandNode2 = (TKeywordAnd)nodeArrayList1.get(0);
        {
            // Block
        LinkedList listNode3 = new LinkedList();
        listNode3 = (LinkedList)nodeArrayList2.get(0);
	if(listNode3 != null) //Macro:ParserTypedLinkedListAddAll
	{
      listNode4.addAll(listNode3);
  	  //listNode4 = listNode3;
	}
        }

        pinnerformulaNode1 = new AAndInnerformula(tkeywordandNode2, listNode4);
        }
	nodeList.add(pinnerformulaNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new35() /* reduce ABinaryInnerformula */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PInnerformula pinnerformulaNode1;
        {
            // Block
        PLogopBinary plogopbinaryNode2;
        PFormula pformulaNode3;
        PFormula pformulaNode4;
        plogopbinaryNode2 = (PLogopBinary)nodeArrayList1.get(0);
        pformulaNode3 = (PFormula)nodeArrayList2.get(0);
        pformulaNode4 = (PFormula)nodeArrayList3.get(0);

        pinnerformulaNode1 = new ABinaryInnerformula(plogopbinaryNode2, pformulaNode3, pformulaNode4);
        }
	nodeList.add(pinnerformulaNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new36() /* reduce AQuantInnerformula */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PInnerformula pinnerformulaNode1;
        {
            // Block
        PQuantifier pquantifierNode2;
        TParenl tparenlNode3;
        PDecls pdeclsNode4;
        TParenr tparenrNode5;
        PFormula pformulaNode6;
        pquantifierNode2 = (PQuantifier)nodeArrayList1.get(0);
        tparenlNode3 = (TParenl)nodeArrayList2.get(0);
        pdeclsNode4 = (PDecls)nodeArrayList3.get(0);
        tparenrNode5 = (TParenr)nodeArrayList4.get(0);
        pformulaNode6 = (PFormula)nodeArrayList5.get(0);

        pinnerformulaNode1 = new AQuantInnerformula(pquantifierNode2, tparenlNode3, pdeclsNode4, tparenrNode5, pformulaNode6);
        }
	nodeList.add(pinnerformulaNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new37() /* reduce AInt$Equals1Innerformula */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PInnerformula pinnerformulaNode1;
        {
            // Block
        PIntCompOp pintcompopNode2;
        PIntexpression pintexpressionNode4;
        PIntexpression pintexpressionNode5;
        {
            // Block
        TKeywordEquals tkeywordequalsNode3;
        tkeywordequalsNode3 = (TKeywordEquals)nodeArrayList1.get(0);

        pintcompopNode2 = new AEqualsIntCompOp(tkeywordequalsNode3);
        }
        pintexpressionNode4 = (PIntexpression)nodeArrayList2.get(0);
        pintexpressionNode5 = (PIntexpression)nodeArrayList3.get(0);

        pinnerformulaNode1 = new AIntInnerformula(pintcompopNode2, pintexpressionNode4, pintexpressionNode5);
        }
	nodeList.add(pinnerformulaNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new38() /* reduce AInt$Greater1Innerformula */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PInnerformula pinnerformulaNode1;
        {
            // Block
        PIntCompOp pintcompopNode2;
        PIntexpression pintexpressionNode4;
        PIntexpression pintexpressionNode5;
        {
            // Block
        TKeywordGreater tkeywordgreaterNode3;
        tkeywordgreaterNode3 = (TKeywordGreater)nodeArrayList1.get(0);

        pintcompopNode2 = new AGreaterIntCompOp(tkeywordgreaterNode3);
        }
        pintexpressionNode4 = (PIntexpression)nodeArrayList2.get(0);
        pintexpressionNode5 = (PIntexpression)nodeArrayList3.get(0);

        pinnerformulaNode1 = new AIntInnerformula(pintcompopNode2, pintexpressionNode4, pintexpressionNode5);
        }
	nodeList.add(pinnerformulaNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new39() /* reduce AInt$Greaterequal1Innerformula */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PInnerformula pinnerformulaNode1;
        {
            // Block
        PIntCompOp pintcompopNode2;
        PIntexpression pintexpressionNode4;
        PIntexpression pintexpressionNode5;
        {
            // Block
        TKeywordGreaterEqual tkeywordgreaterequalNode3;
        tkeywordgreaterequalNode3 = (TKeywordGreaterEqual)nodeArrayList1.get(0);

        pintcompopNode2 = new AGreaterequalIntCompOp(tkeywordgreaterequalNode3);
        }
        pintexpressionNode4 = (PIntexpression)nodeArrayList2.get(0);
        pintexpressionNode5 = (PIntexpression)nodeArrayList3.get(0);

        pinnerformulaNode1 = new AIntInnerformula(pintcompopNode2, pintexpressionNode4, pintexpressionNode5);
        }
	nodeList.add(pinnerformulaNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new40() /* reduce AInt$Lesser1Innerformula */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PInnerformula pinnerformulaNode1;
        {
            // Block
        PIntCompOp pintcompopNode2;
        PIntexpression pintexpressionNode4;
        PIntexpression pintexpressionNode5;
        {
            // Block
        TKeywordLesser tkeywordlesserNode3;
        tkeywordlesserNode3 = (TKeywordLesser)nodeArrayList1.get(0);

        pintcompopNode2 = new ALesserIntCompOp(tkeywordlesserNode3);
        }
        pintexpressionNode4 = (PIntexpression)nodeArrayList2.get(0);
        pintexpressionNode5 = (PIntexpression)nodeArrayList3.get(0);

        pinnerformulaNode1 = new AIntInnerformula(pintcompopNode2, pintexpressionNode4, pintexpressionNode5);
        }
	nodeList.add(pinnerformulaNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new41() /* reduce AInt$Lesserequal1Innerformula */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PInnerformula pinnerformulaNode1;
        {
            // Block
        PIntCompOp pintcompopNode2;
        PIntexpression pintexpressionNode4;
        PIntexpression pintexpressionNode5;
        {
            // Block
        TKeywordLesserEqual tkeywordlesserequalNode3;
        tkeywordlesserequalNode3 = (TKeywordLesserEqual)nodeArrayList1.get(0);

        pintcompopNode2 = new ALesserequalIntCompOp(tkeywordlesserequalNode3);
        }
        pintexpressionNode4 = (PIntexpression)nodeArrayList2.get(0);
        pintexpressionNode5 = (PIntexpression)nodeArrayList3.get(0);

        pinnerformulaNode1 = new AIntInnerformula(pintcompopNode2, pintexpressionNode4, pintexpressionNode5);
        }
	nodeList.add(pinnerformulaNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new42() /* reduce AFuncInnerformula */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PInnerformula pinnerformulaNode1;
        {
            // Block
        PLogopFunction plogopfunctionNode2;
        PExpression pexpressionNode3;
        PExpression pexpressionNode4;
        PExpression pexpressionNode5;
        plogopfunctionNode2 = (PLogopFunction)nodeArrayList1.get(0);
        pexpressionNode3 = (PExpression)nodeArrayList2.get(0);
        pexpressionNode4 = (PExpression)nodeArrayList3.get(0);
        pexpressionNode5 = (PExpression)nodeArrayList4.get(0);

        pinnerformulaNode1 = new AFuncInnerformula(plogopfunctionNode2, pexpressionNode3, pexpressionNode4, pexpressionNode5);
        }
	nodeList.add(pinnerformulaNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new43() /* reduce ATrueLogConst */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PLogConst plogconstNode1;
        {
            // Block
        TKeywordTrue tkeywordtrueNode2;
        tkeywordtrueNode2 = (TKeywordTrue)nodeArrayList1.get(0);

        plogconstNode1 = new ATrueLogConst(tkeywordtrueNode2);
        }
	nodeList.add(plogconstNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new44() /* reduce AFalseLogConst */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PLogConst plogconstNode1;
        {
            // Block
        TKeywordFalse tkeywordfalseNode2;
        tkeywordfalseNode2 = (TKeywordFalse)nodeArrayList1.get(0);

        plogconstNode1 = new AFalseLogConst(tkeywordfalseNode2);
        }
	nodeList.add(plogconstNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new45() /* reduce ATotalLogopFunction */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PLogopFunction plogopfunctionNode1;
        {
            // Block
        TKeywordTotalFunction tkeywordtotalfunctionNode2;
        tkeywordtotalfunctionNode2 = (TKeywordTotalFunction)nodeArrayList1.get(0);

        plogopfunctionNode1 = new ATotalLogopFunction(tkeywordtotalfunctionNode2);
        }
	nodeList.add(plogopfunctionNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new46() /* reduce APartialLogopFunction */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PLogopFunction plogopfunctionNode1;
        {
            // Block
        TKeywordPartialFunction tkeywordpartialfunctionNode2;
        tkeywordpartialfunctionNode2 = (TKeywordPartialFunction)nodeArrayList1.get(0);

        plogopfunctionNode1 = new APartialLogopFunction(tkeywordpartialfunctionNode2);
        }
	nodeList.add(plogopfunctionNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new47() /* reduce AOrLogopBinary */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PLogopBinary plogopbinaryNode1;
        {
            // Block
        TKeywordOr tkeywordorNode2;
        tkeywordorNode2 = (TKeywordOr)nodeArrayList1.get(0);

        plogopbinaryNode1 = new AOrLogopBinary(tkeywordorNode2);
        }
	nodeList.add(plogopbinaryNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new48() /* reduce AImpliesLogopBinary */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PLogopBinary plogopbinaryNode1;
        {
            // Block
        TKeywordImplies tkeywordimpliesNode2;
        tkeywordimpliesNode2 = (TKeywordImplies)nodeArrayList1.get(0);

        plogopbinaryNode1 = new AImpliesLogopBinary(tkeywordimpliesNode2);
        }
	nodeList.add(plogopbinaryNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new49() /* reduce AIffLogopBinary */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PLogopBinary plogopbinaryNode1;
        {
            // Block
        TKeywordIff tkeywordiffNode2;
        tkeywordiffNode2 = (TKeywordIff)nodeArrayList1.get(0);

        plogopbinaryNode1 = new AIffLogopBinary(tkeywordiffNode2);
        }
	nodeList.add(plogopbinaryNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new50() /* reduce AAllQuantifier */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PQuantifier pquantifierNode1;
        {
            // Block
        TKeywordAll tkeywordallNode2;
        tkeywordallNode2 = (TKeywordAll)nodeArrayList1.get(0);

        pquantifierNode1 = new AAllQuantifier(tkeywordallNode2);
        }
	nodeList.add(pquantifierNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new51() /* reduce AExistsQuantifier */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PQuantifier pquantifierNode1;
        {
            // Block
        TKeywordExists tkeywordexistsNode2;
        tkeywordexistsNode2 = (TKeywordExists)nodeArrayList1.get(0);

        pquantifierNode1 = new AExistsQuantifier(tkeywordexistsNode2);
        }
	nodeList.add(pquantifierNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new52() /* reduce ANilDecls */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

        PDecls pdeclsNode1;
        {
            // Block

        pdeclsNode1 = new ANilDecls();
        }
	nodeList.add(pdeclsNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new53() /* reduce AConsDecls */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList7 = pop();
          ArrayList nodeArrayList6 = pop();
          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PDecls pdeclsNode1;
        {
            // Block
        TParenl tparenlNode2;
        TIdentifier tidentifierNode3;
        TNumber tnumberNode4;
        PMultiplicity pmultiplicityNode5;
        PExpression pexpressionNode6;
        TParenr tparenrNode7;
        PDecls pdeclsNode8;
        tparenlNode2 = (TParenl)nodeArrayList1.get(0);
        tidentifierNode3 = (TIdentifier)nodeArrayList2.get(0);
        tnumberNode4 = (TNumber)nodeArrayList3.get(0);
        pmultiplicityNode5 = (PMultiplicity)nodeArrayList4.get(0);
        pexpressionNode6 = (PExpression)nodeArrayList5.get(0);
        tparenrNode7 = (TParenr)nodeArrayList6.get(0);
        pdeclsNode8 = (PDecls)nodeArrayList7.get(0);

        pdeclsNode1 = new AConsDecls(tparenlNode2, tidentifierNode3, tnumberNode4, pmultiplicityNode5, pexpressionNode6, tparenrNode7, pdeclsNode8);
        }
	nodeList.add(pdeclsNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new54() /* reduce AOneMultiplicity */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PMultiplicity pmultiplicityNode1;
        {
            // Block
        TKeywordOne tkeywordoneNode2;
        tkeywordoneNode2 = (TKeywordOne)nodeArrayList1.get(0);

        pmultiplicityNode1 = new AOneMultiplicity(tkeywordoneNode2);
        }
	nodeList.add(pmultiplicityNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new55() /* reduce ASomeMultiplicity */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PMultiplicity pmultiplicityNode1;
        {
            // Block
        TKeywordSome tkeywordsomeNode2;
        tkeywordsomeNode2 = (TKeywordSome)nodeArrayList1.get(0);

        pmultiplicityNode1 = new ASomeMultiplicity(tkeywordsomeNode2);
        }
	nodeList.add(pmultiplicityNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new56() /* reduce ANoMultiplicity */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PMultiplicity pmultiplicityNode1;
        {
            // Block
        TKeywordNo tkeywordnoNode2;
        tkeywordnoNode2 = (TKeywordNo)nodeArrayList1.get(0);

        pmultiplicityNode1 = new ANoMultiplicity(tkeywordnoNode2);
        }
	nodeList.add(pmultiplicityNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new57() /* reduce ALoneMultiplicity */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PMultiplicity pmultiplicityNode1;
        {
            // Block
        TKeywordLone tkeywordloneNode2;
        tkeywordloneNode2 = (TKeywordLone)nodeArrayList1.get(0);

        pmultiplicityNode1 = new ALoneMultiplicity(tkeywordloneNode2);
        }
	nodeList.add(pmultiplicityNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new58() /* reduce ASetMultiplicity */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PMultiplicity pmultiplicityNode1;
        {
            // Block
        TKeywordSet tkeywordsetNode2;
        tkeywordsetNode2 = (TKeywordSet)nodeArrayList1.get(0);

        pmultiplicityNode1 = new ASetMultiplicity(tkeywordsetNode2);
        }
	nodeList.add(pmultiplicityNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new59() /* reduce AExpression */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PExpression pexpressionNode1;
        {
            // Block
        TParenl tparenlNode2;
        PInnerexpression pinnerexpressionNode3;
        TParenr tparenrNode4;
        tparenlNode2 = (TParenl)nodeArrayList1.get(0);
        pinnerexpressionNode3 = (PInnerexpression)nodeArrayList2.get(0);
        tparenrNode4 = (TParenr)nodeArrayList3.get(0);

        pexpressionNode1 = new AExpression(tparenlNode2, pinnerexpressionNode3, tparenrNode4);
        }
	nodeList.add(pexpressionNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new60() /* reduce AConstInnerexpression */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PInnerexpression pinnerexpressionNode1;
        {
            // Block
        PExprConst pexprconstNode2;
        pexprconstNode2 = (PExprConst)nodeArrayList1.get(0);

        pinnerexpressionNode1 = new AConstInnerexpression(pexprconstNode2);
        }
	nodeList.add(pinnerexpressionNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new61() /* reduce AUnaryInnerexpression */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PInnerexpression pinnerexpressionNode1;
        {
            // Block
        PExprUnop pexprunopNode2;
        PExpression pexpressionNode3;
        pexprunopNode2 = (PExprUnop)nodeArrayList1.get(0);
        pexpressionNode3 = (PExpression)nodeArrayList2.get(0);

        pinnerexpressionNode1 = new AUnaryInnerexpression(pexprunopNode2, pexpressionNode3);
        }
	nodeList.add(pinnerexpressionNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new62() /* reduce AMultiInnerexpression */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PInnerexpression pinnerexpressionNode1;
        {
            // Block
        PExprMultop pexprmultopNode2;
        LinkedList listNode4 = new LinkedList();
        pexprmultopNode2 = (PExprMultop)nodeArrayList1.get(0);
        {
            // Block
        LinkedList listNode3 = new LinkedList();
        listNode3 = (LinkedList)nodeArrayList2.get(0);
	if(listNode3 != null) //Macro:ParserTypedLinkedListAddAll
	{
      listNode4.addAll(listNode3);
  	  //listNode4 = listNode3;
	}
        }

        pinnerexpressionNode1 = new AMultiInnerexpression(pexprmultopNode2, listNode4);
        }
	nodeList.add(pinnerexpressionNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new63() /* reduce ABinaryInnerexpression */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PInnerexpression pinnerexpressionNode1;
        {
            // Block
        PExprBinop pexprbinopNode2;
        PExpression pexpressionNode3;
        PExpression pexpressionNode4;
        pexprbinopNode2 = (PExprBinop)nodeArrayList1.get(0);
        pexpressionNode3 = (PExpression)nodeArrayList2.get(0);
        pexpressionNode4 = (PExpression)nodeArrayList3.get(0);

        pinnerexpressionNode1 = new ABinaryInnerexpression(pexprbinopNode2, pexpressionNode3, pexpressionNode4);
        }
	nodeList.add(pinnerexpressionNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new64() /* reduce ARelrefInnerexpression */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PInnerexpression pinnerexpressionNode1;
        {
            // Block
        TKeywordRelref tkeywordrelrefNode2;
        TIdentifier tidentifierNode3;
        tkeywordrelrefNode2 = (TKeywordRelref)nodeArrayList1.get(0);
        tidentifierNode3 = (TIdentifier)nodeArrayList2.get(0);

        pinnerexpressionNode1 = new ARelrefInnerexpression(tkeywordrelrefNode2, tidentifierNode3);
        }
	nodeList.add(pinnerexpressionNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new65() /* reduce AVarrefInnerexpression */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PInnerexpression pinnerexpressionNode1;
        {
            // Block
        TKeywordVarref tkeywordvarrefNode2;
        TIdentifier tidentifierNode3;
        tkeywordvarrefNode2 = (TKeywordVarref)nodeArrayList1.get(0);
        tidentifierNode3 = (TIdentifier)nodeArrayList2.get(0);

        pinnerexpressionNode1 = new AVarrefInnerexpression(tkeywordvarrefNode2, tidentifierNode3);
        }
	nodeList.add(pinnerexpressionNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new66() /* reduce ACompInnerexpression */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PInnerexpression pinnerexpressionNode1;
        {
            // Block
        TKeywordComprehension tkeywordcomprehensionNode2;
        TParenl tparenlNode3;
        PDecls pdeclsNode4;
        TParenr tparenrNode5;
        PFormula pformulaNode6;
        tkeywordcomprehensionNode2 = (TKeywordComprehension)nodeArrayList1.get(0);
        tparenlNode3 = (TParenl)nodeArrayList2.get(0);
        pdeclsNode4 = (PDecls)nodeArrayList3.get(0);
        tparenrNode5 = (TParenr)nodeArrayList4.get(0);
        pformulaNode6 = (PFormula)nodeArrayList5.get(0);

        pinnerexpressionNode1 = new ACompInnerexpression(tkeywordcomprehensionNode2, tparenlNode3, pdeclsNode4, tparenrNode5, pformulaNode6);
        }
	nodeList.add(pinnerexpressionNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new67() /* reduce APrjInnerexpression */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PInnerexpression pinnerexpressionNode1;
        {
            // Block
        TKeywordProjection tkeywordprojectionNode2;
        TParenl tparenlNode3;
        LinkedList listNode5 = new LinkedList();
        TParenr tparenrNode6;
        PExpression pexpressionNode7;
        tkeywordprojectionNode2 = (TKeywordProjection)nodeArrayList1.get(0);
        tparenlNode3 = (TParenl)nodeArrayList2.get(0);
        {
            // Block
        LinkedList listNode4 = new LinkedList();
        listNode4 = (LinkedList)nodeArrayList3.get(0);
	if(listNode4 != null) //Macro:ParserTypedLinkedListAddAll
	{
      listNode5.addAll(listNode4);
  	  //listNode5 = listNode4;
	}
        }
        tparenrNode6 = (TParenr)nodeArrayList4.get(0);
        pexpressionNode7 = (PExpression)nodeArrayList5.get(0);

        pinnerexpressionNode1 = new APrjInnerexpression(tkeywordprojectionNode2, tparenlNode3, listNode5, tparenrNode6, pexpressionNode7);
        }
	nodeList.add(pinnerexpressionNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new68() /* reduce ACastInnerexpression */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PInnerexpression pinnerexpressionNode1;
        {
            // Block
        PExprCast pexprcastNode2;
        PIntexpression pintexpressionNode3;
        pexprcastNode2 = (PExprCast)nodeArrayList1.get(0);
        pintexpressionNode3 = (PIntexpression)nodeArrayList2.get(0);

        pinnerexpressionNode1 = new ACastInnerexpression(pexprcastNode2, pintexpressionNode3);
        }
	nodeList.add(pinnerexpressionNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new69() /* reduce AIfInnerexpression */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PInnerexpression pinnerexpressionNode1;
        {
            // Block
        TKeywordIf tkeywordifNode2;
        PFormula pformulaNode3;
        PExpression pexpressionNode4;
        PExpression pexpressionNode5;
        tkeywordifNode2 = (TKeywordIf)nodeArrayList1.get(0);
        pformulaNode3 = (PFormula)nodeArrayList2.get(0);
        pexpressionNode4 = (PExpression)nodeArrayList3.get(0);
        pexpressionNode5 = (PExpression)nodeArrayList4.get(0);

        pinnerexpressionNode1 = new AIfInnerexpression(tkeywordifNode2, pformulaNode3, pexpressionNode4, pexpressionNode5);
        }
	nodeList.add(pinnerexpressionNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new70() /* reduce APow2ExprCast */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PExprCast pexprcastNode1;
        {
            // Block
        TKeywordInt2pow2 tkeywordint2pow2Node2;
        tkeywordint2pow2Node2 = (TKeywordInt2pow2)nodeArrayList1.get(0);

        pexprcastNode1 = new APow2ExprCast(tkeywordint2pow2Node2);
        }
	nodeList.add(pexprcastNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new71() /* reduce AIntsetExprCast */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PExprCast pexprcastNode1;
        {
            // Block
        TKeywordInt2intset tkeywordint2intsetNode2;
        tkeywordint2intsetNode2 = (TKeywordInt2intset)nodeArrayList1.get(0);

        pexprcastNode1 = new AIntsetExprCast(tkeywordint2intsetNode2);
        }
	nodeList.add(pexprcastNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new72() /* reduce AEmptyExprConst */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PExprConst pexprconstNode1;
        {
            // Block
        TKeywordEmpty tkeywordemptyNode2;
        tkeywordemptyNode2 = (TKeywordEmpty)nodeArrayList1.get(0);

        pexprconstNode1 = new AEmptyExprConst(tkeywordemptyNode2);
        }
	nodeList.add(pexprconstNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new73() /* reduce AIdenExprConst */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PExprConst pexprconstNode1;
        {
            // Block
        TKeywordIden tkeywordidenNode2;
        tkeywordidenNode2 = (TKeywordIden)nodeArrayList1.get(0);

        pexprconstNode1 = new AIdenExprConst(tkeywordidenNode2);
        }
	nodeList.add(pexprconstNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new74() /* reduce AUnivExprConst */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PExprConst pexprconstNode1;
        {
            // Block
        TKeywordUniv tkeywordunivNode2;
        tkeywordunivNode2 = (TKeywordUniv)nodeArrayList1.get(0);

        pexprconstNode1 = new AUnivExprConst(tkeywordunivNode2);
        }
	nodeList.add(pexprconstNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new75() /* reduce AUnionExprMultop */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PExprMultop pexprmultopNode1;
        {
            // Block
        TKeywordUnion tkeywordunionNode2;
        tkeywordunionNode2 = (TKeywordUnion)nodeArrayList1.get(0);

        pexprmultopNode1 = new AUnionExprMultop(tkeywordunionNode2);
        }
	nodeList.add(pexprmultopNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new76() /* reduce AInterExprMultop */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PExprMultop pexprmultopNode1;
        {
            // Block
        TKeywordIntersection tkeywordintersectionNode2;
        tkeywordintersectionNode2 = (TKeywordIntersection)nodeArrayList1.get(0);

        pexprmultopNode1 = new AInterExprMultop(tkeywordintersectionNode2);
        }
	nodeList.add(pexprmultopNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new77() /* reduce AProductExprMultop */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PExprMultop pexprmultopNode1;
        {
            // Block
        TKeywordProduct tkeywordproductNode2;
        tkeywordproductNode2 = (TKeywordProduct)nodeArrayList1.get(0);

        pexprmultopNode1 = new AProductExprMultop(tkeywordproductNode2);
        }
	nodeList.add(pexprmultopNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new78() /* reduce ADiffExprBinop */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PExprBinop pexprbinopNode1;
        {
            // Block
        TKeywordDiff tkeyworddiffNode2;
        tkeyworddiffNode2 = (TKeywordDiff)nodeArrayList1.get(0);

        pexprbinopNode1 = new ADiffExprBinop(tkeyworddiffNode2);
        }
	nodeList.add(pexprbinopNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new79() /* reduce AJoinExprBinop */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PExprBinop pexprbinopNode1;
        {
            // Block
        TKeywordJoin tkeywordjoinNode2;
        tkeywordjoinNode2 = (TKeywordJoin)nodeArrayList1.get(0);

        pexprbinopNode1 = new AJoinExprBinop(tkeywordjoinNode2);
        }
	nodeList.add(pexprbinopNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new80() /* reduce AOverwriteExprBinop */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PExprBinop pexprbinopNode1;
        {
            // Block
        TKeywordOverwrite tkeywordoverwriteNode2;
        tkeywordoverwriteNode2 = (TKeywordOverwrite)nodeArrayList1.get(0);

        pexprbinopNode1 = new AOverwriteExprBinop(tkeywordoverwriteNode2);
        }
	nodeList.add(pexprbinopNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new81() /* reduce ATransposeExprUnop */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PExprUnop pexprunopNode1;
        {
            // Block
        TKeywordTranspose tkeywordtransposeNode2;
        tkeywordtransposeNode2 = (TKeywordTranspose)nodeArrayList1.get(0);

        pexprunopNode1 = new ATransposeExprUnop(tkeywordtransposeNode2);
        }
	nodeList.add(pexprunopNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new82() /* reduce AClosureExprUnop */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PExprUnop pexprunopNode1;
        {
            // Block
        TKeywordClosure tkeywordclosureNode2;
        tkeywordclosureNode2 = (TKeywordClosure)nodeArrayList1.get(0);

        pexprunopNode1 = new AClosureExprUnop(tkeywordclosureNode2);
        }
	nodeList.add(pexprunopNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new83() /* reduce AIntexpression */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PIntexpression pintexpressionNode1;
        {
            // Block
        TParenl tparenlNode2;
        PInnerintexpression pinnerintexpressionNode3;
        TParenr tparenrNode4;
        tparenlNode2 = (TParenl)nodeArrayList1.get(0);
        pinnerintexpressionNode3 = (PInnerintexpression)nodeArrayList2.get(0);
        tparenrNode4 = (TParenr)nodeArrayList3.get(0);

        pintexpressionNode1 = new AIntexpression(tparenlNode2, pinnerintexpressionNode3, tparenrNode4);
        }
	nodeList.add(pintexpressionNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new84() /* reduce AConstInnerintexpression */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PInnerintexpression pinnerintexpressionNode1;
        {
            // Block
        PZnumber pznumberNode2;
        pznumberNode2 = (PZnumber)nodeArrayList1.get(0);

        pinnerintexpressionNode1 = new AConstInnerintexpression(pznumberNode2);
        }
	nodeList.add(pinnerintexpressionNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new85() /* reduce ACardInnerintexpression */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PInnerintexpression pinnerintexpressionNode1;
        {
            // Block
        TKeywordCardinality tkeywordcardinalityNode2;
        PExpression pexpressionNode3;
        tkeywordcardinalityNode2 = (TKeywordCardinality)nodeArrayList1.get(0);
        pexpressionNode3 = (PExpression)nodeArrayList2.get(0);

        pinnerintexpressionNode1 = new ACardInnerintexpression(tkeywordcardinalityNode2, pexpressionNode3);
        }
	nodeList.add(pinnerintexpressionNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new86() /* reduce ABinaryInnerintexpression */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PInnerintexpression pinnerintexpressionNode1;
        {
            // Block
        PIntexprBinop pintexprbinopNode2;
        PIntexpression pintexpressionNode3;
        PIntexpression pintexpressionNode4;
        pintexprbinopNode2 = (PIntexprBinop)nodeArrayList1.get(0);
        pintexpressionNode3 = (PIntexpression)nodeArrayList2.get(0);
        pintexpressionNode4 = (PIntexpression)nodeArrayList3.get(0);

        pinnerintexpressionNode1 = new ABinaryInnerintexpression(pintexprbinopNode2, pintexpressionNode3, pintexpressionNode4);
        }
	nodeList.add(pinnerintexpressionNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new87() /* reduce ACastInnerintexpression */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PInnerintexpression pinnerintexpressionNode1;
        {
            // Block
        TKeywordExpr2int tkeywordexpr2intNode2;
        PExpression pexpressionNode3;
        tkeywordexpr2intNode2 = (TKeywordExpr2int)nodeArrayList1.get(0);
        pexpressionNode3 = (PExpression)nodeArrayList2.get(0);

        pinnerintexpressionNode1 = new ACastInnerintexpression(tkeywordexpr2intNode2, pexpressionNode3);
        }
	nodeList.add(pinnerintexpressionNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new88() /* reduce AAddIntexprBinop */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PIntexprBinop pintexprbinopNode1;
        {
            // Block
        TKeywordAddition tkeywordadditionNode2;
        tkeywordadditionNode2 = (TKeywordAddition)nodeArrayList1.get(0);

        pintexprbinopNode1 = new AAddIntexprBinop(tkeywordadditionNode2);
        }
	nodeList.add(pintexprbinopNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new89() /* reduce ASubIntexprBinop */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PIntexprBinop pintexprbinopNode1;
        {
            // Block
        TKeywordSubtraction tkeywordsubtractionNode2;
        tkeywordsubtractionNode2 = (TKeywordSubtraction)nodeArrayList1.get(0);

        pintexprbinopNode1 = new ASubIntexprBinop(tkeywordsubtractionNode2);
        }
	nodeList.add(pintexprbinopNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new90() /* reduce AMulIntexprBinop */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PIntexprBinop pintexprbinopNode1;
        {
            // Block
        TKeywordMultiplication tkeywordmultiplicationNode2;
        tkeywordmultiplicationNode2 = (TKeywordMultiplication)nodeArrayList1.get(0);

        pintexprbinopNode1 = new AMulIntexprBinop(tkeywordmultiplicationNode2);
        }
	nodeList.add(pintexprbinopNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new91() /* reduce ADivIntexprBinop */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PIntexprBinop pintexprbinopNode1;
        {
            // Block
        TKeywordDivision tkeyworddivisionNode2;
        tkeyworddivisionNode2 = (TKeywordDivision)nodeArrayList1.get(0);

        pintexprbinopNode1 = new ADivIntexprBinop(tkeyworddivisionNode2);
        }
	nodeList.add(pintexprbinopNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new92() /* reduce AModIntexprBinop */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PIntexprBinop pintexprbinopNode1;
        {
            // Block
        TKeywordModulo tkeywordmoduloNode2;
        tkeywordmoduloNode2 = (TKeywordModulo)nodeArrayList1.get(0);

        pintexprbinopNode1 = new AModIntexprBinop(tkeywordmoduloNode2);
        }
	nodeList.add(pintexprbinopNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new93() /* reduce AArequest1Request */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList6 = pop();
          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PRequest prequestNode1;
        {
            // Block
        TKeywordRequest tkeywordrequestNode2;
        TIdentifier tidentifierNode3;
        TNumber tnumberNode4;
        PReqtype preqtypeNode5;
        TParenl tparenlNode6;
        LinkedList listNode7 = new LinkedList();
        TParenr tparenrNode8;
        tkeywordrequestNode2 = (TKeywordRequest)nodeArrayList1.get(0);
        tidentifierNode3 = (TIdentifier)nodeArrayList2.get(0);
        tnumberNode4 = (TNumber)nodeArrayList3.get(0);
        preqtypeNode5 = (PReqtype)nodeArrayList4.get(0);
        tparenlNode6 = (TParenl)nodeArrayList5.get(0);
        {
            // Block
        }
        tparenrNode8 = (TParenr)nodeArrayList6.get(0);

        prequestNode1 = new ARequest(tkeywordrequestNode2, tidentifierNode3, tnumberNode4, preqtypeNode5, tparenlNode6, listNode7, tparenrNode8);
        }
	nodeList.add(prequestNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new94() /* reduce AArequest2Request */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList7 = pop();
          ArrayList nodeArrayList6 = pop();
          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PRequest prequestNode1;
        {
            // Block
        TKeywordRequest tkeywordrequestNode2;
        TIdentifier tidentifierNode3;
        TNumber tnumberNode4;
        PReqtype preqtypeNode5;
        TParenl tparenlNode6;
        LinkedList listNode8 = new LinkedList();
        TParenr tparenrNode9;
        tkeywordrequestNode2 = (TKeywordRequest)nodeArrayList1.get(0);
        tidentifierNode3 = (TIdentifier)nodeArrayList2.get(0);
        tnumberNode4 = (TNumber)nodeArrayList3.get(0);
        preqtypeNode5 = (PReqtype)nodeArrayList4.get(0);
        tparenlNode6 = (TParenl)nodeArrayList5.get(0);
        {
            // Block
        LinkedList listNode7 = new LinkedList();
        listNode7 = (LinkedList)nodeArrayList6.get(0);
	if(listNode7 != null) //Macro:ParserTypedLinkedListAddAll
	{
      listNode8.addAll(listNode7);
  	  //listNode8 = listNode7;
	}
        }
        tparenrNode9 = (TParenr)nodeArrayList7.get(0);

        prequestNode1 = new ARequest(tkeywordrequestNode2, tidentifierNode3, tnumberNode4, preqtypeNode5, tparenlNode6, listNode8, tparenrNode9);
        }
	nodeList.add(prequestNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new95() /* reduce AAargument1Argument */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PArgument pargumentNode1;
        {
            // Block
        TParenl tparenlNode2;
        TIdentifier tidentifierNode3;
        LinkedList listNode4 = new LinkedList();
        TParenr tparenrNode5;
        tparenlNode2 = (TParenl)nodeArrayList1.get(0);
        tidentifierNode3 = (TIdentifier)nodeArrayList2.get(0);
        {
            // Block
        }
        tparenrNode5 = (TParenr)nodeArrayList3.get(0);

        pargumentNode1 = new AArgument(tparenlNode2, tidentifierNode3, listNode4, tparenrNode5);
        }
	nodeList.add(pargumentNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new96() /* reduce AAargument2Argument */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PArgument pargumentNode1;
        {
            // Block
        TParenl tparenlNode2;
        TIdentifier tidentifierNode3;
        LinkedList listNode5 = new LinkedList();
        TParenr tparenrNode6;
        tparenlNode2 = (TParenl)nodeArrayList1.get(0);
        tidentifierNode3 = (TIdentifier)nodeArrayList2.get(0);
        {
            // Block
        LinkedList listNode4 = new LinkedList();
        listNode4 = (LinkedList)nodeArrayList3.get(0);
	if(listNode4 != null) //Macro:ParserTypedLinkedListAddAll
	{
      listNode5.addAll(listNode4);
  	  //listNode5 = listNode4;
	}
        }
        tparenrNode6 = (TParenr)nodeArrayList4.get(0);

        pargumentNode1 = new AArgument(tparenlNode2, tidentifierNode3, listNode5, tparenrNode6);
        }
	nodeList.add(pargumentNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new97() /* reduce APosReqtype */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PReqtype preqtypeNode1;
        {
            // Block
        TKeywordPositive tkeywordpositiveNode2;
        tkeywordpositiveNode2 = (TKeywordPositive)nodeArrayList1.get(0);

        preqtypeNode1 = new APosReqtype(tkeywordpositiveNode2);
        }
	nodeList.add(preqtypeNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new98() /* reduce ANegReqtype */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PReqtype preqtypeNode1;
        {
            // Block
        TKeywordNegative tkeywordnegativeNode2;
        tkeywordnegativeNode2 = (TKeywordNegative)nodeArrayList1.get(0);

        preqtypeNode1 = new ANegReqtype(tkeywordnegativeNode2);
        }
	nodeList.add(preqtypeNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new99() /* reduce AList */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PList plistNode1;
        {
            // Block
        TKeywordList tkeywordlistNode2;
        TIdentifier tidentifierNode3;
        TNumber tnumberNode4;
        tkeywordlistNode2 = (TKeywordList)nodeArrayList1.get(0);
        tidentifierNode3 = (TIdentifier)nodeArrayList2.get(0);
        tnumberNode4 = (TNumber)nodeArrayList3.get(0);

        plistNode1 = new AList(tkeywordlistNode2, tidentifierNode3, tnumberNode4);
        }
	nodeList.add(plistNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new100() /* reduce AStop */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PStop pstopNode1;
        {
            // Block
        TKeywordStop tkeywordstopNode2;
        tkeywordstopNode2 = (TKeywordStop)nodeArrayList1.get(0);

        pstopNode1 = new AStop(tkeywordstopNode2);
        }
	nodeList.add(pstopNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new101() /* reduce AReset */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PReset presetNode1;
        {
            // Block
        TKeywordReset tkeywordresetNode2;
        tkeywordresetNode2 = (TKeywordReset)nodeArrayList1.get(0);

        presetNode1 = new AReset(tkeywordresetNode2);
        }
	nodeList.add(presetNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new102() /* reduce ATerminal$Type */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        LinkedList listNode2 = new LinkedList();
        {
            // Block
        PType ptypeNode1;
        ptypeNode1 = (PType)nodeArrayList1.get(0);
	if(ptypeNode1 != null)
	{
	  listNode2.add(ptypeNode1);
	}
        }
	nodeList.add(listNode2);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new103() /* reduce ANonTerminal$Type */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        LinkedList listNode3 = new LinkedList();
        {
            // Block
        LinkedList listNode1 = new LinkedList();
        PType ptypeNode2;
        listNode1 = (LinkedList)nodeArrayList1.get(0);
        ptypeNode2 = (PType)nodeArrayList2.get(0);
	if(listNode1 != null) //Macro:ParserTypedLinkedListAddAll
	{
      listNode3.addAll(listNode1);
  	  //listNode3 = listNode1;
	}
	if(ptypeNode2 != null)
	{
	  listNode3.add(ptypeNode2);
	}
        }
	nodeList.add(listNode3);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new104() /* reduce ATerminal$Relation */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        LinkedList listNode2 = new LinkedList();
        {
            // Block
        PRelation prelationNode1;
        prelationNode1 = (PRelation)nodeArrayList1.get(0);
	if(prelationNode1 != null)
	{
	  listNode2.add(prelationNode1);
	}
        }
	nodeList.add(listNode2);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new105() /* reduce ANonTerminal$Relation */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        LinkedList listNode3 = new LinkedList();
        {
            // Block
        LinkedList listNode1 = new LinkedList();
        PRelation prelationNode2;
        listNode1 = (LinkedList)nodeArrayList1.get(0);
        prelationNode2 = (PRelation)nodeArrayList2.get(0);
	if(listNode1 != null) //Macro:ParserTypedLinkedListAddAll
	{
      listNode3.addAll(listNode1);
  	  //listNode3 = listNode1;
	}
	if(prelationNode2 != null)
	{
	  listNode3.add(prelationNode2);
	}
        }
	nodeList.add(listNode3);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new106() /* reduce ATerminal$Identifier */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        LinkedList listNode2 = new LinkedList();
        {
            // Block
        TIdentifier tidentifierNode1;
        tidentifierNode1 = (TIdentifier)nodeArrayList1.get(0);
	if(tidentifierNode1 != null)
	{
	  listNode2.add(tidentifierNode1);
	}
        }
	nodeList.add(listNode2);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new107() /* reduce ANonTerminal$Identifier */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        LinkedList listNode3 = new LinkedList();
        {
            // Block
        LinkedList listNode1 = new LinkedList();
        TIdentifier tidentifierNode2;
        listNode1 = (LinkedList)nodeArrayList1.get(0);
        tidentifierNode2 = (TIdentifier)nodeArrayList2.get(0);
	if(listNode1 != null) //Macro:ParserTypedLinkedListAddAll
	{
      listNode3.addAll(listNode1);
  	  //listNode3 = listNode1;
	}
	if(tidentifierNode2 != null)
	{
	  listNode3.add(tidentifierNode2);
	}
        }
	nodeList.add(listNode3);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new108() /* reduce ATerminal$Tuple */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        LinkedList listNode2 = new LinkedList();
        {
            // Block
        PTuple ptupleNode1;
        ptupleNode1 = (PTuple)nodeArrayList1.get(0);
	if(ptupleNode1 != null)
	{
	  listNode2.add(ptupleNode1);
	}
        }
	nodeList.add(listNode2);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new109() /* reduce ANonTerminal$Tuple */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        LinkedList listNode3 = new LinkedList();
        {
            // Block
        LinkedList listNode1 = new LinkedList();
        PTuple ptupleNode2;
        listNode1 = (LinkedList)nodeArrayList1.get(0);
        ptupleNode2 = (PTuple)nodeArrayList2.get(0);
	if(listNode1 != null) //Macro:ParserTypedLinkedListAddAll
	{
      listNode3.addAll(listNode1);
  	  //listNode3 = listNode1;
	}
	if(ptupleNode2 != null)
	{
	  listNode3.add(ptupleNode2);
	}
        }
	nodeList.add(listNode3);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new110() /* reduce ATerminal$Number */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        LinkedList listNode2 = new LinkedList();
        {
            // Block
        TNumber tnumberNode1;
        tnumberNode1 = (TNumber)nodeArrayList1.get(0);
	if(tnumberNode1 != null)
	{
	  listNode2.add(tnumberNode1);
	}
        }
	nodeList.add(listNode2);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new111() /* reduce ANonTerminal$Number */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        LinkedList listNode3 = new LinkedList();
        {
            // Block
        LinkedList listNode1 = new LinkedList();
        TNumber tnumberNode2;
        listNode1 = (LinkedList)nodeArrayList1.get(0);
        tnumberNode2 = (TNumber)nodeArrayList2.get(0);
	if(listNode1 != null) //Macro:ParserTypedLinkedListAddAll
	{
      listNode3.addAll(listNode1);
  	  //listNode3 = listNode1;
	}
	if(tnumberNode2 != null)
	{
	  listNode3.add(tnumberNode2);
	}
        }
	nodeList.add(listNode3);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new112() /* reduce ATerminal$Formula */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        LinkedList listNode2 = new LinkedList();
        {
            // Block
        PFormula pformulaNode1;
        pformulaNode1 = (PFormula)nodeArrayList1.get(0);
	if(pformulaNode1 != null)
	{
	  listNode2.add(pformulaNode1);
	}
        }
	nodeList.add(listNode2);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new113() /* reduce ANonTerminal$Formula */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        LinkedList listNode3 = new LinkedList();
        {
            // Block
        LinkedList listNode1 = new LinkedList();
        PFormula pformulaNode2;
        listNode1 = (LinkedList)nodeArrayList1.get(0);
        pformulaNode2 = (PFormula)nodeArrayList2.get(0);
	if(listNode1 != null) //Macro:ParserTypedLinkedListAddAll
	{
      listNode3.addAll(listNode1);
  	  //listNode3 = listNode1;
	}
	if(pformulaNode2 != null)
	{
	  listNode3.add(pformulaNode2);
	}
        }
	nodeList.add(listNode3);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new114() /* reduce ATerminal$Expression */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        LinkedList listNode2 = new LinkedList();
        {
            // Block
        PExpression pexpressionNode1;
        pexpressionNode1 = (PExpression)nodeArrayList1.get(0);
	if(pexpressionNode1 != null)
	{
	  listNode2.add(pexpressionNode1);
	}
        }
	nodeList.add(listNode2);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new115() /* reduce ANonTerminal$Expression */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        LinkedList listNode3 = new LinkedList();
        {
            // Block
        LinkedList listNode1 = new LinkedList();
        PExpression pexpressionNode2;
        listNode1 = (LinkedList)nodeArrayList1.get(0);
        pexpressionNode2 = (PExpression)nodeArrayList2.get(0);
	if(listNode1 != null) //Macro:ParserTypedLinkedListAddAll
	{
      listNode3.addAll(listNode1);
  	  //listNode3 = listNode1;
	}
	if(pexpressionNode2 != null)
	{
	  listNode3.add(pexpressionNode2);
	}
        }
	nodeList.add(listNode3);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new116() /* reduce ATerminal$Argument */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        LinkedList listNode2 = new LinkedList();
        {
            // Block
        PArgument pargumentNode1;
        pargumentNode1 = (PArgument)nodeArrayList1.get(0);
	if(pargumentNode1 != null)
	{
	  listNode2.add(pargumentNode1);
	}
        }
	nodeList.add(listNode2);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new117() /* reduce ANonTerminal$Argument */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        LinkedList listNode3 = new LinkedList();
        {
            // Block
        LinkedList listNode1 = new LinkedList();
        PArgument pargumentNode2;
        listNode1 = (LinkedList)nodeArrayList1.get(0);
        pargumentNode2 = (PArgument)nodeArrayList2.get(0);
	if(listNode1 != null) //Macro:ParserTypedLinkedListAddAll
	{
      listNode3.addAll(listNode1);
  	  //listNode3 = listNode1;
	}
	if(pargumentNode2 != null)
	{
	  listNode3.add(pargumentNode2);
	}
        }
	nodeList.add(listNode3);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


    private static int[][][] actionTable;
/*      {
			{{-1, REDUCE, 5}, {7, SHIFT, 1}, {45, SHIFT, 2}, {46, SHIFT, 3}, {47, SHIFT, 4}, {48, SHIFT, 5}, },
			{{-1, ERROR, 1}, {68, SHIFT, 12}, },
			{{-1, ERROR, 2}, {68, SHIFT, 13}, },
			{{-1, REDUCE, 100}, },
			{{-1, REDUCE, 101}, },
			{{-1, ERROR, 5}, {68, SHIFT, 14}, },
			{{-1, ERROR, 6}, {70, ACCEPT, -1}, },
			{{-1, REDUCE, 0}, },
			{{-1, REDUCE, 1}, },
			{{-1, REDUCE, 2}, },
			{{-1, REDUCE, 3}, },
			{{-1, REDUCE, 4}, },
			{{-1, ERROR, 12}, {1, SHIFT, 15}, },
			{{-1, ERROR, 13}, {0, SHIFT, 16}, },
			{{-1, ERROR, 14}, {0, SHIFT, 17}, },
			{{-1, ERROR, 15}, {1, SHIFT, 18}, {2, SHIFT, 19}, },
			{{-1, ERROR, 16}, {49, SHIFT, 22}, {50, SHIFT, 23}, },
			{{-1, REDUCE, 99}, },
			{{-1, ERROR, 18}, {10, SHIFT, 25}, {68, SHIFT, 26}, },
			{{-1, ERROR, 19}, {1, SHIFT, 27}, },
			{{-1, REDUCE, 102}, },
			{{-1, ERROR, 21}, {1, SHIFT, 18}, {2, SHIFT, 28}, },
			{{-1, REDUCE, 97}, },
			{{-1, REDUCE, 98}, },
			{{-1, ERROR, 24}, {1, SHIFT, 30}, },
			{{-1, ERROR, 25}, {1, SHIFT, 31}, },
			{{-1, ERROR, 26}, {0, SHIFT, 33}, },
			{{-1, ERROR, 27}, {1, SHIFT, 34}, {2, SHIFT, 35}, },
			{{-1, ERROR, 28}, {1, SHIFT, 38}, },
			{{-1, REDUCE, 103}, },
			{{-1, ERROR, 30}, {1, SHIFT, 39}, {2, SHIFT, 40}, },
			{{-1, ERROR, 31}, {68, SHIFT, 43}, },
			{{-1, ERROR, 32}, {1, SHIFT, 44}, {2, SHIFT, 45}, },
			{{-1, ERROR, 33}, {2, SHIFT, 47}, },
			{{-1, ERROR, 34}, {68, SHIFT, 48}, },
			{{-1, ERROR, 35}, {1, SHIFT, 49}, },
			{{-1, REDUCE, 104}, },
			{{-1, ERROR, 37}, {1, SHIFT, 34}, {2, SHIFT, 51}, },
			{{-1, ERROR, 38}, {1, SHIFT, 34}, {2, SHIFT, 53}, },
			{{-1, ERROR, 39}, {68, SHIFT, 55}, },
			{{-1, REDUCE, 93}, },
			{{-1, REDUCE, 116}, },
			{{-1, ERROR, 42}, {1, SHIFT, 39}, {2, SHIFT, 56}, },
			{{-1, ERROR, 43}, {0, SHIFT, 58}, {67, SHIFT, 59}, },
			{{-1, ERROR, 44}, {68, SHIFT, 61}, },
			{{-1, REDUCE, 13}, },
			{{-1, ERROR, 46}, {2, SHIFT, 62}, },
			{{-1, REDUCE, 12}, },
			{{-1, ERROR, 48}, {8, SHIFT, 63}, {9, SHIFT, 64}, {11, SHIFT, 65}, },
			{{-1, ERROR, 49}, {12, SHIFT, 67}, {13, SHIFT, 68}, {14, SHIFT, 69}, {15, SHIFT, 70}, {16, SHIFT, 71}, {17, SHIFT, 72}, {18, SHIFT, 73}, {19, SHIFT, 74}, {20, SHIFT, 75}, {21, SHIFT, 76}, {22, SHIFT, 77}, {23, SHIFT, 78}, {24, SHIFT, 79}, {25, SHIFT, 80}, {27, SHIFT, 81}, {28, SHIFT, 82}, {57, SHIFT, 83}, {58, SHIFT, 84}, {59, SHIFT, 85}, {60, SHIFT, 86}, {62, SHIFT, 87}, {63, SHIFT, 88}, },
			{{-1, REDUCE, 6}, },
			{{-1, ERROR, 51}, {1, SHIFT, 49}, },
			{{-1, REDUCE, 105}, },
			{{-1, ERROR, 53}, {1, SHIFT, 49}, },
			{{-1, ERROR, 54}, {1, SHIFT, 34}, {2, SHIFT, 97}, },
			{{-1, ERROR, 55}, {2, SHIFT, 98}, {3, SHIFT, 99}, },
			{{-1, REDUCE, 94}, },
			{{-1, REDUCE, 117}, },
			{{-1, REDUCE, 10}, },
			{{-1, ERROR, 59}, {0, SHIFT, 102}, },
			{{-1, ERROR, 60}, {0, SHIFT, 58}, {67, SHIFT, 59}, },
			{{-1, ERROR, 61}, {0, SHIFT, 58}, {67, SHIFT, 59}, },
			{{-1, REDUCE, 14}, },
			{{-1, REDUCE, 21}, },
			{{-1, REDUCE, 22}, },
			{{-1, ERROR, 65}, {8, SHIFT, 63}, {9, SHIFT, 64}, },
			{{-1, ERROR, 66}, {68, SHIFT, 106}, },
			{{-1, REDUCE, 43}, },
			{{-1, REDUCE, 44}, },
			{{-1, ERROR, 69}, {1, SHIFT, 108}, },
			{{-1, ERROR, 70}, {1, SHIFT, 110}, },
			{{-1, REDUCE, 55}, },
			{{-1, REDUCE, 54}, },
			{{-1, REDUCE, 56}, },
			{{-1, REDUCE, 57}, },
			{{-1, REDUCE, 58}, },
			{{-1, ERROR, 76}, {1, SHIFT, 49}, },
			{{-1, REDUCE, 33}, {1, SHIFT, 49}, },
			{{-1, REDUCE, 47}, },
			{{-1, REDUCE, 48}, },
			{{-1, REDUCE, 49}, },
			{{-1, REDUCE, 50}, },
			{{-1, REDUCE, 51}, },
			{{-1, ERROR, 83}, {1, SHIFT, 116}, },
			{{-1, ERROR, 84}, {1, SHIFT, 116}, },
			{{-1, ERROR, 85}, {1, SHIFT, 116}, },
			{{-1, ERROR, 86}, {1, SHIFT, 116}, },
			{{-1, REDUCE, 46}, },
			{{-1, REDUCE, 45}, },
			{{-1, ERROR, 89}, {2, SHIFT, 121}, },
			{{-1, REDUCE, 28}, },
			{{-1, ERROR, 91}, {1, SHIFT, 108}, },
			{{-1, ERROR, 92}, {1, SHIFT, 49}, },
			{{-1, ERROR, 93}, {1, SHIFT, 124}, },
			{{-1, ERROR, 94}, {1, SHIFT, 108}, },
			{{-1, REDUCE, 8}, },
			{{-1, REDUCE, 7}, },
			{{-1, ERROR, 97}, {1, SHIFT, 49}, },
			{{-1, REDUCE, 95}, },
			{{-1, ERROR, 99}, {0, SHIFT, 127}, },
			{{-1, REDUCE, 108}, },
			{{-1, ERROR, 101}, {2, SHIFT, 129}, {3, SHIFT, 99}, },
			{{-1, REDUCE, 11}, },
			{{-1, ERROR, 103}, {2, SHIFT, 131}, },
			{{-1, ERROR, 104}, {0, SHIFT, 58}, {67, SHIFT, 59}, },
			{{-1, ERROR, 105}, {68, SHIFT, 106}, },
			{{-1, REDUCE, 106}, },
			{{-1, ERROR, 107}, {1, SHIFT, 134}, {2, SHIFT, 135}, {68, SHIFT, 136}, },
			{{-1, ERROR, 108}, {26, SHIFT, 138}, {29, SHIFT, 139}, {30, SHIFT, 140}, {31, SHIFT, 141}, {32, SHIFT, 142}, {33, SHIFT, 143}, {34, SHIFT, 144}, {35, SHIFT, 145}, {36, SHIFT, 146}, {37, SHIFT, 147}, {38, SHIFT, 148}, {39, SHIFT, 149}, {40, SHIFT, 150}, {43, SHIFT, 151}, {44, SHIFT, 152}, {61, SHIFT, 153}, {64, SHIFT, 154}, {65, SHIFT, 155}, },
			{{-1, ERROR, 109}, {1, SHIFT, 108}, },
			{{-1, ERROR, 110}, {0, SHIFT, 58}, {26, SHIFT, 138}, {29, SHIFT, 139}, {30, SHIFT, 140}, {31, SHIFT, 141}, {32, SHIFT, 142}, {33, SHIFT, 143}, {34, SHIFT, 144}, {35, SHIFT, 145}, {36, SHIFT, 146}, {37, SHIFT, 147}, {38, SHIFT, 148}, {39, SHIFT, 149}, {40, SHIFT, 150}, {43, SHIFT, 151}, {44, SHIFT, 152}, {51, SHIFT, 163}, {52, SHIFT, 164}, {53, SHIFT, 165}, {54, SHIFT, 166}, {55, SHIFT, 167}, {56, SHIFT, 168}, {61, SHIFT, 153}, {64, SHIFT, 154}, {65, SHIFT, 155}, {66, SHIFT, 169}, {67, SHIFT, 59}, },
			{{-1, ERROR, 111}, {1, SHIFT, 108}, },
			{{-1, ERROR, 112}, {1, SHIFT, 116}, },
			{{-1, REDUCE, 32}, },
			{{-1, REDUCE, 112}, },
			{{-1, REDUCE, 34}, {1, SHIFT, 49}, },
			{{-1, ERROR, 116}, {0, SHIFT, 58}, {51, SHIFT, 163}, {52, SHIFT, 164}, {53, SHIFT, 165}, {54, SHIFT, 166}, {55, SHIFT, 167}, {56, SHIFT, 168}, {66, SHIFT, 169}, {67, SHIFT, 59}, },
			{{-1, ERROR, 117}, {1, SHIFT, 116}, },
			{{-1, ERROR, 118}, {1, SHIFT, 116}, },
			{{-1, ERROR, 119}, {1, SHIFT, 116}, },
			{{-1, ERROR, 120}, {1, SHIFT, 116}, },
			{{-1, REDUCE, 27}, },
			{{-1, ERROR, 122}, {1, SHIFT, 108}, },
			{{-1, ERROR, 123}, {1, SHIFT, 49}, },
			{{-1, REDUCE, 52}, {1, SHIFT, 182}, },
			{{-1, REDUCE, 29}, },
			{{-1, REDUCE, 9}, },
			{{-1, REDUCE, 110}, },
			{{-1, ERROR, 128}, {0, SHIFT, 184}, {4, SHIFT, 185}, },
			{{-1, REDUCE, 96}, },
			{{-1, REDUCE, 109}, },
			{{-1, REDUCE, 15}, },
			{{-1, ERROR, 132}, {2, SHIFT, 186}, },
			{{-1, ERROR, 133}, {1, SHIFT, 134}, {2, SHIFT, 187}, {68, SHIFT, 136}, },
			{{-1, ERROR, 134}, {3, SHIFT, 99}, },
			{{-1, REDUCE, 17}, },
			{{-1, REDUCE, 107}, },
			{{-1, ERROR, 137}, {2, SHIFT, 190}, },
			{{-1, ERROR, 138}, {1, SHIFT, 49}, },
			{{-1, REDUCE, 75}, },
			{{-1, REDUCE, 76}, },
			{{-1, REDUCE, 78}, },
			{{-1, REDUCE, 79}, },
			{{-1, REDUCE, 77}, },
			{{-1, REDUCE, 80}, },
			{{-1, REDUCE, 81}, },
			{{-1, REDUCE, 82}, },
			{{-1, ERROR, 147}, {1, SHIFT, 192}, },
			{{-1, REDUCE, 72}, },
			{{-1, REDUCE, 73}, },
			{{-1, REDUCE, 74}, },
			{{-1, ERROR, 151}, {68, SHIFT, 193}, },
			{{-1, ERROR, 152}, {68, SHIFT, 194}, },
			{{-1, ERROR, 153}, {1, SHIFT, 195}, },
			{{-1, REDUCE, 70}, },
			{{-1, REDUCE, 71}, },
			{{-1, ERROR, 156}, {2, SHIFT, 196}, },
			{{-1, ERROR, 157}, {1, SHIFT, 116}, },
			{{-1, REDUCE, 60}, },
			{{-1, ERROR, 159}, {1, SHIFT, 108}, },
			{{-1, ERROR, 160}, {1, SHIFT, 108}, },
			{{-1, ERROR, 161}, {1, SHIFT, 108}, },
			{{-1, REDUCE, 30}, },
			{{-1, ERROR, 163}, {1, SHIFT, 108}, },
			{{-1, REDUCE, 88}, },
			{{-1, REDUCE, 89}, },
			{{-1, REDUCE, 90}, },
			{{-1, REDUCE, 91}, },
			{{-1, REDUCE, 92}, },
			{{-1, ERROR, 169}, {1, SHIFT, 108}, },
			{{-1, REDUCE, 84}, },
			{{-1, ERROR, 171}, {2, SHIFT, 204}, },
			{{-1, ERROR, 172}, {1, SHIFT, 116}, },
			{{-1, REDUCE, 31}, },
			{{-1, REDUCE, 37}, },
			{{-1, REDUCE, 113}, },
			{{-1, REDUCE, 38}, },
			{{-1, REDUCE, 39}, },
			{{-1, REDUCE, 40}, },
			{{-1, REDUCE, 41}, },
			{{-1, ERROR, 180}, {1, SHIFT, 108}, },
			{{-1, REDUCE, 35}, },
			{{-1, ERROR, 182}, {68, SHIFT, 207}, },
			{{-1, ERROR, 183}, {2, SHIFT, 208}, },
			{{-1, REDUCE, 111}, },
			{{-1, REDUCE, 24}, },
			{{-1, REDUCE, 16}, },
			{{-1, REDUCE, 18}, },
			{{-1, ERROR, 188}, {2, SHIFT, 209}, },
			{{-1, ERROR, 189}, {2, SHIFT, 210}, {3, SHIFT, 99}, },
			{{-1, REDUCE, 19}, },
			{{-1, ERROR, 191}, {1, SHIFT, 108}, },
			{{-1, REDUCE, 52}, {1, SHIFT, 182}, },
			{{-1, REDUCE, 64}, },
			{{-1, REDUCE, 65}, },
			{{-1, ERROR, 195}, {0, SHIFT, 127}, },
			{{-1, REDUCE, 59}, },
			{{-1, REDUCE, 68}, },
			{{-1, REDUCE, 114}, },
			{{-1, REDUCE, 62}, {1, SHIFT, 108}, },
			{{-1, ERROR, 200}, {1, SHIFT, 108}, },
			{{-1, REDUCE, 61}, },
			{{-1, REDUCE, 85}, },
			{{-1, REDUCE, 87}, },
			{{-1, REDUCE, 83}, },
			{{-1, ERROR, 205}, {1, SHIFT, 116}, },
			{{-1, REDUCE, 42}, },
			{{-1, ERROR, 207}, {0, SHIFT, 217}, },
			{{-1, ERROR, 208}, {1, SHIFT, 49}, },
			{{-1, REDUCE, 20}, },
			{{-1, REDUCE, 23}, },
			{{-1, ERROR, 211}, {1, SHIFT, 108}, },
			{{-1, ERROR, 212}, {2, SHIFT, 220}, },
			{{-1, ERROR, 213}, {0, SHIFT, 184}, {2, SHIFT, 221}, },
			{{-1, REDUCE, 115}, },
			{{-1, REDUCE, 63}, },
			{{-1, REDUCE, 86}, },
			{{-1, ERROR, 217}, {16, SHIFT, 71}, {17, SHIFT, 72}, {18, SHIFT, 73}, {19, SHIFT, 74}, {20, SHIFT, 75}, },
			{{-1, REDUCE, 36}, },
			{{-1, REDUCE, 69}, },
			{{-1, ERROR, 220}, {1, SHIFT, 49}, },
			{{-1, ERROR, 221}, {1, SHIFT, 108}, },
			{{-1, ERROR, 222}, {1, SHIFT, 108}, },
			{{-1, REDUCE, 66}, },
			{{-1, REDUCE, 67}, },
			{{-1, ERROR, 225}, {2, SHIFT, 226}, },
			{{-1, REDUCE, 52}, {1, SHIFT, 182}, },
			{{-1, REDUCE, 53}, },
        };*/
    private static int[][][] gotoTable;
/*      {
			{{-1, 6}, },
			{{-1, 7}, },
			{{-1, 170}, {43, 60}, {60, 103}, {61, 104}, {104, 132}, },
			{{-1, 20}, {21, 29}, },
			{{-1, 32}, },
			{{-1, 46}, },
			{{-1, 36}, {37, 52}, {54, 52}, },
			{{-1, 66}, {65, 105}, },
			{{-1, 137}, {133, 188}, },
			{{-1, 100}, {101, 130}, {189, 130}, },
			{{-1, -1}, },
			{{-1, 50}, {51, 95}, {53, 96}, {76, 113}, {77, 114}, {92, 123}, {97, 126}, {115, 175}, {123, 181}, {138, 191}, {208, 218}, {220, 223}, },
			{{-1, 89}, },
			{{-1, 90}, },
			{{-1, 91}, },
			{{-1, 92}, },
			{{-1, 93}, },
			{{-1, 183}, {192, 212}, {226, 227}, },
			{{-1, 94}, {217, 222}, },
			{{-1, 109}, {70, 111}, {91, 122}, {94, 125}, {109, 162}, {111, 173}, {122, 180}, {159, 198}, {160, 200}, {161, 201}, {163, 202}, {169, 203}, {180, 206}, {191, 211}, {199, 214}, {200, 215}, {211, 219}, {221, 224}, {222, 225}, },
			{{-1, 156}, },
			{{-1, 157}, },
			{{-1, 158}, },
			{{-1, 159}, },
			{{-1, 160}, },
			{{-1, 161}, },
			{{-1, 112}, {83, 117}, {84, 118}, {85, 119}, {86, 120}, {112, 174}, {117, 176}, {118, 177}, {119, 178}, {120, 179}, {157, 197}, {172, 205}, {205, 216}, },
			{{-1, 171}, },
			{{-1, 172}, },
			{{-1, 8}, },
			{{-1, 41}, {42, 57}, },
			{{-1, 24}, },
			{{-1, 9}, },
			{{-1, 10}, },
			{{-1, 11}, },
			{{-1, 21}, },
			{{-1, 37}, {38, 54}, },
			{{-1, 107}, {105, 133}, },
			{{-1, 101}, {134, 189}, },
			{{-1, 128}, {195, 213}, },
			{{-1, 115}, },
			{{-1, 199}, },
			{{-1, 42}, },
        };*/
    private static String[] errorMessages;
/*      {
			"expecting: 'problem', 'request', 'stop', 'reset', 'list', EOF",
			"expecting: identifier",
			"expecting: EOF",
			"expecting: '('",
			"expecting: number",
			"expecting: '(', ')'",
			"expecting: 'pos', 'neg'",
			"expecting: 'inttype', identifier",
			"expecting: ')'",
			"expecting: number, '-'",
			"expecting: 'exact', 'subset', 'singleton'",
			"expecting: 'true', 'false', 'in', 'equals', 'some', 'one', 'no', 'lone', 'set', 'not', 'and', 'or', 'implies', 'iff', 'all', 'exists', 'gt', 'gte', 'lt', 'lte', 'pfunc', 'func'",
			"expecting: ')', '<'",
			"expecting: number, ')', '-'",
			"expecting: 'exact', 'subset'",
			"expecting: '(', ')', identifier",
			"expecting: 'if', 'union', 'intersection', 'difference', 'join', 'product', 'overwrite', 'transpose', 'closure', 'comp', 'empty', 'iden', 'univ', 'relref', 'varref', 'prj', 'int2pow2', 'int2intset'",
			"expecting: number, 'if', 'union', 'intersection', 'difference', 'join', 'product', 'overwrite', 'transpose', 'closure', 'comp', 'empty', 'iden', 'univ', 'relref', 'varref', 'card', 'add', 'sub', 'mul', 'div', 'mod', 'prj', 'int2pow2', 'int2intset', 'expr2int', '-'",
			"expecting: number, 'card', 'add', 'sub', 'mul', 'div', 'mod', 'expr2int', '-'",
			"expecting: '(', ')', EOF",
			"expecting: number, ')', '>'",
			"expecting: number, '>'",
			"expecting: '<'",
			"expecting: number, ')'",
			"expecting: 'some', 'one', 'no', 'lone', 'set'",
        };*/
    private static int[] errors;
/*      {
			0, 1, 1, 2, 2, 1, 2, 2, 2, 2, 2, 2, 3, 4, 4, 5, 6, 2, 7, 3, 5, 5, 3, 3, 3, 3, 4, 5, 3, 5, 5, 1, 5, 8, 1, 3, 5, 5, 5, 1, 2, 5, 5, 9, 1, 5, 8, 5, 10, 11, 2, 3, 5, 3, 5, 12, 2, 5, 13, 4, 9, 9, 5, 1, 1, 14, 1, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 5, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 3, 3, 3, 2, 2, 3, 5, 4, 12, 12, 13, 8, 9, 1, 15, 15, 16, 3, 17, 3, 3, 8, 5, 5, 18, 3, 3, 3, 3, 19, 3, 3, 5, 8, 2, 20, 21, 5, 12, 5, 8, 15, 22, 5, 15, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 8, 8, 8, 1, 1, 3, 3, 3, 8, 3, 8, 3, 3, 3, 8, 3, 3, 3, 3, 3, 3, 3, 8, 8, 3, 8, 8, 5, 8, 8, 8, 8, 3, 8, 1, 8, 20, 12, 8, 5, 8, 12, 5, 3, 5, 8, 8, 4, 5, 8, 5, 5, 3, 8, 8, 8, 5, 3, 8, 4, 3, 5, 8, 3, 8, 23, 5, 8, 8, 24, 8, 8, 3, 3, 3, 8, 8, 8, 5, 8, 
        };*/

    static 
    {
        try
        {
            DataInputStream s = new DataInputStream(
                new BufferedInputStream(
                Parser.class.getResourceAsStream("parser.dat")));

            // read actionTable
            int length = s.readInt();
            Parser.actionTable = new int[length][][];
            for(int i = 0; i < Parser.actionTable.length; i++)
            {
                length = s.readInt();
                Parser.actionTable[i] = new int[length][3];
                for(int j = 0; j < Parser.actionTable[i].length; j++)
                {
                for(int k = 0; k < 3; k++)
                {
                    Parser.actionTable[i][j][k] = s.readInt();
                }
                }
            }

            // read gotoTable
            length = s.readInt();
            gotoTable = new int[length][][];
            for(int i = 0; i < gotoTable.length; i++)
            {
                length = s.readInt();
                gotoTable[i] = new int[length][2];
                for(int j = 0; j < gotoTable[i].length; j++)
                {
                for(int k = 0; k < 2; k++)
                {
                    gotoTable[i][j][k] = s.readInt();
                }
                }
            }

            // read errorMessages
            length = s.readInt();
            errorMessages = new String[length];
            for(int i = 0; i < errorMessages.length; i++)
            {
                length = s.readInt();
                StringBuffer buffer = new StringBuffer();

                for(int j = 0; j < length; j++)
                {
                buffer.append(s.readChar());
                }
                errorMessages[i] = buffer.toString();
            }

            // read errors
            length = s.readInt();
            errors = new int[length];
            for(int i = 0; i < errors.length; i++)
            {
                errors[i] = s.readInt();
            }

            s.close();
        }
        catch(Exception e)
        {
            throw new RuntimeException("The file \"parser.dat\" is either missing or corrupted.");
        }
    }
}
