/* This file was generated by SableCC (http://www.sablecc.org/). */

package de.prob.unicode.lexer;

import java.io.*;
import java.util.*;
import de.prob.unicode.node.*;
import de.hhu.stups.sablecc.patch.*;
import java.util.concurrent.LinkedBlockingQueue;

@SuppressWarnings({"unused"}) 
public class Lexer implements ITokenListContainer
{
    protected Token token;
    protected State state = State.INITIAL;

    private PushbackReader in;
    private int line;
    private int pos;
    private boolean cr;
    private boolean eof;
    private final StringBuffer text = new StringBuffer();
    
	private List<IToken> tokenList;
    private final Queue<IToken> nextList = new LinkedBlockingQueue<IToken>();

	private IToken tok;

    public Queue<IToken> getNextList() {
        return nextList;
    }

	public List<IToken> getTokenList() {
		return tokenList;
	}
	
	private void setToken(Token t) {
	  tok = t;
   	  token = t;	
	}
	
	
	public void setTokenList(final List<IToken> list) {
		tokenList = list;
	}

     
    protected void filter() throws LexerException, IOException
    {
        // Do nothing
    }

    protected void filterWrap() throws LexerException, IOException
    {
       filter();
       if (token != null) {
	          getTokenList().add(token); 
              nextList.add(token);
	   }
    }


    public Lexer(  PushbackReader in)
    {
        this.in = in;
    	setTokenList(new ArrayList<IToken>());
    }
    
    public Token peek() throws LexerException, IOException
    {
        while(this.token == null)
        {
            this.setToken(getToken());
            filterWrap();
        }

        return (Token) nextList.peek();
    }

    public Token next() throws LexerException, IOException
    {
        while(this.token == null)
        {
            this.setToken(getToken());
            filterWrap();
        }

        Token result = (Token) nextList.poll();
        this.setToken(null);
        return result;
    }

    protected Token getToken() throws IOException, LexerException
    {
        int dfa_state = 0;

        int start_pos = this.pos;
        int start_line = this.line;

        int accept_state = -1;
        int accept_token = -1;
        int accept_length = -1;
        int accept_pos = -1;
        int accept_line = -1;

          int[][][] gotoTable = Lexer.gotoTable[this.state.id()];
          int[] accept = Lexer.accept[this.state.id()];
        this.text.setLength(0);

        while(true)
        {
            int c = getChar();

            if(c != -1)
            {
                switch(c)
                {
                case 10:
                    if(this.cr)
                    {
                        this.cr = false;
                    }
                    else
                    {
                        this.line++;
                        this.pos = 0;
                    }
                    break;
                case 13:
                    this.line++;
                    this.pos = 0;
                    this.cr = true;
                    break;
                default:
                    this.pos++;
                    this.cr = false;
                    break;
                }

                this.text.append((char) c);

                do
                {
                    int oldState = (dfa_state < -1) ? (-2 -dfa_state) : dfa_state;

                    dfa_state = -1;

                    int[][] tmp1 =  gotoTable[oldState];
                    int low = 0;
                    int high = tmp1.length - 1;

                    while(low <= high)
                    {
                        int middle = (low + high) / 2;
                        int[] tmp2 = tmp1[middle];

                        if(c < tmp2[0])
                        {
                            high = middle - 1;
                        }
                        else if(c > tmp2[1])
                        {
                            low = middle + 1;
                        }
                        else
                        {
                            dfa_state = tmp2[2];
                            break;
                        }
                    }
                }while(dfa_state < -1);
            }
            else
            {
                dfa_state = -1;
            }

            if(dfa_state >= 0)
            {
                if(accept[dfa_state] != -1)
                {
                    accept_state = dfa_state;
                    accept_token = accept[dfa_state];
                    accept_length = this.text.length();
                    accept_pos = this.pos;
                    accept_line = this.line;
                }
            }
            else
            {
                if(accept_state != -1)
                {
                    switch(accept_token)
                    {
                    case 0:
                        {
                              Token token = new0(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 1:
                        {
                              Token token = new1(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 2:
                        {
                              Token token = new2(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 3:
                        {
                              Token token = new3(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 4:
                        {
                              Token token = new4(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 5:
                        {
                              Token token = new5(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 6:
                        {
                              Token token = new6(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 7:
                        {
                              Token token = new7(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 8:
                        {
                              Token token = new8(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 9:
                        {
                              Token token = new9(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 10:
                        {
                              Token token = new10(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 11:
                        {
                              Token token = new11(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 12:
                        {
                              Token token = new12(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 13:
                        {
                              Token token = new13(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 14:
                        {
                              Token token = new14(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 15:
                        {
                              Token token = new15(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 16:
                        {
                              Token token = new16(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 17:
                        {
                              Token token = new17(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 18:
                        {
                              Token token = new18(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 19:
                        {
                              Token token = new19(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 20:
                        {
                              Token token = new20(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 21:
                        {
                              Token token = new21(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 22:
                        {
                              Token token = new22(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 23:
                        {
                              Token token = new23(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 24:
                        {
                              Token token = new24(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 25:
                        {
                              Token token = new25(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 26:
                        {
                              Token token = new26(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 27:
                        {
                              Token token = new27(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 28:
                        {
                              Token token = new28(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 29:
                        {
                              Token token = new29(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 30:
                        {
                              Token token = new30(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 31:
                        {
                              Token token = new31(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 32:
                        {
                              Token token = new32(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 33:
                        {
                              Token token = new33(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 34:
                        {
                              Token token = new34(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 35:
                        {
                              Token token = new35(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 36:
                        {
                              Token token = new36(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 37:
                        {
                              Token token = new37(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 38:
                        {
                              Token token = new38(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 39:
                        {
                              Token token = new39(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 40:
                        {
                              Token token = new40(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 41:
                        {
                              Token token = new41(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 42:
                        {
                              Token token = new42(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 43:
                        {
                              Token token = new43(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 44:
                        {
                              Token token = new44(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 45:
                        {
                              Token token = new45(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 46:
                        {
                              Token token = new46(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 47:
                        {
                              Token token = new47(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 48:
                        {
                              Token token = new48(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 49:
                        {
                              Token token = new49(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 50:
                        {
                              Token token = new50(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 51:
                        {
                              Token token = new51(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 52:
                        {
                              Token token = new52(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 53:
                        {
                              Token token = new53(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 54:
                        {
                              Token token = new54(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 55:
                        {
                              Token token = new55(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 56:
                        {
                              Token token = new56(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 57:
                        {
                              Token token = new57(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 58:
                        {
                              Token token = new58(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 59:
                        {
                              Token token = new59(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 60:
                        {
                              Token token = new60(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 61:
                        {
                              Token token = new61(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 62:
                        {
                              Token token = new62(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 63:
                        {
                              Token token = new63(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 64:
                        {
                              Token token = new64(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 65:
                        {
                              Token token = new65(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 66:
                        {
                              Token token = new66(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 67:
                        {
                              Token token = new67(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 68:
                        {
                              Token token = new68(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    }
                }
                else
                {
                    if(this.text.length() > 0)
                    {
                        throw new LexerException(
                            "[" + (start_line + 1) + "," + (start_pos + 1) + "]" +
                            " Unknown token: " + this.text);
                    }

                      EOF token = new EOF(
                        start_line + 1,
                        start_pos + 1);
                    return token;
                }
            }
        }
    }

    Token new0(  String text,   int line,   int pos) { return new TIn(text, line, pos); }
    Token new1(  String text,   int line,   int pos) { return new TNotsubseteq(text, line, pos); }
    Token new2(  String text,   int line,   int pos) { return new TNotsubset(text, line, pos); }
    Token new3(  String text,   int line,   int pos) { return new TSubseteq(text, line, pos); }
    Token new4(  String text,   int line,   int pos) { return new TSetminus(text, line, pos); }
    Token new5(  String text,   int line,   int pos) { return new TDotdot(text, line, pos); }
    Token new6(  String text,   int line,   int pos) { return new TNat1(text, line, pos); }
    Token new7(  String text,   int line,   int pos) { return new TNat(text, line, pos); }
    Token new8(  String text,   int line,   int pos) { return new TEmptyset(text, line, pos); }
    Token new9(  String text,   int line,   int pos) { return new TBcmsuch(text, line, pos); }
    Token new10(  String text,   int line,   int pos) { return new TBfalse(text, line, pos); }
    Token new11(  String text,   int line,   int pos) { return new TForall(text, line, pos); }
    Token new12(  String text,   int line,   int pos) { return new TExists(text, line, pos); }
    Token new13(  String text,   int line,   int pos) { return new TMapsto(text, line, pos); }
    Token new14(  String text,   int line,   int pos) { return new TBtrue(text, line, pos); }
    Token new15(  String text,   int line,   int pos) { return new TSubset(text, line, pos); }
    Token new16(  String text,   int line,   int pos) { return new TBunion(text, line, pos); }
    Token new17(  String text,   int line,   int pos) { return new TBinter(text, line, pos); }
    Token new18(  String text,   int line,   int pos) { return new TDomres(text, line, pos); }
    Token new19(  String text,   int line,   int pos) { return new TRanres(text, line, pos); }
    Token new20(  String text,   int line,   int pos) { return new TDomsub(text, line, pos); }
    Token new21(  String text,   int line,   int pos) { return new TRansub(text, line, pos); }
    Token new22(  String text,   int line,   int pos) { return new TLambda(text, line, pos); }
    Token new23(  String text,   int line,   int pos) { return new TOftype(text, line, pos); }
    Token new24(  String text,   int line,   int pos) { return new TNotin(text, line, pos); }
    Token new25(  String text,   int line,   int pos) { return new TCprod(text, line, pos); }
    Token new26(  String text,   int line,   int pos) { return new TUnion(text, line, pos); }
    Token new27(  String text,   int line,   int pos) { return new TInter(text, line, pos); }
    Token new28(  String text,   int line,   int pos) { return new TFcomp(text, line, pos); }
    Token new29(  String text,   int line,   int pos) { return new TBcomp(text, line, pos); }
    Token new30(  String text,   int line,   int pos) { return new TStrel(text, line, pos); }
    Token new31(  String text,   int line,   int pos) { return new TDprod(text, line, pos); }
    Token new32(  String text,   int line,   int pos) { return new TPprod(text, line, pos); }
    Token new33(  String text,   int line,   int pos) { return new TBcmeq(text, line, pos); }
    Token new34(  String text,   int line,   int pos) { return new TBcmin(text, line, pos); }
    Token new35(  String text,   int line,   int pos) { return new TIntg(text, line, pos); }
    Token new36(  String text,   int line,   int pos) { return new TLand(text, line, pos); }
    Token new37(  String text,   int line,   int pos) { return new TLimp(text, line, pos); }
    Token new38(  String text,   int line,   int pos) { return new TLeqv(text, line, pos); }
    Token new39(  String text,   int line,   int pos) { return new TLnot(text, line, pos); }
    Token new40(  String text,   int line,   int pos) { return new TQdot(text, line, pos); }
    Token new41(  String text,   int line,   int pos) { return new TConv(text, line, pos); }
    Token new42(  String text,   int line,   int pos) { return new TTrel(text, line, pos); }
    Token new43(  String text,   int line,   int pos) { return new TSrel(text, line, pos); }
    Token new44(  String text,   int line,   int pos) { return new TPfun(text, line, pos); }
    Token new45(  String text,   int line,   int pos) { return new TTfun(text, line, pos); }
    Token new46(  String text,   int line,   int pos) { return new TPinj(text, line, pos); }
    Token new47(  String text,   int line,   int pos) { return new TTinj(text, line, pos); }
    Token new48(  String text,   int line,   int pos) { return new TPsur(text, line, pos); }
    Token new49(  String text,   int line,   int pos) { return new TTsur(text, line, pos); }
    Token new50(  String text,   int line,   int pos) { return new TTbij(text, line, pos); }
    Token new51(  String text,   int line,   int pos) { return new TExpn(text, line, pos); }
    Token new52(  String text,   int line,   int pos) { return new TLor(text, line, pos); }
    Token new53(  String text,   int line,   int pos) { return new TPow1(text, line, pos); }
    Token new54(  String text,   int line,   int pos) { return new TPow(text, line, pos); }
    Token new55(  String text,   int line,   int pos) { return new TMid(text, line, pos); }
    Token new56(  String text,   int line,   int pos) { return new TNeq(text, line, pos); }
    Token new57(  String text,   int line,   int pos) { return new TRel(text, line, pos); }
    Token new58(  String text,   int line,   int pos) { return new TOvl(text, line, pos); }
    Token new59(  String text,   int line,   int pos) { return new TLeq(text, line, pos); }
    Token new60(  String text,   int line,   int pos) { return new TGeq(text, line, pos); }
    Token new61(  String text,   int line,   int pos) { return new TDiv(text, line, pos); }
    Token new62(  String text,   int line,   int pos) { return new TMult(text, line, pos); }
    Token new63(  String text,   int line,   int pos) { return new TMinus(text, line, pos); }
    Token new64(  int line,   int pos) { return new TTake(line, pos); }
    Token new65(  int line,   int pos) { return new TDrop(line, pos); }
    Token new66(  String text,   int line,   int pos) { return new TAnyChar(text, line, pos); }
    Token new67(  String text,   int line,   int pos) { return new TWhitespace(text, line, pos); }
    Token new68(  String text,   int line,   int pos) { return new TSeparator(text, line, pos); }

    private int getChar() throws IOException
    {
        if(this.eof)
        {
            return -1;
        }

        int result = this.in.read();

        if(result == -1)
        {
            this.eof = true;
        }

        return result;
    }

    private void pushBack(int acceptLength) throws IOException
    {
        int length = this.text.length();
        for(int i = length - 1; i >= acceptLength; i--)
        {
            this.eof = false;

            this.in.unread(this.text.charAt(i));
        }
    }

    protected void unread(  Token token) throws IOException
    {
          String text = token.getText();
        int length = text.length();

        for(int i = length - 1; i >= 0; i--)
        {
            this.eof = false;

            this.in.unread(text.charAt(i));
        }

        this.pos = token.getPos() - 1;
        this.line = token.getLine() - 1;
    }

    private String getText(int acceptLength)
    {
        StringBuffer s = new StringBuffer(acceptLength);
        for(int i = 0; i < acceptLength; i++)
        {
            s.append(this.text.charAt(i));
        }

        return s.toString();
    }

    private static int[][][][] gotoTable;
/*  {
        { // INITIAL
            {{0, 8, 1}, {9, 10, 2}, {11, 12, 1}, {13, 13, 2}, {14, 31, 1}, {32, 32, 2}, {33, 33, 3}, {34, 34, 1}, {35, 35, 4}, {36, 36, 1}, {37, 37, 5}, {38, 38, 6}, {39, 39, 1}, {40, 41, 7}, {42, 42, 8}, {43, 43, 9}, {44, 44, 7}, {45, 45, 10}, {46, 46, 11}, {47, 47, 12}, {48, 57, 1}, {58, 58, 13}, {59, 59, 14}, {60, 60, 15}, {61, 61, 16}, {62, 62, 17}, {63, 72, 1}, {73, 73, 18}, {74, 77, 1}, {78, 78, 19}, {79, 79, 1}, {80, 80, 20}, {81, 84, 1}, {85, 85, 21}, {86, 91, 1}, {92, 92, 22}, {93, 93, 1}, {94, 94, 23}, {95, 98, 1}, {99, 99, 24}, {100, 101, 1}, {102, 102, 25}, {103, 109, 1}, {110, 110, 26}, {111, 111, 27}, {112, 115, 1}, {116, 116, 28}, {117, 122, 1}, {123, 123, 29}, {124, 124, 30}, {125, 125, 7}, {126, 126, 31}, {127, 171, 1}, {172, 172, 32}, {173, 182, 1}, {183, 183, 33}, {184, 214, 1}, {215, 215, 34}, {216, 246, 1}, {247, 247, 35}, {248, 954, 1}, {955, 955, 36}, {956, 8228, 1}, {8229, 8229, 37}, {8230, 8468, 1}, {8469, 8469, 38}, {8470, 8472, 1}, {8473, 8473, 39}, {8474, 8483, 1}, {8484, 8484, 40}, {8485, 8593, 1}, {8594, 8594, 41}, {8595, 8595, 1}, {8596, 8596, 42}, {8597, 8607, 1}, {8608, 8608, 43}, {8609, 8610, 1}, {8611, 8611, 44}, {8612, 8613, 1}, {8614, 8614, 45}, {8615, 8657, 1}, {8658, 8658, 46}, {8659, 8659, 1}, {8660, 8660, 47}, {8661, 8695, 1}, {8696, 8696, 48}, {8697, 8703, 1}, {8704, 8704, 49}, {8705, 8706, 1}, {8707, 8707, 50}, {8708, 8708, 1}, {8709, 8709, 51}, {8710, 8711, 1}, {8712, 8712, 52}, {8713, 8713, 53}, {8714, 8721, 1}, {8722, 8722, 54}, {8723, 8725, 1}, {8726, 8726, 55}, {8727, 8727, 56}, {8728, 8728, 57}, {8729, 8738, 1}, {8739, 8739, 58}, {8740, 8740, 1}, {8741, 8741, 59}, {8742, 8742, 1}, {8743, 8743, 60}, {8744, 8744, 61}, {8745, 8745, 62}, {8746, 8746, 63}, {8747, 8763, 1}, {8764, 8764, 64}, {8765, 8787, 1}, {8788, 8788, 65}, {8789, 8799, 1}, {8800, 8800, 66}, {8801, 8803, 1}, {8804, 8804, 67}, {8805, 8805, 68}, {8806, 8833, 1}, {8834, 8834, 69}, {8835, 8835, 1}, {8836, 8836, 70}, {8837, 8837, 1}, {8838, 8838, 71}, {8839, 8839, 1}, {8840, 8840, 72}, {8841, 8854, 1}, {8855, 8855, 73}, {8856, 8867, 1}, {8868, 8868, 74}, {8869, 8869, 75}, {8870, 8897, 1}, {8898, 8898, 76}, {8899, 8899, 77}, {8900, 9654, 1}, {9655, 9655, 78}, {9656, 9664, 1}, {9665, 9665, 79}, {9666, 10495, 1}, {10496, 10496, 80}, {10497, 10515, 1}, {10516, 10516, 81}, {10517, 10517, 1}, {10518, 10518, 82}, {10519, 10625, 1}, {10626, 10626, 83}, {10627, 10851, 1}, {10852, 10852, 84}, {10853, 10853, 85}, {10854, 57599, 1}, {57600, 57600, 86}, {57601, 57601, 87}, {57602, 57602, 88}, {57603, 57603, 89}, {57604, 65535, 1}, },
            {{0, 8, 1}, {11, 12, 1}, {14, 31, 1}, {34, 34, 1}, {36, 36, 1}, {39, 39, 1}, {48, 57, 1}, {63, 91, 1}, {93, 93, 1}, {95, 122, 1}, {127, 171, 1}, {173, 182, 1}, {184, 214, 1}, {216, 246, 1}, {248, 954, 1}, {956, 8228, 1}, {8230, 8468, 1}, {8470, 8472, 1}, {8474, 8483, 1}, {8485, 8593, 1}, {8595, 8595, 1}, {8597, 8607, 1}, {8609, 8610, 1}, {8612, 8613, 1}, {8615, 8657, 1}, {8659, 8659, 1}, {8661, 8695, 1}, {8697, 8703, 1}, {8705, 8706, 1}, {8708, 8708, 1}, {8710, 8711, 1}, {8714, 8721, 1}, {8723, 8725, 1}, {8729, 8738, 1}, {8740, 8740, 1}, {8742, 8742, 1}, {8747, 8763, 1}, {8765, 8787, 1}, {8789, 8799, 1}, {8801, 8803, 1}, {8806, 8833, 1}, {8835, 8835, 1}, {8837, 8837, 1}, {8839, 8839, 1}, {8841, 8854, 1}, {8856, 8867, 1}, {8870, 8897, 1}, {8900, 9654, 1}, {9656, 9664, 1}, {9666, 10495, 1}, {10497, 10515, 1}, {10517, 10517, 1}, {10519, 10625, 1}, {10627, 10851, 1}, {10854, 57599, 1}, {57604, 65535, 1}, },
            {{9, 10, 2}, {13, 13, 2}, {32, 32, 2}, },
            {},
            {},
            {},
            {},
            {},
            {{42, 42, 90}, },
            {{45, 45, 91}, {62, 62, 92}, },
            {{45, 45, 93}, {62, 62, 94}, },
            {{46, 46, 95}, },
            {{58, 58, 96}, {60, 60, 97}, {61, 61, 98}, {92, 92, 99}, {124, 124, 100}, },
            {{58, 58, 101}, {61, 61, 102}, {124, 124, 103}, {8712, 8712, 104}, {8739, 8739, 105}, },
            {},
            {{43, 43, 106}, {45, 45, 107}, {58, 58, 108}, {60, 60, 109}, {61, 61, 110}, {124, 124, 111}, },
            {{62, 62, 112}, },
            {{43, 43, 113}, {45, 45, 114}, {60, 60, 115}, {61, 61, 116}, },
            {{0, 57, -3}, {63, 77, 1}, {78, 78, 117}, {79, 91, 1}, {93, 65535, -3}, },
            {{0, 57, -3}, {63, 64, 1}, {65, 65, 118}, {66, 91, 1}, {93, 65535, -3}, },
            {{0, 57, -3}, {63, 78, 1}, {79, 79, 119}, {80, 91, 1}, {93, 65535, -3}, },
            {{0, 77, -20}, {78, 78, 120}, {79, 65535, -20}, },
            {{47, 47, 121}, {48, 48, 122}, {73, 73, 123}, {85, 85, 124}, {98, 98, 125}, {99, 99, 126}, {100, 100, 127}, {101, 101, 128}, {102, 102, 129}, {103, 103, 130}, {105, 105, 131}, {108, 108, 132}, {109, 109, 133}, {110, 110, 134}, {111, 111, 135}, {112, 112, 136}, {113, 113, 137}, {114, 114, 138}, {115, 115, 139}, {116, 116, 140}, {124, 124, 141}, },
            {},
            {{0, 93, -3}, {95, 104, 1}, {105, 105, 142}, {106, 122, 1}, {127, 65535, -3}, },
            {{0, 93, -3}, {95, 96, 1}, {97, 97, 143}, {98, 122, 1}, {127, 65535, -3}, },
            {{0, 93, -3}, {95, 110, 1}, {111, 111, 144}, {112, 122, 1}, {127, 65535, -3}, },
            {{0, 93, -3}, {95, 101, 1}, {102, 102, 145}, {103, 113, 1}, {114, 114, 146}, {115, 122, 1}, {127, 65535, -3}, },
            {{0, 93, -3}, {95, 113, 1}, {114, 114, 147}, {115, 65535, -29}, },
            {{125, 125, 148}, },
            {{45, 45, 149}, {62, 62, 150}, {124, 124, 151}, },
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {{49, 49, 152}, },
            {{49, 49, 153}, },
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {{62, 62, 154}, },
            {{62, 62, 155}, },
            {{62, 62, 156}, },
            {{62, 62, 157}, },
            {},
            {},
            {{58, 58, 158}, {60, 60, 159}, },
            {},
            {},
            {{92, 92, 160}, },
            {},
            {},
            {},
            {},
            {},
            {},
            {{62, 62, 161}, },
            {},
            {{45, 45, 162}, {58, 58, 163}, {124, 124, 164}, },
            {{62, 62, 165}, },
            {},
            {},
            {{62, 62, 166}, },
            {{62, 62, 167}, },
            {},
            {},
            {{0, 57, -3}, {63, 83, 1}, {84, 84, 168}, {85, 91, 1}, {93, 65535, -3}, },
            {{0, 83, -119}, {84, 84, 169}, {85, 65535, -119}, },
            {{0, 57, -3}, {63, 86, 1}, {87, 87, 170}, {88, 91, 1}, {93, 65535, -3}, },
            {{0, 57, -3}, {63, 72, 1}, {73, 73, 171}, {74, 91, 1}, {93, 65535, -3}, },
            {},
            {{120, 120, 172}, },
            {{110, 110, 173}, },
            {{110, 110, 174}, },
            {{99, 99, 175}, {102, 102, 176}, {105, 105, 177}, {116, 116, 178}, {117, 117, 179}, },
            {{111, 111, 180}, {112, 112, 181}, },
            {{105, 105, 182}, {111, 111, 183}, {112, 112, 184}, },
            {{109, 109, 185}, {120, 120, 186}, },
            {{99, 99, 187}, {111, 111, 188}, },
            {{101, 101, 189}, },
            {{110, 110, 190}, },
            {{97, 97, 191}, {101, 101, 192}, {105, 105, 193}, {110, 110, 194}, {111, 111, 195}, },
            {{97, 97, 196}, {105, 105, 197}, },
            {{97, 97, 198}, {101, 101, 199}, {111, 111, 200}, },
            {{102, 102, 201}, {118, 118, 202}, },
            {{102, 102, 203}, {105, 105, 204}, {111, 111, 205}, {112, 112, 206}, {115, 115, 207}, },
            {{100, 100, 208}, },
            {{97, 97, 209}, {101, 101, 210}, },
            {{101, 101, 211}, {114, 114, 212}, {116, 116, 213}, {117, 117, 214}, },
            {{98, 98, 215}, {102, 102, 216}, {105, 105, 217}, {114, 114, 218}, {115, 115, 219}, },
            {{47, 47, 220}, },
            {{0, 113, -30}, {114, 114, 221}, {115, 65535, -29}, },
            {{0, 93, -3}, {95, 107, 1}, {108, 108, 222}, {109, 122, 1}, {127, 65535, -3}, },
            {{0, 93, -3}, {95, 115, 1}, {116, 116, 223}, {117, 122, 1}, {127, 65535, -3}, },
            {{0, 115, -146}, {116, 116, 224}, {117, 65535, -146}, },
            {{0, 65535, -3}, },
            {{0, 93, -3}, {95, 116, 1}, {117, 117, 225}, {118, 122, 1}, {127, 65535, -3}, },
            {},
            {{62, 62, 226}, },
            {{62, 62, 227}, },
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {{58, 58, 228}, },
            {},
            {{62, 62, 229}, },
            {{62, 62, 230}, },
            {},
            {},
            {},
            {},
            {{62, 62, 231}, },
            {{0, 57, -3}, {63, 68, 1}, {69, 69, 232}, {70, 91, 1}, {93, 65535, -3}, },
            {{0, 39, -3}, {48, 48, 1}, {49, 49, 233}, {50, 57, 1}, {63, 65535, -3}, },
            {{0, 48, -171}, {49, 49, 234}, {50, 65535, -171}, },
            {{0, 78, -22}, {79, 79, 235}, {80, 65535, -22}, },
            {{112, 112, 236}, },
            {{116, 116, 237}, },
            {{105, 105, 238}, },
            {{109, 109, 239}, {111, 111, 240}, },
            {{97, 97, 241}, },
            {{110, 110, 242}, },
            {{114, 114, 243}, },
            {{110, 110, 244}, },
            {{110, 110, 245}, },
            {{114, 114, 246}, },
            {{118, 118, 247}, },
            {{109, 109, 248}, },
            {{114, 114, 249}, },
            {{112, 112, 250}, },
            {{105, 105, 251}, {112, 112, 252}, },
            {{111, 111, 253}, },
            {{114, 114, 254}, },
            {{113, 113, 255}, },
            {{116, 116, 256}, },
            {{109, 109, 257}, {110, 110, 258}, },
            {{113, 113, 259}, },
            {{109, 109, 260}, },
            {{111, 111, 261}, },
            {{114, 114, 262}, },
            {{112, 112, 263}, },
            {{100, 100, 264}, },
            {{116, 116, 265}, },
            {{113, 113, 266}, },
            {{116, 116, 267}, },
            {{116, 116, 268}, },
            {{108, 108, 269}, },
            {{117, 117, 270}, },
            {{110, 110, 271}, },
            {{119, 119, 272}, },
            {{114, 114, 273}, },
            {{117, 117, 274}, },
            {{111, 111, 275}, },
            {{110, 110, 276}, },
            {{108, 108, 277}, },
            {{116, 116, 278}, },
            {{101, 101, 279}, },
            {{114, 114, 280}, },
            {{98, 98, 281}, },
            {{105, 105, 282}, },
            {{117, 117, 283}, },
            {{110, 110, 284}, },
            {{101, 101, 285}, },
            {{117, 117, 286}, },
            {},
            {{0, 93, -3}, {95, 98, 1}, {99, 99, 287}, {100, 122, 1}, {127, 65535, -3}, },
            {{0, 93, -3}, {95, 114, 1}, {115, 115, 288}, {116, 122, 1}, {127, 65535, -3}, },
            {{0, 65535, -3}, },
            {{0, 93, -3}, {95, 120, 1}, {121, 121, 289}, {122, 122, 1}, {127, 65535, -3}, },
            {{0, 93, -3}, {95, 100, 1}, {101, 101, 290}, {102, 122, 1}, {127, 65535, -3}, },
            {},
            {},
            {},
            {},
            {{62, 62, 291}, },
            {},
            {{0, 57, -3}, {63, 81, 1}, {82, 82, 292}, {83, 91, 1}, {93, 65535, -3}, },
            {{0, 65535, -3}, },
            {{0, 65535, -3}, },
            {{0, 77, -20}, {78, 78, 293}, {79, 65535, -20}, },
            {{116, 116, 294}, },
            {{101, 101, 295}, },
            {{111, 111, 296}, },
            {{101, 101, 297}, {105, 105, 298}, {115, 115, 299}, },
            {{109, 109, 300}, },
            {{108, 108, 301}, },
            {{116, 116, 302}, },
            {{117, 117, 303}, },
            {{105, 105, 304}, },
            {{118, 118, 305}, },
            {{111, 111, 306}, },
            {},
            {{114, 114, 307}, {115, 115, 308}, },
            {{111, 111, 309}, },
            {{116, 116, 310}, },
            {{115, 115, 311}, },
            {{110, 110, 312}, },
            {{109, 109, 313}, },
            {{97, 97, 314}, },
            {},
            {{103, 103, 315}, },
            {{98, 98, 316}, },
            {{100, 100, 317}, },
            {{118, 118, 318}, },
            {{112, 112, 319}, },
            {{116, 116, 320}, },
            {},
            {{115, 115, 321}, },
            {},
            {{49, 49, 322}, },
            {},
            {{105, 105, 323}, {115, 115, 324}, },
            {{121, 121, 325}, },
            {},
            {{110, 110, 326}, },
            {{106, 106, 327}, },
            {{49, 49, 328}, },
            {{111, 111, 329}, },
            {{114, 114, 330}, },
            {{116, 116, 331}, },
            {{114, 114, 332}, {115, 115, 333}, },
            {},
            {{109, 109, 334}, },
            {{108, 108, 335}, },
            {{101, 101, 336}, },
            {{115, 115, 337}, },
            {{106, 106, 338}, },
            {{110, 110, 339}, },
            {{106, 106, 340}, },
            {{108, 108, 341}, },
            {{114, 114, 342}, },
            {{0, 65535, -3}, },
            {{0, 100, -227}, {101, 101, 343}, {102, 65535, -227}, },
            {{0, 93, -3}, {95, 111, 1}, {112, 112, 344}, {113, 122, 1}, {127, 65535, -3}, },
            {{0, 65535, -3}, },
            {},
            {{0, 65535, -3}, },
            {{0, 65535, -3}, },
            {{111, 111, 345}, },
            {{114, 114, 346}, },
            {{110, 110, 347}, },
            {{113, 113, 348}, },
            {{110, 110, 349}, },
            {{117, 117, 350}, },
            {{112, 112, 351}, },
            {{115, 115, 352}, },
            {{101, 101, 353}, },
            {{101, 101, 354}, },
            {{111, 111, 355}, },
            {},
            {{100, 100, 356}, },
            {{101, 101, 357}, },
            {{117, 117, 358}, },
            {{100, 100, 359}, },
            {{121, 121, 360}, },
            {{116, 116, 361}, },
            {},
            {{112, 112, 362}, },
            {{108, 108, 363}, },
            {},
            {{100, 100, 364}, },
            {},
            {},
            {},
            {},
            {{116, 116, 365}, },
            {},
            {{110, 110, 366}, },
            {{117, 117, 367}, },
            {{112, 112, 368}, },
            {},
            {},
            {},
            {{100, 100, 369}, },
            {},
            {},
            {{101, 101, 370}, },
            {{117, 117, 371}, },
            {{105, 105, 372}, },
            {},
            {{108, 108, 373}, },
            {{101, 101, 374}, },
            {},
            {},
            {},
            {},
            {},
            {{0, 65535, -3}, },
            {{0, 100, -227}, {101, 101, 375}, {102, 65535, -227}, },
            {},
            {},
            {},
            {},
            {},
            {{99, 99, 376}, },
            {},
            {{101, 101, 377}, },
            {{114, 114, 378}, },
            {},
            {{110, 110, 379}, },
            {},
            {{115, 115, 380}, },
            {{98, 98, 381}, },
            {},
            {{115, 115, 382}, },
            {{115, 115, 383}, },
            {},
            {{108, 108, 384}, },
            {{97, 97, 385}, },
            {{111, 111, 386}, },
            {},
            {{98, 98, 387}, },
            {{101, 101, 388}, },
            {},
            {{115, 115, 389}, },
            {{98, 98, 390}, },
            {{110, 110, 391}, },
            {},
            {{116, 116, 392}, },
            {{0, 65535, -3}, },
            {{104, 104, 393}, },
            {},
            {},
            {},
            {},
            {},
            {{101, 101, 394}, },
            {},
            {},
            {},
            {},
            {{115, 115, 395}, },
            {},
            {},
            {},
            {{117, 117, 396}, },
            {{101, 101, 397}, },
            {},
            {{116, 116, 398}, },
            {{101, 101, 399}, },
            {{115, 115, 400}, },
            {{113, 113, 401}, },
            {},
            {{116, 116, 402}, },
            {},
            {},
            {{101, 101, 403}, },
            {{113, 113, 404}, },
            {},
        }
    };*/

    private static int[][] accept;
/*  {
        // INITIAL
        {66, 66, 67, 11, 12, 22, 36, 68, 62, 68, 63, 40, 61, 0, 28, 68, 68, 68, 66, 66, 66, 66, 4, 51, 66, 66, 66, 66, 66, 68, 55, 41, 39, 40, 25, 61, 22, 5, 7, 54, 35, 45, 57, 49, 47, 13, 37, 38, 44, 11, 12, 8, 0, 24, 63, 4, 62, 29, 55, 32, 36, 52, 17, 16, 41, 33, 56, 59, 60, 15, 2, 3, 1, 31, 14, 10, 27, 26, 19, 18, 48, 46, 50, 23, 20, 21, 42, 43, 30, 58, 25, -1, -1, -1, -1, 5, 24, -1, 56, 17, -1, 34, 33, 9, 34, 9, 58, -1, 3, -1, 59, 18, 37, -1, -1, 31, 60, 66, 66, 66, 66, 16, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 66, 66, 66, 66, 52, 66, 8, -1, 19, 32, 6, 53, 44, 48, 45, 49, 1, -1, 64, 57, -1, 15, 20, 38, 46, 47, 35, 7, 54, 66, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 65, 66, 66, 39, 66, 66, 13, 21, 2, 43, 42, 50, 66, 6, 53, 66, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 61, -1, -1, -1, -1, -1, -1, -1, 60, -1, -1, -1, 59, -1, -1, 52, -1, 55, 7, 56, -1, -1, 58, -1, -1, 54, -1, -1, -1, -1, 57, -1, -1, -1, -1, -1, -1, -1, -1, -1, 29, 66, 66, 14, 30, 27, 26, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 41, -1, -1, -1, -1, -1, -1, 51, -1, -1, 35, -1, 36, 38, 37, 39, -1, 6, -1, -1, -1, 44, 46, 53, -1, 48, 40, -1, -1, -1, 43, -1, -1, 50, 45, 47, 42, 49, 10, 66, 5, 27, 26, 33, 34, -1, 29, -1, -1, 14, -1, 25, -1, -1, 31, -1, -1, 28, -1, -1, -1, 24, -1, -1, 32, -1, -1, -1, 30, -1, 23, -1, 10, 17, 16, 18, 20, -1, 12, 11, 22, 13, -1, 23, 19, 21, -1, 15, 9, -1, -1, -1, -1, 8, -1, 4, 3, 2, -1, 1, },

    };*/

    public static class State
    {
        public final static State INITIAL = new State(0);

        private int id;

        private State(  int id)
        {
            this.id = id;
        }

        public int id()
        {
            return this.id;
        }
    }

    static 
    {
        try
        {
            DataInputStream s = new DataInputStream(
                new BufferedInputStream(
                Lexer.class.getResourceAsStream("lexer.dat")));

            // read gotoTable
            int length = s.readInt();
            gotoTable = new int[length][][][];
            for(int i = 0; i < gotoTable.length; i++)
            {
                length = s.readInt();
                gotoTable[i] = new int[length][][];
                for(int j = 0; j < gotoTable[i].length; j++)
                {
                    length = s.readInt();
                    gotoTable[i][j] = new int[length][3];
                    for(int k = 0; k < gotoTable[i][j].length; k++)
                    {
                        for(int l = 0; l < 3; l++)
                        {
                            gotoTable[i][j][k][l] = s.readInt();
                        }
                    }
                }
            }

            // read accept
            length = s.readInt();
            accept = new int[length][];
            for(int i = 0; i < accept.length; i++)
            {
                length = s.readInt();
                accept[i] = new int[length];
                for(int j = 0; j < accept[i].length; j++)
                {
                    accept[i][j] = s.readInt();
                }
            }

            s.close();
        }
        catch(Exception e)
        {
            throw new RuntimeException("The file \"lexer.dat\" is either missing or corrupted.");
        }
    }
}
