/* This file was generated by SableCC (http://www.sablecc.org/). */

package de.be4.ltl.core.parser.lexer;

import java.io.*;
import java.util.*;
import de.be4.ltl.core.parser.node.*;
import de.hhu.stups.sablecc.patch.*;
import java.util.concurrent.LinkedBlockingQueue;

@SuppressWarnings({"unused"}) 
public class Lexer implements ITokenListContainer
{
    protected Token token;
    protected State state = State.LTL;

    private PushbackReader in;
    private int line;
    private int pos;
    private boolean cr;
    private boolean eof;
    private final StringBuffer text = new StringBuffer();
    
	private List<IToken> tokenList;
    private final Queue<IToken> nextList = new LinkedBlockingQueue<IToken>();

	private IToken tok;

    public Queue<IToken> getNextList() {
        return nextList;
    }

	public List<IToken> getTokenList() {
		return tokenList;
	}
	
	private void setToken(Token t) {
	  tok = t;
   	  token = t;	
	}
	
	
	public void setTokenList(final List<IToken> list) {
		tokenList = list;
	}

     
    protected void filter() throws LexerException, IOException
    {
        // Do nothing
    }

    protected void filterWrap() throws LexerException, IOException
    {
       filter();
       if (token != null) {
	          getTokenList().add(token); 
              nextList.add(token);
	   }
    }


    public Lexer(  PushbackReader in)
    {
        this.in = in;
    	setTokenList(new ArrayList<IToken>());
    }
    
    public Token peek() throws LexerException, IOException
    {
        while(this.token == null)
        {
            this.setToken(getToken());
            filterWrap();
        }

        return (Token) nextList.peek();
    }

    public Token next() throws LexerException, IOException
    {
        while(this.token == null)
        {
            this.setToken(getToken());
            filterWrap();
        }

        Token result = (Token) nextList.poll();
        this.setToken(null);
        return result;
    }

    protected Token getToken() throws IOException, LexerException
    {
        int dfa_state = 0;

        int start_pos = this.pos;
        int start_line = this.line;

        int accept_state = -1;
        int accept_token = -1;
        int accept_length = -1;
        int accept_pos = -1;
        int accept_line = -1;

          int[][][] gotoTable = Lexer.gotoTable[this.state.id()];
          int[] accept = Lexer.accept[this.state.id()];
        this.text.setLength(0);

        while(true)
        {
            int c = getChar();

            if(c != -1)
            {
                switch(c)
                {
                case 10:
                    if(this.cr)
                    {
                        this.cr = false;
                    }
                    else
                    {
                        this.line++;
                        this.pos = 0;
                    }
                    break;
                case 13:
                    this.line++;
                    this.pos = 0;
                    this.cr = true;
                    break;
                default:
                    this.pos++;
                    this.cr = false;
                    break;
                }

                this.text.append((char) c);

                do
                {
                    int oldState = (dfa_state < -1) ? (-2 -dfa_state) : dfa_state;

                    dfa_state = -1;

                    int[][] tmp1 =  gotoTable[oldState];
                    int low = 0;
                    int high = tmp1.length - 1;

                    while(low <= high)
                    {
                        int middle = (low + high) / 2;
                        int[] tmp2 = tmp1[middle];

                        if(c < tmp2[0])
                        {
                            high = middle - 1;
                        }
                        else if(c > tmp2[1])
                        {
                            low = middle + 1;
                        }
                        else
                        {
                            dfa_state = tmp2[2];
                            break;
                        }
                    }
                }while(dfa_state < -1);
            }
            else
            {
                dfa_state = -1;
            }

            if(dfa_state >= 0)
            {
                if(accept[dfa_state] != -1)
                {
                    accept_state = dfa_state;
                    accept_token = accept[dfa_state];
                    accept_length = this.text.length();
                    accept_pos = this.pos;
                    accept_line = this.line;
                }
            }
            else
            {
                if(accept_state != -1)
                {
                    switch(accept_token)
                    {
                    case 0:
                        {
                              Token token = new0(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.LTL; break;
                            }
                            return token;
                        }
                    case 1:
                        {
                              Token token = new1(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.LTL; break;
                            }
                            return token;
                        }
                    case 2:
                        {
                              Token token = new2(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.ACTIONS; break;
                            }
                            return token;
                        }
                    case 3:
                        {
                              Token token = new3(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.ACTIONS; break;
                            }
                            return token;
                        }
                    case 4:
                        {
                              Token token = new4(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.ACTIONS; break;
                            }
                            return token;
                        }
                    case 5:
                        {
                              Token token = new5(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.LTL; break;
                            }
                            return token;
                        }
                    case 6:
                        {
                              Token token = new6(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.LTL; break;
                            }
                            return token;
                        }
                    case 7:
                        {
                              Token token = new7(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.LTL; break;
                            }
                            return token;
                        }
                    case 8:
                        {
                              Token token = new8(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.LTL; break;
                            }
                            return token;
                        }
                    case 9:
                        {
                              Token token = new9(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.LTL; break;
                            }
                            return token;
                        }
                    case 10:
                        {
                              Token token = new10(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.ACTION; break;
                            }
                            return token;
                        }
                    case 11:
                        {
                              Token token = new11(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.ACTION; break;
                            }
                            return token;
                        }
                    case 12:
                        {
                              Token token = new12(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.ACTION; break;
                            }
                            return token;
                        }
                    case 13:
                        {
                              Token token = new13(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.ATOMIC; break;
                                case 0: state = State.ATOMIC; break;
                            }
                            return token;
                        }
                    case 14:
                        {
                              Token token = new14(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.ATOMIC; break;
                            }
                            return token;
                        }
                    case 15:
                        {
                              Token token = new15(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.ATOMIC; break;
                            }
                            return token;
                        }
                    case 16:
                        {
                              Token token = new16(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 2: state = State.ACTION; break;
                            }
                            return token;
                        }
                    case 17:
                        {
                              Token token = new17(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 2: state = State.ACTION; break;
                            }
                            return token;
                        }
                    case 18:
                        {
                              Token token = new18(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 2: state = State.ACTION; break;
                            }
                            return token;
                        }
                    case 19:
                        {
                              Token token = new19(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.LTL; break;
                            }
                            return token;
                        }
                    case 20:
                        {
                              Token token = new20(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.LTL; break;
                            }
                            return token;
                        }
                    case 21:
                        {
                              Token token = new21(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 3: state = State.ACTIONS; break;
                            }
                            return token;
                        }
                    case 22:
                        {
                              Token token = new22(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 3: state = State.ACTIONS; break;
                            }
                            return token;
                        }
                    case 23:
                        {
                              Token token = new23(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 3: state = State.ACTIONS; break;
                            }
                            return token;
                        }
                    case 24:
                        {
                              Token token = new24(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 3: state = State.ACTIONS; break;
                            }
                            return token;
                        }
                    case 25:
                        {
                              Token token = new25(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.LTL; break;
                            }
                            return token;
                        }
                    case 26:
                        {
                              Token token = new26(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.LTL; break;
                            }
                            return token;
                        }
                    case 27:
                        {
                              Token token = new27(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.LTL; break;
                            }
                            return token;
                        }
                    case 28:
                        {
                              Token token = new28(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.LTL; break;
                            }
                            return token;
                        }
                    case 29:
                        {
                              Token token = new29(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.LTL; break;
                            }
                            return token;
                        }
                    case 30:
                        {
                              Token token = new30(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.LTL; break;
                            }
                            return token;
                        }
                    case 31:
                        {
                              Token token = new31(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.LTL; break;
                            }
                            return token;
                        }
                    case 32:
                        {
                              Token token = new32(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.LTL; break;
                            }
                            return token;
                        }
                    case 33:
                        {
                              Token token = new33(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.LTL; break;
                            }
                            return token;
                        }
                    case 34:
                        {
                              Token token = new34(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.LTL; break;
                            }
                            return token;
                        }
                    case 35:
                        {
                              Token token = new35(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.LTL; break;
                            }
                            return token;
                        }
                    case 36:
                        {
                              Token token = new36(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.LTL; break;
                            }
                            return token;
                        }
                    case 37:
                        {
                              Token token = new37(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.LTL; break;
                            }
                            return token;
                        }
                    case 38:
                        {
                              Token token = new38(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.LTL; break;
                            }
                            return token;
                        }
                    case 39:
                        {
                              Token token = new39(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.LTL; break;
                            }
                            return token;
                        }
                    case 40:
                        {
                              Token token = new40(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.LTL; break;
                            }
                            return token;
                        }
                    case 41:
                        {
                              Token token = new41(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.LTL; break;
                            }
                            return token;
                        }
                    case 42:
                        {
                              Token token = new42(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.ACTION; break;
                            }
                            return token;
                        }
                    case 43:
                        {
                              Token token = new43(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.ACTION; break;
                            }
                            return token;
                        }
                    case 44:
                        {
                              Token token = new44(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    }
                }
                else
                {
                    if(this.text.length() > 0)
                    {
                        throw new LexerException(
                            "[" + (start_line + 1) + "," + (start_pos + 1) + "]" +
                            " Unknown token: " + this.text);
                    }

                      EOF token = new EOF(
                        start_line + 1,
                        start_pos + 1);
                    return token;
                }
            }
        }
    }

    Token new0(  int line,   int pos) { return new TTrue(line, pos); }
    Token new1(  int line,   int pos) { return new TFalse(line, pos); }
    Token new2(  String text,   int line,   int pos) { return new TDlk(text, line, pos); }
    Token new3(  String text,   int line,   int pos) { return new TDet(text, line, pos); }
    Token new4(  String text,   int line,   int pos) { return new TCtrl(text, line, pos); }
    Token new5(  int line,   int pos) { return new TSink(line, pos); }
    Token new6(  int line,   int pos) { return new TDeadlock(line, pos); }
    Token new7(  int line,   int pos) { return new TCurrent(line, pos); }
    Token new8(  String text,   int line,   int pos) { return new TLPar(text, line, pos); }
    Token new9(  String text,   int line,   int pos) { return new TRPar(text, line, pos); }
    Token new10(  String text,   int line,   int pos) { return new TLSq(text, line, pos); }
    Token new11(  String text,   int line,   int pos) { return new TEnabled(text, line, pos); }
    Token new12(  String text,   int line,   int pos) { return new TAvailable(text, line, pos); }
    Token new13(  String text,   int line,   int pos) { return new TAtomicPropositionBegin(text, line, pos); }
    Token new14(  String text,   int line,   int pos) { return new TAtomicPropositionEnd(text, line, pos); }
    Token new15(  String text,   int line,   int pos) { return new TApChar(text, line, pos); }
    Token new16(  String text,   int line,   int pos) { return new TActionEnd(text, line, pos); }
    Token new17(  String text,   int line,   int pos) { return new TActionBegin(text, line, pos); }
    Token new18(  String text,   int line,   int pos) { return new TTpChar(text, line, pos); }
    Token new19(  String text,   int line,   int pos) { return new TExistsIdentifier(text, line, pos); }
    Token new20(  String text,   int line,   int pos) { return new TForallIdentifier(text, line, pos); }
    Token new21(  String text,   int line,   int pos) { return new TArgsBegin(text, line, pos); }
    Token new22(  String text,   int line,   int pos) { return new TArgsEnd(text, line, pos); }
    Token new23(  String text,   int line,   int pos) { return new TActionsSplit(text, line, pos); }
    Token new24(  String text,   int line,   int pos) { return new TActionChar(text, line, pos); }
    Token new25(  int line,   int pos) { return new TImplies(line, pos); }
    Token new26(  int line,   int pos) { return new TAnd(line, pos); }
    Token new27(  int line,   int pos) { return new TOr(line, pos); }
    Token new28(  int line,   int pos) { return new TNot(line, pos); }
    Token new29(  int line,   int pos) { return new TUntil(line, pos); }
    Token new30(  int line,   int pos) { return new TWeakuntil(line, pos); }
    Token new31(  int line,   int pos) { return new TRelease(line, pos); }
    Token new32(  int line,   int pos) { return new TGlobally(line, pos); }
    Token new33(  int line,   int pos) { return new TFinally(line, pos); }
    Token new34(  int line,   int pos) { return new TNext(line, pos); }
    Token new35(  int line,   int pos) { return new TSince(line, pos); }
    Token new36(  int line,   int pos) { return new TTrigger(line, pos); }
    Token new37(  int line,   int pos) { return new THistorically(line, pos); }
    Token new38(  int line,   int pos) { return new TOnce(line, pos); }
    Token new39(  int line,   int pos) { return new TYesterday(line, pos); }
    Token new40(  String text,   int line,   int pos) { return new TStrongFairEverything(text, line, pos); }
    Token new41(  String text,   int line,   int pos) { return new TWeakFairEverything(text, line, pos); }
    Token new42(  String text,   int line,   int pos) { return new TStrongFair(text, line, pos); }
    Token new43(  String text,   int line,   int pos) { return new TWeakFair(text, line, pos); }
    Token new44(  String text,   int line,   int pos) { return new TWhiteSpace(text, line, pos); }

    private int getChar() throws IOException
    {
        if(this.eof)
        {
            return -1;
        }

        int result = this.in.read();

        if(result == -1)
        {
            this.eof = true;
        }

        return result;
    }

    private void pushBack(int acceptLength) throws IOException
    {
        int length = this.text.length();
        for(int i = length - 1; i >= acceptLength; i--)
        {
            this.eof = false;

            this.in.unread(this.text.charAt(i));
        }
    }

    protected void unread(  Token token) throws IOException
    {
          String text = token.getText();
        int length = text.length();

        for(int i = length - 1; i >= 0; i--)
        {
            this.eof = false;

            this.in.unread(text.charAt(i));
        }

        this.pos = token.getPos() - 1;
        this.line = token.getLine() - 1;
    }

    private String getText(int acceptLength)
    {
        StringBuffer s = new StringBuffer(acceptLength);
        for(int i = 0; i < acceptLength; i++)
        {
            s.append(this.text.charAt(i));
        }

        return s.toString();
    }

    private static int[][][][] gotoTable;
/*  {
        { // LTL
            {{0, 9, 1}, {10, 10, 2}, {11, 12, 1}, {13, 13, 2}, {14, 32, 1}, {33, 33, 3}, {35, 35, 4}, {38, 38, 5}, {40, 40, 6}, {41, 41, 7}, {61, 61, 8}, {65, 65, 9}, {70, 70, 10}, {71, 71, 11}, {72, 72, 12}, {79, 79, 13}, {82, 82, 14}, {83, 83, 15}, {84, 84, 16}, {85, 85, 17}, {87, 87, 18}, {88, 88, 19}, {89, 89, 20}, {91, 91, 21}, {99, 99, 22}, {100, 100, 23}, {101, 101, 24}, {102, 102, 25}, {110, 110, 26}, {111, 111, 27}, {115, 115, 28}, {116, 116, 29}, {119, 119, 30}, {123, 123, 31}, {127, 160, 1}, {8206, 8207, 1}, {8232, 8233, 1}, },
            {{0, 9, 1}, {11, 12, 1}, {14, 32, 1}, {127, 8233, -2}, },
            {},
            {{0, 9, 32}, {10, 10, 33}, {11, 12, 32}, {13, 13, 33}, {14, 32, 32}, {65, 90, 34}, {97, 122, 35}, {127, 160, 32}, {8206, 8207, 32}, {8232, 8233, 32}, },
            {{0, 9, 36}, {10, 10, 37}, {11, 12, 36}, {13, 13, 37}, {14, 32, 36}, {65, 90, 38}, {97, 122, 39}, {127, 160, 36}, {8206, 8207, 36}, {8232, 8233, 36}, },
            {},
            {},
            {},
            {{62, 62, 40}, },
            {{118, 118, 41}, },
            {},
            {},
            {},
            {},
            {},
            {{69, 69, 42}, {70, 70, 43}, },
            {},
            {},
            {{69, 69, 44}, {70, 70, 45}, },
            {},
            {},
            {},
            {{111, 111, 46}, {117, 117, 47}, },
            {{101, 101, 48}, },
            {{40, 40, 49}, },
            {{97, 97, 50}, },
            {{111, 111, 51}, },
            {{114, 114, 52}, },
            {{102, 102, 53}, {105, 105, 54}, },
            {{114, 114, 55}, },
            {{102, 102, 56}, },
            {},
            {{0, 8233, -5}, },
            {{0, 8233, -5}, },
            {{0, 9, 57}, {10, 10, 58}, {11, 12, 57}, {13, 13, 58}, {14, 32, 57}, {46, 46, 59}, {48, 57, 60}, {65, 90, 61}, {95, 95, 62}, {97, 122, 63}, {127, 160, 57}, {8206, 8207, 57}, {8232, 8233, 57}, },
            {{0, 8233, -36}, },
            {{0, 8233, -6}, },
            {{0, 8233, -6}, },
            {{0, 9, 64}, {10, 10, 65}, {11, 12, 64}, {13, 13, 65}, {14, 32, 64}, {46, 46, 66}, {48, 57, 67}, {65, 90, 68}, {95, 95, 69}, {97, 122, 70}, {127, 160, 64}, {8206, 8207, 64}, {8232, 8233, 64}, },
            {{0, 8233, -40}, },
            {},
            {{40, 40, 71}, },
            {{70, 70, 72}, },
            {{40, 40, 73}, },
            {{70, 70, 74}, },
            {{40, 40, 75}, },
            {{110, 110, 76}, },
            {{114, 114, 77}, },
            {{97, 97, 78}, {116, 116, 79}, },
            {},
            {{108, 108, 80}, },
            {{116, 116, 81}, },
            {},
            {{40, 40, 82}, },
            {{110, 110, 83}, },
            {{117, 117, 84}, },
            {{40, 40, 85}, },
            {{0, 46, -36}, {127, 8233, -36}, },
            {{0, 8233, -59}, },
            {},
            {{0, 8233, -36}, },
            {{0, 8233, -36}, },
            {{0, 8233, -36}, },
            {{0, 8233, -36}, },
            {{0, 46, -40}, {127, 8233, -40}, },
            {{0, 8233, -66}, },
            {},
            {{0, 8233, -40}, },
            {{0, 8233, -40}, },
            {{0, 8233, -40}, },
            {{0, 8233, -40}, },
            {},
            {},
            {},
            {},
            {},
            {{116, 116, 86}, },
            {{114, 114, 87}, },
            {{100, 100, 88}, },
            {{101, 101, 89}, },
            {{115, 115, 90}, },
            {},
            {},
            {{107, 107, 91}, },
            {{101, 101, 92}, },
            {},
            {{114, 114, 93}, },
            {{101, 101, 94}, },
            {{108, 108, 95}, },
            {{114, 114, 96}, },
            {{101, 101, 97}, },
            {},
            {},
            {{111, 111, 98}, },
            {{110, 110, 99}, },
            {{111, 111, 100}, },
            {{109, 109, 101}, },
            {},
            {{108, 108, 102}, },
            {{116, 116, 103}, },
            {{99, 99, 104}, },
            {{105, 105, 105}, },
            {{108, 108, 106}, },
            {},
            {{107, 107, 107}, },
            {{110, 110, 108}, },
            {{101, 101, 109}, },
            {{40, 40, 110}, },
            {{105, 105, 111}, },
            {{114, 114, 112}, },
            {},
            {{115, 115, 113}, },
            {{40, 40, 114}, },
            {{116, 116, 115}, },
            {},
            {{105, 105, 116}, },
            {{99, 99, 117}, },
            {{40, 40, 118}, },
            {},
        }
        { // ATOMIC
            {{0, 9, 1}, {10, 10, 2}, {11, 12, 1}, {13, 13, 2}, {14, 32, 1}, {33, 122, 3}, {123, 123, 4}, {124, 124, 3}, {125, 125, 5}, {126, 126, 3}, {127, 160, 1}, {161, 8205, 3}, {8206, 8207, 1}, {8208, 8231, 3}, {8232, 8233, 1}, {8234, 65535, 3}, },
            {{0, 9, 6}, {11, 12, 6}, {14, 32, 6}, {127, 160, 6}, {8206, 8207, 6}, {8232, 8233, 6}, },
            {},
            {},
            {},
            {},
            {{0, 8233, -3}, },
        }
        { // ACTION
            {{0, 9, 1}, {10, 10, 2}, {11, 12, 1}, {13, 13, 2}, {14, 32, 1}, {33, 39, 3}, {40, 40, 4}, {41, 41, 5}, {42, 90, 3}, {91, 91, 4}, {92, 92, 3}, {93, 93, 5}, {94, 126, 3}, {127, 160, 1}, {161, 8205, 3}, {8206, 8207, 1}, {8208, 8231, 3}, {8232, 8233, 1}, {8234, 65535, 3}, },
            {{0, 9, 6}, {11, 12, 6}, {14, 32, 6}, {127, 160, 6}, {8206, 8207, 6}, {8232, 8233, 6}, },
            {},
            {},
            {},
            {},
            {{0, 8233, -3}, },
        }
        { // ACTIONS
            {{0, 9, 1}, {10, 10, 2}, {11, 12, 1}, {13, 13, 2}, {14, 32, 1}, {33, 39, 3}, {40, 40, 4}, {41, 41, 5}, {42, 43, 3}, {44, 44, 6}, {45, 126, 3}, {127, 160, 1}, {161, 8205, 3}, {8206, 8207, 1}, {8208, 8231, 3}, {8232, 8233, 1}, {8234, 65535, 3}, },
            {{0, 9, 7}, {11, 12, 7}, {14, 32, 7}, {127, 160, 7}, {8206, 8207, 7}, {8232, 8233, 7}, },
            {},
            {},
            {},
            {},
            {},
            {{0, 8233, -3}, },
        }
    };*/

    private static int[][] accept;
/*  {
        // LTL
        {-1, 44, 44, -1, -1, 26, 8, 9, -1, -1, 33, 32, 37, 38, 31, 35, 36, 29, 30, 34, 39, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, 13, -1, -1, -1, -1, -1, -1, -1, -1, 25, -1, -1, -1, -1, -1, -1, -1, -1, 11, -1, -1, 27, -1, -1, -1, -1, -1, -1, 20, -1, -1, -1, -1, -1, -1, 19, -1, -1, -1, -1, 12, 40, 42, 41, 43, -1, -1, -1, -1, -1, 28, 42, -1, -1, 43, -1, -1, -1, -1, -1, 5, 0, -1, -1, -1, -1, 1, -1, -1, -1, -1, -1, 7, -1, -1, -1, 6, -1, -1, 2, -1, -1, -1, 4, -1, -1, -1, 3, },
        // ATOMIC
        {-1, 15, 15, 15, 13, 14, 44, },
        // ACTION
        {-1, 18, 18, 18, 17, 16, 44, },
        // ACTIONS
        {-1, 24, 24, 24, 21, 22, 23, 44, },

    };*/

    public static class State
    {
        public final static State LTL = new State(0);
        public final static State ATOMIC = new State(1);
        public final static State ACTION = new State(2);
        public final static State ACTIONS = new State(3);

        private int id;

        private State(  int id)
        {
            this.id = id;
        }

        public int id()
        {
            return this.id;
        }
    }

    static 
    {
        try
        {
            DataInputStream s = new DataInputStream(
                new BufferedInputStream(
                Lexer.class.getResourceAsStream("lexer.dat")));

            // read gotoTable
            int length = s.readInt();
            gotoTable = new int[length][][][];
            for(int i = 0; i < gotoTable.length; i++)
            {
                length = s.readInt();
                gotoTable[i] = new int[length][][];
                for(int j = 0; j < gotoTable[i].length; j++)
                {
                    length = s.readInt();
                    gotoTable[i][j] = new int[length][3];
                    for(int k = 0; k < gotoTable[i][j].length; k++)
                    {
                        for(int l = 0; l < 3; l++)
                        {
                            gotoTable[i][j][k][l] = s.readInt();
                        }
                    }
                }
            }

            // read accept
            length = s.readInt();
            accept = new int[length][];
            for(int i = 0; i < accept.length; i++)
            {
                length = s.readInt();
                accept[i] = new int[length];
                for(int j = 0; j < accept[i].length; j++)
                {
                    accept[i][j] = s.readInt();
                }
            }

            s.close();
        }
        catch(Exception e)
        {
            throw new RuntimeException("The file \"lexer.dat\" is either missing or corrupted.");
        }
    }
}
