/* This file was generated by SableCC (http://www.sablecc.org/). */

package promela.lexer;

import java.io.*;
import java.util.*;
import promela.node.*;
import de.hhu.stups.sablecc.patch.*;


@SuppressWarnings({"unused"}) 
public class Lexer implements ITokenListContainer
{
    protected Token token;
    protected State state = State.INITIAL;

    private PushbackReader in;
    private int line;
    private int pos;
    private boolean cr;
    private boolean eof;
    private final StringBuffer text = new StringBuffer();
    
	private List<IToken> tokenList;

	private IToken tok;

	public List<IToken> getTokenList() {
		return tokenList;
	}
	
	private void setToken(Token t) {
	  tok = t;
   	  token = t;	
	}
	
	
	public void setTokenList(final List<IToken> list) {
		tokenList = list;
	}

     
    protected void filter() throws LexerException, IOException
    {
        // Do nothing
    }

    protected void filterWrap() throws LexerException, IOException
    {
       filter();
       if (token != null) {
	          getTokenList().add(token); 
	   }
    }


    public Lexer(  PushbackReader in)
    {
        this.in = in;
    	setTokenList(new ArrayList<IToken>());
    }
    
    public Token peek() throws LexerException, IOException
    {
        while(this.token == null)
        {
            this.setToken(getToken());
            filterWrap();
        }

        return this.token;
    }

    public Token next() throws LexerException, IOException
    {
        while(this.token == null)
        {
            this.setToken(getToken());
            filterWrap();
        }

        Token result = this.token;
        this.setToken(null);
        return result;
    }

    protected Token getToken() throws IOException, LexerException
    {
        int dfa_state = 0;

        int start_pos = this.pos;
        int start_line = this.line;

        int accept_state = -1;
        int accept_token = -1;
        int accept_length = -1;
        int accept_pos = -1;
        int accept_line = -1;

          int[][][] gotoTable = Lexer.gotoTable[this.state.id()];
          int[] accept = Lexer.accept[this.state.id()];
        this.text.setLength(0);

        while(true)
        {
            int c = getChar();

            if(c != -1)
            {
                switch(c)
                {
                case 10:
                    if(this.cr)
                    {
                        this.cr = false;
                    }
                    else
                    {
                        this.line++;
                        this.pos = 0;
                    }
                    break;
                case 13:
                    this.line++;
                    this.pos = 0;
                    this.cr = true;
                    break;
                default:
                    this.pos++;
                    this.cr = false;
                    break;
                }

                this.text.append((char) c);

                do
                {
                    int oldState = (dfa_state < -1) ? (-2 -dfa_state) : dfa_state;

                    dfa_state = -1;

                    int[][] tmp1 =  gotoTable[oldState];
                    int low = 0;
                    int high = tmp1.length - 1;

                    while(low <= high)
                    {
                        int middle = (low + high) / 2;
                        int[] tmp2 = tmp1[middle];

                        if(c < tmp2[0])
                        {
                            high = middle - 1;
                        }
                        else if(c > tmp2[1])
                        {
                            low = middle + 1;
                        }
                        else
                        {
                            dfa_state = tmp2[2];
                            break;
                        }
                    }
                }while(dfa_state < -1);
            }
            else
            {
                dfa_state = -1;
            }

            if(dfa_state >= 0)
            {
                if(accept[dfa_state] != -1)
                {
                    accept_state = dfa_state;
                    accept_token = accept[dfa_state];
                    accept_length = this.text.length();
                    accept_pos = this.pos;
                    accept_line = this.line;
                }
            }
            else
            {
                if(accept_state != -1)
                {
                    switch(accept_token)
                    {
                    case 0:
                        {
                              Token token = new0(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 1:
                        {
                              Token token = new1(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 2:
                        {
                              Token token = new2(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 3:
                        {
                              Token token = new3(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 4:
                        {
                              Token token = new4(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 5:
                        {
                              Token token = new5(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 6:
                        {
                              Token token = new6(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 7:
                        {
                              Token token = new7(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 8:
                        {
                              Token token = new8(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 9:
                        {
                              Token token = new9(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 10:
                        {
                              Token token = new10(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 11:
                        {
                              Token token = new11(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 12:
                        {
                              Token token = new12(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 13:
                        {
                              Token token = new13(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 14:
                        {
                              Token token = new14(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 15:
                        {
                              Token token = new15(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 16:
                        {
                              Token token = new16(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 17:
                        {
                              Token token = new17(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 18:
                        {
                              Token token = new18(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 19:
                        {
                              Token token = new19(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 20:
                        {
                              Token token = new20(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 21:
                        {
                              Token token = new21(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 22:
                        {
                              Token token = new22(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 23:
                        {
                              Token token = new23(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 24:
                        {
                              Token token = new24(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 25:
                        {
                              Token token = new25(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 26:
                        {
                              Token token = new26(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 27:
                        {
                              Token token = new27(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 28:
                        {
                              Token token = new28(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 29:
                        {
                              Token token = new29(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 30:
                        {
                              Token token = new30(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 31:
                        {
                              Token token = new31(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 32:
                        {
                              Token token = new32(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 33:
                        {
                              Token token = new33(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 34:
                        {
                              Token token = new34(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 35:
                        {
                              Token token = new35(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 36:
                        {
                              Token token = new36(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 37:
                        {
                              Token token = new37(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 38:
                        {
                              Token token = new38(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 39:
                        {
                              Token token = new39(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 40:
                        {
                              Token token = new40(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 41:
                        {
                              Token token = new41(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 42:
                        {
                              Token token = new42(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 43:
                        {
                              Token token = new43(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 44:
                        {
                              Token token = new44(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 45:
                        {
                              Token token = new45(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 46:
                        {
                              Token token = new46(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 47:
                        {
                              Token token = new47(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 48:
                        {
                              Token token = new48(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 49:
                        {
                              Token token = new49(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 50:
                        {
                              Token token = new50(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 51:
                        {
                              Token token = new51(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 52:
                        {
                              Token token = new52(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 53:
                        {
                              Token token = new53(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 54:
                        {
                              Token token = new54(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 55:
                        {
                              Token token = new55(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 56:
                        {
                              Token token = new56(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 57:
                        {
                              Token token = new57(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 58:
                        {
                              Token token = new58(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 59:
                        {
                              Token token = new59(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 60:
                        {
                              Token token = new60(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 61:
                        {
                              Token token = new61(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 62:
                        {
                              Token token = new62(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 63:
                        {
                              Token token = new63(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 64:
                        {
                              Token token = new64(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 65:
                        {
                              Token token = new65(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 66:
                        {
                              Token token = new66(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 67:
                        {
                              Token token = new67(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 68:
                        {
                              Token token = new68(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 69:
                        {
                              Token token = new69(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 70:
                        {
                              Token token = new70(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 71:
                        {
                              Token token = new71(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 72:
                        {
                              Token token = new72(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 73:
                        {
                              Token token = new73(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 74:
                        {
                              Token token = new74(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 75:
                        {
                              Token token = new75(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 76:
                        {
                              Token token = new76(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 77:
                        {
                              Token token = new77(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 78:
                        {
                              Token token = new78(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 79:
                        {
                              Token token = new79(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 80:
                        {
                              Token token = new80(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 81:
                        {
                              Token token = new81(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 82:
                        {
                              Token token = new82(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 83:
                        {
                              Token token = new83(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 84:
                        {
                              Token token = new84(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 85:
                        {
                              Token token = new85(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 86:
                        {
                              Token token = new86(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 87:
                        {
                              Token token = new87(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 88:
                        {
                              Token token = new88(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 89:
                        {
                              Token token = new89(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 90:
                        {
                              Token token = new90(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 91:
                        {
                              Token token = new91(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 92:
                        {
                              Token token = new92(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 93:
                        {
                              Token token = new93(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 94:
                        {
                              Token token = new94(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 95:
                        {
                              Token token = new95(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 96:
                        {
                              Token token = new96(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    }
                }
                else
                {
                    if(this.text.length() > 0)
                    {
                        throw new LexerException(
                            "[" + (start_line + 1) + "," + (start_pos + 1) + "]" +
                            " Unknown token: " + this.text);
                    }

                      EOF token = new EOF(
                        start_line + 1,
                        start_pos + 1);
                    return token;
                }
            }
        }
    }

    Token new0(  String text,   int line,   int pos) { return new TWhiteSpace(text, line, pos); }
    Token new1(  String text,   int line,   int pos) { return new TTraditionalComment(text, line, pos); }
    Token new2(  String text,   int line,   int pos) { return new TEndOfLineComment(text, line, pos); }
    Token new3(  String text,   int line,   int pos) { return new TNumber(text, line, pos); }
    Token new4(  int line,   int pos) { return new TBang(line, pos); }
    Token new5(  int line,   int pos) { return new TComplement(line, pos); }
    Token new6(  String text,   int line,   int pos) { return new TMultop(text, line, pos); }
    Token new7(  int line,   int pos) { return new TPlus(line, pos); }
    Token new8(  int line,   int pos) { return new TMinus(line, pos); }
    Token new9(  String text,   int line,   int pos) { return new TShiftop(text, line, pos); }
    Token new10(  String text,   int line,   int pos) { return new TEqop(text, line, pos); }
    Token new11(  int line,   int pos) { return new TBitand(line, pos); }
    Token new12(  int line,   int pos) { return new TBitor(line, pos); }
    Token new13(  int line,   int pos) { return new TBitxor(line, pos); }
    Token new14(  int line,   int pos) { return new TAnd(line, pos); }
    Token new15(  int line,   int pos) { return new TOr(line, pos); }
    Token new16(  int line,   int pos) { return new TLt(line, pos); }
    Token new17(  int line,   int pos) { return new TGt(line, pos); }
    Token new18(  String text,   int line,   int pos) { return new TRelop(text, line, pos); }
    Token new19(  int line,   int pos) { return new TLParenthese(line, pos); }
    Token new20(  int line,   int pos) { return new TRParenthese(line, pos); }
    Token new21(  int line,   int pos) { return new TLBrace(line, pos); }
    Token new22(  int line,   int pos) { return new TRBrace(line, pos); }
    Token new23(  int line,   int pos) { return new TLBracket(line, pos); }
    Token new24(  int line,   int pos) { return new TRBracket(line, pos); }
    Token new25(  int line,   int pos) { return new TSemicolon(line, pos); }
    Token new26(  int line,   int pos) { return new TNumberSign(line, pos); }
    Token new27(  int line,   int pos) { return new TComma(line, pos); }
    Token new28(  int line,   int pos) { return new TDot(line, pos); }
    Token new29(  int line,   int pos) { return new TAssign(line, pos); }
    Token new30(  int line,   int pos) { return new TColonColon(line, pos); }
    Token new31(  int line,   int pos) { return new TColon(line, pos); }
    Token new32(  int line,   int pos) { return new TPlusPlus(line, pos); }
    Token new33(  int line,   int pos) { return new TMinusMinus(line, pos); }
    Token new34(  int line,   int pos) { return new TRightarrow(line, pos); }
    Token new35(  int line,   int pos) { return new TBangBang(line, pos); }
    Token new36(  int line,   int pos) { return new TQueryQuery(line, pos); }
    Token new37(  int line,   int pos) { return new TQuery(line, pos); }
    Token new38(  int line,   int pos) { return new TUnderscore(line, pos); }
    Token new39(  int line,   int pos) { return new TQuotes(line, pos); }
    Token new40(  int line,   int pos) { return new TAt(line, pos); }
    Token new41(  int line,   int pos) { return new TApostrophe(line, pos); }
    Token new42(  int line,   int pos) { return new TBackslash(line, pos); }
    Token new43(  int line,   int pos) { return new TActivetok(line, pos); }
    Token new44(  int line,   int pos) { return new TAssert(line, pos); }
    Token new45(  int line,   int pos) { return new TAtomic(line, pos); }
    Token new46(  int line,   int pos) { return new TBit(line, pos); }
    Token new47(  int line,   int pos) { return new TBool(line, pos); }
    Token new48(  int line,   int pos) { return new TBreak(line, pos); }
    Token new49(  int line,   int pos) { return new TByte(line, pos); }
    Token new50(  String text,   int line,   int pos) { return new TChanop(text, line, pos); }
    Token new51(  int line,   int pos) { return new TChan(line, pos); }
    Token new52(  int line,   int pos) { return new TDStep(line, pos); }
    Token new53(  int line,   int pos) { return new TDo(line, pos); }
    Token new54(  int line,   int pos) { return new TElse(line, pos); }
    Token new55(  int line,   int pos) { return new TEnabled(line, pos); }
    Token new56(  int line,   int pos) { return new TEval(line, pos); }
    Token new57(  int line,   int pos) { return new TFalse(line, pos); }
    Token new58(  int line,   int pos) { return new TFi(line, pos); }
    Token new59(  int line,   int pos) { return new TGoto(line, pos); }
    Token new60(  int line,   int pos) { return new THidden(line, pos); }
    Token new61(  int line,   int pos) { return new TIf(line, pos); }
    Token new62(  int line,   int pos) { return new TInittok(line, pos); }
    Token new63(  int line,   int pos) { return new TInt(line, pos); }
    Token new64(  int line,   int pos) { return new TLen(line, pos); }
    Token new65(  int line,   int pos) { return new TLine(line, pos); }
    Token new66(  int line,   int pos) { return new TMtypetok(line, pos); }
    Token new67(  int line,   int pos) { return new TNevertok(line, pos); }
    Token new68(  int line,   int pos) { return new TNotrace(line, pos); }
    Token new69(  int line,   int pos) { return new TNp(line, pos); }
    Token new70(  int line,   int pos) { return new TOd(line, pos); }
    Token new71(  int line,   int pos) { return new TOf(line, pos); }
    Token new72(  int line,   int pos) { return new TPcValue(line, pos); }
    Token new73(  int line,   int pos) { return new TPid(line, pos); }
    Token new74(  int line,   int pos) { return new TPrintf(line, pos); }
    Token new75(  int line,   int pos) { return new TPrintm(line, pos); }
    Token new76(  int line,   int pos) { return new TPrioritytok(line, pos); }
    Token new77(  int line,   int pos) { return new TProcessid(line, pos); }
    Token new78(  int line,   int pos) { return new TNrPr(line, pos); }
    Token new79(  int line,   int pos) { return new TInlinetok(line, pos); }
    Token new80(  int line,   int pos) { return new TProctypetok(line, pos); }
    Token new81(  int line,   int pos) { return new TProvided(line, pos); }
    Token new82(  int line,   int pos) { return new TRun(line, pos); }
    Token new83(  int line,   int pos) { return new TShort(line, pos); }
    Token new84(  int line,   int pos) { return new TShow(line, pos); }
    Token new85(  int line,   int pos) { return new TSkip(line, pos); }
    Token new86(  int line,   int pos) { return new TTimeout(line, pos); }
    Token new87(  int line,   int pos) { return new TTracetok(line, pos); }
    Token new88(  int line,   int pos) { return new TTrue(line, pos); }
    Token new89(  int line,   int pos) { return new TTypedef(line, pos); }
    Token new90(  int line,   int pos) { return new TUnless(line, pos); }
    Token new91(  int line,   int pos) { return new TUnsigned(line, pos); }
    Token new92(  int line,   int pos) { return new TXr(line, pos); }
    Token new93(  int line,   int pos) { return new TXs(line, pos); }
    Token new94(  String text,   int line,   int pos) { return new TName(text, line, pos); }
    Token new95(  String text,   int line,   int pos) { return new TByteliteral(text, line, pos); }
    Token new96(  String text,   int line,   int pos) { return new TString(text, line, pos); }

    private int getChar() throws IOException
    {
        if(this.eof)
        {
            return -1;
        }

        int result = this.in.read();

        if(result == -1)
        {
            this.eof = true;
        }

        return result;
    }

    private void pushBack(int acceptLength) throws IOException
    {
        int length = this.text.length();
        for(int i = length - 1; i >= acceptLength; i--)
        {
            this.eof = false;

            this.in.unread(this.text.charAt(i));
        }
    }

    protected void unread(  Token token) throws IOException
    {
          String text = token.getText();
        int length = text.length();

        for(int i = length - 1; i >= 0; i--)
        {
            this.eof = false;

            this.in.unread(text.charAt(i));
        }

        this.pos = token.getPos() - 1;
        this.line = token.getLine() - 1;
    }

    private String getText(int acceptLength)
    {
        StringBuffer s = new StringBuffer(acceptLength);
        for(int i = 0; i < acceptLength; i++)
        {
            s.append(this.text.charAt(i));
        }

        return s.toString();
    }

    private static int[][][][] gotoTable;
/*  {
        { // INITIAL
            {{0, 8, 1}, {9, 9, 2}, {10, 10, 3}, {11, 11, 1}, {12, 12, 4}, {13, 13, 5}, {14, 31, 1}, {32, 32, 6}, {33, 33, 7}, {34, 34, 8}, {35, 35, 9}, {36, 36, 1}, {37, 37, 10}, {38, 38, 11}, {39, 39, 12}, {40, 40, 13}, {41, 41, 14}, {42, 42, 15}, {43, 43, 16}, {44, 44, 17}, {45, 45, 18}, {46, 46, 19}, {47, 47, 20}, {48, 57, 21}, {58, 58, 22}, {59, 59, 23}, {60, 60, 24}, {61, 61, 25}, {62, 62, 26}, {63, 63, 27}, {64, 64, 28}, {65, 90, 29}, {91, 91, 30}, {92, 92, 31}, {93, 93, 32}, {94, 94, 33}, {95, 95, 34}, {96, 96, 1}, {97, 97, 35}, {98, 98, 36}, {99, 99, 37}, {100, 100, 38}, {101, 101, 39}, {102, 102, 40}, {103, 103, 41}, {104, 104, 42}, {105, 105, 43}, {106, 107, 29}, {108, 108, 44}, {109, 109, 45}, {110, 110, 46}, {111, 111, 47}, {112, 112, 48}, {113, 113, 29}, {114, 114, 49}, {115, 115, 50}, {116, 116, 51}, {117, 117, 52}, {118, 119, 29}, {120, 120, 53}, {121, 122, 29}, {123, 123, 54}, {124, 124, 55}, {125, 125, 56}, {126, 126, 57}, {127, 255, 1}, },
            {},
            {{9, 9, 58}, {10, 10, 59}, {12, 12, 60}, {13, 13, 61}, {32, 32, 62}, },
            {{9, 32, -4}, },
            {{9, 32, -4}, },
            {{9, 9, 58}, {10, 10, 63}, {12, 32, -4}, },
            {{9, 32, -4}, },
            {{33, 33, 64}, {61, 61, 65}, },
            {{0, 33, 66}, {34, 34, 67}, {35, 65535, 66}, },
            {},
            {},
            {{38, 38, 68}, },
            {},
            {},
            {},
            {},
            {{43, 43, 69}, },
            {},
            {{45, 45, 70}, {62, 62, 71}, },
            {},
            {{42, 42, 72}, {47, 47, 73}, },
            {{48, 57, 74}, },
            {{58, 58, 75}, },
            {},
            {{60, 60, 76}, {61, 61, 77}, },
            {{61, 61, 78}, },
            {{61, 61, 79}, {62, 62, 80}, },
            {{63, 63, 81}, },
            {},
            {{48, 57, 82}, {65, 90, 83}, {95, 95, 84}, {97, 122, 83}, },
            {},
            {},
            {},
            {},
            {{110, 110, 85}, {112, 112, 86}, },
            {{48, 95, -31}, {97, 98, 83}, {99, 99, 87}, {100, 114, 83}, {115, 115, 88}, {116, 116, 89}, {117, 122, 83}, },
            {{48, 95, -31}, {97, 104, 83}, {105, 105, 90}, {106, 110, 83}, {111, 111, 91}, {112, 113, 83}, {114, 114, 92}, {115, 120, 83}, {121, 121, 93}, {122, 122, 83}, },
            {{48, 95, -31}, {97, 103, 83}, {104, 104, 94}, {105, 122, 83}, },
            {{48, 90, -31}, {95, 95, 95}, {97, 110, 83}, {111, 111, 96}, {112, 122, 83}, },
            {{48, 95, -31}, {97, 107, 83}, {108, 108, 97}, {109, 109, 98}, {110, 110, 99}, {111, 117, 83}, {118, 118, 100}, {119, 122, 83}, },
            {{48, 95, -31}, {97, 97, 101}, {98, 104, 83}, {105, 105, 102}, {106, 116, 83}, {117, 117, 103}, {118, 122, 83}, },
            {{48, 95, -31}, {97, 110, 83}, {111, 111, 104}, {112, 122, 83}, },
            {{48, 104, -38}, {105, 105, 105}, {106, 122, 83}, },
            {{48, 95, -31}, {97, 101, 83}, {102, 102, 106}, {103, 109, 83}, {110, 110, 107}, {111, 122, 83}, },
            {{48, 95, -31}, {97, 100, 83}, {101, 101, 108}, {102, 104, 83}, {105, 105, 109}, {106, 122, 83}, },
            {{48, 95, -31}, {97, 115, 83}, {116, 116, 110}, {117, 122, 83}, },
            {{48, 100, -46}, {101, 101, 111}, {102, 102, 112}, {103, 110, 83}, {111, 111, 113}, {112, 112, 114}, {113, 122, 83}, },
            {{48, 95, -31}, {97, 99, 83}, {100, 100, 115}, {101, 101, 83}, {102, 102, 116}, {103, 122, 83}, },
            {{48, 98, -37}, {99, 99, 117}, {100, 104, 83}, {105, 105, 118}, {106, 113, 83}, {114, 114, 119}, {115, 122, 83}, },
            {{48, 95, -31}, {97, 116, 83}, {117, 117, 120}, {118, 122, 83}, },
            {{48, 103, -39}, {104, 104, 121}, {105, 106, 83}, {107, 107, 122}, {108, 122, 83}, },
            {{48, 104, -38}, {105, 105, 123}, {106, 113, 83}, {114, 114, 124}, {115, 120, 83}, {121, 121, 125}, {122, 122, 83}, },
            {{48, 95, -31}, {97, 109, 83}, {110, 110, 126}, {111, 122, 83}, },
            {{48, 95, -31}, {97, 113, 83}, {114, 114, 127}, {115, 115, 128}, {116, 122, 83}, },
            {},
            {{124, 124, 129}, },
            {},
            {},
            {{9, 32, -4}, },
            {{9, 32, -4}, },
            {{9, 32, -4}, },
            {{9, 32, -7}, },
            {{9, 32, -4}, },
            {{9, 32, -4}, },
            {},
            {},
            {{0, 65535, -10}, },
            {},
            {},
            {},
            {},
            {},
            {{0, 9, 130}, {10, 10, 131}, {11, 12, 130}, {13, 13, 132}, {14, 41, 130}, {42, 42, 133}, {43, 65535, 130}, },
            {{0, 9, 134}, {10, 10, 135}, {11, 12, 134}, {13, 13, 136}, {14, 65535, 134}, },
            {{48, 57, 74}, },
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {{48, 122, -31}, },
            {{48, 122, -31}, },
            {{48, 122, -31}, },
            {{114, 114, 137}, },
            {{105, 105, 138}, },
            {{48, 115, -47}, {116, 116, 139}, {117, 122, 83}, },
            {{48, 95, -31}, {97, 114, 83}, {115, 115, 140}, {116, 122, 83}, },
            {{48, 110, -43}, {111, 111, 141}, {112, 122, 83}, },
            {{48, 115, -47}, {116, 116, 142}, {117, 122, 83}, },
            {{48, 110, -43}, {111, 111, 143}, {112, 122, 83}, },
            {{48, 100, -46}, {101, 101, 144}, {102, 122, 83}, },
            {{48, 115, -47}, {116, 116, 145}, {117, 122, 83}, },
            {{48, 95, -31}, {97, 97, 146}, {98, 122, 83}, },
            {{48, 114, -90}, {115, 115, 147}, {116, 122, 83}, },
            {{48, 122, -31}, },
            {{48, 114, -90}, {115, 115, 148}, {116, 122, 83}, },
            {{48, 95, -31}, {97, 111, 83}, {112, 112, 149}, {113, 122, 83}, },
            {{48, 95, -31}, {97, 97, 150}, {98, 122, 83}, },
            {{48, 95, -31}, {97, 97, 151}, {98, 122, 83}, },
            {{48, 107, -41}, {108, 108, 152}, {109, 122, 83}, },
            {{48, 122, -31}, },
            {{48, 107, -41}, {108, 108, 153}, {109, 122, 83}, },
            {{48, 115, -47}, {116, 116, 154}, {117, 122, 83}, },
            {{48, 99, -49}, {100, 100, 155}, {101, 122, 83}, },
            {{48, 122, -31}, },
            {{48, 104, -38}, {105, 105, 156}, {106, 107, 83}, {108, 108, 157}, {109, 115, 83}, {116, 116, 158}, {117, 122, 83}, },
            {{48, 109, -54}, {110, 110, 159}, {111, 122, 83}, },
            {{48, 109, -54}, {110, 110, 160}, {111, 122, 83}, },
            {{48, 95, -31}, {97, 120, 83}, {121, 121, 161}, {122, 122, 83}, },
            {{48, 95, -31}, {97, 108, 83}, {109, 109, 162}, {110, 117, 83}, {118, 118, 163}, {119, 122, 83}, },
            {{48, 116, -51}, {117, 117, 164}, {118, 122, 83}, },
            {{48, 115, -47}, {116, 116, 165}, {117, 122, 83}, },
            {{48, 90, -31}, {95, 95, 166}, {97, 122, 83}, },
            {{48, 122, -31}, },
            {{48, 122, -31}, },
            {{48, 90, -31}, {95, 95, 167}, {97, 122, 83}, },
            {{48, 99, -49}, {100, 100, 168}, {101, 122, 83}, },
            {{48, 104, -38}, {105, 105, 169}, {106, 110, 83}, {111, 111, 170}, {112, 122, 83}, },
            {{48, 109, -54}, {110, 110, 171}, {111, 122, 83}, },
            {{48, 110, -43}, {111, 111, 172}, {112, 122, 83}, },
            {{48, 104, -38}, {105, 105, 173}, {106, 122, 83}, },
            {{48, 108, -113}, {109, 109, 174}, {110, 122, 83}, },
            {{48, 95, -31}, {97, 97, 175}, {98, 116, 83}, {117, 117, 176}, {118, 122, 83}, },
            {{48, 111, -100}, {112, 112, 177}, {113, 122, 83}, },
            {{48, 107, -41}, {108, 108, 178}, {109, 114, 83}, {115, 115, 179}, {116, 122, 83}, },
            {{48, 122, -31}, },
            {{48, 122, -31}, },
            {},
            {{0, 65535, -74}, },
            {{0, 65535, -74}, },
            {{0, 9, 130}, {10, 10, 180}, {11, 65535, -74}, },
            {{0, 9, 181}, {10, 10, 182}, {11, 12, 181}, {13, 13, 183}, {14, 41, 181}, {42, 42, 133}, {43, 46, 181}, {47, 47, 184}, {48, 65535, 181}, },
            {{0, 65535, -75}, },
            {},
            {{10, 10, 185}, },
            {{95, 95, 186}, },
            {{100, 100, 187}, },
            {{48, 104, -38}, {105, 105, 188}, {106, 122, 83}, },
            {{48, 100, -46}, {101, 101, 189}, {102, 122, 83}, },
            {{48, 108, -113}, {109, 109, 190}, {110, 122, 83}, },
            {{48, 122, -31}, },
            {{48, 107, -41}, {108, 108, 191}, {109, 122, 83}, },
            {{48, 95, -31}, {97, 97, 192}, {98, 122, 83}, },
            {{48, 100, -46}, {101, 101, 193}, {102, 122, 83}, },
            {{48, 109, -54}, {110, 110, 194}, {111, 122, 83}, },
            {{48, 115, -47}, {116, 116, 195}, {117, 122, 83}, },
            {{48, 100, -46}, {101, 101, 196}, {102, 122, 83}, },
            {{48, 115, -47}, {116, 116, 197}, {117, 122, 83}, },
            {{48, 95, -31}, {97, 97, 83}, {98, 98, 198}, {99, 122, 83}, },
            {{48, 107, -41}, {108, 108, 199}, {109, 122, 83}, },
            {{48, 114, -90}, {115, 115, 200}, {116, 122, 83}, },
            {{48, 107, -41}, {108, 108, 201}, {109, 122, 83}, },
            {{48, 110, -43}, {111, 111, 202}, {112, 122, 83}, },
            {{48, 99, -49}, {100, 100, 203}, {101, 122, 83}, },
            {{48, 115, -47}, {116, 116, 204}, {117, 122, 83}, },
            {{48, 104, -38}, {105, 105, 205}, {106, 122, 83}, },
            {{48, 122, -31}, },
            {{48, 122, -31}, },
            {{48, 100, -46}, {101, 101, 206}, {102, 122, 83}, },
            {{48, 111, -100}, {112, 112, 207}, {113, 122, 83}, },
            {{48, 111, -100}, {112, 112, 208}, {113, 122, 83}, },
            {{48, 100, -46}, {101, 101, 209}, {102, 122, 83}, },
            {{48, 107, -41}, {108, 108, 210}, {109, 122, 83}, },
            {{48, 113, -55}, {114, 114, 211}, {115, 122, 83}, },
            {{48, 122, -31}, },
            {{48, 95, -31}, {97, 117, 83}, {118, 118, 212}, {119, 122, 83}, },
            {{48, 122, -31}, },
            {{48, 109, -54}, {110, 110, 213}, {111, 111, 214}, {112, 122, 83}, },
            {{48, 98, -37}, {99, 99, 215}, {100, 117, 83}, {118, 118, 216}, {119, 122, 83}, },
            {{48, 122, -31}, },
            {{48, 113, -55}, {114, 114, 217}, {115, 118, 83}, {119, 119, 218}, {120, 122, 83}, },
            {{48, 111, -100}, {112, 112, 219}, {113, 122, 83}, },
            {{48, 100, -46}, {101, 101, 220}, {102, 122, 83}, },
            {{48, 98, -37}, {99, 99, 221}, {100, 122, 83}, },
            {{48, 100, -46}, {101, 101, 222}, {102, 122, 83}, },
            {{48, 100, -46}, {101, 101, 223}, {102, 122, 83}, },
            {{48, 100, -46}, {101, 101, 224}, {102, 122, 83}, },
            {{48, 104, -38}, {105, 105, 225}, {106, 122, 83}, },
            {{0, 65535, -74}, },
            {{0, 9, 226}, {10, 10, 227}, {11, 12, 226}, {13, 13, 228}, {14, 41, 226}, {42, 42, 229}, {43, 65535, 226}, },
            {{0, 65535, -183}, },
            {{0, 9, 226}, {10, 10, 230}, {11, 65535, -183}, },
            {},
            {},
            {{112, 112, 231}, },
            {},
            {{48, 117, -169}, {118, 118, 232}, {119, 122, 83}, },
            {{48, 113, -55}, {114, 114, 233}, {115, 122, 83}, },
            {{48, 104, -38}, {105, 105, 234}, {106, 122, 83}, },
            {{48, 122, -31}, },
            {{48, 95, -31}, {97, 106, 83}, {107, 107, 235}, {108, 122, 83}, },
            {{48, 122, -31}, },
            {{48, 122, -31}, },
            {{48, 100, -46}, {101, 101, 236}, {102, 122, 83}, },
            {{48, 122, -31}, },
            {{48, 120, -112}, {121, 121, 237}, {122, 122, 83}, },
            {{48, 107, -41}, {108, 108, 238}, {109, 122, 83}, },
            {{48, 122, -31}, },
            {{48, 100, -46}, {101, 101, 239}, {102, 122, 83}, },
            {{48, 122, -31}, },
            {{48, 122, -31}, },
            {{48, 100, -46}, {101, 101, 240}, {102, 122, 83}, },
            {{48, 122, -31}, },
            {{48, 109, -54}, {110, 110, 241}, {111, 122, 83}, },
            {{48, 122, -31}, },
            {{48, 100, -46}, {101, 101, 242}, {102, 122, 83}, },
            {{48, 115, -47}, {116, 116, 243}, {117, 122, 83}, },
            {{48, 113, -55}, {114, 114, 244}, {115, 122, 83}, },
            {{48, 107, -41}, {108, 108, 245}, {109, 122, 83}, },
            {{48, 95, -31}, {97, 97, 246}, {98, 122, 83}, },
            {{48, 95, -31}, {97, 97, 247}, {98, 122, 83}, },
            {{48, 115, -47}, {116, 116, 248}, {117, 122, 83}, },
            {{48, 113, -55}, {114, 114, 249}, {115, 122, 83}, },
            {{48, 115, -47}, {116, 116, 250}, {117, 122, 83}, },
            {{48, 104, -38}, {105, 105, 251}, {106, 122, 83}, },
            {{48, 115, -47}, {116, 116, 252}, {117, 122, 83}, },
            {{48, 122, -31}, },
            {{48, 122, -31}, },
            {{48, 110, -43}, {111, 111, 253}, {112, 122, 83}, },
            {{48, 100, -46}, {101, 101, 254}, {102, 122, 83}, },
            {{48, 122, -31}, },
            {{48, 99, -49}, {100, 100, 255}, {101, 122, 83}, },
            {{48, 114, -90}, {115, 115, 256}, {116, 122, 83}, },
            {{48, 95, -31}, {97, 102, 83}, {103, 103, 257}, {104, 122, 83}, },
            {{0, 65535, -183}, },
            {{0, 65535, -183}, },
            {{0, 9, 226}, {10, 10, 258}, {11, 65535, -183}, },
            {{0, 41, -135}, {42, 42, 229}, {43, 65535, -135}, },
            {{0, 65535, -183}, },
            {{114, 114, 259}, },
            {{48, 100, -46}, {101, 101, 260}, {102, 122, 83}, },
            {{48, 115, -47}, {116, 116, 261}, {117, 122, 83}, },
            {{48, 98, -37}, {99, 99, 262}, {100, 122, 83}, },
            {{48, 122, -31}, },
            {{48, 111, -100}, {112, 112, 263}, {113, 122, 83}, },
            {{48, 122, -31}, },
            {{48, 100, -46}, {101, 101, 264}, {102, 122, 83}, },
            {{48, 122, -31}, },
            {{48, 109, -54}, {110, 110, 265}, {111, 122, 83}, },
            {{48, 100, -46}, {101, 101, 266}, {102, 122, 83}, },
            {{48, 122, -31}, },
            {{48, 120, -112}, {121, 121, 267}, {122, 122, 83}, },
            {{48, 122, -31}, },
            {{48, 122, -31}, },
            {{48, 98, -37}, {99, 99, 268}, {100, 122, 83}, },
            {{48, 107, -41}, {108, 108, 269}, {109, 122, 83}, },
            {{48, 101, -45}, {102, 102, 270}, {103, 108, 83}, {109, 109, 271}, {110, 122, 83}, },
            {{48, 104, -38}, {105, 105, 272}, {106, 122, 83}, },
            {{48, 120, -112}, {121, 121, 273}, {122, 122, 83}, },
            {{48, 99, -49}, {100, 100, 274}, {101, 122, 83}, },
            {{48, 122, -31}, },
            {{48, 116, -51}, {117, 117, 275}, {118, 122, 83}, },
            {{48, 122, -31}, },
            {{48, 100, -46}, {101, 101, 276}, {102, 122, 83}, },
            {{48, 114, -90}, {115, 115, 277}, {116, 122, 83}, },
            {{48, 109, -54}, {110, 110, 278}, {111, 122, 83}, },
            {{0, 65535, -183}, },
            {},
            {{48, 122, -31}, },
            {{48, 122, -31}, },
            {{48, 122, -31}, },
            {{48, 122, -31}, },
            {{48, 99, -49}, {100, 100, 279}, {101, 122, 83}, },
            {{48, 122, -31}, },
            {{48, 122, -31}, },
            {{48, 122, -31}, },
            {{48, 100, -46}, {101, 101, 280}, {102, 122, 83}, },
            {{48, 116, -51}, {117, 117, 281}, {118, 122, 83}, },
            {{48, 122, -31}, },
            {{48, 122, -31}, },
            {{48, 115, -47}, {116, 116, 282}, {117, 122, 83}, },
            {{48, 111, -100}, {112, 112, 283}, {113, 122, 83}, },
            {{48, 100, -46}, {101, 101, 284}, {102, 122, 83}, },
            {{48, 115, -47}, {116, 116, 285}, {117, 122, 83}, },
            {{48, 101, -45}, {102, 102, 286}, {103, 122, 83}, },
            {{48, 122, -31}, },
            {{48, 100, -46}, {101, 101, 287}, {102, 122, 83}, },
            {{48, 122, -31}, },
            {{48, 122, -31}, },
            {{48, 100, -46}, {101, 101, 288}, {102, 122, 83}, },
            {{48, 120, -112}, {121, 121, 289}, {122, 122, 83}, },
            {{48, 100, -46}, {101, 101, 290}, {102, 122, 83}, },
            {{48, 99, -49}, {100, 100, 291}, {101, 122, 83}, },
            {{48, 122, -31}, },
            {{48, 122, -31}, },
            {{48, 99, -49}, {100, 100, 292}, {101, 122, 83}, },
            {{48, 122, -31}, },
            {{48, 122, -31}, },
            {{48, 122, -31}, },
            {{48, 122, -31}, },
            {{48, 122, -31}, },
        }
    };*/

    private static int[][] accept;
/*  {
        // INITIAL
        {0, 95, 0, 0, 0, 0, 0, 4, 39, 26, 6, 11, 41, 19, 20, 6, 7, 27, 8, 28, 6, 3, 31, 25, 16, 29, 17, 37, 40, 94, 23, 42, 24, 13, 38, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 21, 12, 22, 5, 0, 0, 0, 0, 0, 0, 35, 10, -1, 96, 14, 32, 33, 34, -1, 2, 3, 30, 9, 18, 10, 18, 9, 36, 94, 94, 94, -1, -1, 94, 94, 94, 94, 94, 94, 94, 94, 94, 53, 94, 94, 94, 94, 94, 58, 94, 94, 94, 61, 94, 94, 94, 94, 94, 94, 94, 94, 70, 71, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 92, 93, 15, -1, -1, -1, -1, 2, 2, 2, -1, -1, 94, 94, 94, 46, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 63, 64, 94, 94, 94, 94, 94, 94, 69, 94, 73, 94, 94, 82, 94, 94, 94, 94, 94, 94, 94, 94, -1, -1, -1, -1, 1, 2, -1, 77, 94, 94, 94, 47, 94, 49, 51, 94, 54, 94, 94, 56, 94, 50, 59, 94, 62, 94, 65, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 84, 85, 94, 94, 88, 94, 94, 94, -1, -1, -1, -1, -1, -1, 94, 94, 94, 48, 94, 50, 94, 57, 94, 94, 66, 94, 67, 50, 94, 94, 94, 94, 94, 94, 83, 94, 87, 94, 94, 94, -1, 78, 43, 44, 45, 52, 94, 60, 79, 50, 94, 94, 74, 75, 94, 94, 94, 94, 94, 90, 94, 55, 68, 94, 94, 94, 94, 86, 89, 94, 72, 76, 80, 81, 91, },

    };*/

    public static class State
    {
        public final static State INITIAL = new State(0);

        private int id;

        private State(  int id)
        {
            this.id = id;
        }

        public int id()
        {
            return this.id;
        }
    }

    static 
    {
        try
        {
            DataInputStream s = new DataInputStream(
                new BufferedInputStream(
                Lexer.class.getResourceAsStream("lexer.dat")));

            // read gotoTable
            int length = s.readInt();
            gotoTable = new int[length][][][];
            for(int i = 0; i < gotoTable.length; i++)
            {
                length = s.readInt();
                gotoTable[i] = new int[length][][];
                for(int j = 0; j < gotoTable[i].length; j++)
                {
                    length = s.readInt();
                    gotoTable[i][j] = new int[length][3];
                    for(int k = 0; k < gotoTable[i][j].length; k++)
                    {
                        for(int l = 0; l < 3; l++)
                        {
                            gotoTable[i][j][k][l] = s.readInt();
                        }
                    }
                }
            }

            // read accept
            length = s.readInt();
            accept = new int[length][];
            for(int i = 0; i < accept.length; i++)
            {
                length = s.readInt();
                accept[i] = new int[length];
                for(int j = 0; j < accept[i].length; j++)
                {
                    accept[i][j] = s.readInt();
                }
            }

            s.close();
        }
        catch(Exception e)
        {
            throw new RuntimeException("The file \"lexer.dat\" is either missing or corrupted.");
        }
    }
}
