/*
 * Decompiled with CFR 0.152.
 */
package com.github.krukow.clj_ds;

import com.github.krukow.clj_ds.PersistentList;
import com.github.krukow.clj_ds.PersistentMap;
import com.github.krukow.clj_ds.PersistentSet;
import com.github.krukow.clj_ds.PersistentSortedMap;
import com.github.krukow.clj_ds.PersistentSortedSet;
import com.github.krukow.clj_ds.PersistentVector;
import com.github.krukow.clj_ds.TransientSet;
import com.github.krukow.clj_ds.TransientVector;
import com.github.krukow.clj_lang.PersistentArrayMap;
import com.github.krukow.clj_lang.PersistentHashMap;
import com.github.krukow.clj_lang.PersistentHashSet;
import com.github.krukow.clj_lang.PersistentTreeMap;
import com.github.krukow.clj_lang.PersistentTreeSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Persistents {
    public static <E> PersistentVector<E> vector() {
        return com.github.krukow.clj_lang.PersistentVector.emptyVector();
    }

    public static <E> PersistentVector<E> vector(E val) {
        return Persistents.vector().plus(val);
    }

    public static <E> PersistentVector<E> vector(E ... vals) {
        return com.github.krukow.clj_lang.PersistentVector.create(vals);
    }

    public static <E> PersistentVector<E> vector(Iterable<? extends E> vals) {
        return com.github.krukow.clj_lang.PersistentVector.create(vals);
    }

    public static <E> PersistentSet<E> hashSet() {
        return PersistentHashSet.emptySet();
    }

    public static <E> PersistentSet<E> hashSet(E val) {
        return Persistents.hashSet().plus(val);
    }

    public static <E> PersistentSet<E> hashSet(E ... vals) {
        return PersistentHashSet.create(vals);
    }

    public static <E> PersistentSet<E> hashSet(Iterable<? extends E> vals) {
        return PersistentHashSet.create(vals);
    }

    public static <K, V> PersistentMap<K, V> hashMap() {
        return PersistentHashMap.emptyMap();
    }

    public static <K, V> PersistentMap<K, V> hashMap(K key, V val) {
        return Persistents.hashMap().plus(key, val);
    }

    public static <K, V> PersistentMap<K, V> hashMap(Object ... keyValues) {
        return PersistentHashMap.create(keyValues);
    }

    public static <K, V> PersistentMap<K, V> hashMap(Map<? extends K, ? extends V> init) {
        return PersistentHashMap.create(init);
    }

    public static <K, V> PersistentMap<K, V> arrayMap() {
        return PersistentArrayMap.EMPTY;
    }

    public static <K, V> PersistentMap<K, V> arrayMap(Map<? extends K, ? extends V> init) {
        return PersistentArrayMap.create(init);
    }

    public static <K, V> PersistentSortedMap<K, V> treeMap() {
        return PersistentTreeMap.EMPTY;
    }

    public static <K, V> PersistentSortedMap<K, V> treeMap(K key, V val) {
        return Persistents.treeMap().plus(key, val);
    }

    public static <K, V> PersistentSortedMap<K, V> treeMap(Map<? extends K, ? extends V> init) {
        return PersistentTreeMap.create(init);
    }

    public static <E> PersistentSortedSet<E> treeSet() {
        return PersistentTreeSet.EMPTY;
    }

    public static <E> PersistentList<E> linkedList() {
        return com.github.krukow.clj_lang.PersistentList.emptyList();
    }

    public static <E> PersistentList<E> linkedList(E val) {
        return Persistents.linkedList().plus(val);
    }

    public static <E> PersistentList<E> linkedList(E ... vals) {
        return com.github.krukow.clj_lang.PersistentList.create(vals);
    }

    public static <E> PersistentList<E> linkedList(Iterable<? extends E> vals) {
        return com.github.krukow.clj_lang.PersistentList.create(vals);
    }

    public static <E> PersistentList<E> plusAll(PersistentList<E> list, Iterable<? extends E> others) {
        return com.github.krukow.clj_lang.PersistentList.consAll(list, others);
    }

    public static <E> PersistentList<E> plusAll(PersistentList<E> list, E ... others) {
        PersistentList<E> result = list;
        for (E other : others) {
            result = result.plus(other);
        }
        return result;
    }

    public static <E> PersistentVector<E> plusAll(PersistentVector<E> vec, Iterable<? extends E> others) {
        TransientVector<E> result = vec.asTransient();
        for (E other : others) {
            result = result.plus(other);
        }
        return result.persist();
    }

    public static <E> PersistentVector<E> plusAll(PersistentVector<E> vec, E ... others) {
        TransientVector<E> result = vec.asTransient();
        for (E other : others) {
            result = result.plus(other);
        }
        return result.persist();
    }

    public static <E> PersistentSet<E> plusAll(PersistentSet<E> set, Iterable<? extends E> others) {
        TransientSet<E> result = (TransientSet<E>)set.asTransient();
        for (E other : others) {
            result = result.plus(other);
        }
        return result.persist();
    }

    public static <E> PersistentSet<E> plusAll(PersistentSet<E> set, E ... others) {
        TransientSet<E> result = (TransientSet<E>)set.asTransient();
        for (E other : others) {
            result = result.plus(other);
        }
        return result.persist();
    }

    public static <E> PersistentSet<E> minusAll(PersistentSet<E> set, Iterable<? extends E> others) {
        TransientSet<E> result = (TransientSet<E>)set.asTransient();
        for (E other : others) {
            result = result.minus(other);
        }
        return result.persist();
    }

    public static <E> PersistentSet<E> minusAll(PersistentSet<E> set, E ... others) {
        TransientSet<E> result = (TransientSet<E>)set.asTransient();
        for (E other : others) {
            result = result.minus(other);
        }
        return result.persist();
    }

    public static <E> PersistentSortedSet<E> plusAll(PersistentSortedSet<E> set, Iterable<? extends E> others) {
        PersistentSortedSet<E> result = set;
        for (E other : others) {
            result = result.plus(other);
        }
        return result;
    }

    public static <E> PersistentSortedSet<E> plusAll(PersistentSortedSet<E> set, E ... others) {
        PersistentSortedSet<E> result = set;
        for (E other : others) {
            result = result.plus(other);
        }
        return result;
    }

    public static <E> PersistentSortedSet<E> minusAll(PersistentSortedSet<E> set, Iterable<? extends E> others) {
        PersistentSortedSet<E> result = set;
        for (E other : others) {
            result = result.minus(other);
        }
        return result;
    }

    public static <E> PersistentSortedSet<E> minusAll(PersistentSortedSet<E> set, E ... others) {
        PersistentSortedSet<E> result = set;
        for (E other : others) {
            result = result.minus(other);
        }
        return result;
    }

    private Persistents() {
    }
}

