/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import util.ToolIO;

public class MailSender {
    private final String mailto = System.getProperty("result.mail.address");
    private String mainFile;
    private File err;
    private File out;
    private String from;
    private String domain;

    private static boolean send(String from, String to, String domain, String subject, File[] files) {
        Properties properties = System.getProperties();
        try {
            List<MXRecord> mailhosts = MailSender.getMXForDomain(domain);
            Iterator<MXRecord> i$ = mailhosts.iterator();
            if (i$.hasNext()) {
                MXRecord mxRecord = i$.next();
                properties.put("mail.smtp.host", mxRecord.hostname);
                Session session = Session.getDefaultInstance((Properties)properties);
                MimeMessage msg = new MimeMessage(session);
                msg.setFrom((Address)new InternetAddress(from));
                msg.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(to));
                msg.setSubject(subject);
                MimeBodyPart messageBodyPart = new MimeBodyPart();
                MimeMultipart multipart = new MimeMultipart();
                for (File file : files) {
                    if (file == null) continue;
                    messageBodyPart = new MimeBodyPart();
                    messageBodyPart.setDataHandler(new DataHandler((DataSource)new FileDataSource(file)));
                    messageBodyPart.setFileName(file.getName());
                    messageBodyPart.setHeader("Content-Type", "text/plain");
                    multipart.addBodyPart((BodyPart)messageBodyPart);
                }
                msg.setContent((Multipart)multipart);
                Transport.send((Message)msg);
                return true;
            }
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        catch (AddressException e) {
            e.printStackTrace();
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
        return false;
    }

    private static List<MXRecord> getMXForDomain(String aDomain) throws NamingException {
        InitialDirContext ctx = new InitialDirContext();
        Attributes attributes = ctx.getAttributes("dns:/" + aDomain, new String[]{"MX"});
        Attribute attr = attributes.get("MX");
        ArrayList<MXRecord> list = new ArrayList<MXRecord>();
        if (attr == null) {
            list.add(new MXRecord(0, aDomain));
        }
        for (int i = 0; i < attr.size(); ++i) {
            String[] split;
            Object object = attr.get(i);
            if (object == null || !(object instanceof String) || (split = ((String)object).split("\\s+")) == null || split.length != 2) continue;
            Integer weight = Integer.parseInt(split[0]);
            list.add(new MXRecord(weight, split[1]));
        }
        Collections.sort(list);
        return list;
    }

    public MailSender(String aMainFile) throws FileNotFoundException, UnknownHostException {
        if (this.mailto != null) {
            this.domain = this.mailto.split("@")[1];
            this.from = "TLC - The friendly model checker <" + System.getProperty("user.name") + "@" + InetAddress.getLocalHost().getHostName() + ">";
            this.mainFile = aMainFile;
            String tmpdir = System.getProperty("java.io.tmpdir");
            this.out = new File(tmpdir + File.separator + "MC.out");
            ToolIO.out = new LogPrintStream(this.out);
            this.err = new File(tmpdir + File.separator + "MC.err");
            ToolIO.err = new LogPrintStream(this.err);
        }
    }

    public boolean send() {
        return this.send(new ArrayList<File>());
    }

    public boolean send(List<File> files) {
        if (this.mailto != null) {
            files.add(this.out);
            if (this.err.length() != 0L) {
                files.add(this.err);
            }
            return MailSender.send(this.from, this.mailto, this.domain, "Model Checking result for " + this.mainFile, files.toArray(new File[files.size()]));
        }
        return true;
    }

    private static class LogPrintStream
    extends PrintStream {
        public LogPrintStream(File file) throws FileNotFoundException {
            super(new FileOutputStream(file));
        }

        @Override
        public void print(String str) {
            System.out.print(str);
            super.print(str);
        }

        @Override
        public void println(String str) {
            System.out.println(str);
            super.println(str);
        }
    }

    private static class MXRecord
    implements Comparable<MXRecord> {
        public Integer weight;
        public String hostname;

        public MXRecord(int aWeight, String aHostname) {
            this.weight = aWeight;
            this.hostname = aHostname;
        }

        @Override
        public int compareTo(MXRecord o) {
            return this.weight.compareTo(o.weight);
        }
    }
}

