/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value;

import tlc2.value.Enumerable;
import tlc2.value.MVPerm;
import tlc2.value.SetEnumValue;
import tlc2.value.Value;
import tlc2.value.ValueEnumeration;
import tlc2.value.ValueExcept;
import util.Assert;

public class SetCupValue
extends Value
implements Enumerable {
    public Value set1;
    public Value set2;
    protected SetEnumValue cupSet;

    public SetCupValue(Value set1, Value set2) {
        this.set1 = set1;
        this.set2 = set2;
        this.cupSet = null;
    }

    @Override
    public final byte getKind() {
        return 19;
    }

    @Override
    public final int compareTo(Object obj) {
        this.convertAndCache();
        return this.cupSet.compareTo(obj);
    }

    public final boolean equals(Object obj) {
        this.convertAndCache();
        return this.cupSet.equals(obj);
    }

    @Override
    public final boolean member(Value elem) {
        return this.set1.member(elem) || this.set2.member(elem);
    }

    @Override
    public final boolean isFinite() {
        return this.set1.isFinite() && this.set2.isFinite();
    }

    @Override
    public final Value takeExcept(ValueExcept ex) {
        if (ex.idx < ex.path.length) {
            Assert.fail("Attempted to apply EXCEPT to the set " + SetCupValue.ppr(this.toString()) + ".");
        }
        return ex.value;
    }

    @Override
    public final Value takeExcept(ValueExcept[] exs) {
        if (exs.length != 0) {
            Assert.fail("Attempted to apply EXCEPT to the set " + SetCupValue.ppr(this.toString()) + ".");
        }
        return this;
    }

    @Override
    public final int size() {
        this.convertAndCache();
        return this.cupSet.size();
    }

    @Override
    public final boolean isNormalized() {
        return this.cupSet != null && this.cupSet != DummyEnum && this.cupSet.isNormalized();
    }

    @Override
    public final void normalize() {
        if (this.cupSet != null && this.cupSet != DummyEnum) {
            this.cupSet.normalize();
        }
    }

    @Override
    public final boolean isDefined() {
        return this.set1.isDefined() && this.set2.isDefined();
    }

    @Override
    public final Value deepCopy() {
        return this;
    }

    @Override
    public final boolean assignable(Value val) {
        return this.equals(val);
    }

    @Override
    public final long fingerPrint(long fp) {
        this.convertAndCache();
        return this.cupSet.fingerPrint(fp);
    }

    @Override
    public final Value permute(MVPerm perm) {
        this.convertAndCache();
        return this.cupSet.permute(perm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void convertAndCache() {
        if (this.cupSet == null) {
            this.cupSet = SetEnumValue.convert(this);
        } else if (this.cupSet == DummyEnum) {
            SetEnumValue val = null;
            SetCupValue setCupValue = this;
            synchronized (setCupValue) {
                if (this.cupSet == DummyEnum) {
                    val = SetEnumValue.convert(this);
                    val.deepNormalize();
                }
            }
            setCupValue = this;
            synchronized (setCupValue) {
                if (this.cupSet == DummyEnum) {
                    this.cupSet = val;
                }
            }
        }
    }

    @Override
    public final StringBuffer toString(StringBuffer sb, int offset) {
        try {
            if (expand) {
                SetEnumValue val = SetEnumValue.convert(this);
                return ((Value)val).toString(sb, offset);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        sb = this.set1.toString(sb, offset);
        sb = sb.append(" \\cup ");
        sb = this.set2.toString(sb, offset);
        return sb;
    }

    @Override
    public final ValueEnumeration elements() {
        if (this.cupSet == null || this.cupSet == DummyEnum) {
            return new Enumerator();
        }
        return this.cupSet.elements();
    }

    final class Enumerator
    implements ValueEnumeration {
        ValueEnumeration enum1;
        ValueEnumeration enum2;

        public Enumerator() {
            if (SetCupValue.this.set1 instanceof Enumerable && SetCupValue.this.set2 instanceof Enumerable) {
                this.enum1 = ((Enumerable)((Object)SetCupValue.this.set1)).elements();
                this.enum2 = ((Enumerable)((Object)SetCupValue.this.set2)).elements();
            } else {
                Assert.fail("Attempted to enumerate S \\cup T when S:\n" + Value.ppr(SetCupValue.this.set1.toString()) + "\nand T:\n" + Value.ppr(SetCupValue.this.set2.toString()) + "\nare not both enumerable");
            }
        }

        @Override
        public final void reset() {
            this.enum1.reset();
            this.enum2.reset();
        }

        @Override
        public final Value nextElement() {
            Value elem = this.enum1.nextElement();
            if (elem != null) {
                return elem;
            }
            elem = this.enum2.nextElement();
            return elem;
        }
    }
}

