/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util.statistics;

import java.util.Map;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.NotCompliantMBeanException;
import tlc2.output.MP;
import tlc2.tool.management.TLCStandardMBean;
import tlc2.util.statistics.IBucketStatistics;
import tlc2.util.statistics.management.BucketStatisticsMXWrapper;

public class BucketStatistics
implements IBucketStatistics {
    protected final AtomicLong observations = new AtomicLong(0L);
    protected final ConcurrentNavigableMap<Integer, AtomicLong> buckets = new ConcurrentSkipListMap<Integer, AtomicLong>();
    private final String title;
    private final int maximum;

    BucketStatistics() {
        this("Historgram");
    }

    public BucketStatistics(String aTitle) {
        this(aTitle, Integer.MAX_VALUE);
    }

    public BucketStatistics(String aTitle, String pkg, String name) {
        this(aTitle, Integer.MAX_VALUE, pkg, name);
    }

    public BucketStatistics(String aTitle, int aMaxmimum) {
        this.title = aTitle;
        this.maximum = aMaxmimum;
    }

    public BucketStatistics(String aTitle, int aMaxmimum, String pkg, String name) {
        this(aTitle, aMaxmimum);
        try {
            BucketStatisticsMXWrapper graphStatsMXWrapper = new BucketStatisticsMXWrapper(this, name, pkg);
        }
        catch (NotCompliantMBeanException e) {
            MP.printWarning(1000, "Failed to create MBean wrapper for BucketStatistics. No statistics/metrics will be avaiable.", e);
            TLCStandardMBean graphStatsMXWrapper = TLCStandardMBean.getNullTLCStandardMBean();
        }
    }

    @Override
    public void addSample(int amount) {
        if (amount < 0) {
            throw new IllegalArgumentException("Negative amount invalid");
        }
        int idx = Math.min(this.maximum, amount);
        AtomicLong atomicLong = (AtomicLong)this.buckets.get(idx);
        if (atomicLong == null) {
            this.buckets.putIfAbsent(idx, new AtomicLong(1L));
        } else {
            atomicLong.incrementAndGet();
        }
        this.observations.getAndIncrement();
    }

    @Override
    public long getObservations() {
        return this.observations.get();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("============================\n");
        buf.append("=" + this.title + "=\n");
        buf.append("============================\n");
        buf.append(String.format("Observations: %d\n", this.observations.get()));
        buf.append(String.format("Min: %d\n", this.getMin()));
        buf.append(String.format("Max: %d\n", this.getMax()));
        buf.append(String.format("Mean: %.2f\n", this.getMean()));
        buf.append(String.format("Median: %d\n", this.getMedian()));
        buf.append(String.format("Standard deviation: %.2f\n", this.getStdDev()));
        buf.append(String.format("75%%: %.2f\n", this.getPercentile(0.75)));
        buf.append(String.format("95%%: %.2f\n", this.getPercentile(0.95)));
        buf.append(String.format("98%%: %.2f\n", this.getPercentile(0.98)));
        buf.append(String.format("99%%: %.2f\n", this.getPercentile(0.99)));
        buf.append(String.format("99.9%%: %.2f\n", this.getPercentile(0.999)));
        buf.append("numEdges/occurrences (log scale)\n");
        buf.append("--------------------------------\n");
        for (Map.Entry next : this.buckets.entrySet()) {
            long amount = ((AtomicLong)next.getValue()).get();
            int i = (Integer)next.getKey();
            buf.append(String.format("%02d", i));
            buf.append(":");
            buf.append(String.format("%02d", amount));
            buf.append(" ");
            int j = 0;
            while ((double)j < Math.log(amount)) {
                buf.append("#");
                ++j;
            }
            buf.append("\n");
        }
        buf.append("============================");
        return buf.toString();
    }

    @Override
    public int getMedian() {
        long l = this.observations.get();
        if (l <= 0L) {
            return -1;
        }
        long sum = 0L;
        for (Map.Entry next : this.buckets.entrySet()) {
            if ((sum += ((AtomicLong)next.getValue()).get()) <= l / 2L) continue;
            return (Integer)next.getKey();
        }
        throw new RuntimeException("bug, shoud not get here");
    }

    @Override
    public double getMean() {
        long sum = 0L;
        for (Map.Entry next : this.buckets.entrySet()) {
            long value = ((AtomicLong)next.getValue()).get();
            int i = (Integer)next.getKey();
            sum += value * (long)i;
        }
        if (this.observations.get() > 0L) {
            return (double)sum / ((double)this.observations.get() * 1.0);
        }
        return -1.0;
    }

    @Override
    public int getMin() {
        if (this.observations.get() <= 0L) {
            return -1;
        }
        return (Integer)this.buckets.firstKey();
    }

    @Override
    public int getMax() {
        if (this.observations.get() <= 0L) {
            return -1;
        }
        return (Integer)this.buckets.lastKey();
    }

    @Override
    public double getStdDev() {
        long N = this.observations.get();
        if (N <= 0L) {
            return -1.0;
        }
        double mean = this.getMean() * 1.0;
        double sum = 0.0;
        for (Map.Entry next : this.buckets.entrySet()) {
            double Xi = (double)((Integer)next.getKey()).intValue() * 1.0;
            double diff = Xi - mean;
            sum += diff * diff * ((double)((AtomicLong)next.getValue()).get() * 1.0);
        }
        double variance = sum / ((double)N * 1.0);
        double stdDev = Math.sqrt(variance);
        return stdDev;
    }

    @Override
    public double getPercentile(double quantile) {
        if (Double.isNaN(quantile)) {
            throw new IllegalArgumentException("NaN");
        }
        long obsv = this.observations.get();
        if (obsv <= 0L) {
            return -1.0;
        }
        quantile = Math.min(1.0, quantile);
        int pos = (int)((double)obsv * 1.0 * (quantile = Math.max(0.0, quantile)));
        if ((long)pos > obsv) {
            return this.buckets.size();
        }
        if (pos < 0) {
            return 0.0;
        }
        long cnt = 0L;
        for (Map.Entry next : this.buckets.entrySet()) {
            int i = (Integer)next.getKey();
            if ((cnt += ((AtomicLong)next.getValue()).get()) <= (long)pos) continue;
            return i;
        }
        return quantile;
    }
}

