/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.liveness;

import tlc2.tool.liveness.LiveExprNode;
import tlc2.tool.liveness.TBGraphNode;
import tlc2.util.Vect;

public class TBGraph
extends Vect {
    public final LiveExprNode tf;
    private int initCnt;

    public TBGraph(LiveExprNode tf) {
        this.tf = tf;
        this.initCnt = 0;
    }

    public TBGraphNode getNode(int idx) {
        return (TBGraphNode)this.elementAt(idx);
    }

    public final void setInitCnt(int n) {
        this.initCnt = n;
    }

    public int getInitCnt() {
        return this.initCnt;
    }

    public final void toString(StringBuffer sb, String padding) {
        for (int i = 0; i < this.size(); ++i) {
            TBGraphNode tnode = this.getNode(i);
            sb.append(padding);
            sb.append("Node " + i + ".\n");
            tnode.getPar().toString(sb, padding);
            sb.append(" --> ");
            for (int j = 0; j < tnode.nexts.size(); ++j) {
                sb.append(tnode.nextAt((int)j).index + " ");
            }
            sb.append("\n");
        }
    }

    @Override
    public final String toString() {
        StringBuffer sb = new StringBuffer();
        this.toString(sb, "");
        return sb.toString();
    }

    public String toDotViz() {
        StringBuffer sb = new StringBuffer();
        sb.append("digraph TableauGraph {\n");
        sb.append("nodesep = 0.7\n");
        sb.append("rankdir=LR;\n");
        for (int i = 0; i < this.size(); ++i) {
            sb.append(this.getNode(i).toDotViz());
        }
        sb.append("}");
        return sb.toString();
    }
}

